<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Listas extends MX_Controller
{

	public $path_js;
	protected $_permisos;

	public function __construct()
	{
		parent::__construct();

		if ($this->session->userdata('COD_TIPOPERFIL') !== 1 && $this->session->userdata('COD_TIPOPERFIL') !== 2) {
			echo "<h3>No tiene permisos para acceder a esta sección.</h3>";
			exit;
		}

		$this->load->model(['Lista', 'candidatos/Candidato']);
		$this->path_js = 'listas/scripts_dev.js';
		$this->load->helper('html');
		$this->_permisos = $this->session->userdata('permisos');


	}

	public function index()
	{
		$data_view['titulo']  = 'Listas';
		$data_view['permisos']  = $this->_permisos;
		$data_view['load_js'] = $this->path_js;
		$this->load->view('index', $data_view);
	}

//-----------------------------------------------------------------------------

     /**
      * Lista asociados desde Datatables. 
      */
     public function get_all()
     {
     	$list = $this->Lista->get_datatables();
     	$data = array();
     	$no   = $this->input->post('start');
     	foreach ($list as $lista) {
     		$no++;
     		$row     = array();
     		$delete= '';
     		$editar = '';
     		$status = '';
     		$asignar = '';

     		if(isset($this->_permisos['listas']['listas_borrar'])) {
     			$delete  = "<a href='listas/delete/$lista->ID_LISTA/$lista->TEX_TIPLIS' class='btn btn-danger' onclick='borrarRegistro(this.id)'>Eliminar</a>";
     		}

     		if(isset($this->_permisos['listas']['listas_editar'])) {
     			$editar = "<a href='listas/create/1/$lista->ID_LISTA ' class='btn btn-success'>Editar</a>";
     		}
     		if(isset($this->_permisos['listas']['listas_activar'])) {
     			$status  = ($lista->BOL_ACTIVO) ? "<a href='listas/status/$lista->ID_LISTA/$lista->BOL_ACTIVO ' class='btn btn-danger' style='margin-left:3px;'>Desactivar</a>" : "<a href='listas/status/$lista->ID_LISTA/$lista->BOL_ACTIVO ' class='btn btn-success' style='margin-left:3px;'>Activar</a>";
     		}

     		if(isset($this->_permisos['listas']['listas_asignar_candidatos'])) {
     			
     			$asignar = "<a href='listas/asignar_candidatos/$lista->ID_LISTA/$lista->TEX_TIPLIS' class='btn btn-primary''>Asignar</a>";
     		} 		
     		
     		$row[]   = $lista->ID_LISTA;
     		$row[]   = $lista->TEX_NOMLIS;
     		$row[]   = $lista->TEX_TIPLIS;
     		$row[]   = $lista->TEX_NOMINS;
     		$row[]   = $lista->TEX_NOMCIU;
     		$row[]   = $lista->TEX_NOMAGE;
     		$row[]   = ($lista->BOL_ACTIVO) ? '<p style="color:green">Activo</p>' : '<p style="color:red">Inactivo</p>';
     		$row[]   = "$editar $asignar $status $delete";
     		$data[]  = $row;
     	}
     	$output = array(
     		"draw"            => $this->input->post('draw'),
     		"recordsTotal"    => $this->Lista->count_all(),
     		"recordsFiltered" => $this->Lista->count_filtered(),
     		"data"            => $data,
     	);
     	echo json_encode($output);
     }

//----------------------------------------------------------------------------- 

     /**
      * Crear lista.
      */
     public function create($edit = null, $id = null)
     {
     	if ($this->input->post()) {
     		$edit = $this->input->post('edit');
     		$id   = $this->input->post('ID_LISTA');
     		if ($edit) {
     			$this->form_validation->set_rules('TEX_NOMLIS', 'Nombre del Lista', 'required');
     		}
     		else {
     			$this->form_validation->set_rules('TEX_NOMLIS', 'Nombre del Lista', 'required|is_unique[evi03listas.TEX_NOMLIS]');
     		}
     		if (!$this->form_validation->run()) {
     			$this->session->set_flashdata('error', validation_errors());
     			if ($edit) {
     				redirect("listas/create/1/$id");
     			}
     			redirect("listas/create");
     		}
     		else {
     			$_post       = $this->security->xss_clean($_POST);
     			$datos_lista = array_merge($_post, $this->get_campos_control_DB());
     			if($datos_lista['TEX_FOTO'] === ''){
     				unset($datos_lista['TEX_FOTO']);
     			}
                 // $this->db->trans_start();
     			if ($edit && $id) {
     				unset($datos_lista['edit']);
     				if ($this->Lista->edit($id, $datos_lista)) {
     					$id_candidato_lista = $this->Candidato->get_by(['ID_LISTA' => $id, 'TEXT_TIPLIST' => 'LCL']);
     					if ($id_candidato_lista) {
     						$data_candidato_edit = [
     							'TEX_APECAN'      => $this->input->post('TEX_NOMLIS'),
     							'ID_INSTAN'       => $this->input->post('ID_INSTAN'),
     							'COD_CIUDAD'      => $this->input->post('COD_CIUDAD'),
     							'COD_AGENCIA'     => $this->input->post('COD_AGENCIA'),
     							'TEX_OBSERVACION' => 'Candidato creado a partir de la lista: ' . $id . ' - ' . $this->input->post('TEX_NOMLIS'),
     						];
     						$this->Candidato->edit($id_candidato_lista->ID_CANDID, $data_candidato_edit);
     					}

     				//	var_dump($_FILES['upload_foto']['size']);exit;
     					if ($_FILES['upload_foto']['size'] > 0) {
     						if ($this->do_upload($id)) {
     							$datos_candidato_foto = ['TEX_FOTO' => 'uploads/listas/' . $this->upload->data('file_name')];
     							$this->Lista->edit($id, $datos_candidato_foto);
     						}

     					}



     					$this->session->set_flashdata('success', 'Se ha editado el registro');
     					redirect('listas');

     				}
     				else {
     					$this->session->set_flashdata('error', 'Error en la edición de los datos');
     					redirect("listas/create/1/$id");
     				}
     			}
                 // $this->db->trans_complete();
                 //Id de la lista creada.
     			$this->db->trans_start();
                //  echo '<pre>';
                //  var_dump($datos_lista);
               // unset($datos_lista['upload_foto']);
     			$id_lista = $this->Lista->insert($datos_lista);
     			if (is_int($id_lista)) {
     				if ($this->do_upload($id_lista)) {
     					$_POST['TEX_FOTO'] = 'uploads/listas/' . $this->upload->data('file_name');
     					$update_arr        = ['TEX_FOTO' => 'uploads/listas/' . $this->upload->data('file_name')];
     					$this->Lista->edit($id_lista, $update_arr);
     				}


     				if ($this->input->post('TEX_TIPLIS') === 'LCC') {
     					$nombre_lista = $this->input->post('TEX_NOMLIS');
     					$id_instancia = $this->input->post('ID_INSTAN');
     					$cod_ciudad   = $this->input->post('COD_CIUDAD');
     					$id_agencia   = $this->input->post('COD_AGENCIA');
                         //Creación de candidato lista..
     					$this->Candidato->create_candidato_lista($id_lista, $nombre_lista, $id_instancia, $cod_ciudad, $id_agencia);
     					$this->session->set_flashdata('success', 'Se ha guardado el registro');
     				}
     				$this->db->trans_complete();
     				redirect('listas');
     			}
     			else {
     				$this->session->set_flashdata('error', 'Error en la inserción de los datos');
     				redirect('listas/create');
     			}
     		}
     	}
     	else {
     		if ($edit && $id) {
     			$data_view['titulo'] = 'Editar Lista';
     			$data_view['lista']  = $this->Lista->get($id);
     		}
     		$data_view['ciudades']   = $this->Lista->select_forms('gen04ciudad', 'COD_CIUDAD', 'TEX_NOMCIU', null, null, null, 'TEX_NOMCIU');
     		$data_view['agencias']   = $this->Lista->select_forms('gen01agencias', 'COD_AGENCIA', 'TEX_NOMAGE');
     		$data_view['instancias'] = $this->Lista->select_forms('evi02instan', 'ID_INSTAN', 'TEX_NOMINS');
     		$data_view['route']      = $this->get_module_name();
     		$data_view['empresas']   = $this->Lista->get_html_select_empresas();
     		$data_view['titulo']     = 'Crear Lista';
     		$data_view['load_js']    = $this->path_js;
     		$this->load->view('create', $data_view);
     	}
     }

     //-----------------------------------------------------------------------------    

     /**
      * Asignar candidatos a las listas.
      * 
      * @param type $id_lista
      * @param type $tipo_lista
      */
     public function asignar_candidatos($id_lista = null, $tipo_lista = null)
     {
     	if (!$this->input->post()) {
     		if ($id_lista && $tipo_lista) {
                 //Candidatos sin asignar.
     			$this->db->where('TEXT_TIPLIST', NULL);
     			$this->db->where('BOL_BLANCO', 0);
     			$data_view['candidatos'] = $this->Candidato->get_all();

                 // Evalua si tiene candidatos asignados.
     			$this->db->where('ID_LISTA', $id_lista);
     			$this->db->where('TEXT_TIPLIST !=', 'LCL');
     			$tiene_asignados = $this->Candidato->get_all();
     			if ($tiene_asignados) {
     				$data_view['asignados'] = $tiene_asignados;
     			}

                 //Candidatos asignados a la lista.
     			$data_view['titulo']     = 'Asignar Candidatos';
     			$data_view['id_lista']   = $id_lista;
     			$data_view['tipo_lista'] = $tipo_lista;
     			$data_view['load_js']    = $this->path_js;
     			$this->load->view('asignar', $data_view);
     		}
     	}
     	else {
     		$candidato   = $this->input->post('ID_CANDID[]');
     		$re_asignado = $this->input->post('ID_ASIGN[]');
     		$this->form_validation->set_rules("ID_CANDID[]", 'Candidato', 'integer');

     		if (!$this->form_validation->run()) {
     			$this->session->set_flashdata('error', validation_errors());
     			redirect('listas/asignar_candidatos/');
     		}

     		for ($i = 0; $i < count($re_asignado); $i++) {
     			$id_re_asign  = $re_asignado[$i];
     			$arr_re_asign = [
     				'ID_LISTA'     => null,
     				'TEXT_TIPLIST' => null,
     			];
                 //Re asignación.
     			$this->Candidato->edit($id_re_asign, $arr_re_asign);
     		}

     		for ($index = 0; $index < count($candidato); $index++) {
     			$id_candidato = $candidato[$index];
     			$arr_asign    = [
     				'ID_LISTA'     => $this->input->post('ID_LISTA'),
     				'TEXT_TIPLIST' => $this->input->post('TEXT_TIPLIST'),
     			];
                 //Asignación
     			$this->Candidato->edit($id_candidato, $arr_asign);
     		}
     		$this->session->set_flashdata('success', 'Se asignaron los candidatos');
     		redirect('listas');
     	}
     }

     /**
      * 
      * Cambiar status
      * 
      * @param type $id
      * @param type $status
      * 
      */
     public function status($id, $status)
     {
     	$data = ['BOL_ACTIVO' => 1];
     	if ($status) {
     		$data = ['BOL_ACTIVO' => 0];
     	}
     	if ($this->Lista->edit($id, $data)):
     		$this->session->set_flashdata('success', 'Status cambiado');
     		redirect('listas');
     	else:
     		$this->session->set_flashdata('error', 'Ocurrió un error al cambiar el status');
     		redirect('listas');
     	endif;
     }

     /**
      * Borrar Registro
      * @param type $id
      */
     public function delete($id, $tipo_lista)
     {
     	if ($id) {
     		$data = ['IS_DELETE' => 1];
     		if ($this->Lista->edit($id, $data)):
     			if ($tipo_lista === 'LCC') {
     				$this->Lista->delete_candidato_lista($id);
     			}
     			else {
     				$this->Lista->update_candidatos_aso_lista($id);
     			}

     			$this->session->set_flashdata('success', 'Registro Eliminado');
     			redirect('listas');
     		else:
     			$this->session->set_flashdata('error', 'Ocurrió un error al eliminar el registro');
     			redirect('listas');
     		endif;
     	}
     }

     public function do_upload($name_image)
     {
     	$config['upload_path']   = './uploads/listas';
     	$config['allowed_types'] = 'gif|jpg|png';
     	$config['max_size']      = 5000;
     	$config['max_width']     = 1920;
     	$config['max_height']    = 1080;
     	$config['file_name']     = $name_image;
     	$config['overwrite']     = true;

     	$this->load->library('upload', $config);
     	if ($this->upload->do_upload('upload_foto')) {

     		return $config['file_name'];
     	}
     	else {
     		$this->session->set_flashdata('error', $this->upload->display_errors());
     	}
     }

  }
