<?php

 /*
  * To change this license header, choose License Headers in Project Properties.
  * To change this template file, choose Tools | Templates
  * and open the template in the editor.
  */

 /**
  * Description of User
  *
  * @author Developer
  */
 class Lista extends MY_Model
 {

     protected $_table;
     protected $_table_parent;
     protected $_table_parent2;
     protected $_table_parent3;
     private $_column = array('ID_LISTA', 'TEX_NOMLIS');
     private $_order  = array('ID_LISTA' => 'desc');
     private $_configuracion;

     public function __construct()
     {
         parent::__construct();
         $this->load->database();

         //Modelo de la Configuración.
         $this->load->model('configuracion/Config');
         //Datos de la configuración.
         $this->_configuracion = $this->Config->get_row();
         if (!$this->_configuracion) {
             exit('No se ha definido la configuración del sistema.');
         }

         $this->_table         = 'evi03listas';
         $this->_table_parent  = 'evi02instan';
         $this->_table_parent2 = 'gen04ciudad';
         $this->_table_parent3 = 'gen01agencias';
         $this->primary_key    = 'ID_LISTA';
     }

     /**
      * Para editar el campo de una tabla. 
      * 
      * @param type @table Tabla
      * @param type @table_id Id a editar
      * @param type @id Id primaria
      * @param type $data datos
      * @return boolean
      */
     public function edit($id, $data)
     {
         $this->db->where($this->primary_key, $id);
         if ($this->db->update($this->_table, $data)):
             return true;
         else:
             return false;
         endif;
     }

     private function _get_datatables_query()
     {
         $this->db->select("$this->_table.*,$this->_table_parent.TEX_NOMINS,"
           . " $this->_table_parent2.TEX_NOMCIU, $this->_table_parent3.TEX_NOMAGE");
         $this->db->from($this->_table);
         $this->db->join($this->_table_parent, "$this->_table_parent.ID_INSTAN=$this->_table.ID_INSTAN");
         $this->db->join($this->_table_parent2, "$this->_table_parent2.COD_CIUDAD=$this->_table.COD_CIUDAD");
         $this->db->join($this->_table_parent3, "$this->_table_parent3.COD_AGENCIA=$this->_table.COD_AGENCIA");
         $this->db->where("$this->_table.IS_DELETE", 0);
         $i = 0;
         foreach ($this->_column as $item) {
             if ($_POST['search']['value']) ($i === 0) ? $this->db->like($item, $_POST['search']['value']) : $this->db->or_like($item, $_POST['search']['value']);
             $column[$i] = $item;
             $i++;
         }
         if (isset($_POST['order'])) {
             $this->db->order_by($column[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
         }
         else if (isset($this->_order)) {
             $order = $this->_order;
             $this->db->order_by(key($order), $order[key($order)]);
         }
     }

     public function get_datatables()
     {
         $this->_get_datatables_query();
         if ($_POST['length'] != -1):
             $this->db->limit($_POST['length'], $_POST['start']);
         endif;
         $query = $this->db->get();
         return $query->result();
     }

     public function count_filtered()
     {
         $this->_get_datatables_query();
         $query = $this->db->get();
         return $query->num_rows();
     }

     public function count_all()
     {
         $this->db->from($this->_table);
         $this->db->where("$this->_table.BOL_ACTIVO", 1);
         return $this->db->count_all_results();
     }

     public function get_all_listas($instancia_id)
     {
         $this->db->where('ID_INSTAN', $instancia_id);
         //Tipo de segmentacion por Agencia.
         if ($this->_configuracion->TEX_SEGMEN === 'A') {
             $this->db->where('COD_AGENCIA', $this->session->userdata('COD_AGENCIA'));
         }
         //Tipo de segmentacion po Ciudad.
         if ($this->_configuracion->TEX_SEGMEN === 'C') {
             $this->db->where('COD_CIUDAD', $this->session->userdata('COD_CIUDAD'));
         }
         $this->db->order_by('cast(NUM_ORDEN as unsigned)');
         return $this->db->get($this->_table)->result();
     }

     /**
      * Borra el candidato tipo lista. 
      * 
      * @param type $id_lista
      * @return boolean
      */
     public function delete_candidato_lista($id_lista)
     {
         if ($id_lista) {
             if ($this->db->delete('evi04candidat_mr', ['ID_LISTA' => $id_lista])) {
                 return true;
             }
             else {
                 return false;
             }
         }
     }

     /**
      * Edita los datos de la lista en la tabla candidatos en caso de borrarla. 
      * 
      * @param type $id_lista
      * @return boolean
      */
     public function update_candidatos_aso_lista($id_lista)
     {
         if ($id_lista) {
             $this->db->where('ID_LISTA', $id_lista);
             if ($this->db->update('evi04candidat_mr', ['ID_LISTA' => null, 'TEXT_TIPLIST' => null])) {
                 return true;
             }
             else {
                 return false;
             }
         }
     }

 }
 