<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Log_ingresos extends MX_Controller {

	public $path_js;

	public function __construct() {
		parent::__construct();

		if ($this->session->userdata('COD_TIPOPERFIL') !== 1 && $this->session->userdata('COD_TIPOPERFIL') !== 2) {
			echo "<h3>No tiene permisos para acceder a esta sección.</h3>";
			exit;
		}

		$this->load->model('Log_ingreso');
		$this->path_js = 'log_ingresos/scripts_dev.js';
	}

	public function index() {

		$data_view['titulo'] = 'Log de ingreso Participantes';
		$data_view['load_js'] = $this->path_js;
		$this->load->view('index', $data_view);

	}

    /**
     * Lista asociados desde Datatables. 
     */
    public function get_all() {
    	$list = $this->Log_ingreso->get_datatables();
    	$data = array();
    	$no = $this->input->post('start');
    	foreach ($list as $log_ingreso) {
    		$no++;
    		$row = array();
    		$row[] = $log_ingreso->ID_LOINPA;
    		$row[] = $log_ingreso->NUM_IDETER;
    		$row[] = $log_ingreso->TEX_NOMPAR.' '.$log_ingreso->TEX_APEPAR;
    		$row[] = $log_ingreso->NUM_TELCEL;
    		$row[] = $log_ingreso->NUM_PINGEN;
    		$row[] = $log_ingreso->FEC_INISES;
    		$row[] = $log_ingreso->FEC_FINSES;
    		$row[] = ($log_ingreso->BOL_USADO)?'<span class="text-danger">Usado</span>':'<span class="text-danger"><span class="text-success">No Usado</span>';
    		$row[] = $log_ingreso->FEC_CREACION;
    		$data[] = $row;
    	}
    	$output = array(
    		"draw" => $this->input->post('draw'),
    		"recordsTotal" => $this->Log_ingreso->count_all(),
    		"recordsFiltered" => $this->Log_ingreso->count_filtered(),
    		"data" => $data,
    	);
    	echo json_encode($output);
    	
    }

    public function status($id, $status) {
    	$data = ['BOL_ACTIVO' => 1];
    	if ($status) {
    		$data = ['BOL_ACTIVO' => 0];
    	}
    	if ($this->Log_ingreso->edit($id, $data)):
    		$this->session->set_flashdata('success', 'Status cambiado');
    		redirect('log_ingresos');
    	else:
    		$this->session->set_flashdata('error', 'Ocurrió un error al cambiar el status');
    		redirect('log_ingresos');
    	endif;
    }

 }
