<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Paises extends MX_Controller
{

	public $path_js;
	private $_permisos;

	public function __construct()
	{
		parent::__construct();
		if ($this->session->userdata('COD_TIPOPERFIL') !== 1 && $this->session->userdata('COD_TIPOPERFIL') !== 2) {
			echo "<h3>No tiene permisos para acceder a esta sección.</h3>";
			exit;
		}
		$this->load->model('Pais');
		$this->path_js = 'paises/scripts_dev.js';
		$this->_permisos = $this->session->userdata('permisos'); 
	}

	public function index()
	{
		$data_view['titulo']  = 'Listado de Paises';
		$data_view['load_js'] = $this->path_js;
		$data_view['permisos']  = $this->_permisos;
		$this->load->view('index', $data_view);
	}

	function change_status($primary_key, $row)
	{
		return site_url('paises/status') . '/' . $primary_key . '/' . $row->BOL_ACTIVO;
	}

	public function example_output($output = null, $titulo = null)
	{
		$this->load->view('render', $output);
	}

     /**
      * Lista asociados desde Datatables. 
      */
     public function get_all()
     {
     	$list = $this->Pais->get_datatables();
     	$data = array();
     	$no   = $this->input->post('start');
     	foreach ($list as $pais) {
     		$no++;
     		$row    = array();
     		$delete= '';
     		$editar = '';
     		$status = '';


     		if(isset($this->_permisos['paises']['paises_borrar'])) {
     			$delete = "<a href='paises/delete/$pais->COD_PAIS ' class='btn btn-danger' onclick='borrarRegistro(this.id)'>Eliminar</a>";
     		}

     		if(isset($this->_permisos['paises']['paises_editar'])) {
     			$editar = "<a href='paises/create/1/$pais->COD_PAIS ' class='btn btn-success'>Editar</a>";
     		}
     		if(isset($this->_permisos['paises']['paises_activar'])) {
     			$status = ($pais->BOL_ACTIVO) ? "<a href='paises/status/$pais->COD_PAIS/$pais->BOL_ACTIVO ' class='btn btn-danger' style='margin-left:3px;'>Desactivar</a>" : "<a href='paises/status/$pais->COD_PAIS/$pais->BOL_ACTIVO ' class='btn btn-success' style='margin-left:3px;'>Activar</a>";
     		}

     		$row[]  = $pais->COD_PAIS;
     		$row[]  = $pais->TEX_NOMPAIS;
     		$row[]  = ($pais->BOL_ACTIVO) ? '<p style="color:green">Activo</p>' : '<p style="color:red">Inactivo</p>';
     		$row[]  = "$editar $status $delete";
     		$data[] = $row;
     	}
     	$output = array(
     		"draw"            => $this->input->post('draw'),
     		"recordsTotal"    => $this->Pais->count_all(),
     		"recordsFiltered" => $this->Pais->count_filtered(),
     		"data"            => $data,
     	);
     	echo json_encode($output);
     }

     /**
      * Crear pais.
      */
     public function create($edit = null, $id = null)
     {
         // if ($this->session->userdata('logged_in')):
     	if ($this->input->post()):
     		$edit = $this->input->post('edit');
     		$id   = $this->input->post('COD_PAIS');
     		if ($edit) {
     			$this->form_validation->set_rules('COD_PAIS', 'Código del País', 'trim|required|integer');
     			$this->form_validation->set_rules('TEX_NOMPAIS', 'Nombre del País', 'required');
     		}
     		else {
     			$this->form_validation->set_rules('COD_PAIS', 'Código del País', 'trim|required|integer|is_unique[gen02pais.COD_PAIS]');
     			$this->form_validation->set_rules('TEX_NOMPAIS', 'Nombre del País', 'required|is_unique[gen02pais.TEX_NOMPAIS]');
     		}
     		if (!$this->form_validation->run()):
     			$this->session->set_flashdata('error', validation_errors());
     			if ($edit) {
     				redirect("paises/create/1/$id");
     			}
     			redirect("paises/create");
     		else:
     			$_post      = $this->security->xss_clean($_POST);
     			$datos_pais = array_merge($_post, $this->get_campos_control_DB());
     			if ($edit && $id) {
     				unset($datos_pais['edit']);
     				if ($this->Pais->edit($id, $datos_pais)) {
     					$this->session->set_flashdata('success', 'Se ha editado el registro');
     					redirect('paises');
     				}
     				else {
     					$this->session->set_flashdata('error', 'Error en la edición de los datos');
     					redirect("paises/create/1/$id");
     				}
     			}
     			if (is_int($this->Pais->insert($datos_pais))):
     				$this->session->set_flashdata('success', 'Se ha guardado el registro');
     				redirect('paises');
     			else:
     				$this->session->set_flashdata('error', 'Error en la inserción de los datos');
     				redirect('paises/create');
     			endif;
     		endif;
     	else:
     		$data_view['route'] = $this->get_module_name();
     		if ($edit && $id) {
     			$data_view['pais'] = $this->Pais->get($id);
     		}
     		$data_view['titulo']  = 'Crear País';
     		$data_view['load_js'] = $this->path_js;
     		$this->load->view('create', $data_view);
     	endif;
         // endif;
     }

     /**
      * 
      * Cambiar status
      * 
      * @param type $id
      * @param type $status
      * 
      */
     public function status($id, $status)
     {
     	if ($status === 'inactivo') {
     		$data = ['BOL_ACTIVO' => 1];
     	}
     	if ($status === 'activo') {
     		$data = ['BOL_ACTIVO' => 0];
     	}
     	if ($this->Pais->edit($id, $data)):
     		$this->session->set_flashdata('success', 'Status cambiado');
     		redirect('paises');
     	else:
     		$this->session->set_flashdata('error', 'Ocurrió un error al cambiar el status');
     		redirect('paises');
     	endif;
     }

     /**
      * Borrar Registro
      * @param type $id
      */
     public function delete($id)
     {
     	$data = ['IS_DELETE' => 1];
     	if ($this->Pais->edit($id, $data)):
     		$this->session->set_flashdata('success', 'Registro Eliminado');
     		redirect('paises');
     	else:
     		$this->session->set_flashdata('error', 'Ocurrió un error al eliminar el registro');
     		redirect('paises');
     	endif;
     }

  }
