<?php

/**
* EVIR V 2.0
*
* An application development for PHP
*
* This content is released under the End User License Agreement (EULA)
*
* Copyright (c) 2008 - 2016, Cyberia Tech SAS.
*
* THIS IS A LEGAL AGREEMENT BETWEEN YOU, THE END USER, 
* AND EVIR .IF YOU DO NOT AGREE TO THE TERMS OF THIS AGREEMENT, 
* DO NOT DOWNLOAD OR USE THIS SOFTWARE.
*
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
*
* LICENSE
* The software is licensed for exclusive and non-transferable use. 
* A licensed copy of the software may be used for an unlimited amount 
* of time without any monthly fees. For each installed instance of the software,
* a separate license is required unless the multi-user licenses bundle
* deal has been purchased, thus the a simple copy of the software can be
* installed up to multiple different machines depending on the license type.
*
* @package	Evir 2.
* @author Jaime P. Bravo <http://www.jaimebravo.co> <http://www.githib.com/fire_flex>
* @copyright	Copyright (c) 2008 - 2016, Cyberia Tech SAS.(http://cyberiatech.com.co/)
* @license	http://opensource.org/licenses/MIT	EULA
* @link	http://cyberiatech.com.co/evir
* @since	Version 2.0.0
* @filesource
*/
defined('BASEPATH') OR exit('No direct script access allowed');

class Puntos_votacion extends MX_Controller
{
    
    public $path_js;
    public $message;
    
    public function __construct()
    {
        
        parent::__construct();
        
        $this->load->model(['participantes/Participante',
        'configuracion/Config', 'instancias/Instancia', 'log_ingresos/Log_ingreso',
        'acceso/Log_recordar_password', 'ingresos_salidas/Ingresos_salida', 'Punto_votacion', 'acceso/Access', 'Maquina']);
        $this->load->helper('security');
        $this->path_js        = 'ingresos_salidas/scripts_dev.js';
        
        //Config del sistema
        $this->_configuracion = $this->Config->get_row();
        
        //Si no esta definida la configuración.
        if (!$this->_configuracion) {
            $data_view['message'] = 'No se ha definido la configuración del sistema. Contacte al administrador.';
            $this->load->view('errors/error_start_sistema', $data_view);
            return false;
        }

        
        if($this->session->userdata('COD_TIPOPERFIL')){
            $this->load->helper('cookie');
            setcookie('punto_votacion', true);
        } 

    }
    
    //--------------------------------------------------------------------------------------------------------------------------------
    /**
    *  Carga de los datos de votación. 
    * 
    * @param type $instancia_numero
    * @return boolean
    */
    public function index()
    {
        $this->load->helper('cookie');

        //Datos de la primera instancia activa.
        $instancia = $this->Instancia->get_instancia_by_id();
        
        if ($instancia) {
            $valida_fecha = $this->valida_fecha_vigencia_instancia($instancia);
            //Si la validación de fechas no se cumple.
            if (!$valida_fecha) {
                return false;
            }
        }
        
        //Validación de Mac
        $validacion_maquina = $this->_validacionMac();

        $ck_punto_votacion = (boolean)get_cookie('punto_votacion');

        if(!$ck_punto_votacion){
            $validacion_maquina = false;
        }
                
        $data_view['nombre_empresa'] = $this->Access->get_nom_empresa()->TEX_NOMEMP;
        $data_view['titulo']  = 'Punto de votación';
        $data_view['load_js'] = $this->path_js;
        // $data_view['mensaje_login']  = $this->get_texto_sistema('TEX_LOGIN')->TEX_LABEL;
        $data_view['mensaje_login']  = 'Punto de votación';
        $data_view['images'] = [
            'uploads/backgrounds/tech1.jpg',
            'uploads/backgrounds/tech2.jpg',
            'uploads/backgrounds/tech3.jpg',
            'uploads/backgrounds/tech4.jpg',
            'uploads/backgrounds/tech1.jpg',
            'uploads/backgrounds/tech2.jpg',
            'uploads/backgrounds/tech3.jpg',
            'uploads/backgrounds/tech4.jpg',
        ];
        $data_view['validacion_maquina'] = $validacion_maquina;
        if (!$this->input->post()) {
            $this->load->view('index', $data_view);
        }
        else {
           if(!$validacion_maquina){
           // $this->session->set_flashdata('error', 'Este dispositivo no está autorizado para ejecutar este proceso, comuníquese con el administrador');
            redirect("moduloVotacion");
           }


            $data_view['mensaje_login'] = '';
            $data_view['validacion_maquina'] = $validacion_maquina;
            $this->form_validation->set_rules('NUM_IDETER', 'Identificación', 'required|integer');
            if ($this->form_validation->run() == FALSE) {
                $this->session->set_flashdata('error', validation_errors());
                redirect("moduloVotacion");
            }
            else {
                
                $participante_id = ltrim($this->input->post('NUM_IDETER'), '0');
                
                // Validacion si hay instancias activas. 
                $instancias_activas =  $this->Instancia->all();
                
                if(!$instancias_activas) {
                    $data_view['message'] = $this->get_texto_sistema('TEX_INSTA_INACTIVA')->TEX_LABEL;
                    $this->load->view('index', $data_view);
                    return false;
                }
                
                //Validacion si el participante ya ha votado.
                $validacion_voto_previo = $this->Participante->get_exits_voto($instancia->ID_INSTAN, $participante_id);
                if($validacion_voto_previo) {
                    $data_view['message'] = $this->get_texto_sistema('TEX_ISVOTO')->TEX_LABEL;
                    $this->load->view('index', $data_view);
                    return false;
                }
                
                
                //Se valida que sea con registro previo.
                if ($this->_configuracion->BOL_REGIST) {
                    
                    //Validacion cuando el participante no esta registrado. 
                    $this->db->where('FEC_REGIST !=', 'NULL');
                    $validacion_registro =  $this->Participante->get($participante_id);
                    if(!$validacion_registro) {
                        $data_view['message'] = $this->get_texto_sistema('PARTI_NO_REGIS')->TEX_LABEL;
                        $this->load->view('index', $data_view);
                        return false;
                    }
                    //Validacion si el participante esta fuera del auditorio.
                    $validacion_fuera_auditorio = $this->Ingresos_salida->valida_participante_fuera_auditorio($participante_id);
                    if($validacion_fuera_auditorio) {
                        $data_view['message'] = $this->get_texto_sistema('TEX_PART_FUERA_AUDI')->TEX_LABEL;
                        $this->load->view('index', $data_view);
                        return false;
                    }
                }
                
                $valida_ip_agencia = $this->Access->get_ip_agencia_participante(xss_clean($this->input->post('NUM_IDETER')));
                
                $valida_ip_agencia = (isset($valida_ip_agencia->TEX_IPORIG))?$valida_ip_agencia->TEX_IPORIG:'0';
                
                if($valida_ip_agencia !== '' || !empty($valida_ip_agencia)){	
                    if($valida_ip_agencia !== '0'){
                        if($valida_ip_agencia != $this->get_client_ip_server()) {
                            //  echo $this->get_client_ip_server();exit;
                            $data_view['message'] = $this->get_texto_sistema('TEX_VALIPORIG')->TEX_LABEL;
                            $this->load->view('index', $data_view);
                            return false;
                        }
                    }   
                }
                
                
                
                $acceso = xss_clean($this->input->post('NUM_IDETER'));
                $login = $this->_inicio_session($acceso, null);
                
                if(!$login){
                    $this->session->set_flashdata('error', $this->get_texto_sistema('TEX_SESAB')->TEX_LABEL);
                    redirect("moduloVotacion");
                }
                
            }
            
        }
    }

    public function timer_votacion()
    {
        $tiempo_restante = $this->_configuracion->NUM_TEMPO;
        if (!$tiempo_restante) {
            return 0;
        }
        $tiempo_en_seg = $tiempo_restante * 60;
        return $tiempo_en_seg;
    }
    
    public function get_client_ip_server() {
        if (!empty($_SERVER['HTTP_CLIENT_IP'])) 
        {
            $ip=$_SERVER['HTTP_CLIENT_IP'];
        }
        elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR']))
        {
            $ip=$_SERVER['HTTP_X_FORWARDED_FOR'];
        }
        else
        {
            $ip=$_SERVER['REMOTE_ADDR'];
        }
        return $ip;
    }
    
    
    private function _validacionMac()
    {

        $mac_cliente = $_SERVER['REMOTE_ADDR'];
        $datos_maquina = $this->Maquina->get_row($mac_cliente);

        if (!$datos_maquina) {
            return false;
        }
        return true;
    }
    
    /**
    *  Inicio de sesión del participante.
    *
    * @param type $acceso
    * @param type $password
    * @param type $is_pin
    * @return boolean
    */
    private function _inicio_session($acceso, $password = null, $is_pin = null)
    {
        $login_status = $this->Access->login_participante($acceso, $password);
        
        if (!$login_status) {
            return false;
        } else {
            $start_session = $this->_start_session_usuario($login_status->NUM_IDETER, $login_status->TEX_NOMPAR, $login_status->TEX_APEPAR, $login_status->COD_CIUDAD,
            $login_status->COD_AGENCIA, $login_status->TEX_MAIL, $login_status->NUM_PESO, $login_status->TEX_NOMAGE, $is_pin);
            if ($start_session) {
                
                if($this->_configuracion->NUM_TEMPO) {
                    $tiempo_votacion = $this->timer_votacion();
                    $this->load->helper('cookie');
                    delete_cookie('tm');
                    setcookie('tm', $tiempo_votacion);
                    
                }
                
                $this->_update_inisession_participante($is_pin);
                
                if ($this->_configuracion->BOL_VALLIS) {
                    redirect('votacion/Votacion_listas');
                } else {
                    redirect('votacion');
                }
            } else {
                $data_view['message'] = 'Error al iniciar la session';
                $this->load->view('index', $data_view);
            }
        }
    }
    
    //------------------------------------------------------------------------------
    /**
    * Valida la vigencia de la instancia con referencia a la fecha de inicio y
    * la fecha final.
    *
    * @param type $instancia
    */
    public function valida_fecha_vigencia_instancia($instancia)
    {
        setlocale(LC_ALL,"es_CO");
        $fecha_ini_instancia = $instancia->FEC_INIUSO;
        $fecha_ini_instancia_format = iconv('ISO-8859-2', 'UTF-8', strftime("%H:%M:%S %p del %A %d de %B de %Y", strtotime($instancia->FEC_INIUSO)));
        
        $fecha_fin_instancia_format = iconv('ISO-8859-2', 'UTF-8', strftime(" %H:%M:%S %p del %A %d de %B de %Y ", strtotime($instancia->FEC_FINUSO)));
        $fecha_fin_instancia = $instancia->FEC_FINUSO;
        $fecha_hoy           = date('Y-m-d H:i:s');
        $data_view['logo'] = $this->Access->get_logo_empresa();
        
        $mensaje_cierre_fechas = '.<br><br>	 Vigencia del proceso desde: <b style="font-weight:600">'.$fecha_ini_instancia_format.'</b> hasta: <b style="font-weight:600">'.$fecha_fin_instancia_format.'<b>';
        
        $data_view['message_label'] = $mensaje_cierre_fechas;
        //Valida la fecha de cierre de la instacia.
        if ($fecha_hoy < $fecha_ini_instancia) {
            $data_view['message'] = $this->get_texto_sistema('no_inicio_proceso_votacion')->TEX_LABEL;
            $data_view['remain_votacion'] = true;
            $this->load->view('errors/error_start_sistema', $data_view);
            return false;
        }
        if ($fecha_hoy > $fecha_fin_instancia) {
            $data_view['message'] = $this->get_texto_sistema('TEX_NOVIGE')->TEX_LABEL;
            $this->load->view('errors/error_start_sistema', $data_view);
            return false;
        }
        return true;
    }
    
    
    /**
    *  Inicio de sessión del participante.
    *
    * @param type $identificacion
    * @param type $nombre
    * @param type $apellido
    * @param type $ciudad
    * @param type $agencia
    * @param type $email
    * @return boolean
    */
    private function _start_session_usuario($identificacion, $nombre, $apellido, $ciudad, $agencia, $email, $peso_voto, $nombre_agencia, $is_pin = null)
    {
        $nombre_campo_agencia = $this->_configuracion->TEX_NOMSEG;
        
        $instancias_activas =$this->Instancia->all();
        $arr_instancias_activas = [];
        foreach ($instancias_activas as $key => $instancia) {
            $arr_instancias_activas[] = $instancia->ID_INSTAN;
        }
        
        $user_data = array(
            'NUM_IDETER'  => $identificacion,
            'TEX_NOMPAR'  => $nombre,
            'TEX_APEPAR'  => $apellido,
            'COD_CIUDAD'  => (int) $ciudad,
            'COD_AGENCIA' => (int) $agencia,
            'TEX_NOMAGE'  => $nombre_agencia,
            'TEX_NOMSEG'  => $nombre_campo_agencia,
            'TEX_MAIL'    => $email,
            'PESO_VOTO'    => $peso_voto,
            'BOL_INISES'  => (int) 1,
            'logged_in'   => true,
            'is_pin'      => $is_pin,
            'punto_votacion'      => true,
            'instancias_activas'      => $arr_instancias_activas,
        );
        $this->session->set_userdata($user_data);
        return true;
    }
    
    //------------------------------------------------------------------------------
    
    /**
    * Actualiza el estado de inicio de sessión del participante.
    *
    * @param type $valor
    * @param type $status
    */
    private function _update_inisession_participante($is_pin = null)
    {
        if ($this->session->userdata('logged_in')) {
            $this->Participante->edit($this->session->userdata('NUM_IDETER'), ['FEC_INISES'=> date('Y-m-d H:i:s'),'BOL_INISES'=> 1]);
            if ($is_pin) {
                $this->Log_ingreso->edit($valor, ['FEC_INISES' => $this->get_fecha_hora_hoy()]);
            }
        }
    }
    
}
