<?php $this->load->view('template/head.php'); ?>
<?php $this->load->view('template/header_admin.php'); ?>

<section class="row contenedor-titulo">
    <div class="col-md-12">
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title"><i class="fa fa-question-circle"></i> <?= isset($instancia) ? 'Editar Pregunta' : 'Nueva Pregunta' ?></h3>
            </div>
        </div>
    </div>
</section>

<section class="row contenedor" style="margin-top: 15px;">

    <!-- ================= FORMULARIO DE PREGUNTA ================= -->
    <div class="col-md-12">
        <div class="panel panel-primary">
            <div class="panel-heading">
                <h4 class="panel-title"><i class="fa fa-edit"></i> Datos de la Pregunta/ Instancia</h4>
            </div>
            <div class="panel-body">
    <form method="post" action="<?= base_url('pyr/guardar') ?>" class="form-horizontal">
        <input type="hidden" name="guardar_pregunta" value="1">
        <input type="hidden" name="id_instancia" value="<?= $instancia ? $instancia->ID_INSTAN : '' ?>">

        <!-- Pregunta -->
        <div class="form-group">
            <label class="col-sm-2 control-label">Pregunta</label>
            <div class="col-sm-10">
                <input type="text" name="pregunta" class="form-control" 
                       value="<?= $instancia ? $instancia->TEX_NOMINS : '' ?>" required
                       placeholder="Ingrese el texto de la pregunta">
            </div>
        </div>

        <!-- Multiselección y Orden -->
        <div class="form-group">
            <label class="col-sm-2 control-label">Multiselección</label>
            <div class="col-sm-4">
                <input type="number" name="multiseleccion" class="form-control only-numbers" min="0" required
                       value="<?= $instancia ? $instancia->NUM_MUSEIN : '' ?>"
                       placeholder="Número de opciones">
            </div>
            <label class="col-sm-2 control-label">Orden</label>
            <div class="col-sm-4">
                <input type="number" name="orden" class="form-control only-numbers" min="0" required
                       value="<?= $instancia ? $instancia->NUM_ORDEN : ($maxOrden + 1) ?>">
            </div>
        </div>

        <!-- Puestos y Decimales -->
        <div class="form-group">
            <label class="col-sm-2 control-label">Puestos</label>
            <div class="col-sm-4">
                <input type="number" name="puestos" class="form-control only-numbers" min="0" required
                       value="<?= $instancia ? $instancia->NUM_TOTELE : '' ?>"
                       placeholder="Total puestos">
            </div>
            <label class="col-sm-2 control-label">Decimales</label>
            <div class="col-sm-4">
                <input type="number" name="decimales" class="form-control only-numbers" min="0" required
                       value="<?= $instancia ? $instancia->NUM_DECRES : '' ?>"
                       placeholder="Número decimales">
            </div>
        </div>

        <!-- Fechas -->
        <div class="form-group">
            <label class="col-sm-2 control-label">Fecha Inicio</label>
            <div class="col-sm-4">
                <input type="date" name="fec_ini" class="form-control" onkeydown="return false"
                       value="<?= $instancia ? substr($instancia->FEC_INIUSO,0,10) : date('Y-m-d') ?>">
            </div>
            <label class="col-sm-2 control-label">Fecha Fin</label>
            <div class="col-sm-4">
                <input type="date" name="fec_fin" class="form-control" onkeydown="return false"
                       value="<?= $instancia ? substr($instancia->FEC_FINUSO,0,10) : date('Y-m-d', strtotime('+1 year')) ?>">
            </div>
        </div>

        <!-- Switches -->
        <div class="form-group input-type">
            <label class="col-sm-2 control-label">¿Activo?</label>
            <div class="col-sm-2 btn-group" data-toggle="buttons">
                <label class="switch btn btn-primary <?= (@$instancia->BOL_ACTIVO) ? 'active' : '' ?>" style="min-width: 50px;">
                    <?= form_radio('activo', '1', (@$instancia->BOL_ACTIVO) ? true : false) ?> Sí
                </label>
                <label class="switch btn btn-primary <?= (@$instancia->BOL_ACTIVO) ? '' : 'active' ?>" style="min-width: 50px;">
                    <?= form_radio('activo', '0', (@$instancia->BOL_ACTIVO) ? false : true) ?> No
                </label>
            </div>

            <label class="col-sm-2 control-label">¿Voto en Blanco?</label>
            <div class="col-sm-2 btn-group" data-toggle="buttons">
                <label class="switch btn btn-primary <?= (@$instancia->BOL_VOTBLA) ? 'active' : '' ?>" style="min-width: 50px;">
                    <?= form_radio('voto_blanco', '1', (@$instancia->BOL_VOTBLA) ? true : false) ?> Sí
                </label>
                <label class="switch btn btn-primary <?= (@$instancia->BOL_VOTBLA) ? '' : 'active' ?>" style="min-width: 50px;">
                    <?= form_radio('voto_blanco', '0', (@$instancia->BOL_VOTBLA) ? false : true) ?> No
                </label>
            </div>

            <label class="col-sm-2 control-label">¿Obliga Multiselección?</label>
            <div class="col-sm-2 btn-group" data-toggle="buttons">
                <label class="switch btn btn-primary <?= (@$instancia->BOL_OBLMUL) ? 'active' : '' ?>" style="min-width: 50px;">
                    <?= form_radio('obliga_multi', '1', (@$instancia->BOL_OBLMUL) ? true : false) ?> Sí
                </label>
                <label class="switch btn btn-primary <?= (@$instancia->BOL_OBLMUL) ? '' : 'active' ?>" style="min-width: 50px;">
                    <?= form_radio('obliga_multi', '0', (@$instancia->BOL_OBLMUL) ? false : true) ?> No
                </label>
            </div>
        </div>

        <!-- Botón Guardar Pregunta -->
        <div class="form-group">
            <div class="col-sm-offset-2 col-sm-10">
                <button type="submit" class="btn btn-success" style="min-width: 140px; margin-right: 10px;">
                    <i class="fa fa-save"></i> Guardar Pregunta
                </button>
                <a href="<?= base_url('pyr/index') ?>" class="btn btn-danger" style="min-width: 100px;">
                    <i class="fa fa-times"></i> Regresar
                </a>
            </div>
        </div>
    </form>
            </div>
        </div>
    </div>

    <!-- ================= FORMULARIO DE OPCIONES DE RESPUESTA ================= -->
    <?php if ($instancia && $instancia->ID_INSTAN): ?>
    
    <!-- ================= PANEL DE CANDIDATOS PREESTABLECIDOS ================= -->
    <div class="col-md-12" style="margin-top: 20px;">
        <div class="panel panel-success">
            <div class="panel-heading">
                <h4 class="panel-title"><i class="fa fa-users"></i>Opciones de Respuestas/ candidatos Preestablecidos</h4>
            </div>
            <div class="panel-body">
                <!-- Filtros -->
                <div class="row" style="margin-bottom: 15px;">
                    <div class="col-md-3">
                        <input type="text" id="buscar-candidato" class="form-control" placeholder="Buscar por nombre..." style="border-radius: 6px;">
                    </div>
                    <div class="col-md-3">
                        <select id="filtro-ciudad" class="form-control" style="border-radius: 6px;">
                            <option value="">Todas las ciudades</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <select id="filtro-agencia" class="form-control" style="border-radius: 6px;">
                            <option value="">Todas las agencias</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <button type="button" id="limpiar-filtros" class="btn btn-default" style="border-radius: 6px;">
                            <i class="fa fa-refresh"></i> Limpiar filtros
                        </button>
                    </div>
                </div>

                <!-- Lista de candidatos -->
                <div style="max-height: 400px; overflow-y: auto; border: 1px solid #ddd; border-radius: 6px; padding: 15px; background-color: #f9f9f9;">
                    <div style="margin-bottom: 15px;">
                        <label>
                            <input type="checkbox" id="seleccionar-todos"> 
                            <strong>Seleccionar todos los visibles</strong>
                            <span id="contador-seleccionados" style="color: #28a745; font-weight: bold;">(0 seleccionados)</span>
                        </label>
                    </div>
                    
                    <div id="lista-candidatos-predef">
                        <?php if(!empty($candidatos_predef)): ?>
                            <?php foreach($candidatos_predef as $cp): ?>
                                <div class="candidato-item" data-id-candidato="<?= $cp->ID_CANDID ?>" data-nombre="<?= strtolower($cp->TEX_NOMCAN . ' ' . $cp->TEX_APECAN) ?>" 
                                     data-ciudad="<?= $cp->COD_CIUDAD ?>" data-agencia="<?= $cp->COD_AGENCIA ?>" 
                                     style="padding: 15px; margin-bottom: 10px; border: 1px solid #e0e0e0; border-radius: 8px; background-color: white; box-shadow: 0 2px 4px rgba(0,0,0,0.1); transition: all 0.3s ease;">
                                    
                                    <div style="display: flex; align-items: flex-start; gap: 15px;">
                                        <!-- Checkbox y Foto -->
                                        <div style="display: flex; align-items: flex-start; gap: 10px; flex-shrink: 0;">
                                            <input type="checkbox" class="candidato-checkbox" 
                                                   data-id="<?= $cp->ID_CANDID ?>"
                                                   data-nombre="<?= $cp->TEX_NOMCAN ?>"
                                                   data-apellido="<?= $cp->TEX_APECAN ?>"
                                                   data-foto="<?= $cp->TEX_FOTO ?>"
                                                   data-ciudad="<?= $cp->COD_CIUDAD ?>"
                                                   data-ciudad-nombre="<?= $cp->TEX_NOMCIU ?>"
                                                   data-agencia="<?= $cp->COD_AGENCIA ?>"
                                                   data-agencia-nombre="<?= $cp->TEX_NOMAGE ?>"
                                                   data-texto-perfil="<?= isset($cp->TEX_PERCAN) ? $cp->TEX_PERCAN : '' ?>"
                                                   style="margin-top: 5px; transform: scale(1.2);">
                                            
                                            <!-- Fotografía del candidato -->
                                            <div style="width: 60px; height: 60px; border: 2px solid #e0e0e0; border-radius: 8px; overflow: hidden; background-color: #f8f9fa; display: flex; align-items: center; justify-content: center;">
                                                <?php if (!empty($cp->TEX_FOTO)): ?>
                                                    <img src="<?= base_url($cp->TEX_FOTO) ?>" alt="Foto de <?= $cp->TEX_NOMCAN ?>" 
                                                         style="width: 100%; height: 100%; object-fit: cover;">
                                                <?php else: ?>
                                                    <i class="fa fa-user" style="font-size: 24px; color: #6c757d;"></i>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                        
                                        <!-- Información del candidato -->
                                        <div style="flex: 1; min-width: 0;">
                                            <!-- Nombre y datos básicos -->
                                            <div style="margin-bottom: 8px;">
                                                <strong style="font-size: 16px; color: #333;"><?= $cp->TEX_NOMCAN ?> <?= $cp->TEX_APECAN ?></strong>
                                            </div>
                                            
                                            <!-- Ciudad y Agencia -->
                                            <div style="margin-bottom: 8px; font-size: 13px; color: #666;">
                                                <?php if($cp->TEX_NOMCIU): ?>
                                                    <i class="fa fa-map-marker" style="margin-right: 5px;"></i>
                                                    <span style="margin-right: 15px;"><?= $cp->TEX_NOMCIU ?></span>
                                                <?php endif; ?>
                                                <?php if($cp->TEX_NOMAGE): ?>
                                                    <i class="fa fa-building" style="margin-right: 5px;"></i>
                                                    <span><?= $cp->TEX_NOMAGE ?></span>
                                                <?php endif; ?>
                                            </div>
                                            
                                            <!-- Texto del perfil -->
                                            <?php if(isset($cp->TEX_PERCAN) && !empty($cp->TEX_PERCAN)): ?>
                                                <div style="margin-top: 10px; padding: 8px 12px; background-color: #f8f9fa; border: 1px solid #e9ecef; border-radius: 6px; font-size: 13px; line-height: 1.4;">
                                                    <i class="fa fa-quote-left" style="color: #6c757d; margin-right: 5px; font-size: 11px;"></i>
                                                    <span style="color: #495057; font-style: italic;"><?= $cp->TEX_PERCAN ?></span>
                                                    <i class="fa fa-quote-right" style="color: #6c757d; margin-left: 5px; font-size: 11px;"></i>
                                                </div>
                                            <?php else: ?>
                                                <div style="margin-top: 10px; padding: 8px 12px; background-color: #fff3cd; border: 1px solid #ffeaa7; border-radius: 6px; font-size: 12px; color: #856404;">
                                                    <i class="fa fa-info-circle" style="margin-right: 5px;"></i>
                                                    <em>Sin texto de perfil</em>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <p style="text-align: center; color: #666; margin: 20px 0;">No hay candidatos preestablecidos disponibles</p>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Botones de acción -->
                <div style="margin-top: 15px; text-align: center;">
                    <button type="button" id="agregar-seleccionados" class="btn btn-success" style="margin-right: 10px;">
                        <i class="fa fa-plus"></i> Agregar Seleccionados
                    </button>
                    <button type="button" id="duplicar-seleccionados" class="btn btn-warning" style="margin-right: 10px;">
                        <i class="fa fa-copy"></i> Duplicar Seleccionados
                    </button>
                   <!-- <button type="button" id="limpiar-tabla" class="btn btn-warning">
                        <i class="fa fa-trash"></i> Limpiar Candidatos Agregados
                    </button>-->
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-12" style="margin-top: 20px;">
        <div class="panel panel-info">
            <div class="panel-heading">
                <h4 class="panel-title"><i class="fa fa-list"></i> Opciones de Respuesta/ Candidatos asociados a la Instancia/Pregunta</h4>
            </div>
            <div class="panel-body">
    <form method="post" action="<?= base_url('pyr/guardar') ?>" class="form-horizontal" enctype="multipart/form-data" id="form-respuestas">
        <input type="hidden" name="guardar_candidatos" value="1">
        <input type="hidden" name="id_instancia" value="<?= $instancia->ID_INSTAN ?>">

        <div class="table-responsive" style="max-height:400px; overflow-y:auto; overflow-x:auto; border:1px solid #ddd; border-radius: 5px;">
            <table class="table table-striped table-hover" style="font-size:12px; margin-bottom: 0; table-layout: fixed; width: 100%;">
                <thead style="background-color: #f8f9fa; border-bottom: 2px solid #dee2e6; position: sticky; top: 0; z-index: 10;">
                    <tr>
                        <th style="padding: 6px; font-weight: 600; color: #495057; width: 20%; background-color: #f8f9fa; font-size: 11px;">Descripción Opción de Respuesta</th>
                        <th style="padding: 6px; font-weight: 600; color: #495057; width: 15%; background-color: #f8f9fa; font-size: 11px;">Complemento Descripción</th>
                        <th style="padding: 6px; font-weight: 600; color: #495057; width: 18%; background-color: #f8f9fa; font-size: 11px;">Texto Perfil</th>
                        <th style="padding: 6px; font-weight: 600; color: #495057; text-align: center; width: 8%; background-color: #f8f9fa; font-size: 11px;">Consecutivo</th>
                        <th style="padding: 6px; font-weight: 600; color: #495057; text-align: center; width: 8%; background-color: #f8f9fa; font-size: 11px;">Fotografía</th>
                        <th style="padding: 6px; font-weight: 600; color: #495057; width: 13%; background-color: #f8f9fa; font-size: 11px;">Ciudad</th>
                        <th style="padding: 6px; font-weight: 600; color: #495057; width: 13%; background-color: #f8f9fa; font-size: 11px;">Segmento</th>
                        <th style="padding: 6px; font-weight: 600; color: #495057; text-align: center; width: 5%; background-color: #f8f9fa; font-size: 11px;">Acciones</th>
                    </tr>
                </thead>
          <tbody id="opciones-container">
    <?php if(!empty($candidatos)): ?>
        <?php foreach($candidatos as $i => $c): ?>
            <tr class="opcion" data-index="<?= $i ?>" data-candidato-id="<?= isset($c->ID_CANDID) ? $c->ID_CANDID : '' ?>" data-candidato-db-id="<?= isset($c->ID_CANDID) ? $c->ID_CANDID : '' ?>" style="vertical-align: middle;">
                <!-- Campo oculto con el ID del candidato (para UPDATE) -->
                <input type="hidden" name="opciones[<?= $i ?>][id_candidato]" value="<?= isset($c->ID_CANDID) ? $c->ID_CANDID : '' ?>">
                
                <td style="padding: 6px;">
                    <input type="text" name="opciones[<?= $i ?>][descripcion]" class="form-control" value="<?= $c->TEX_NOMCAN ?>" required style="border-radius: 4px; font-size: 12px;">
                </td>
                <td style="padding: 6px;">
                    <input type="text" name="opciones[<?= $i ?>][complemento]" class="form-control" value="<?= $c->TEX_APECAN ?>" style="border-radius: 4px; font-size: 12px;">
                </td>
                <td style="padding: 6px;">
                    <input type="text" name="opciones[<?= $i ?>][texto_perfil]" class="form-control" value="<?= isset($c->TEX_PERCAN) ? $c->TEX_PERCAN : '' ?>" style="border-radius: 4px; font-size: 12px;" placeholder="Perfil">
                </td>
                <td style="padding: 6px; text-align: center;">
                    <div style="display: flex; flex-direction: column; align-items: center; gap: 4px;">
                        <input type="number" name="opciones[<?= $i ?>][orden]" class="form-control only-numbers orden-input text-center" min="0" value="<?= $c->NUM_ORDEN ?>" required style="border-radius: 4px; font-weight: bold; color: #28a745; font-size: 14px; width: 45px; height: 32px; padding: 4px;">
                        <div class="btn-group-vertical" style="width: 45px;">
                            <button type="button" class="btn btn-outline-secondary btn-xs mover-arriba" style="height: 20px; padding: 0; border-radius: 3px 3px 0 0; font-size: 10px; line-height: 1;" title="Subir">
                                <i class="fa fa-chevron-up"></i>
                            </button>
                            <button type="button" class="btn btn-outline-secondary btn-xs mover-abajo" style="height: 20px; padding: 0; border-radius: 0 0 3px 3px; font-size: 10px; line-height: 1; border-top: none;" title="Bajar">
                                <i class="fa fa-chevron-down"></i>
                            </button>
                        </div>
                    </div>
                </td>
                <!-- Fotografía -->
                <td style="padding: 6px; text-align: center;">
                    <div class="foto-container" style="position: relative;">
                        <div class="preview-foto" style="width: 60px; height: 60px; border: 2px dashed #dee2e6; border-radius: 6px; display: flex; align-items: center; justify-content: center; margin: 0 auto 4px; background-color: #f8f9fa; cursor: pointer; transition: all 0.3s ease;" onclick="document.getElementById('imagen_<?= $i ?>').click();">
                            <?php if (!empty($c->TEX_FOTO)): ?>
                                <img src="<?= base_url($c->TEX_FOTO) ?>" alt="Vista previa" style="width: 100%; height: 100%; object-fit: cover; border-radius: 4px;">
                            <?php else: ?>
                                <i class="fa fa-camera" style="font-size: 18px; color: #6c757d;"></i>
                            <?php endif; ?>
                        </div>
                        <input type="file" name="opciones[<?= $i ?>][imagen]" id="imagen_<?= $i ?>" class="form-control upload-foto" accept="image/*" style="display: none;" data-tiene-foto="<?= !empty($c->TEX_FOTO) ? '1' : '0' ?>">
                        <small class="text-muted" style="font-size: 10px;">Click</small>
                    </div>
                </td>
                <!-- Ciudad -->
                <td style="padding: 6px;">
                    <select name="opciones[<?= $i ?>][ciudad]" 
                            class="form-control select-ciudad" 
                            data-loaded="0" 
                            data-selected="<?= $c->COD_CIUDAD ?>"
                            required
                            style="border-radius: 4px; font-size: 12px;">
                        <?php if ($c->COD_CIUDAD): ?>
                            <option value="<?= $c->COD_CIUDAD ?>" selected><?= $c->TEX_NOMCIU ?></option>
                        <?php else: ?>
                            <option value="">Seleccione</option>
                        <?php endif; ?>
                    </select>
                </td>
                <!-- Segmento -->
                <td style="padding: 6px;">
                    <select name="opciones[<?= $i ?>][segmento]" 
                            class="form-control select-agencia" 
                            data-loaded="0" 
                            data-selected="<?= $c->COD_AGENCIA ?>"
                            required
                            style="border-radius: 4px; font-size: 12px;">
                        <?php if ($c->COD_AGENCIA): ?>
                            <option value="<?= $c->COD_AGENCIA ?>" selected><?= $c->TEX_NOMAGE ?></option>
                        <?php else: ?>
                            <option value="">Seleccione</option>
                        <?php endif; ?>
                    </select>
                </td>
                <td style="padding: 6px; text-align: center;">
    <div class="btn-group btn-group-sm">
        <?php if (isset($c->ID_CANDID) && $c->ID_CANDID): ?>
            <!-- Botón de estado (muestra si está activado o desactivado) -->
            <button type="button" 
                    class="btn <?= ($c->BOL_ACTIVO == 1) ? 'btn-success' : 'btn-danger' ?> btn-toggle-estado" 
                    data-candidato-id="<?= $c->ID_CANDID ?>" 
                    data-estado-actual="<?= ($c->BOL_ACTIVO == 1) ? 1 : 0 ?>"
                    title="<?= ($c->BOL_ACTIVO == 1) ? 'Desactivar' : 'Activar' ?>"
                    style="padding: 2px 4px; font-size: 10px;">
                <?php if ($c->BOL_ACTIVO == 1): ?>
                    <i class="fa fa-check"></i>
                <?php else: ?>
                    <i class="fa fa-times"></i>
                <?php endif; ?>
            </button>
        <?php endif; ?>

        <!-- Botón eliminar -->
       
            <button type="button" 
                class="btn btn-danger eliminar-candidato" 
                data-id="<?= $c->ID_CANDID ?>" 
                title="Eliminar"
                style="padding: 2px 4px; font-size: 10px;">
            <i class="fa fa-trash"></i>
        </button>


    </div>
</td>

            </tr>
        <?php endforeach; ?>
    <?php else: ?>
        <!-- Fila nueva si no hay candidatos -->
        <tr class="opcion" data-index="0" style="vertical-align: middle;">
            <!-- Campo oculto vacío (para INSERT) -->
            <input type="hidden" name="opciones[0][id_candidato]" value="">
            
            <td style="padding: 6px;">
                <input type="text" name="opciones[0][descripcion]" class="form-control" placeholder="Descripción" required style="border-radius: 4px; font-size: 12px;">
            </td>
            <td style="padding: 6px;">
                <input type="text" name="opciones[0][complemento]" class="form-control" placeholder="Complemento"  style="border-radius: 4px; font-size: 12px;">
            </td>
            <td style="padding: 6px;">
                <input type="text" name="opciones[0][texto_perfil]" class="form-control" placeholder="Perfil" style="border-radius: 4px; font-size: 12px;">
            </td>
            <td style="padding: 6px; text-align: center;">
                <div style="display: flex; flex-direction: column; align-items: center; gap: 4px;">
                    <input type="number" name="opciones[0][orden]" class="form-control only-numbers orden-input text-center" min="0" placeholder="#" required style="border-radius: 4px; font-weight: bold; color: #28a745; font-size: 14px; width: 45px; height: 32px; padding: 4px;">
                    <div class="btn-group-vertical" style="width: 45px;">
                        <button type="button" class="btn btn-outline-secondary btn-xs mover-arriba" style="height: 20px; padding: 0; border-radius: 3px 3px 0 0; font-size: 10px; line-height: 1;" title="Subir">
                            <i class="fa fa-chevron-up"></i>
                        </button>
                        <button type="button" class="btn btn-outline-secondary btn-xs mover-abajo" style="height: 20px; padding: 0; border-radius: 0 0 3px 3px; font-size: 10px; line-height: 1; border-top: none;" title="Bajar">
                            <i class="fa fa-chevron-down"></i>
                        </button>
                    </div>
                </div>
            </td>
            <td style="padding: 6px; text-align: center;">
                <div class="foto-container" style="position: relative;">
                    <div class="preview-foto" style="width: 60px; height: 60px; border: 2px dashed #dee2e6; border-radius: 6px; display: flex; align-items: center; justify-content: center; margin: 0 auto 4px; background-color: #f8f9fa; cursor: pointer; transition: all 0.3s ease;" onclick="document.getElementById('imagen_0').click();">
                        <i class="fa fa-camera" style="font-size: 18px; color: #6c757d;"></i>
                    </div>
                    <input type="file" name="opciones[0][imagen]" id="imagen_0" class="form-control upload-foto" accept="image/*" style="display: none;" data-tiene-foto="0">
                    <small class="text-muted" style="font-size: 10px;">Click</small>
                </div>
            </td>
            <td style="padding: 6px;">
                <select name="opciones[0][ciudad]" class="form-control select-ciudad" data-loaded="0" required style="border-radius: 4px; font-size: 12px;">
                    <option value="">Seleccione</option>
                </select>
            </td>
            <td style="padding: 6px;">
                <select name="opciones[0][segmento]" class="form-control select-agencia" data-loaded="0" required style="border-radius: 4px; font-size: 12px;">
                    <option value="">Seleccione</option>
                </select>
            </td>
            <td style="padding: 6px; text-align: center;">
                <div class="btn-group btn-group-sm">
                    <button type="button" class="btn btn-danger eliminar-fila" title="Eliminar" style="padding: 2px 4px; font-size: 10px;">
                        <i class="fa fa-trash"></i>
                    </button>
                </div>
            </td>
        </tr>
    <?php endif; ?>
</tbody>

            </table>
        </div>

        <div class="form-group" style="margin-top:15px;">
            <button type="button" id="agregar-opcion" class="btn btn-warning" style="background-color: #ff9500; border-color: #ff9500; color: white; font-weight: 600; padding: 10px 20px; border-radius: 6px; box-shadow: 0 2px 4px rgba(0,0,0,0.1);">
                <i class="fa fa-plus" style="margin-right: 8px;"></i> Agregar Nuevas Respuesta/ Candidato
            </button>
            <button type="submit" class="btn btn-primary" style="background-color: #4a90e2; border-color: #4a90e2; color: white; font-weight: 600; padding: 10px 20px; border-radius: 6px; box-shadow: 0 2px 4px rgba(0,0,0,0.1);" id="guardar-respuestas">
                <i class="fa fa-save" style="margin-right: 8px;"></i> Guardar Respuestas / Candidato
            </button>
        </div>
    </form>
            </div>
        </div>
    </div>
    <?php endif; ?>
</section>

<script>
// ================= VALIDACIONES =================
document.addEventListener('input', function(e) {
    if(e.target.classList.contains('only-numbers')) {
        e.target.value = e.target.value.replace(/[^0-9]/g, '');
        if (e.target.value < 0) e.target.value = 0;
    }
});

// ================= FUNCIONALIDAD BOTÓN ACTIVAR/DESACTIVAR =================
document.addEventListener('click', function(e) {
    if (e.target.closest('.btn-toggle-estado')) {
        var btn = e.target.closest('.btn-toggle-estado');
        var candidatoId = btn.getAttribute('data-candidato-id');
        var estadoActual = parseInt(btn.getAttribute('data-estado-actual'));
        var nuevoEstado = estadoActual === 1 ? 0 : 1;
        
        if (confirm('¿Está seguro de que desea ' + (estadoActual === 1 ? 'desactivar' : 'activar') + ' este candidato?')) {
            // Hacer petición AJAX para cambiar estado
            fetch('<?= base_url("pyr/cambiar_estado_candidato") ?>/' + candidatoId + '/' + nuevoEstado, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    // Actualizar el botón
                    if (nuevoEstado === 1) {
                        btn.className = 'btn btn-warning btn-toggle-estado';
                        btn.innerHTML = '<i class="fa fa-pause"></i> Desactivar';
                    } else {
                        btn.className = 'btn btn-success btn-toggle-estado';
                        btn.innerHTML = '<i class="fa fa-play"></i> Activar';
                    }
                    btn.setAttribute('data-estado-actual', nuevoEstado);
                    
                    // Mostrar mensaje de éxito
                    alert(data.message || (nuevoEstado === 1 ? 'Candidato activado correctamente.' : 'Candidato desactivado correctamente.'));
                } else {
                    alert(data.message || 'Error al cambiar el estado del candidato.');
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('Error al procesar la solicitud.');
            });
        }
    }
});

// ================= VISTA PREVIA IMAGEN =================
document.addEventListener('change', function(e) {
    if(e.target.classList.contains('upload-foto')) {
        const file = e.target.files[0];
        if(file) {
            const reader = new FileReader();
            reader.onload = function(ev) {
                let preview = e.target.closest('td').querySelector('.preview-foto');
                if(!preview) {
                    preview = e.target.closest('.foto-container').querySelector('.preview-foto');
                }
                preview.innerHTML = `<img src="${ev.target.result}" style="width: 100%; height: 100%; object-fit: cover; border-radius: 6px;">`;
                // Marcar que ahora tiene foto
                e.target.setAttribute('data-tiene-foto', '1');
            };
            reader.readAsDataURL(file);
        }
    }
});

// ================= HOVER EFFECT PARA FOTOS =================
document.addEventListener('mouseover', function(e) {
    if(e.target.closest('.preview-foto')) {
        e.target.closest('.preview-foto').style.borderColor = '#007bff';
        e.target.closest('.preview-foto').style.backgroundColor = '#e3f2fd';
    }
});

document.addEventListener('mouseout', function(e) {
    if(e.target.closest('.preview-foto')) {
        e.target.closest('.preview-foto').style.borderColor = '#dee2e6';
        e.target.closest('.preview-foto').style.backgroundColor = '#f8f9fa';
    }
});

// ================= HOVER EFFECT PARA CANDIDATOS PREESTABLECIDOS =================
document.addEventListener('mouseover', function(e) {
    if(e.target.closest('.candidato-item')) {
        let item = e.target.closest('.candidato-item');
        item.style.transform = 'translateY(-2px)';
        item.style.boxShadow = '0 4px 12px rgba(0,0,0,0.15)';
        item.style.borderColor = '#007bff';
    }
});

document.addEventListener('mouseout', function(e) {
    if(e.target.closest('.candidato-item')) {
        let item = e.target.closest('.candidato-item');
        item.style.transform = 'translateY(0)';
        item.style.boxShadow = '0 2px 4px rgba(0,0,0,0.1)';
        item.style.borderColor = '#e0e0e0';
    }
});

// ================= FUNCIÓN PARA OCULTAR/MOSTRAR CANDIDATOS =================
function ocultarCandidatosAgregados() {
    // Obtener todos los IDs de candidatos ya en la tabla
    let candidatosEnTabla = [];
    let opcionesContainer = document.getElementById('opciones-container');
    
    if (!opcionesContainer) {
        return;
    }
    
    opcionesContainer.querySelectorAll('.opcion').forEach(function(fila) {
        let candidatoId = fila.dataset.candidatoId;
        if (candidatoId && candidatoId !== '') {
            candidatosEnTabla.push(candidatoId);
        }
    });
    
    // Ocultar candidatos que ya están en la tabla
    document.querySelectorAll('.candidato-item').forEach(function(item) {
        let idCandidato = item.dataset.idCandidato;
        if (candidatosEnTabla.includes(idCandidato)) {
            item.style.display = 'none';
            item.classList.add('ya-agregado');
        } else {
            item.style.display = 'block';
            item.classList.remove('ya-agregado');
        }
    });
    
    // Actualizar contador después de filtrar
    actualizarContador();
}

// ================= AGREGAR FILA =================
document.getElementById('agregar-opcion')?.addEventListener('click', function() {
    var container = document.getElementById('opciones-container');
    var index = container.querySelectorAll('.opcion').length;
    var tr = document.createElement('tr');
    tr.className = "opcion";
    tr.setAttribute("data-index", index);
    tr.innerHTML = `
        <td style="padding: 6px;"><input type="text" name="opciones[${index}][descripcion]" class="form-control" placeholder="Descripción" required style="border-radius: 4px; font-size: 12px;"></td>
        <td style="padding: 6px;"><input type="text" name="opciones[${index}][complemento]" class="form-control" placeholder="Complemento"  style="border-radius: 4px; font-size: 12px;"></td>
        <td style="padding: 6px;"><input type="text" name="opciones[${index}][texto_perfil]" class="form-control" placeholder="Perfil" style="border-radius: 4px; font-size: 12px;"></td>
        <td style="padding: 6px; text-align: center;">
            <div style="display: flex; flex-direction: column; align-items: center; gap: 4px;">
                <input type="number" name="opciones[${index}][orden]" class="form-control only-numbers orden-input text-center" min="0" placeholder="#" required style="border-radius: 4px; font-weight: bold; color: #28a745; font-size: 14px; width: 45px; height: 32px; padding: 4px;">
                <div class="btn-group-vertical" style="width: 45px;">
                    <button type="button" class="btn btn-outline-secondary btn-xs mover-arriba" style="height: 20px; padding: 0; border-radius: 3px 3px 0 0; font-size: 10px; line-height: 1;" title="Subir">
                        <i class="fa fa-chevron-up"></i>
                    </button>
                    <button type="button" class="btn btn-outline-secondary btn-xs mover-abajo" style="height: 20px; padding: 0; border-radius: 0 0 3px 3px; font-size: 10px; line-height: 1; border-top: none;" title="Bajar">
                        <i class="fa fa-chevron-down"></i>
                    </button>
                </div>
            </div>
        </td>
        <td style="padding: 6px; text-align: center;">
            <div class="foto-container" style="position: relative;">
                <div class="preview-foto" style="width: 60px; height: 60px; border: 2px dashed #dee2e6; border-radius: 6px; display: flex; align-items: center; justify-content: center; margin: 0 auto 4px; background-color: #f8f9fa; cursor: pointer; transition: all 0.3s ease;" onclick="document.getElementById('imagen_${index}').click();">
                    <i class="fa fa-camera" style="font-size: 18px; color: #6c757d;"></i>
                </div>
                <input type="file" name="opciones[${index}][imagen]" id="imagen_${index}" class="form-control upload-foto" accept="image/*" style="display: none;" data-tiene-foto="0">
                <small class="text-muted" style="font-size: 10px;">Click</small>
            </div>
        </td>
        <td style="padding: 6px;">
            <select name="opciones[${index}][ciudad]" class="form-control select-ciudad" data-loaded="0" required style="border-radius: 4px; font-size: 12px;">
                <option value="">Seleccione</option>
            </select>
        </td>
        <td style="padding: 6px;">
            <select name="opciones[${index}][segmento]" class="form-control select-agencia" data-loaded="0" required style="border-radius: 4px; font-size: 12px;">
                <option value="">Seleccione</option>
            </select>
        </td>
        <td style="padding: 6px; text-align: center;">
            <div class="btn-group btn-group-sm">
                <button type="button" class="btn btn-danger eliminar-fila" title="Eliminar" style="padding: 2px 4px; font-size: 10px;">
                    <i class="fa fa-trash"></i>
                </button>
            </div>
        </td>`;
    tr.style.verticalAlign = 'middle';
    container.appendChild(tr);
    actualizarOrdenes();
    
    // ================= SCROLL Y ENFOQUE =================
    // Hacer scroll hacia la nueva fila agregada
    tr.scrollIntoView({ 
        behavior: 'smooth', 
        block: 'center' 
    });
    
    // Enfocar el primer input de la nueva fila
    setTimeout(function() {
        var primerInput = tr.querySelector('input[type="text"]');
        if (primerInput) {
            primerInput.focus();
        }
    }, 300);
});

// ================= VALIDACIÓN COMPLETA ANTES DE ENVIAR =================
document.getElementById('form-respuestas').addEventListener('submit', function(e) {
    e.preventDefault(); // Prevenir envío automático
    
    // Guardar flag para hacer scroll después de recargar
    localStorage.setItem('scrollToRespuestas', 'true');
    
    let overlay = document.getElementById('loader-overlay');
    overlay.style.display = 'flex'; // Mostrar loader

    let errores = [];
    let filas = document.querySelectorAll('#opciones-container .opcion');
    
    // Verificar que hay al menos una fila
    if (filas.length === 0) {
        alert('Debe agregar al menos una opción de respuesta antes de guardar.');
        overlay.style.display = 'none'; // 🔹 Ocultar loader si hay error
        return false;
    }
    
    // Validar cada fila
    filas.forEach(function(fila, index) {
        let numeroFila = index + 1;

        let descripcion = fila.querySelector('input[name*="[descripcion]"]');
        if (!descripcion.value.trim()) {
            errores.push(`Fila ${numeroFila}: Descripción es obligatoria`);
            descripcion.style.borderColor = '#d9534f';
            descripcion.style.backgroundColor = '#f2dede';
        }

        let orden = fila.querySelector('input[name*="[orden]"]');
        if (!orden.value.trim()) {
            errores.push(`Fila ${numeroFila}: Consecutivo es obligatorio`);
            orden.style.borderColor = '#d9534f';
            orden.style.backgroundColor = '#f2dede';
        }

        let inputFoto = fila.querySelector('input[type="file"]');
        let tieneFoto = inputFoto.getAttribute('data-tiene-foto') === '1';
        let archivoSeleccionado = inputFoto.files && inputFoto.files.length > 0;
        if (!tieneFoto && !archivoSeleccionado) {
            errores.push(`Fila ${numeroFila}: Fotografía es obligatoria`);
            let previewFoto = fila.querySelector('.preview-foto');
            previewFoto.style.borderColor = '#d9534f';
            previewFoto.style.backgroundColor = '#f2dede';
        }

        let ciudad = fila.querySelector('select[name*="[ciudad]"]');
        if (!ciudad.value) {
            errores.push(`Fila ${numeroFila}: Ciudad es obligatoria`);
            ciudad.style.borderColor = '#d9534f';
            ciudad.style.backgroundColor = '#f2dede';
        }

        let segmento = fila.querySelector('select[name*="[segmento]"]');
        if (!segmento.value) {
            errores.push(`Fila ${numeroFila}: Segmento es obligatoria`);
            segmento.style.borderColor = '#d9534f';
            segmento.style.backgroundColor = '#f2dede';
        }
    });

    // Si hay errores
    if (errores.length > 0) {
        overlay.style.display = 'none'; // 🔹 Ocultar loader si hay errores
        let mensaje = 'Se encontraron los siguientes errores:\n\n' + errores.join('\n');
        alert(mensaje);
        return false;
    }

    // Si no hay errores, enviar el formulario
    this.submit();
});


// Limpiar estilos de error cuando el usuario interactúe
document.addEventListener('input', function(e) {
    if (e.target.style.borderColor === 'rgb(217, 83, 79)') {
        e.target.style.borderColor = '';
        e.target.style.backgroundColor = '';
    }
});

document.addEventListener('change', function(e) {
    if (e.target.style.borderColor === 'rgb(217, 83, 79)') {
        e.target.style.borderColor = '';
        e.target.style.backgroundColor = '';
    }
    
    // Limpiar error de foto cuando se selecciona una imagen
    if (e.target.classList.contains('upload-foto') && e.target.files.length > 0) {
        let previewFoto = e.target.closest('td').querySelector('.preview-foto');
        if (previewFoto) {
            previewFoto.style.borderColor = '#dee2e6';
            previewFoto.style.backgroundColor = '#f8f9fa';
        }
    }
});

// ================= AJAX CIUDADES =================
// Cargar ciudades para filtros
document.addEventListener('DOMContentLoaded', function() {
    // Ocultar candidatos ya agregados al cargar la página
    ocultarCandidatosAgregados();
    
    // Cargar ciudades para filtro
    fetch('<?= base_url("pyr/ajax_ciudades") ?>')
        .then(r => r.json())
        .then(data => {
            let select = document.getElementById('filtro-ciudad');
            data.forEach(ciudad => {
                let opt = document.createElement('option');
                opt.value = ciudad.COD_CIUDAD;
                opt.textContent = ciudad.TEX_NOMCIU;
                select.appendChild(opt);
            });
        });

    // Cargar agencias para filtro
    fetch('<?= base_url("pyr/ajax_agencias") ?>')
        .then(r => r.json())
        .then(data => {
            let select = document.getElementById('filtro-agencia');
            data.forEach(agencia => {
                let opt = document.createElement('option');
                opt.value = agencia.COD_AGENCIA;
                opt.textContent = agencia.TEX_NOMAGE;
                select.appendChild(opt);
            });
        });
    
    // Verificar si debe hacer scroll después de recargar
    if (localStorage.getItem('scrollToRespuestas') === 'true') {
        // Limpiar el flag
        localStorage.removeItem('scrollToRespuestas');
        
        // Hacer scroll hacia las opciones de respuesta después de que todo esté cargado
        setTimeout(function() {
            let opcionesPanel = document.querySelector('.panel-info');
            if (opcionesPanel) {
                opcionesPanel.scrollIntoView({ 
                    behavior: 'smooth', 
                    block: 'start' 
                });
            }
        }, 500);
    }
});

document.addEventListener('focusin', function(e){
    if(e.target.classList.contains('select-ciudad') && e.target.dataset.loaded == "0"){
        let selected = e.target.dataset.selected;
        fetch('<?= base_url("pyr/ajax_ciudades") ?>')
            .then(r => r.json())
            .then(data => {
                e.target.innerHTML = '<option value="">Seleccione</option>';
                data.forEach(ciudad => {
                    let opt = document.createElement('option');
                    opt.value = ciudad.COD_CIUDAD;
                    opt.textContent = ciudad.TEX_NOMCIU;
                    if(selected && selected == ciudad.COD_CIUDAD) opt.selected = true;
                    e.target.appendChild(opt);
                });
                e.target.dataset.loaded = "1";
            });
    }
});

// ================= AJAX AGENCIAS =================
document.addEventListener('focusin', function(e){
    if(e.target.classList.contains('select-agencia') && e.target.dataset.loaded == "0"){
        let selected = e.target.dataset.selected;
        fetch('<?= base_url("pyr/ajax_agencias") ?>')
            .then(r => r.json())
            .then(data => {
                e.target.innerHTML = '<option value="">Seleccione</option>';
                data.forEach(agen => {
                    let opt = document.createElement('option');
                    opt.value = agen.COD_AGENCIA;
                    opt.textContent = agen.TEX_NOMAGE;
                    if(selected && selected == agen.COD_AGENCIA) opt.selected = true;
                    e.target.appendChild(opt);
                });
                e.target.dataset.loaded = "1";
            });
    }
});

// ================= MOVER ↑ ↓ =================
document.addEventListener('click', function(e) {
    if (e.target.classList.contains('mover-arriba') || e.target.classList.contains('mover-abajo')) {
        let fila = e.target.closest('tr');
        let container = document.getElementById('opciones-container');
        if (e.target.classList.contains('mover-arriba') && fila.previousElementSibling) {
            container.insertBefore(fila, fila.previousElementSibling);
        } else if (e.target.classList.contains('mover-abajo') && fila.nextElementSibling) {
            container.insertBefore(fila.nextElementSibling, fila);
        }
        actualizarOrdenes();
    }
});

// ================= ELIMINAR FILA =================
document.addEventListener('click', function(e) {
    if (e.target.classList.contains('eliminar-fila')) {
        if (confirm('¿Está seguro de que desea eliminar esta opción de respuesta?')) {
            // Obtener el ID del candidato antes de eliminar la fila
            let fila = e.target.closest('tr');
            let candidatoId = fila.dataset.candidatoId;
            
            e.target.closest('tr').remove();
            actualizarOrdenes();
            
            // Si el candidato eliminado era un duplicado, también eliminar de la lista preestablecidos
            if (candidatoId && candidatoId.startsWith('dup_')) {
                let candidatoItem = document.querySelector(`[data-id-candidato="${candidatoId}"]`);
                if (candidatoItem) {
                    candidatoItem.remove();
                }
            }
            
            // Actualizar candidatos ocultos después de eliminar fila
            ocultarCandidatosAgregados();
        }
    }
});

// ================= ELIMINAR CANDIDATO POR AJAX =================
document.addEventListener('click', function(e) {
    if (e.target.classList.contains('eliminar-candidato') || e.target.closest('.eliminar-candidato')) {
        let btn = e.target.closest('.eliminar-candidato');
        let idCandidato = btn.dataset.id;

        if (confirm('¿Está seguro de que desea eliminar este candidato?')) {
            fetch('<?= base_url("pyr/eliminar_candidato_ajax/") ?>' + idCandidato, {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' }
            })
            .then(r => r.json())
            .then(data => {
                if (data.success) {
                    // Eliminar la fila directamente de la tabla
                    let fila = btn.closest('tr');
                    fila.remove();

                    alert(data.message);
                } else {
                    alert(data.message);
                }
            })
            .catch(err => {
                console.error(err);
                alert('Error al procesar la solicitud.');
            });
        }
    }
});


// ================= REORDENAR =================
function actualizarOrdenes() {
    document.querySelectorAll('#opciones-container .opcion').forEach((fila, i) => {
        let ordenInput = fila.querySelector('.orden-input');
        if (ordenInput) ordenInput.value = i + 1;
    });
}

// ================= FUNCIONALIDAD CANDIDATOS PREESTABLECIDOS =================

// Buscador en tiempo real
document.getElementById('buscar-candidato')?.addEventListener('input', function() {
    filtrarCandidatos();
});

// Filtros por ciudad y agencia
document.getElementById('filtro-ciudad')?.addEventListener('change', function() {
    filtrarCandidatos();
});

document.getElementById('filtro-agencia')?.addEventListener('change', function() {
    filtrarCandidatos();
});

// Limpiar filtros
document.getElementById('limpiar-filtros')?.addEventListener('click', function() {
    document.getElementById('buscar-candidato').value = '';
    document.getElementById('filtro-ciudad').value = '';
    document.getElementById('filtro-agencia').value = '';
    filtrarCandidatos();
});

// Función para filtrar candidatos
function filtrarCandidatos() {
    let busqueda = document.getElementById('buscar-candidato').value.toLowerCase();
    let ciudadFiltro = document.getElementById('filtro-ciudad').value;
    let agenciaFiltro = document.getElementById('filtro-agencia').value;
    
    let candidatos = document.querySelectorAll('.candidato-item');
    let visibles = 0;
    
    candidatos.forEach(function(candidato) {
        // No mostrar candidatos ya agregados
        if (candidato.classList.contains('ya-agregado')) {
            candidato.style.display = 'none';
            return;
        }
        
        let nombre = candidato.dataset.nombre;
        let ciudad = candidato.dataset.ciudad;
        let agencia = candidato.dataset.agencia;
        
        let mostrar = true;
        
        // Filtro por nombre
        if (busqueda && !nombre.includes(busqueda)) {
            mostrar = false;
        }
        
        // Filtro por ciudad
        if (ciudadFiltro && ciudad != ciudadFiltro) {
            mostrar = false;
        }
        
        // Filtro por agencia
        if (agenciaFiltro && agencia != agenciaFiltro) {
            mostrar = false;
        }
        
        candidato.style.display = mostrar ? 'block' : 'none';
        if (mostrar) visibles++;
    });
    
    // Actualizar contador
    actualizarContador();
}

// Seleccionar/deseleccionar todos
document.getElementById('seleccionar-todos')?.addEventListener('change', function() {
    let checkboxes = document.querySelectorAll('.candidato-item:not([style*="display: none"]) .candidato-checkbox');
    checkboxes.forEach(function(checkbox) {
        checkbox.checked = this.checked;
    }, this);
    actualizarContador();
});

// Actualizar contador cuando se selecciona individualmente
document.addEventListener('change', function(e) {
    if (e.target.classList.contains('candidato-checkbox')) {
        actualizarContador();
    }
});

// Función para actualizar contador
function actualizarContador() {
    let seleccionados = document.querySelectorAll('.candidato-checkbox:checked').length;
    let contadorElement = document.getElementById('contador-seleccionados');
    if (contadorElement) {
        contadorElement.textContent = `(${seleccionados} seleccionados)`;
    }
}

// Agregar candidatos seleccionados a la tabla
document.getElementById('agregar-seleccionados')?.addEventListener('click', function() {
    let seleccionados = document.querySelectorAll('.candidato-checkbox:checked');
    let container = document.getElementById('opciones-container');
    
    if (seleccionados.length === 0) {
        alert('Por favor seleccione al menos un candidato');
        return;
    }
    
    if (!container) {
        alert('Error: No se encontró la tabla de opciones');
        return;
    }
    
    seleccionados.forEach(function(checkbox) {
        let index = container.querySelectorAll('.opcion').length;
        let tr = document.createElement('tr');
        tr.className = "opcion";
        tr.setAttribute("data-index", index);
        tr.setAttribute("data-candidato-id", checkbox.dataset.id);
        tr.style.verticalAlign = 'middle';
        
        let fotoHtml = '';
        let tieneFoto = '0';
        if (checkbox.dataset.foto && checkbox.dataset.foto !== '') {
            fotoHtml = `<img src="<?= base_url() ?>${checkbox.dataset.foto}" style="width: 100%; height: 100%; object-fit: cover; border-radius: 6px;">`;
            tieneFoto = '1';
        } else {
            fotoHtml = `<i class="fa fa-camera" style="font-size: 24px; color: #6c757d;"></i>`;
        }
        
        tr.innerHTML = `
          <input type="hidden" name="opciones[${index}][id_candidato]" value="${checkbox.dataset.id.startsWith('dup_') ? '' : checkbox.dataset.id}">
          <input type="hidden" name="opciones[${index}][id_original]" value="${checkbox.dataset.id.startsWith('dup_') ? checkbox.dataset.id.split('_')[1] : ''}">
          <input type="hidden" name="opciones[${index}][foto_original]" value="${checkbox.dataset.id.startsWith('dup_') ? checkbox.dataset.foto : ''}">

            <td style="padding: 10px;">
                <input type="text" name="opciones[${index}][descripcion]" class="form-control" value="${checkbox.dataset.nombre}${checkbox.dataset.id.startsWith('dup_') ? ' (Copia)' : ''}" required style="border-radius: 6px;">
            </td>
            <td style="padding: 10px;">
                <input type="text" name="opciones[${index}][complemento]" class="form-control" value="${checkbox.dataset.apellido}"  style="border-radius: 6px;">
            </td>
            <td style="padding: 10px;">
                <input type="text" name="opciones[${index}][texto_perfil]" class="form-control" value="${checkbox.dataset.textoPerfil || ''}" style="border-radius: 6px;" placeholder="Texto del perfil">
            </td>
            <td style="padding: 10px; text-align: center;">
                <div class="input-group input-group-sm">
                    <input type="number" name="opciones[${index}][orden]" class="form-control only-numbers orden-input text-center" min="0" value="${index + 1}" required style="border-radius: 6px; font-weight: bold; color: #28a745; margin-bottom: 5px;">
                </div>
                <div class="btn-group btn-group-sm" style="width: 100%;">
                    <button type="button" class="btn btn-outline-secondary btn-sm mover-arriba" style="width: 50%; border-radius: 4px 0 0 4px;" title="Mover arriba">
                        <i class="fa fa-chevron-up"></i>
                    </button>
                    <button type="button" class="btn btn-outline-secondary btn-sm mover-abajo" style="width: 50%; border-radius: 0 4px 4px 0;" title="Mover abajo">
                        <i class="fa fa-chevron-down"></i>
                    </button>
                </div>
            </td>
            <td style="padding: 10px; text-align: center;">
                <div class="foto-container" style="position: relative;">
                    <div class="preview-foto" style="width: 60px; height: 60px; border: 2px dashed #dee2e6; border-radius: 6px; display: flex; align-items: center; justify-content: center; margin: 0 auto 4px; background-color: #f8f9fa; cursor: pointer; transition: all 0.3s ease;" onclick="document.getElementById('imagen_${index}').click();">
                        ${fotoHtml}
                    </div>
                    <input type="file" name="opciones[${index}][imagen]" id="imagen_${index}" class="form-control upload-foto" accept="image/*" style="display: none;" data-tiene-foto="${tieneFoto}">
                    <small class="text-muted" style="font-size: 10px;">Click</small>
                </div>
            </td>
            <td style="padding: 6px;">
                <select name="opciones[${index}][ciudad]" class="form-control select-ciudad" data-loaded="1" data-selected="${checkbox.dataset.ciudad}" required style="border-radius: 4px; font-size: 12px;">
                    <option value="${checkbox.dataset.ciudad}" selected>${checkbox.dataset.ciudadNombre || ''}</option>
                </select>
            </td>
            <td style="padding: 6px;">
                <select name="opciones[${index}][segmento]" class="form-control select-agencia" data-loaded="1" data-selected="${checkbox.dataset.agencia}" required style="border-radius: 4px; font-size: 12px;">
                    <option value="${checkbox.dataset.agencia}" selected>${checkbox.dataset.agenciaNombre || ''}</option>
                </select>
            </td>
            <td style="padding: 6px; text-align: center;">
                <div class="btn-group btn-group-sm">
                    <button type="button" class="btn btn-danger eliminar-fila" style="padding: 4px 6px; font-size: 10px; border-radius: 4px;" data-es-duplicado="${checkbox.dataset.id.startsWith('dup_') ? 'true' : 'false'}">
                        <i class="fa fa-trash"></i>
                    </button>
                </div>
            </td>`;
        
        container.appendChild(tr);
        
        // Desmarcar el checkbox
        checkbox.checked = false;
    });
    
    actualizarOrdenes();
    actualizarContador();
    
    // Ocultar candidatos recién agregados
    ocultarCandidatosAgregados();
    
    // Scroll hacia la tabla
    document.querySelector('#opciones-container').scrollIntoView({ 
        behavior: 'smooth', 
        block: 'center' 
    });
});

// ================= DUPLICAR CANDIDATOS SELECCIONADOS =================
document.getElementById('duplicar-seleccionados')?.addEventListener('click', function() {
    let seleccionados = document.querySelectorAll('.candidato-checkbox:checked');
    let listaCandidatos = document.getElementById('lista-candidatos-predef');
    
    if (seleccionados.length === 0) {
        alert('Por favor seleccione al menos un candidato para duplicar');
        return;
    }
    
    if (!listaCandidatos) {
        alert('Error: No se encontró la lista de candidatos');
        return;
    }
    
    let candidatosDuplicados = [];
    
    seleccionados.forEach(function(checkbox) {
        let candidatoOriginal = checkbox.closest('.candidato-item');
        
        if (!candidatoOriginal) {
            console.error('No se encontró el elemento candidato-item');
            return;
        }
        
        // Generar ID único para el duplicado
        let idOriginal = checkbox.dataset.id;
        let timestamp = Date.now();
        let random = Math.floor(Math.random() * 1000);
        let idDuplicado = `dup_${idOriginal}_${timestamp}_${random}`;
        
        // Crear elemento duplicado
        let duplicado = candidatoOriginal.cloneNode(true);
        
        if (!duplicado) {
            console.error('Error al clonar el candidato');
            return;
        }
        
        duplicado.dataset.idCandidato = idDuplicado;
        duplicado.classList.add('candidato-duplicado');
        
        // Actualizar checkbox del duplicado
        let checkboxDuplicado = duplicado.querySelector('.candidato-checkbox');
        if (checkboxDuplicado) {
            checkboxDuplicado.dataset.id = idDuplicado;
            checkboxDuplicado.checked = false;
        }
        
        // Actualizar el texto para mostrar que es duplicado
        let label = duplicado.querySelector('label');
        if (label) {
            let textoOriginal = label.innerHTML;
            label.innerHTML = textoOriginal.replace(
                /<strong>([^<]+)<\/strong>/,
                '<strong>$1 <span style="color: #f0ad4e; font-weight: bold;">[DUPLICADO]</span></strong>'
            );
        }
        
        // Insertar después del candidato original
        if (candidatoOriginal.parentNode) {
            candidatoOriginal.parentNode.insertBefore(duplicado, candidatoOriginal.nextSibling);
        }
        
        // Desmarcar el checkbox original
        checkbox.checked = false;
        
        candidatosDuplicados.push({
            original: checkbox.dataset.nombre + ' ' + checkbox.dataset.apellido,
            duplicado: idDuplicado
        });
    });
    
    // Actualizar contador
    actualizarContador();
    
    // Mostrar mensaje de confirmación
    let mensaje = `Se han creado ${candidatosDuplicados.length} duplicado(s):\n\n`;
    candidatosDuplicados.forEach(function(item) {
        mensaje += `• ${item.original}\n`;
    });
    mensaje += '\nLos duplicados aparecen marcados con [DUPLICADO] y pueden ser agregados a la tabla de respuestas de forma independiente.';
    
    alert(mensaje);
    
    // Hacer scroll hacia los duplicados creados
    if (candidatosDuplicados.length > 0) {
        let primerDuplicado = document.querySelector(`[data-id-candidato="${candidatosDuplicados[0].duplicado}"]`);
        if (primerDuplicado) {
            primerDuplicado.scrollIntoView({ 
                behavior: 'smooth', 
                block: 'center' 
            });
        }
    }
});

// Agregar buscador para la tabla de respuestas
document.addEventListener('DOMContentLoaded', function() {
    // Crear el buscador para la tabla de respuestas
    let tablaContainer = document.querySelector('.table-responsive');
    if (tablaContainer) {
        let buscadorHtml = `
            <div style="margin-bottom: 15px;">
                <div class="row">
                    <div class="col-md-4">
                        <input type="text" id="buscar-en-tabla" class="form-control" placeholder="Buscar en tabla de respuestas..." style="border-radius: 6px;">
                    </div>
                    <div class="col-md-2">
                        <button type="button" id="limpiar-busqueda-tabla" class="btn btn-default" style="border-radius: 6px;">
                            <i class="fa fa-refresh"></i> Limpiar
                        </button>
                    </div>
                </div>
            </div>
        `;
        tablaContainer.insertAdjacentHTML('beforebegin', buscadorHtml);
        
        // Funcionalidad del buscador
        document.getElementById('buscar-en-tabla')?.addEventListener('input', function() {
            let busqueda = this.value.toLowerCase();
            let filas = document.querySelectorAll('#opciones-container .opcion');
            
            filas.forEach(function(fila) {
                let descripcion = fila.querySelector('input[name*="[descripcion]"]').value.toLowerCase();
                let complemento = fila.querySelector('input[name*="[complemento]"]').value.toLowerCase();
                let textoPerfil = fila.querySelector('input[name*="[texto_perfil]"]').value.toLowerCase();
                
                if (descripcion.includes(busqueda) || complemento.includes(busqueda)) {
                    fila.style.display = '';
                } else {
                    fila.style.display = 'none';
                }
            });
        });
        
        // Limpiar búsqueda
        document.getElementById('limpiar-busqueda-tabla')?.addEventListener('click', function() {
            document.getElementById('buscar-en-tabla').value = '';
            let filas = document.querySelectorAll('#opciones-container .opcion');
            filas.forEach(function(fila) {
                fila.style.display = '';
            });
        });
    }
});

// ================= LIMPIAR SOLO CANDIDATOS AGREGADOS DESDE PREESTABLECIDOS =================
document.getElementById('limpiar-tabla')?.addEventListener('click', function() {
    if (confirm('¿Está seguro de que desea eliminar solo los candidatos agregados desde la lista preestablecida?')) {
        // Buscar solo las filas que tienen data-candidato-id con valor (agregadas desde candidatos preestablecidos)
        let filasParaEliminar = document.querySelectorAll('#opciones-container .opcion[data-candidato-id]:not([data-candidato-id=""])');
        
        // Eliminar solo esas filas
        filasParaEliminar.forEach(function(fila) {
            fila.remove();
        });
        
        // Actualizar órdenes después de eliminar
        actualizarOrdenes();
        
        // Mostrar todos los candidatos preestablecidos nuevamente
        document.querySelectorAll('.candidato-item').forEach(function(item) {
            item.style.display = 'block';
            item.classList.remove('ya-agregado');
        });
        
        // Aplicar filtros actuales
        filtrarCandidatos();
        
        // Mostrar mensaje de confirmación
        alert('Se han eliminado los candidatos agregados desde la lista preestablecida. Las opciones creadas manualmente se mantienen.');
    }
});
</script>

<!-- Loader Overlay -->
<div id="loader-overlay" style="
    position: fixed;
    top: 0; left: 0;
    width: 100%; height: 100%;
    display: none;
    align-items: center;
    justify-content: center;
    z-index: 9999;
    flex-direction: column;
    color: rgb(255, 255, 255);
    background:url(<?php echo base_url().'uploads/cargando.gif' ?>) 50% 50% no-repeat rgb(255, 255, 255);">
    <div class="loader-balls">
        <div></div><div></div><div></div>
    </div>
    
</div>

<style>

    /* Estilos para botones de la tabla - pequeños y horizontales */
    .btn-group {
        display: flex !important;
        justify-content: center !important;
        align-items: center !important;
    }
    
    .btn-group .btn {
        margin: 0 !important;
        border-radius: 0 !important;
        padding: 4px 8px !important;
        font-size: 12px !important;
        min-width: auto !important;
        border-right: 1px solid rgba(255,255,255,0.3) !important;
    }
    
    .btn-group .btn:first-child {
        border-radius: 4px 0 0 4px !important;
    }
    
    .btn-group .btn:last-child {
        border-radius: 0 4px 4px 0 !important;
        border-right: none !important;
    }
    
    .btn-group .btn:only-child {
        border-radius: 4px !important;
        border-right: none !important;
    }

    /* Colores específicos para los botones */
    .btn-success {
        background-color: #28a745 !important;
        border-color: #28a745 !important;
    }
    
    .btn-danger {
        background-color: #dc3545 !important;
        border-color: #dc3545 !important;
    }
    
    /* Efectos hover */
    .btn-group .btn:hover {
        transform: translateY(-1px);
        box-shadow: 0 2px 4px rgba(0,0,0,0.2);
        z-index: 1;
        position: relative;
    }
    .loader-balls {
  display: flex;
  justify-content: center;
  align-items: center;
}


@keyframes bounce {
  from { transform: translateY(0); }
  to   { transform: translateY(-20px); }
}

/* Estilos para botones de acciones en la tabla */
.btn-group .btn {
    margin: 0 !important;
    border-radius: 0 !important;
    border-right: 1px solid rgba(255,255,255,0.3);
}

.btn-group .btn:first-child {
    border-radius: 4px 0 0 4px !important;
}

.btn-group .btn:last-child {
    border-radius: 0 4px 4px 0 !important;
    border-right: none;
}

.btn-group .btn:only-child {
    border-radius: 4px !important;
    border-right: none;
}

/* Colores específicos para cada botón */
.btn-toggle-estado.btn-success {
    background-color: #5cb85c !important;
    border-color: #4cae4c !important;
}

.btn-toggle-estado.btn-danger {
    background-color: #d9534f !important;
    border-color: #d43f3a !important;
}

.eliminar-candidato {
    background-color: #d9534f !important;
    border-color: #d43f3a !important;
}

.eliminar-fila {
    background-color: #d9534f !important;
    border-color: #d43f3a !important;
}

/* Efectos hover */
.btn-group .btn:hover {
    transform: translateY(-1px);
    box-shadow: 0 2px 4px rgba(0,0,0,0.2);
    z-index: 2;
    position: relative;
}

/* Asegurar que los botones mantengan su altura */
.btn-group-sm .btn {
    min-height: 30px;
    display: flex;
    align-items: center;
    justify-content: center;
}

/* Estilos adicionales para la vista mejorada de candidatos */
.candidato-item:hover {
    transform: translateY(-2px) !important;
    box-shadow: 0 4px 12px rgba(0,0,0,0.15) !important;
    border-color: #007bff !important;
}
</style>

<?php $this->load->view('template/footer.php'); ?>