<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of User
 *
 * @author Developer
 */
class Sincronizacion_model extends MY_Model {

    protected $_table = 'sincro01proceso';
    protected $_table_generacion = 'sincro03generacion';
    protected $_table_registros = 'evi07audpro';
    private $_column = array('COD_PROCESO', 'STATUS', 'FEC_EJECUTA', 'sincro01proceso.COD_AGENCIA',
          'COD_EJEUSU', 'TEX_EJENOTA');
    private $_order = array('FEC_EJECUTA' => 'desc');

    public function __construct() {
        parent::__construct();
        $this->load->database();
        $this->_table = 'sincro01proceso';
        $this->_table_log = 'sincro02logproceso';
        $this->primary_key = 'COD_PROCESO';
    }


   public function insert_log($data)
   {
       $this->db->insert($this->_table_log, $data);
   }

  

   public function insert_generacion($data)
   {
       $this->db->insert($this->_table_generacion, $data);
   }

   /**
     * Para editar el campo de una tabla.
     *
     * @param type @table Tabla
     * @param type @table_id Id a editar
     * @param type @id Id primaria
     * @param type $data datos
     * @return boolean
     */
    public function edit($id, $data)
    {
    	$this->db->where($this->primary_key, $id);
    	if ($this->db->update($this->_table, $data)):
    		return true;
    	else:
    		return false;
    	endif;
    }


   public function consulta_generacion()
   {
       $this->db->select("$this->_table_generacion.*, usua.TEX_USUARIO");
        $this->db->from($this->_table_generacion);
        $this->db->join('auth03usuarios usua', "usua.COD_USUARIO=$this->_table_generacion.COD_SINUSU");
        $this->db->order_by('FEC_GENARCHIV', 'DESC');
        return $this->db->get()->row();
   }

  public function get_registros_sincronizacion($cod_proceso)
  {
        $this->db->select("*");
        $this->db->from($this->_table_log);
        $this->db->where('COD_PROCESO', $cod_proceso);
        return $this->db->get()->result();
  }

    public function consultar_registros() {
        $this->db->select('parti.NUM_IDETER, parti.BOL_INISES, parti.COD_AGENCIA, audid.ID_INSTAN, audid.ID_CANDID,
            audid.FEC_PROVOT,audid.TEX_IPORIG');
        $this->db->from('evi07audpro audid');
        $this->db->join('evi05partic parti', "parti.NUM_IDETER=audid.NUM_IDETER");
        return $this->db->get()->result();
    }


    private function _get_datatables_query() {
        $this->db->select("$this->_table.*, 
          (SELECT count(COD_LOGPROCESO) from sincro02logproceso WHERE COD_PROCESO=$this->_table.COD_PROCESO) as total_registros, 
          (SELECT count(COD_LOGPROCESO) from sincro02logproceso WHERE COD_PROCESO=$this->_table.COD_PROCESO AND BOL_REGIS=1) as total_registrados,
          u.TEX_USUARIO as usuario, a.TEX_NOMAGE as agencia");
        $this->db->join('auth03usuarios u', "u.COD_USUARIO=$this->_table.COD_EJEUSU");
        $this->db->join('gen01agencias a', "a.COD_AGENCIA=$this->_table.COD_AGENCIA");
       // $this->db->where("$this->_table.STATUS", 1);
        $this->db->from($this->_table);
        $i = 0;
        foreach ($this->_column as $item) {
            if ($_POST['search']['value'])
                ($i === 0) ? $this->db->like($item, $_POST['search']['value']) : $this->db->or_like($item, $_POST['search']['value']);
            $column[$i] = $item;
            $i++;
        }
        if (isset($_POST['order'])) {
            $this->db->order_by(isset($column[$_POST['order']['0']['column']]), $_POST['order']['0']['dir']);
        } else if (isset($this->_order)) {
            $order = $this->_order;
            $this->db->order_by(key($order), $order[key($order)]);
        }
    }

    public function get_datatables() {
        $this->_get_datatables_query();
        if ($_POST['length'] != -1):
            $this->db->limit($_POST['length'], $_POST['start']);
        endif;
        $query = $this->db->get();
        return $query->result();
    }

    public function count_filtered() {
        $this->_get_datatables_query();
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all() {
        $this->db->from($this->_table);
        return $this->db->count_all_results();
    }

}
