<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description
 *
 * @author Developer
 */
class Sincronizacion_model_log extends MY_Model {

    protected $_table;
    private $_cod_proceso;
    private $_column = array('COD_LOGPROCESO', 'ID_INSTAN', 'ID_CANDID', 'NUM_IDETER',
          'FEC_PROVOT', 'TEX_IPORIG', 'BOL_REGIS', 'FEC_CREACION');
    private $_order = array('COD_LOGPROCESO' => 'asc');
    
    public function __construct() {
        parent::__construct();
        $this->load->database();
        $this->_table = 'sincro02logproceso';
        $this->primary_key = 'COD_LOGPROCESO';
    }

    /**
     * Para editar el campo de una tabla.
     *
     * @param type @table Tabla
     * @param type @table_id Id a editar
     * @param type @id Id primaria
     * @param type $data datos
     * @return boolean
     */
    public function edit($id, $data)
    {
    	$this->db->where($this->primary_key, $id);
    	if ($this->db->update($this->_table, $data)):
    		return true;
    	else:
    		return false;
    	endif;
    }

    private function _get_datatables_query($cod_proceso) {
        $this->db->select("$this->_table.*, CONCAT(p.TEX_NOMPAR, ' ', p.TEX_APEPAR) as nombre_participante, 
            a.TEX_NOMAGE AS agencia", FALSE);
        $this->db->from($this->_table);
        $this->db->join('evi05partic p', "p.NUM_IDETER=$this->_table.NUM_IDETER");
        $this->db->join('gen01agencias a', "a.COD_AGENCIA=p.COD_AGENCIA");
        $this->db->where('COD_PROCESO', $cod_proceso);
        $i = 0;
          foreach ($this->_column as $item) {
                if ($_POST['search']['value']) {
                    $search = $_POST['search']['value']; 
                    $paren = '';
                    if($i==7) {
                        $paren=')';                 
                    }
                    ($i === 0) ? 
                    $this->db->where("($item LIKE '%$search%'"): $this->db->or_where("$item LIKE '%$search%'$paren");
                }
                $column[$i] = $item;
                $i++;
            }
        if (isset($_POST['order'])) {
            $this->db->order_by(isset($column[$_POST['order']['0']['column']]), $_POST['order']['0']['dir']);
        } else if (isset($this->_order)) {
            $order = $this->_order;
            $this->db->order_by(key($order), $order[key($order)]);
        }
    }

    public function get_datatables($cod_proceso) {
        $this->_cod_proceso = $cod_proceso;
        $this->_get_datatables_query($cod_proceso);
        if ($_POST['length'] != -1):
            $this->db->limit($_POST['length'], $_POST['start']);
        endif;
        $query = $this->db->get();
        return $query->result();
    }

    public function count_filtered() {
        $this->_get_datatables_query($this->_cod_proceso);
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all() {
        $this->db->from($this->_table);
        return $this->db->count_all_results();
    }
}
