<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Sistema extends MX_Controller
{

	public $path_js;

	public function __construct()
	{
		parent::__construct();
		if ($this->session->userdata('COD_TIPOPERFIL') !== 1) {
			echo "<h3>No tiene permisos para acceder a esta sección.</h3>";
			exit;
		}
		$this->load->model('Sistema_model');
		$this->load->helper('file');
		$this->path_js = 'sistema/scripts_dev.js';
	}

	public function index()
	{
		$data_view['titulo']  = 'Generar Módulo';
		$data_view['load_js'] = $this->path_js;
		$this->load->view('index', $data_view);
	}

	public function generar_modulo()
	{
		if ($this->input->post('nom_mod')) {
			$this->form_validation->set_rules('nom_mod', 'Nombre del módulo', 'trim|required|is_unique[evi10modulos.TEX_NOMMOD]');

			if (!$this->form_validation->run()){
				$this->session->set_flashdata('error', validation_errors());
				redirect("sistema");
			}
			$nom_mod = strtolower($this->input->post('nom_mod')); 
         $nom_mod = str_replace(" ", "_", $nom_mod);

			$path = "application/modules/".$nom_mod;

			if(!is_dir($path)) 
			{
				$dir_modulo =  mkdir($path,0755,TRUE);
				if($dir_modulo) {
					$dir_controllers = 	mkdir($path."/controllers",0755,TRUE);
					$nombre_controlador = $path.'/controllers/'.ucfirst($nom_mod).'.php';
					mkdir($path.'/models',0755,TRUE);
					mkdir($path.'/views',0755,TRUE);
					$nombre_modelo= $path.'/models/'.ucfirst($nom_mod).'_model.php';
					$nombre_view= $path.'/views/'.'index.php';
					if (file_put_contents($nombre_controlador, '') !== false) {

					} 

					if (file_put_contents($nombre_modelo, '') !== false) {

					} 	
					if (file_put_contents($nombre_controlador, '') !== false) {

					} 
					if (file_put_contents($nombre_view, '') !== false) {

					} 	
					$data = ['TEX_NOMMOD' => $nom_mod];
					$this->db->trans_start();
					$crear_modulo = 	$this->Sistema_model->crear_modulo($data);
					if($crear_modulo) {
						$crear_permisos = $this->Sistema_model->crear_permisos_modulo($nom_mod);

					}
					$this->db->trans_complete();

				}
			} 

			



		} else{
			redirect('sistema');

		}
	}    

}
