<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Textos extends MX_Controller
{

	public $path_js;
	private $_permisos;

	public function __construct()
	{
		parent::__construct();
		if ($this->session->userdata('COD_TIPOPERFIL') !== 1 && $this->session->userdata('COD_TIPOPERFIL') !== 2) {
			echo "<h3>No tiene permisos para acceder a esta sección.</h3>";
			exit;
		}
		$this->load->model(['Texto', 'configuracion/Modulos_sistema']);
		$this->path_js = 'textos/scripts_dev.js';
		$this->_permisos = $this->session->userdata('permisos'); 
	}

	public function index()
	{
		$data_view['titulo']  = 'Listado de Textos del sistema';
		$data_view['load_js'] = $this->path_js;
		$data_view['permisos']  = $this->_permisos;
		$this->load->view('index', $data_view);
	}

	function change_status($primary_key, $row)
	{
		return site_url('textos/status') . '/' . $primary_key . '/' . $row->BOL_ACTIVO;
	}

	public function example_output($output = null, $titulo = null)
	{
		$this->load->view('render', $output);
	}

     /**
      * Lista asociados desde Datatables. 
      */
     public function get_all()
     {
     	$list = $this->Texto->get_datatables();
     	$data = array();
     	$no   = $this->input->post('start');
     	foreach ($list as $texto) {
     		$no++;
     		$row    = array();
     		$delete= '';
     		$editar = '';
     		$status = '';


     		if(isset($this->_permisos['textos']['textos_borrar'])) {
     			$delete = "<a href='textos/delete/$texto->ID_TEXTOS ' class='btn btn-danger' onclick='borrarRegistro(this.id)'>Eliminar</a>";
     		}

     		if(isset($this->_permisos['textos']['textos_editar'])) {
     			$editar = "<a href='textos/create/1/$texto->ID_TEXTOS ' class='btn btn-success'>Editar</a>";
     		}
     		if(isset($this->_permisos['textos']['textos_activar'])) {
     			$status = ($texto->BOL_ACTIVO) ? "<a href='textos/status/$texto->ID_TEXTOS/$texto->BOL_ACTIVO ' class='btn btn-danger' style='margin-left:3px;'>Desactivar</a>" : "<a href='textos/status/$texto->ID_TEXTOS/$texto->BOL_ACTIVO ' class='btn btn-success' style='margin-left:3px;'>Activar</a>";
     		}

     		$row[]  = $texto->ID_TEXTOS;
     		$row[]  = $texto->TEX_VALOR;
     		$row[]  = $texto->TEX_LABEL;
     		$row[]  = $texto->TEX_NOMMOD;
     		$row[]  = $texto->TEX_OBSERVACION;
     		$row[]  = ($texto->BOL_ACTIVO) ? '<p style="color:green">Activo</p>' : '<p style="color:red">Inactivo</p>';
     		$row[]  = "$editar $status $delete";
     		$data[] = $row;
     	}
     	$output = array(
     		"draw"            => $this->input->post('draw'),
     		"recordsTotal"    => $this->Texto->count_all(),
     		"recordsFiltered" => $this->Texto->count_filtered(),
     		"data"            => $data,
     	);
     	echo json_encode($output);
     }

     /**
      * Crear texto.
      */
     public function create($edit = null, $id = null)
     {
         // if ($this->session->userdata('logged_in')):
     	if ($this->input->post()):
     		$edit = $this->input->post('edit');
     		$id   = $this->input->post('ID_TEXTOS');
     		if ($edit) {
     			$this->form_validation->set_rules('TEX_VALOR', 'Valor del Texto', 'required');
     		}
     		else {
     			$this->form_validation->set_rules('TEX_VALOR', 'Valor del Texto', 'required|is_unique[evi08textos.TEX_VALOR]');
     		}
     		if (!$this->form_validation->run()):
     			$this->session->set_flashdata('error', validation_errors());
     			if ($edit) {
     				redirect("textos/create/1/$id");
     			}
     			redirect("textos/create");
     		else:
     			$_post      = $this->security->xss_clean($_POST);
     			$datos_texto = array_merge($_post, $this->get_campos_control_DB());
     			if ($edit && $id) {
     				unset($datos_texto['edit']);
     				if ($this->Texto->edit($id, $datos_texto)) {
     					$this->session->set_flashdata('success', 'Se ha editado el registro');
     					redirect('textos');
     				}
     				else {
     					$this->session->set_flashdata('error', 'Error en la edición de los datos');
     					redirect("textos/create/1/$id");
     				}
     			}

     			$datos_texto['ID_EMPRESA'] = $this->get_empresa_id();       

     			if (is_int($this->Texto->insert($datos_texto))):
     				$this->session->set_flashdata('success', 'Se ha guardado el registro');
     				redirect('textos');
     			else:
     				$this->session->set_flashdata('error', 'Error en la inserción de los datos');
     				redirect('textos/create');
     			endif;
     		endif;
     	else:
     		$data_view['route'] = $this->get_module_name();
     		$data_view['modulos'] = $this->Modulos_sistema->select_forms('evi10modulos', 'COD_MODULO', 'TEX_NOMMOD', null, 'TEX_NOMMOD', null, 'TEX_NOMMOD');
     		if ($edit && $id) {
     			$data_view['texto'] = $this->Texto->get($id);
     		}
     		$data_view['titulo']  = 'Crear Texto';
     		$data_view['load_js'] = $this->path_js;
     		$this->load->view('create', $data_view);
     	endif;
         // endif;
     }

     /**
      * 
      * Cambiar status
      * 
      * @param type $id
      * @param type $status
      * 
      */
     public function status($id, $status)
     {
     	$data = ['BOL_ACTIVO' => 1];
     	if ($status) {
     		$data = ['BOL_ACTIVO' => 0];
     	}
     	
     	if ($this->Texto->edit($id, $data)):
     		$this->session->set_flashdata('success', 'Status cambiado');
     		redirect('textos');
     	else:
     		$this->session->set_flashdata('error', 'Ocurrió un error al cambiar el status');
     		redirect('textos');
     	endif;
     }

     /**
      * Borrar Registro
      * @param type $id
      */
     public function delete($id)
     {
     	$data = ['IS_DELETE' => 1];
     	if ($this->Texto->edit($id, $data)):
     		$this->session->set_flashdata('success', 'Registro Eliminado');
     		redirect('textos');
     	else:
     		$this->session->set_flashdata('error', 'Ocurrió un error al eliminar el registro');
     		redirect('textos');
     	endif;
     }

  }
