<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Tipo_perfiles extends MX_Controller
{

	public $path_js;

	public function __construct()
	{
		parent::__construct();
		if (!$this->session->userdata('COD_PERFIL')) {
			echo "<h3>No tiene permisos para acceder a esta sección.</h3>";
			exit;
		}
		$this->load->model('Tipo_perfil');
		$this->path_js = 'tipo_perfiles/scripts_dev.js';
	}

	public function index()
	{
		$data_view['titulo']  = 'Listado de Tipos de Perfiles';
		$data_view['load_js'] = $this->path_js;
		$this->load->view('index', $data_view);
	}

	function change_status($primary_key, $row)
	{
		return site_url('tipo_perfiles/status') . '/' . $primary_key . '/' . $row->BOL_ACTIVO;
	}

	public function example_output($output = null, $titulo = null)
	{
		$this->load->view('render', $output);
	}

     /**
      * Lista asociados desde Datatables. 
      */
     public function get_all()
     {
     	$list = $this->Tipo_perfil->get_datatables();
     	$data = array();
     	$no   = $this->input->post('start');
     	foreach ($list as $pais) {
     		$no++;
     		$row    = array();
     		$status = ($pais->BOL_ACTIVO) ? "<a href='tipo_perfiles/status/$pais->COD_TIPOPERFIL/$pais->BOL_ACTIVO ' class='btn btn-danger' style='margin-left:3px;'>Desactivar</a>" : "<a href='tipo_perfiles/status/$pais->COD_TIPOPERFIL/$pais->BOL_ACTIVO ' class='btn btn-success' style='margin-left:3px;'>Activar</a>";
     		$delete = "<a href='tipo_perfiles/delete/$pais->COD_TIPOPERFIL ' class='btn btn-danger' onclick='borrarRegistro(this.id)'>Eliminar</a>";
     		$row[]  = $pais->COD_TIPOPERFIL;
     		$row[]  = $pais->TEXT_TIPOPERFIL;
     		$row[]  = ($pais->BOL_ACTIVO) ? '<p style="color:green">Activo</p>' : '<p style="color:red">Inactivo</p>';
     		$row[]  = "<a href='tipo_perfiles/create/1/$pais->COD_TIPOPERFIL ' class='btn btn-success'>Editar</a> $status $delete";
     		$data[] = $row;
     	}
     	$output = array(
     		"draw"            => $this->input->post('draw'),
     		"recordsTotal"    => $this->Tipo_perfil->count_all(),
     		"recordsFiltered" => $this->Tipo_perfil->count_filtered(),
     		"data"            => $data,
     	);
     	echo json_encode($output);
     }

     /**
      * Crear pais.
      */
     public function create($edit = null, $id = null)
     {
         // if ($this->session->userdata('logged_in')):
     	if ($this->input->post()):
     		$edit = $this->input->post('edit');
     		$id   = $this->input->post('COD_TIPOPERFIL');
     		if ($edit) {
     			$this->form_validation->set_rules('TEXT_TIPOPERFIL', 'Nombre del Tipo Perfil', 'required');
     		}
     		else {
     			$this->form_validation->set_rules('TEXT_TIPOPERFIL', 'Nombre del Tipo Perfil', 'required|is_unique[auth01tiposperfiles.TEXT_TIPOPERFIL]');
     		}
     		if (!$this->form_validation->run()):
     			$this->session->set_flashdata('error', validation_errors());
     			if ($edit) {
     				redirect("tipo_perfiles/create/1/$id");
     			}
     			redirect("tipo_perfiles/create");
     		else:
     			$_post      = $this->security->xss_clean($_POST);
     			$datos_pais = array_merge($_post, $this->get_campos_control_DB());
     			if ($edit && $id) {
     				unset($datos_pais['edit']);
     				if ($this->Tipo_perfil->edit($id, $datos_pais)) {
     					$this->session->set_flashdata('success', 'Se ha editado el registro');
     					redirect('tipo_perfiles');
     				}
     				else {
     					$this->session->set_flashdata('error', 'Error en la edición de los datos');
     					redirect("tipo_perfiles/create/1/$id");
     				}
     			}
     			if (is_int($this->Tipo_perfil->insert($datos_pais))):
     				$this->session->set_flashdata('success', 'Se ha guardado el registro');
     				redirect('tipo_perfiles');
     			else:
     				$this->session->set_flashdata('error', 'Error en la inserción de los datos');
     				redirect('tipo_perfiles/create');
     			endif;
     		endif;
     	else:
     		$data_view['route'] = $this->get_module_name();
     		if ($edit && $id) {
     			$data_view['tipo_perfil'] = $this->Tipo_perfil->get($id);
     		}
     		$data_view['titulo']  = 'Crear Tipo Perfil';
     		$data_view['load_js'] = $this->path_js;
     		$this->load->view('create', $data_view);
     	endif;
         // endif;
     }

     /**
      * 
      * Cambiar status
      * 
      * @param type $id
      * @param type $status
      * 
      */
     public function status($id, $status)
     {
     	$data = ['BOL_ACTIVO' => 0];
     	if (!$status) {
     		$data = ['BOL_ACTIVO' => 1];
     	}
     	
     	if ($this->Tipo_perfil->edit($id, $data)):
     		$this->session->set_flashdata('success', 'Status cambiado');
     		redirect('tipo_perfiles');
     	else:
     		$this->session->set_flashdata('error', 'Ocurrió un error al cambiar el status');
     		redirect('tipo_perfiles');
     	endif;
     }

     /**
      * Borrar Registro
      * @param type $id
      */
     public function delete($id)
     {
     	$data = ['IS_DELETE' => 1];
     	if ($this->Tipo_perfil->edit($id, $data)):
     		$this->session->set_flashdata('success', 'Registro Eliminado');
     		redirect('tipo_perfiles');
     	else:
     		$this->session->set_flashdata('error', 'Ocurrió un error al eliminar el registro');
     		redirect('tipo_perfiles');
     	endif;
     }

  }
  