<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of User
 *
 * @author Developer
 */
class Tipo_usuario extends MY_Model {

	protected $_table;
	private $_column = array('COD_PERFIL', 'TEX_NOMTIPO', 'auth02perfiles.BOL_ACTIVO');
	private $_order = array('COD_PERFIL' => 'desc');

	public function __construct() {
		parent::__construct();
		$this->load->database();
		$this->_table = 'auth02perfiles';
		$this->_table_parent = 'auth01tiposperfiles';
		$this->primary_key = 'COD_PERFIL';
	}

    /**
     * Para editar el campo de una tabla. 
     * 
     * @param type @table Tabla
     * @param type @table_id Id a editar
     * @param type @id Id primaria
     * @param type $data datos
     * @return boolean
     */
    public function edit($id, $data) {
    	$this->db->where($this->primary_key, $id);
    	if ($this->db->update($this->_table, $data)):
    		return true;
    	else:
    		return false;
    	endif;
    }

    private function _get_datatables_query() {
    	$this->db->select("*");
    	$this->db->from($this->_table);
    	$this->db->join("$this->_table_parent","$this->_table_parent.COD_TIPOPERFIL=$this->_table.COD_TIPOPERFIL");
    	$this->db->where("$this->_table.IS_DELETE", 0);
    	$i = 0;
    	foreach ($this->_column as $item) {
    		if ($_POST['search']['value'])
    			($i === 0) ? $this->db->like($item, $_POST['search']['value']) : $this->db->or_like($item, $_POST['search']['value']);
    		$column[$i] = $item;
    		$i++;
    	}
    	if (isset($_POST['order'])) {
    		$this->db->order_by($column[isset($_POST['order']['0']['column'])], $_POST['order']['0']['dir']);
    	} else if (isset($this->_order)) {
    		$order = $this->_order;
    		$this->db->order_by(key($order), $order[key($order)]);
    	}
    }

    public function get_datatables() {
    	$this->_get_datatables_query();
    	if ($_POST['length'] != -1):
    		$this->db->limit($_POST['length'], $_POST['start']);
    	endif;
    	$query = $this->db->get();
    	return $query->result();
    }

    public function count_filtered() {
    	$this->_get_datatables_query();
    	$query = $this->db->get();
    	return $query->num_rows();
    }

    public function count_all() {
    	$this->db->from($this->_table);
    	$this->db->where("$this->_table.BOL_ACTIVO", 1);
    	return $this->db->count_all_results();
    }

 }
