<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Usuarios extends MX_Controller
{

	public $path_js;
	public $path_js_login;
	private $_configuracion;
	private $_access;
	private $_permisos;

	public function __construct()
	{
		parent::__construct();
		$this->load->model(['Usuario', 'configuracion/Config']);
		$this->load->helper('security');
		$this->path_js = 'usuarios/scripts_dev.js';
		$this->path_js_login = 'usuarios/scripts_dev_login.js';
		$this->load->model(['configuracion/Config', 'acceso/Access']);

		$this->_configuracion = $this->Config->get_row();
        //  if (!$this->_configuracion) {
        //      $data_view['message'] = 'No se ha definido la configuración de la aplicación. Contacte al administrador.';
        //      $this->load->view('errors/error_start_sistema', $data_view);
        //      return false;
        //  }
		$this->_permisos = $this->session->userdata('permisos'); 
	}

	public function index()
	{
		if ($this->session->userdata('COD_TIPOPERFIL') === 1 || $this->session->userdata('COD_TIPOPERFIL') === 2) {
			$data_view['titulo']  = 'Listado de Usuarios';
			$data_view['permisos']  = $this->_permisos;
			$data_view['load_js'] = $this->path_js;
			$this->load->view('index', $data_view);
		}
		
	}

     /**
      * Lista asociados desde Datatables. 
      */
     public function get_all()
     {
     	if ($this->session->userdata('COD_TIPOPERFIL') === 1 || $this->session->userdata('COD_TIPOPERFIL') === 2) {
     		$list = $this->Usuario->get_datatables();
     		$data = array();
     		$no   = $this->input->post('start');
     		foreach ($list as $usuario) {
     			$no++;
     			$row    = array();

     			$delete= '';
     			$editar = '';
     			$status = '';

     			if(isset($this->_permisos['usuarios']['usuarios_borrar'])) {
     				$delete = "<a href='usuarios/delete/$usuario->COD_USUARIO ' class='btn btn-danger' onclick='borrarRegistro(this.id)'>Eliminar</a>";
     			}

     			if(isset($this->_permisos['usuarios']['usuarios_editar'])) {
     				$editar = "<a href='usuarios/create/1/$usuario->COD_USUARIO ' class='btn btn-success'>Editar</a>";
     			}
     			if(isset($this->_permisos['usuarios']['usuarios_activar'])) {
     				$status = ($usuario->BOL_ACTIVO) ? "<a href='usuarios/status/$usuario->COD_USUARIO/$usuario->BOL_ACTIVO ' class='btn btn-danger' style='margin-left:3px;'>Desactivar</a>" : "<a href='usuarios/status/$usuario->COD_USUARIO/$usuario->BOL_ACTIVO ' class='btn btn-success' style='margin-left:3px;'>Activar</a>";
     			}


     			$row[]  = $usuario->COD_USUARIO;
     			$row[]  = $usuario->TEX_NOMTIPO;
     			$row[]  = $usuario->TEX_NOMUSUA;
     			$row[]  = $usuario->TEX_USUARIO;
     			$row[]  = $usuario->TEX_MAILUSUA;
     			$row[]  = ($usuario->BOL_ACTIVO) ? '<p style="color:green">Activo</p>' : '<p style="color:red">Inactivo</p>';
     			$row[]  = "$editar $status $delete";
     			$data[] = $row;
     		}
     		$output = array(
     			"draw"            => $this->input->post('draw'),
     			"recordsTotal"    => $this->Usuario->count_all(),
     			"recordsFiltered" => $this->Usuario->count_filtered(),
     			"data"            => $data,
     		);
     		echo json_encode($output);
     	}
     }

     /**
      * Acceso al sistema. 
      */
     public function login()
     {
     	$data_view['load_js'] = $this->path_js_login;
     	$data_view['titulo']  = 'Inicio de Sesión / '.$this->Access->get_nom_empresa()->TEX_NOMEMP;

     	if ($this->input->post()) {
     		$this->form_validation->set_rules('TEX_USUARIO', 'Usuario', 'trim|required');
     		$this->form_validation->set_rules('TEX_CONTRASENA', 'Contraseña', 'required|min_length[6]');
     		if ($this->form_validation->run() == FALSE) {
     			$data_view['message'] = validation_errors();
     			$this->load->view('login', $data_view);
     		}
     		else {
     			$usuario      = xss_clean($this->input->post('TEX_USUARIO'));
     			$password     = sha1($this->input->post('TEX_CONTRASENA'));
     			$login_status = $this->Usuario->login_user($usuario, $password);

     			if (!$login_status) {
     				$data_view['message'] = 'La datos proporcionados son incorrectos o el usuario esta desactivado.';
     				$this->load->view('login', $data_view);
     			}
     			else {
     				$permisos = $this->_cargar_permisos_usuario($login_status->COD_PERFIL);

     				$this->start_session_usuario($login_status->COD_USUARIO, $login_status->COD_TIPOPERFIL, $login_status->COD_PERFIL, $login_status->TEX_USUARIO, $login_status->TEX_NOMUSUA, $login_status->TEX_MAILUSUA, $login_status->COD_AGENCIA, $permisos);
     				redirect("administrador");
     			}
     		}
     	}
     	else {
     		$this->load->view('login', $data_view);
     	}
     }

	/**
	Carga de permisos asociados al usuario.
	*/ 
	private function _cargar_permisos_usuario($cod_usuario)
	{
		$arr = [];
		$datos_pemisos = $this->Usuario->get_perfil_permisos($cod_usuario);

			$config_cierre_votacion =$this->get_valida_cierre_instancia();
		foreach ($datos_pemisos as $key => $permiso) {
			$permiso_es_votacion = $permiso->BOL_VOTACION;
			if($config_cierre_votacion && $permiso_es_votacion && (boolean)$this->_configuracion->BOL_ACTIINFORVOT) {
				$mostrar_en_front = false;
			} else {
				$mostrar_en_front = true;
			}

			$arr[$permiso->TEX_MODULO][$permiso->TEX_NOMPERMI] = [
				'TEX_NOMPERMI'=> $permiso->TEX_NOMPERMI,
				'TEX_MODULO' => $permiso->TEX_MODULO,
				'TIPO_ACCION' => $permiso->TIPO_ACCION,
				'COD_TIPOPERFIL' => $permiso->COD_TIPOPERFIL,
				'MOSTRAR_FRONT' => $mostrar_en_front
			];
		}

		return $arr;
	}

	private function start_session_usuario($cod_usuario, $tipo_perfil, $tipo_usuario, $usuario, $nombre_usuario, $mail_usuario, $agencia, $permisos)
	{
		$user_data = array(
			'COD_USUARIO'  => (int) $cod_usuario,
			'COD_TIPOPERFIL'  => (int) $tipo_perfil,
			'COD_PERFIL' => (int) $tipo_usuario,
			'TEX_USUARIO'  => $usuario,
			'TEX_NOMUSUA'  => $nombre_usuario,
			'TEX_MAILUSUA' => $mail_usuario,
			'COD_AGENCIA'  => (int) $agencia,
			'NOMBRE_SEGMENTO' => ($this->_configuracion->TEX_NOMSEG)?$this->_configuracion->TEX_NOMSEG:'Agencia',
			'POR_LISTAS'  => (boolean) ($this->_configuracion->BOL_VALLIS)?$this->_configuracion->BOL_VALLIS:false,
			'EMPRESA'      => $this->Access->get_nom_empresa()->TEX_NOMEMP,
			'CIERRE_VOTACION'      => ($this->_configuracion->BOL_ACTIINFORVOT)?$this->get_valida_cierre_instancia():false,
			'logged_in'    => TRUE
		);

		$this->session->set_userdata($user_data);
		$this->session->set_userdata('permisos', $permisos);
		$configuracion = $this->Config->get_datos_load_session();
		if ($configuracion) {
			$this->session->set_userdata('settings', $configuracion);
		}

		return true;
	}

	public function change_password()
	{
		if ($this->input->post()) {
			$this->form_validation->set_rules('TEX_CONTRASENA', 'Contraseña', 'trim|required|min_length[6]|xss_clean');
			$this->form_validation->set_rules('NEW_TEX_CONTRASENA', 'Nueva Contraseña', 'trim|required|min_length[6]|xss_clean');
			$this->form_validation->set_rules('RE_NEW_TEX_CONTRASENA', 'Confirma Nueva Contraseña', 'trim|required|min_length[6]|xss_clean|matches[NEW_TEX_CONTRASENA]');
			if ($this->form_validation->run() == FALSE):
				$this->session->set_flashdata('error', validation_errors());
				redirect('usuarios/change_password');
			else:
				$data = ['TEX_CONTRASENA' => sha1($this->input->post('NEW_TEX_CONTRASENA'))];
				if ($this->Usuario->edit($this->session->userdata('COD_USUARIO'), $data)) {
					$this->session->set_flashdata('success', 'Has cambiado la contraseña con exito');
					redirect('administrador');
				}
				$this->session->set_flashdata('error', 'Ocurrió un error cambiando la contraseña');
				redirect('usuarios/change_password');
			endif;
		}
		else {
			$this->load->view('usuarios/change_password');
		};
	}

	public function exits_password()
	{

		var_dump($validate);
		exit;
		$validate = $this->Usuario->exits($this->session->userdata('COD_USUARIO'), sha1($this->input->post('TEX_CONTRASENA')));

		if ($validate > 0) {
			return TRUE;
		}
		else {
			$this->form_validation->set_message('exits_password', 'La contraseña actual no es correcta');
			return FALSE;
		}
	}

     /**
      * Para salir de la aplicación.
      */
     public function logout()
     {
     	if ($this->session->userdata('COD_PERFIL')) {
     		$this->session->sess_destroy();
     		redirect('usuarios/login');
     	}
     }

     /**
      * Crear usuario.
      */
     public function create($edit = null, $id = null)
     {
     	if ($this->session->userdata('COD_TIPOPERFIL') === 1 || $this->session->userdata('COD_TIPOPERFIL') === 2) {
     		if ($this->input->post()):
     			$edit = $this->input->post('edit');
     			$id   = $this->input->post('COD_USUARIO');

     			if ($edit) {
     				$this->form_validation->set_rules('TEX_USUARIO', 'Usuario', 'trim|required');
     				$this->form_validation->set_rules('TEX_NOMUSUA', 'Nombre del Usuario', 'required');
     				$this->form_validation->set_rules('TEX_CONTRASENA', 'Contraseña', 'min_length[6]|matches[RE_TEX_CONTRASENA]');
     				$this->form_validation->set_rules('RE_TEX_CONTRASENA', 'Confirmación Contraseña', 'min_length[6]|matches[TEX_CONTRASENA]');
     			}
     			else {
     				$this->form_validation->set_rules('TEX_MAILUSUA', 'Email', 'is_unique[auth03usuarios.TEX_MAILUSUA]');
     				$this->form_validation->set_rules('TEX_CONTRASENA', 'Contraseña', 'required|min_length[6]|matches[RE_TEX_CONTRASENA]');
     				$this->form_validation->set_rules('TEX_USUARIO', 'Usuario', 'trim|required|is_unique[auth03usuarios.TEX_USUARIO]');
     				$this->form_validation->set_rules('TEX_NOMUSUA', 'Nombre del Usuario', 'required');
     				$this->form_validation->set_rules('RE_TEX_CONTRASENA', 'Confirmación Contraseña', 'required|min_length[6]|matches[TEX_CONTRASENA]');
     			}


     			if (!$this->form_validation->run()):
     				$this->session->set_flashdata('error', validation_errors());
     				if ($edit) {
     					redirect("usuarios/create/1/$id");
     				}
     				redirect("usuarios/create");
     			else:
     				unset($_POST['RE_TEX_CONTRASENA']);
     				$post_usuario = [
     					'TEX_NOMUSUA'    => xss_clean($this->input->post('TEX_NOMUSUA')),
     					'TEX_MAILUSUA'   => xss_clean($this->input->post('TEX_MAILUSUA')),
     					'COD_PERFIL'   => xss_clean($this->input->post('COD_PERFIL')),
     					'TEX_USUARIO'    => xss_clean($this->input->post('TEX_USUARIO')),
     					'TEX_CONTRASENA' => '',
     					'COD_AGENCIA'    => xss_clean($this->input->post('COD_AGENCIA')),
     				];

     				$datos_usuario = array_merge($post_usuario, $this->get_campos_control_DB());
     				if ($edit && $id) {
     					if (isset($_POST['TEX_CONTRASENA']) && empty($_POST['TEX_CONTRASENA'])) {
     						unset($datos_usuario['TEX_CONTRASENA']);
     					}
     					else {
     						$password_sha1                   = sha1($this->input->post('TEX_CONTRASENA'));
     						$datos_usuario['TEX_CONTRASENA'] = $password_sha1;
     					}



     					unset($datos_usuario['edit']);
     					if ($this->Usuario->edit($id, $datos_usuario)) {
                         //Permisos.
     						$tipo_usuario        = $this->input->post('COD_PERFIL');
     						$this->session->set_flashdata('success', 'Se ha editado el registro');
     						redirect('usuarios');
     					}
     					else {
     						$this->session->set_flashdata('error', 'Error en la edición de los datos');
     						redirect("usuarios/create/1/$id");
     					}
     				}
                 //   $this->db->trans_start();
     				$password_sha1                   = sha1($this->input->post('TEX_CONTRASENA'));
     				$datos_usuario['TEX_CONTRASENA'] = $password_sha1;
                    // var_dump($datos_usuario);exit;
     				$id_usuario = $this->Usuario->insert($datos_usuario);
     				if (is_int($id_usuario)) {
     					$arr_permisos = $this->input->post('permisos');
     					$tipo_usuario = $this->input->post('COD_PERFIL');
     					$this->Usuario->insertar_permisos($arr_permisos, $tipo_usuario, $id_usuario);
     					$this->session->set_flashdata('success', 'Se ha guardado el registro');
     					redirect('usuarios');
     				}
     				else {
     					$this->session->set_flashdata('error', 'Error en la inserción de los datos');
     					redirect('usuarios/create');
     				}
             //  $this->db->trans_complete();
     			endif;
     		else:
     			$data_view['route']             = $this->get_module_name();
     			$data_view['tipo_usuarios']     = $this->Usuario->select_forms('auth02perfiles', 'COD_PERFIL', 'TEX_NOMTIPO', null, null, null, 'TEX_NOMTIPO');
     			$data_view['titulo']            = 'Crear Usuario';
     			$data_view['list_all_permisos'] = $this->Usuario->get_all_permisos();
     			$data_view['agencias']          = $this->Usuario->select_forms('gen01agencias', 'COD_AGENCIA', 'TEX_NOMAGE');
     			if ($edit && $id) {
     				$data_view['titulo']                   = 'Editar Usuario';
     				$data_view['usuario']                  = $this->Usuario->get($id);
     			}
     			$data_view['load_js'] = $this->path_js;
     			$this->load->view('create', $data_view);
     		endif;
     	}
         // endif;
     }

     /**
      * 
      * Cambiar status
      * 
      * @param type $id
      * @param type $status
      * 
      */
     public function status($id, $status)
     {
     	$data = ['BOL_ACTIVO' => 1];
     	if ($status) {
     		$data = ['BOL_ACTIVO' => 0];
     	}
     	if ($this->Usuario->edit($id, $data)):
     		$this->session->set_flashdata('success', 'Status cambiado');
     		redirect('usuarios');
     	else:
     		$this->session->set_flashdata('error', 'Ocurrió un error al cambiar el status');
     		redirect('usuarios');
     	endif;
     }

     /**
      * Borrar Registro
      * @param type $id
      */
     public function delete($id)
     {
     	$data = ['IS_DELETE' => 1];
     	if ($this->Usuario->edit($id, $data)):
     		$this->session->set_flashdata('success', 'Registro Eliminado');
     		redirect('usuarios');
     	else:
     		$this->session->set_flashdata('error', 'Ocurrió un error al eliminar el registro');
     		redirect('usuarios');
     	endif;
     }

  }
  