<?php



defined('BASEPATH') OR exit('No direct script access allowed');



/**

* EVIR V 2.0

*

* An application development for PHP

*

* This content is released under the End User License Agreement (EULA)

*

* Copyright (c) 2008 - 2016, Cyberia Tech SAS.

*

* THIS IS A LEGAL AGREEMENT BETWEEN YOU, THE END USER, 

* AND EVIR .IF YOU DO NOT AGREE TO THE TERMS OF THIS AGREEMENT, 

* DO NOT DOWNLOAD OR USE THIS SOFTWARE.

*

* The above copyright notice and this permission notice shall be included in

* all copies or substantial portions of the Software.

*

* LICENSE

* The software is licensed for exclusive and non-transferable use. 

* A licensed copy of the software may be used for an unlimited amount 

* of time without any monthly fees. For each installed instance of the software,

* a separate license is required unless the multi-user licenses bundle

* deal has been purchased, thus the a simple copy of the software can be

* installed up to multiple different machines depending on the license type.

*

* @package	Evir 2.

* @author Jaime P. Bravo <http://www.jaimebravo.co> <http://www.githib.com/fire_flex>

* @copyright	Copyright (c) 2008 - 2016, Cyberia Tech SAS.(http://cyberiatech.com.co/)

* @license	http://opensource.org/licenses/MIT	EULA

* @link	http://cyberiatech.com.co/evir

* @since	Version 2.0.0

* @filesource

*/

class Votacion extends MX_Controller

{

	

	public $path_js;

	private $_configuracion;

	private $_message = '';

	

	public function __construct()

	{

		

		parent::__construct();

		

		$this->load->model(['instancias/Instancia', 'candidatos/Candidato', 'agencias/Agencia',

		'empresas/Empresa', 'participantes/Participante', 'log_ingresos/Log_ingreso', 'configuracion/Config',

		'puntos_votacion/Maquina']);

		$this->load->helper('security');

		$this->path_js        = 'votacion/scripts_dev.js';

		$this->_configuracion = $this->Config->get_row();

		if (!$this->_configuracion) {

			$data_view['message'] = 'No se ha definido la configuración de la aplicación. Contacte al administrador.';

			$this->load->view('errors/error_start_sistema', $data_view);

			return false;

		}

		//Si la votación es por listas redirecciona a controlador votación listas.

		if ($this->_configuracion->BOL_VALLIS) {

			redirect('votacion/votacion_por_listas');

		}

		

		//$this->_enviar_email_confirmacion();

	}

	

	//--------------------------------------------------------------------------------------------------------------------------------

	/**

	*  Carga de los datos de votación. 

	* 

	* @param type $instancia_numero

	* @return boolean

	*/

	public function index($instancia_numero = null)

	{


		 
		 // print_r($_SESSION);
		 $participante_id=$this->session->userdata('NUM_IDETER');
		 $sesion=$this->session->userdata('session_id');
		 $validafecha = $this->Participante->consultafecha($participante_id);
		 $sesion_bd= $validafecha->BOL_SESIONID;


		if ($this->session->userdata('logged_in') && $sesion_bd==$sesion) {

			//print_r('pas');die;

			// Validacion instancias activas. 

			$instancias_activas =  $this->Instancia->all();

			

			if(!$instancias_activas) {

				redirect('acceso/logout');

			}

			

			$this->load->library('user_agent');

			$is_mobile = $this->agent->is_mobile();

			$agent = $this->agent->mobile();

			

			if ($instancia_numero) {
				
				$validacion_voto_previo = $this->Participante->get_exits_voto($instancia_numero, $participante_id);
		

				$instancia         = $this->Instancia->get_instancia($instancia_numero);

				$data_view['instancia']  = $instancia;

				$data_view['candidatos'] = [];

				if (isset($instancia) && !$validacion_voto_previo) {

					$data_view['candidatos'] = $this->Candidato->get_candidatos_by_instancia($instancia->ID_INSTAN);

				}
				
				

				//Orden de la instancia.

				if (!isset($instancia)|| $validacion_voto_previo) {

					$this->logout();

					$data_view['mensaje'] = $this->get_texto_sistema('TEX_TERMIN')->TEX_LABEL;

					//Si se cierra la ventana.

					$data_view['bol_cierra'] = (boolean)$this->_configuracion->BOL_CIERRA;

					if ($this->_configuracion->BOL_VALMAI) {

						$this->_enviar_email_confirmacion();

					}



					if ($this->session->userdata('punto_votacion')) {

						$data_view['bol_redirect'] = (boolean)$this->session->userdata('punto_votacion');

						$data_view['url'] = base_url('puntoVotacion');

					}

					

					$this->load->view('avisos/voto_success', $data_view);

					return false;

				}

			} else {

				//Instancia Inicial.
				//$instancia                           = $this->Instancia->get_instancia();

				$participante_id=$this->session->userdata('NUM_IDETER');
		
				$acumulador=array();
				foreach($instancias_activas as $intans) {
					
					$validacion_voto_previo = $this->Participante->get_exits_voto($intans->ID_INSTAN, $participante_id);
					if(!$validacion_voto_previo) {
		
						$valor=array($intans->ID_INSTAN);
						$acumulador=array_merge($acumulador,$valor);
					
					}
					
				  }
				  $instancia                           = $this->Instancia->get_instancia(current($acumulador));

				$data_view['instancia']              = $instancia;

				$data_view['candidatos']         = $this->Candidato->get_candidatos_by_instancia($instancia->ID_INSTAN);

			}

			

			

			//Número de candidatos por fila.

			$data_view['numero_candidatos_grid'] = (int) $this->_configuracion->NUM_CANFIL;

			//Datos del voto en Blanco.

			$data_view['voto_blanco']            = $this->Candidato->get_voto_blanco($instancia->ID_INSTAN);

			//Datos de la empresa.

			$nombre_empresa                      = $this->Empresa->get_nom_empresa();

			$data_view['empresa']                = $nombre_empresa->TEX_NOMEMP . ' - ' . $nombre_empresa->COD_NIT;

			//Datos agencia del participante.

			$data_view['agencia_participante']   = $this->Agencia->get($this->session->userdata('COD_AGENCIA'));

			

			//Mensaje de bienvenida

			$data_view['mensaje_bienvenida'] = $this->get_texto_sistema('TEX_BIENVE')->TEX_LABEL;

			

			$data_view['buscador']  = $this->_configuracion->BOL_BUSTAR;

			$data_view['previsualizar_votacion']  = (boolean) $this->_configuracion->BOL_VOTPREV;

			

			
			if ((boolean)$this->_configuracion->BOL_ACTBMODAL) {
				$data_view['mostrar_modal'] = true;
				$data_view['mensaje_modal'] = $this->get_texto_sistema('TEX_MODALINI')->TEX_LABEL;
			
			} else {
				$data_view['mostrar_modal'] = false;
			}
			

			$this->db->where('BOL_ACTIVO', 1)->order_by('NUM_ORDEN', 'ASC');

			$data_view['load_js'] = $this->path_js;

			$data_view['is_mobile'] = $is_mobile;

			$data_view['agent'] = $agent;

						// Verificar si se debe mostrar el modal
			

			$this->load->view('index', $data_view);

		}
		else {

			redirect('acceso/logout');

		}

	}

	

	//--------------------------------------------------------------------------------------------------------------------------------

	

	//------------------------------------------------------------------------------

	/**

	* Valida la vigencia de la instancia con referencia a la fecha de inicio y

	* la fecha final.

	*

	* @param type $instancia

	*/

	public function valida_fecha_vigencia_instancia($instancia)

	{

		setlocale(LC_ALL,"es_CO");

		$fecha_ini_instancia = $instancia->FEC_INIUSO;

		$fecha_ini_instancia_format = iconv('ISO-8859-2', 'UTF-8', strftime("%H:%M:%S %p del %A %d de %B de %Y", strtotime($instancia->FEC_INIUSO)));

		

		$fecha_fin_instancia_format = iconv('ISO-8859-2', 'UTF-8', strftime(" %H:%M:%S %p del %A %d de %B de %Y ", strtotime($instancia->FEC_FINUSO)));

		$fecha_fin_instancia = $instancia->FEC_FINUSO;

		$fecha_hoy           = date('Y-m-d H:i:s');

		

		//Valida la fecha de cierre de la instacia.

		if ($fecha_hoy < $fecha_ini_instancia) {

			return false;

		}

		if ($fecha_hoy > $fecha_fin_instancia) {

			return false;

		}

		return true;

	}

	

	

	/**

	* Proceso de  Votación.

	*/

	public function proceso()

	{

		$participante_id=$this->session->userdata('NUM_IDETER');
		$sesion=$this->session->userdata('session_id');
		$validafecha = $this->Participante->consultafecha($participante_id);
		$sesion_bd= $validafecha->BOL_SESIONID;


	   if ($this->session->userdata('logged_in') && $sesion_bd==$sesion ) {

			if ($this->input->post()) {

				$id_instancia = xss_clean($this->input->post('ID_INSTAN'));

				$orden        = xss_clean($this->input->post('NUM_ORDEN'));

				$candidato    = xss_clean($this->input->post('ID_CANDID[]'));

				$previsualizar_votacion    =  xss_clean($this->input->post('previsualizar_votacion'));

				$ip_address = $this->input->ip_address();

				

				// Validacion instancias activas. 

				$instancias_activas =  $this->Instancia->all();

				

				if(!$instancias_activas) {

					$this->_message = ['type' => 'error', 

					'message' =>  $this->get_texto_sistema('TEX_INSTA_INACTIVA')->TEX_LABEL,

					'redirect' => 'acceso/logout'

				]; 

				echo json_encode($this->_message);

				return false;

			}

			

			//Validacion de la vigencia de la  instancia. 

			$objInstancia = $this->Instancia->get_instancia_by_id($id_instancia);

			$valida_vigencia_instancia = $this->valida_fecha_vigencia_instancia($objInstancia);

			

			if(!$valida_vigencia_instancia) {

				

				if(count($instancias_activas) == 1) {

					$this->_message = ['type' => 'error', 

					'message' =>  $this->get_texto_sistema('TEX_INSTA_INACTIVA')->TEX_LABEL,

					'redirect' => 'acceso/logout'

				]; 

				echo json_encode($this->_message);

				return false;

			}

			

			$n_orden = $orden + 1;

			$url_retorno = 'votacion/index/' . $n_orden;

			

			$this->_message = ['type' => 'error', 

			'message' =>   $this->get_texto_sistema('TEX_VOTA_CERRADA')->TEX_LABEL, 

			'redirect' => $url_retorno

		]; 

		echo json_encode($this->_message);

		return false;

	}

	

	

	

	$this->form_validation->set_rules("ID_CANDID[]", 'Candidato', 'integer');

	$this->form_validation->set_rules('ID_BLANCO', 'Voto Blanco', 'integer');

	

	if (!$this->form_validation->run()) {

		$this->_message = ['type' => 'error', 'message' => validation_errors()]; 

		echo json_encode($this->_message);

		return false;

	}

	

	

	

	$id_voto_blanco = $this->input->post('ID_BLANCO');

	$voto_blanco    = $this->input->post('BOL_VOTBLA');

	//Instancias que se han agredado a la sesion y que estan activas para el participante.

	$instancias_para_votacion = $this->session->userdata('instancias_activas');

	

	if($previsualizar_votacion) {

		$contador=0;

		if($voto_blanco && $id_voto_blanco){

			$datos_candidato = $this->Candidato->get($id_voto_blanco);

			$this->_message = ['type' => 'success', 'message' => $contador.'. '.$datos_candidato->TEX_NOMCAN.' '.$datos_candidato->TEX_APECAN];

		}

		else {

			$lista_candidato = '';

			for ($index = 0; $index < count($candidato); $index++) {

				$contador++;	

				$id_candidato = $candidato[$index];

				if($id_candidato !== ''){

					$datos_candidato = $this->Candidato->get($id_candidato);

					$lista_candidato .= $contador.'. '.$datos_candidato->TEX_NOMCAN.' '.$datos_candidato->TEX_APECAN.'<br>';

				}

			}

			$this->_message = ['type' => 'success', 'message' => $lista_candidato]; 

		}

		

		echo json_encode($this->_message);

		return false;

	}

	

	$this->db->trans_start();



	$punto_votacion = (boolean)$this->session->userdata('punto_votacion');



	if($punto_votacion){

        $mac_cliente = $_SERVER['REMOTE_ADDR'];

		$datos_maquina = $this->Maquina->get_row($mac_cliente);



		if($datos_maquina){

			if($datos_maquina->NOM_MAC)

			$ip_address = $datos_maquina->NOM_MAC;

		}

		



	}







	if (!$voto_blanco) {

		$arr_votos = [];

		for ($index = 0; $index < count($candidato); $index++) {	

			$id_candidato = $candidato[$index];

			

			if(!empty($id_candidato)){ 
				

				//Si ya ha votado por el mismo candidato.

			$valida_votacion = $this->valida_voto($id_instancia, $id_candidato);

			
			/*	if (!$valida_votacion) {
					

					$n_orden = $orden + 1;

					$url_retorno = base_url('votacion/index/' . $n_orden);

					$this->_message = ['type' => 'error', 'message' => '¡Ya has realizado esta votación! ', 'url_retorno'=>$url_retorno]; 

					echo json_encode($this->_message);

					return false;

				} */

				

				$arr_save = [

					'ID_INSTAN'  => $id_instancia,

					'ID_CANDID'  => $id_candidato,

					'NUM_IDETER' => $this->session->userdata('NUM_IDETER'),

					'FEC_PROVOT' => $this->get_fecha_hora_hoy(),

					'TEX_IPORIG' => $ip_address

				];
				

				//Inserción de log y suma de voto al candidato.

				//print_r($valida_votacion);die;

				$insert_log_voto = $this->Candidato->insert_log_voto($arr_save, $id_candidato);

				if(!$insert_log_voto){

					$this->_message = ['type' => 'error', 'message' => 'Error en la transacción']; 

				}

				$arr_votos[] = $arr_save;

			}

		}

	}

	else {

		$arr_save = [

			'ID_INSTAN'  => $id_instancia,

			'ID_CANDID'  => $id_voto_blanco,

			'NUM_IDETER' => $this->session->userdata('NUM_IDETER'),

			'FEC_PROVOT' => $this->get_fecha_hora_hoy(),

			'TEX_IPORIG' => $ip_address

		];

		//Inserción de log y suma de voto al candidato.

		$insert_log_voto = $this->Candidato->insert_log_voto($arr_save, $id_voto_blanco);

		if(!$insert_log_voto){

			$this->_message = ['type' => 'error', 'message' => 'Error en la transacción']; 

		}

		$arr_votos[] = $arr_save;

	}

	

	$this->db->trans_complete();

	if ($this->db->trans_status() === FALSE)

	{

		$this->_message = ['type' => 'error', 'message' => 'Error en la transacción']; 

	}

	

	$orden_instancia = $orden + 1;

	//print_r('uuu');die;

	$url_retorno = base_url('votacion/index/' . $orden_instancia);







	$this->_message = ['type' => 'success', 'message' => ' ', 'url_retorno'=>$url_retorno]; 

}

echo json_encode($this->_message);

} 

else {
	
	$url_retorno = base_url();
$this->_message = ['type' => 'error', 'message' => 'Esta Sesión está cerrada', 'url_retorno' => $url_retorno]; 

echo json_encode($this->_message);


}

}



//-----------------------------------------------------------------------------

/**

* Valida que no se haya hecho una votación previa.

* 

* @param type $instancia

* @param type $candidato

* @return boolean

*/

public function valida_voto($instancia, $candidato)

{

	$participante = $this->session->userdata('NUM_IDETER');

    $consulta     = $this->Participante->get_exits_voto($instancia, $participante/*, $candidato*/);

	if ($consulta) {

		$this->form_validation->set_message('valida_voto', 'Ya has realizado esta votación');

		return false;

	}

	else {

		return true;

	}

}



//------------------------------------------------------------------------------



/**

* Para salir de la aplicación.

*/

public function logout()

{

	if ($this->session->userdata('logged_in')) {

		$this->load->helper('cookie');

		if ($this->session->userdata('is_pin')) {

			$this->Log_ingreso->edit($this->session->userdata('NUM_IDETER'), ['FEC_FINSES' => $this->get_fecha_hora_hoy(), 'BOL_USADO' => 1]);

			delete_cookie('tm');

			delete_cookie('mbienvenida');

		}

		$this->session->sess_destroy();

		//  redirect('/');

	}

}



public function timer_votacion()

{

	$tiempo_restante = $this->_configuracion->NUM_TEMPO;

	if (!$tiempo_restante) {

		return false;

	}

	$tiempo_en_seg = $tiempo_restante * 60;

	echo json_encode($tiempo_en_seg);

}



private function _enviar_email_confirmacion()

{

	$email_participante  = $this->session->userdata('TEX_MAIL');

	$asunto = $this->get_texto_sistema('TEX_MAIASU')->TEX_LABEL;

	$mensaje_sistema = $this->get_texto_sistema('TEX_MAIMEN')->TEX_LABEL;

	$nombre_participante = $this->session->userdata('TEX_NOMPAR') . ' ' . $this->session->userdata('TEX_APEPAR');

	$mensaje             = "

	<html>

	<head>

	<title>Confirmación de Voto en EVIR</title>

	</head>

	<body> <h3>¡Gracias por Votar!</h3> 

	<p>Estimado: $nombre_participante</p>

	<p>$mensaje_sistema</p><p></p></body>

	</html>

	";




	  $fromEmail = "info@gestionvir.com";

        $fromName  = "Evir - Votación Virtual";

        $to        = $email_participante;



        // Cabeceras del correo

        $headers = 'From: ' . $fromName . ' <' . $fromEmail . '>' . "\r\n" .

            'Reply-To: ' . $fromEmail . "\r\n" .

            'X-Mailer: PHP/' . phpversion() . "\r\n" .

            'MIME-Version: 1.0' . "\r\n" .

            'Content-type: text/html; charset=UTF-8';



		

		if (mail($to, $asunto, $mensaje, $headers)) {

            return true; // o manejar como necesites

        } else {

            return false;
        }
	}

		/**

		*  Para Enviar Email.

		* 

		* @param type Asunto

		* @param type $mensaje Cuerpo del mensaje

		* @param type $destino Email del destino.

		* @return boolean Resultado del envío.

		*/

		private function _send_email($asunto, $mensaje, $destino)

		{

			require_once(APPPATH . 'third_party/phpmailer/PHPMailerAutoload.php');

			$this->ini_desencriptado();

			$mail             = new PHPMailer();

			$mail->IsSMTP();

			$mail->SMTPAuth   = true;

			$mail->CharSet    = "utf-8";

			$mail->Encoding   = "base64";

			$mail->SMTPSecure = "ssl";

			//  $mail->Host       = $this->_configuracion->TEX_SMTP;

			$mail->Host       = 'smtp.gmail.com';

			

			//  $mail->Port       = $this->_configuracion->TEX_PORT;

			$mail->Port     = '465';

			//  $mail->Username   = $this->_configuracion->TEX_MAINOM;

			$mail->Username = 'evirsistemavotacion@gmail.com';

			$mail->Password = 'evir1234';

			$mail->SetFrom($this->_configuracion->TEX_MAINOM, 'Sistema Votación EVIR');

			$mail->isHTML(true);

			$mail->Subject  = $asunto;

			$mail->Body     = $mensaje;

			$mail->AddAddress($destino, "Receiver");

			if (!$mail->Send()) {

				return false;

			}

			else {

				return true;

			}

		}

		

	}

	

	