$(document).ready(function () {
	var nombreEmpresa = $('#nom_empresa').html();
	var nombreUsuario = $('#nom_usuario').html();
	var fechaGeneracion;
	var locale;
	var date = new Date(),
	locale = "es-co",
	fechaGeneracion = date.toLocaleString(locale);
	$('#reporte-por-agencia').parsley();
	$('#reporte-form-por-instancia').parsley();
	/**
	* reporte personas sin registrar
	*/
	
	$('#personas_sin_registrarse').DataTable({
		
		"bStateSave": true,
		
		dom: 'lBfrtip',
		
		buttons: [{
			
			extend: 'excelHtml5',
			
			text: 'Exportar a Excel',
			
			title: nombreEmpresa + ' - Personas sin Registrarse',
			
			exportOptions: {
				
				modifier: {
					
					search: 'applied',
					
					order: 'applied'
					
				}
				
			}
			
		},
		
		{
			
			extend: 'pdf',
			
			text: 'Exportar a PDF',
			
			title: nombreEmpresa + ' -  Personas sin Registrarse',
			
			customize: function (win) {
				
				win.defaultStyle.fontSize = '9';
				
			},
			
			message: 'Generado el: ' + fechaGeneracion + ' Generado Por: ' + nombreUsuario,
			
			header: true,
			
			footer: true,
			
			exportOptions: {
				
				modifier: {
					
					page: 'current'
					
				}
				
			}
			
		},
		
		{
			
			extend: 'copy',
			
			text: 'Copiar',
			
			exportOptions: {
				
				modifier: {
					
					search: 'applied',
					
					order: 'applied'
					
				}
				
			}
			
		}
		
	],
	
	lengthMenu: [
		
		[40, 50, 100, 100000],
		
		[40, 50, 100, "Todos"]
		
	],
	
	"scrollX": true,
	
	"bProcessing": true,
	
	"serverSide": true,
	
	"ajax": {
		
		url: baseUrl + "informes/get_all_personas_sin_registrarse", // json datasource
		
		type: "post", // type of method  ,GET/POST/DELETE
		
		error: function () {
			
			$("#processing").css("display", "none");
			
		},
		
		
		
	},
	
	"footerCallback": function (tfoot, data, start, end, display) {
		
		var response = this.api().ajax.json();
		
		var api = this.api();
		
		$(tfoot).find('th').eq(0).html("Población: " + response.poblacion);
		
		$(tfoot).find('th').eq(1).html("% Población: " + response.porcentaje_total_poblacion);
		
		$(tfoot).find('th').eq(2).html("No Regis.: " + response.no_registradas);
		
		$(tfoot).find('th').eq(3).html("% Partic.: " + response.porcentaje_total_no_registradas);
		
	},
	
	"language": {
		
		"sProcessing": "Procesando...",
		
		"sLengthMenu": "Mostrar _MENU_ registros",
		
		"sZeroRecords": "No se encontraron resultados",
		
		"sEmptyTable": "Ningún dato disponible en esta tabla",
		
		"sInfo": "Mostrando participantes del _START_ al _END_ de un total de _TOTAL_ registros",
		
		"sInfoEmpty": "Mostrando participantes del 0 al 0 de un total de 0 registros",
		
		"sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
		
		"sInfoPostFix": "",
		
		"sSearch": "Buscar: ",
		
		"sUrl": "",
		
		"sInfoThousands": ",",
		
		"sLoadingRecords": "Cargando...",
		
		"oPaginate": {
			
			"sFirst": "Primero",
			
			"sLast": "Último",
			
			"sNext": "Siguiente",
			
			"sPrevious": "Anterior"
			
		},
		
		"oAria": {
			
			"sSortAscending": ": Activar para ordenar la columna de manera ascendente",
			
			"sSortDescending": ": Activar para ordenar la columna de manera descendente"
			
		}
		
	}
	
});





//--------------------------------------------------------------------------



/**

* reporte personas registradas

*/

$('#personas_registradas').DataTable({
	
	"bStateSave": true,
	
	dom: 'lBfrtip',
	
	buttons: [{
		
		extend: 'excelHtml5',
		
		text: 'Exportar a Excel',
		
		title: nombreEmpresa + ' -  Personas Registradas',
		
		exportOptions: {
			
			modifier: {
				
				search: 'applied',
				
				order: 'applied'
				
			}
			
		}
		
	},
	
	{
		
		extend: 'pdf',
		
		text: 'Exportar a PDF',
		
		title: nombreEmpresa + ' - Personas Registradas',
		
		message: 'Generado el: ' + fechaGeneracion + ' Generado Por: ' + nombreUsuario,
		
		header: true,
		
		footer: true,
		
		exportOptions: {
			
			modifier: {
				
				page: 'current'
				
			}
			
		}
		
	},
	
	{
		
		extend: 'copy',
		
		text: 'Copiar',
		
		exportOptions: {
			
			modifier: {
				
				search: 'applied',
				
				order: 'applied'
				
			}
			
		}
		
	}
	
],

lengthMenu: [
	
	[40, 50, 100, 100000],
	
	[40, 50, 100, "Todos"]
	
],

"scrollX": true,

"bProcessing": true,

"serverSide": true,

"ajax": {
	
	url: baseUrl + "informes/get_all_personas_registradas", // json datasource
	
	type: "post", // type of method  ,GET/POST/DELETE
	
	error: function () {
		
		$("#processing").css("display", "none");
		
	}
	
},

"initComplete": function (settings, json) {
	
	$('#total_poblacion').html(json.poblacion);
	
	$('#porcentaje_total_poblacion').html(json.porcentaje_total_poblacion);
	
	$('#registradas').html(json.registradas);
	
	$('#porcentaje_total_registradas').html(json.porcentaje_total_registradas);
	
},

"footerCallback": function (tfoot, data, start, end, display) {
	
	var response = this.api().ajax.json();
	
	var api = this.api();
	
	$(tfoot).find('th').eq(0).html("Población: " + response.poblacion);
	
	$(tfoot).find('th').eq(1).html("% Población: " + response.porcentaje_total_poblacion);
	
	$(tfoot).find('th').eq(2).html("Regis.: " + response.registradas);
	
	$(tfoot).find('th').eq(3).html("% Partic.: " + response.porcentaje_total_registradas);
	
},

"language": {
	
	"sProcessing": "Procesando...",
	
	"sLengthMenu": "Mostrar _MENU_ registros",
	
	"sZeroRecords": "No se encontraron resultados",
	
	"sEmptyTable": "Ningún dato disponible en esta tabla",
	
	"sInfo": "Mostrando participantes del _START_ al _END_ de un total de _TOTAL_ registros",
	
	"sInfoEmpty": "Mostrando participantes del 0 al 0 de un total de 0 registros",
	
	"sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
	
	"sInfoPostFix": "",
	
	"sSearch": "Buscar: ",
	
	"sUrl": "",
	
	"sInfoThousands": ",",
	
	"sLoadingRecords": "Cargando...",
	
	"oPaginate": {
		
		"sFirst": "Primero",
		
		"sLast": "Último",
		
		"sNext": "Siguiente",
		
		"sPrevious": "Anterior"
		
	},
	
	"oAria": {
		
		"sSortAscending": ": Activar para ordenar la columna de manera ascendente",
		
		"sSortDescending": ": Activar para ordenar la columna de manera descendente"
		
	}
	
}

});

//--------------------------------------------------------------------------
/**
* Participantes
*/

$('#log-recordar-password').DataTable({
	"bStateSave": true,
	dom: 'lBfrtip',
	buttons: [{
		extend: 'excelHtml5',
		text: 'Exportar a Excel',
		title: nombreEmpresa + ' - Log recordar password',
		exportOptions: {
			modifier: {
				search: 'applied',
				order: 'applied'
			}
			
		}
		
	},
	
	{
		
		extend: 'pdf',
		text: 'Exportar a PDF',
		title: nombreEmpresa + ' - Log recordar password',
		
		customize: function (win) {
			
			win.defaultStyle.fontSize = '9';
			
		},
		
		message: 'Generado el: ' + fechaGeneracion + ' Generado Por: ' + nombreUsuario,
		
		header: true,
		
		footer: true,
		
		exportOptions: {
			
			modifier: {
				
				page: 'current'
				
			}
			
		}
		
	},
	
	{
		
		extend: 'copy',
		
		text: 'Copiar',
		
		exportOptions: {
			
			modifier: {
				
				search: 'applied',
				
				order: 'applied'
				
			}
			
		}
		
	}
	
],

lengthMenu: [
	[40, 50, 100, 100000],
	[40, 50, 100, "Todos"]
],
"scrollX": true,
"bProcessing": true,
"serverSide": true,
"ajax": {
	url: baseUrl + "informes/get_log_recordar_password",
	type: "post", 
	error: function () {
		$("#processing").css("display", "none");
	}
},
"footerCallback": function (tfoot, data, start, end, display) {
	
	var response = this.api().ajax.json();
	
	var api = this.api();
	
	$(tfoot).find('th').eq(6).html("Total: " + response.total);
	
},
"language": {
	
	"sProcessing": "Procesando...",
	
	"sLengthMenu": "Mostrar _MENU_ registros",
	
	"sZeroRecords": "No se encontraron resultados",
	
	"sEmptyTable": "Ningún dato disponible en esta tabla",
	
	"sInfo": "Mostrando participantes del _START_ al _END_ de un total de _TOTAL_ registros",
	
	"sInfoEmpty": "Mostrando del 0 al 0 de un total de 0 registros",
	
	"sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
	
	"sInfoPostFix": "",
	
	"sSearch": "Buscar: ",
	
	"sUrl": "",
	
	"sInfoThousands": ",",
	
	"sLoadingRecords": "Cargando...",
	
	"oPaginate": {
		
		"sFirst": "Primero",
		
		"sLast": "Último",
		
		"sNext": "Siguiente",
		
		"sPrevious": "Anterior"
		
	},
	
	"oAria": {
		
		"sSortAscending": ": Activar para ordenar la columna de manera ascendente",
		
		"sSortDescending": ": Activar para ordenar la columna de manera descendente"
		
	}
}
});




//--------------------------------------------------------------------------

/**
* Participantes
*/

$('#participantes').DataTable({
	
	"bStateSave": true,
	
	dom: 'lBfrtip',
	
	buttons: [{
		
		extend: 'excelHtml5',
		
		text: 'Exportar a Excel',
		
		title: nombreEmpresa + ' - Personas que han participado',
		
		exportOptions: {
			
			modifier: {
				
				search: 'applied',
				
				order: 'applied'
				
			}
			
		}
		
	},
	
	{
		
		extend: 'pdf',
		
		text: 'Exportar a PDF',
		
		title: nombreEmpresa + ' - Personas que han participado',
		
		customize: function (win) {
			
			win.defaultStyle.fontSize = '9';
			
		},
		
		message: 'Generado el: ' + fechaGeneracion + ' Generado Por: ' + nombreUsuario,
		
		header: true,
		
		footer: true,
		
		exportOptions: {
			
			modifier: {
				
				page: 'current'
				
			}
			
		}
		
	},
	
	{
		
		extend: 'copy',
		
		text: 'Copiar',
		
		exportOptions: {
			
			modifier: {
				
				search: 'applied',
				
				order: 'applied'
				
			}
			
		}
		
	}
	
],

lengthMenu: [
	
	[40, 50, 100, 100000],
	
	[40, 50, 100, "Todos"]
	
],

"scrollX": true,

"bProcessing": true,

"serverSide": true,



"ajax": {
	
	url: baseUrl + "informes/get_all_participantes", // json datasource
	
	type: "post", // type of method  ,GET/POST/DELETE
	
	error: function () {
		
		$("#processing").css("display", "none");
		
	}
	
},

"initComplete": function (settings, json) {
	
	$('#total_poblacion').html(json.poblacion);
	
	$('#porcentaje_total_poblacion').html(json.porcentaje_total_poblacion);
	
	$('#total_participacion').html(json.participacion);
	
	$('#porcentaje_total_participacion').html(json.porcentaje_total_participacion);
	
},

"footerCallback": function (tfoot, data, start, end, display) {
	
	var response = this.api().ajax.json();
	
	var api = this.api();
	
	console.log(response);
	
	$(tfoot).find('th').eq(0).html("Población: " + response.poblacion);
	
	$(tfoot).find('th').eq(1).html("% Población: " + response.porcentaje_total_poblacion);
	
	$(tfoot).find('th').eq(2).html("Partic.: " + response.participacion);
	
	$(tfoot).find('th').eq(3).html("% Partic.: " + response.porcentaje_total_participacion);
	
},

"language": {
	
	"sProcessing": "Procesando...",
	
	"sLengthMenu": "Mostrar _MENU_ registros",
	
	"sZeroRecords": "No se encontraron resultados",
	
	"sEmptyTable": "Ningún dato disponible en esta tabla",
	
	"sInfo": "Mostrando participantes del _START_ al _END_ de un total de _TOTAL_ registros",
	
	"sInfoEmpty": "Mostrando participantes del 0 al 0 de un total de 0 registros",
	
	"sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
	
	"sInfoPostFix": "",
	
	"sSearch": "Buscar: ",
	
	"sUrl": "",
	
	"sInfoThousands": ",",
	
	"sLoadingRecords": "Cargando...",
	
	"oPaginate": {
		
		"sFirst": "Primero",
		
		"sLast": "Último",
		
		"sNext": "Siguiente",
		
		"sPrevious": "Anterior"
		
	},
	
	"oAria": {
		
		"sSortAscending": ": Activar para ordenar la columna de manera ascendente",
		
		"sSortDescending": ": Activar para ordenar la columna de manera descendente"
		
	}
	
}

});



//--------------------------------------------------------------------------

/**

* Participantes

*/


$('#filtro_bloqueados').on('change', function () {
	$('#participantes-bloqueados').DataTable().search($(this).val()).draw();
});


var participantesBloqueados = $('#participantes-bloqueados').DataTable({
	
	"bStateSave": true,
	
	dom: 'lBfrtip',
	
	buttons: [{
		
		extend: 'excelHtml5',
		
		text: 'Exportar a Excel',
		
		title: nombreEmpresa + ' - Personas Bloquedas',
		
		exportOptions: {
			
			modifier: {
				
				search: 'applied',
				
				order: 'applied'
				
			}
			
		}
		
	},
	
	{
		
		extend: 'pdf',
		
		text: 'Exportar a PDF',
		
		title: nombreEmpresa + ' - Personas Bloquedas',
		
		message: 'Generado el: ' + fechaGeneracion + ' Generado Por: ' + nombreUsuario,
		
		header: true,
		
		footer: true,
		
		exportOptions: {
			
			modifier: {
				
				page: 'current'
				
			}
			
		}
		
	},
	
	{
		
		extend: 'copy',
		
		text: 'Copiar',
		
		exportOptions: {
			
			modifier: {
				
				search: 'applied',
				
				order: 'applied'
				
			}
			
		}
		
	}
	
],

lengthMenu: [
	
	[40, 50, 100, 100000],
	
	[40, 50, 100, "Todos"]
	
],

"scrollX": true,

"bProcessing": true,

"serverSide": true,

"ajax": {
	
	url: baseUrl + "informes/get_all_participantes_bloqueados", // json datasource
	
	type: "post", // type of method  ,GET/POST/DELETE
	
	error: function () {
		
		$("#processing").css("display", "none");
		
	}
	
},

"language": {
	
	"sProcessing": "Procesando...",
	
	"sLengthMenu": "Mostrar _MENU_ registros",
	
	"sZeroRecords": "No se encontraron resultados",
	
	"sEmptyTable": "Ningún dato disponible en esta tabla",
	
	"sInfo": "Mostrando participantes del _START_ al _END_ de un total de _TOTAL_ registros",
	
	"sInfoEmpty": "Mostrando participantes del 0 al 0 de un total de 0 registros",
	
	"sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
	
	"sInfoPostFix": "",
	
	"sSearch": "Buscar: ",
	
	"sUrl": "",
	
	"sInfoThousands": ",",
	
	"sLoadingRecords": "Cargando...",
	
	"oPaginate": {
		
		"sFirst": "Primero",
		
		"sLast": "Último",
		
		"sNext": "Siguiente",
		
		"sPrevious": "Anterior"
		
	},
	
	"oAria": {
		
		"sSortAscending": ": Activar para ordenar la columna de manera ascendente",
		
		"sSortDescending": ": Activar para ordenar la columna de manera descendente"
		
	}
	
}

});

//--------------------------------------------------------------------------



/**

* Personas bloqueadas

*/

$('#participantes_bloqueados').DataTable({
	
	"bStateSave": true,
	
	dom: 'lBfrtip',
	
	buttons: [{
		
		extend: 'excelHtml5',
		
		text: 'Exportar a Excel',
		
		exportOptions: {
			
			modifier: {
				
				search: 'applied',
				
				order: 'applied'
				
			}
			
		}
		
	},
	
	{
		
		extend: 'pdf',
		
		text: 'Exportar a PDF',
		
		title: nombreEmpresa + ' - Personas Bloquedas sin votar',
		
		message: 'Generado el: ' + fechaGeneracion + ' Generado Por: ' + nombreUsuario,
		
		header: true,
		
		footer: true,
		
		exportOptions: {
			
			modifier: {
				
				page: 'current'
				
			}
			
		}
		
	},
	
	{
		
		extend: 'copy',
		
		text: 'Copiar',
		
		exportOptions: {
			
			modifier: {
				
				search: 'applied',
				
				order: 'applied'
				
			}
			
		}
		
	}
	
],

lengthMenu: [
	
	[40, 50, 100, 100000],
	
	[40, 50, 100, "Todos"]
	
],

"scrollX": true,

"bProcessing": true,

"serverSide": true,

"ajax": {
	
	url: baseUrl + "informes/get_all_participantes_bloqueados", // json datasource
	
	type: "post", // type of method  ,GET/POST/DELETE
	
	error: function () {
		
		$("#processing").css("display", "none");
		
	}
	
},

"language": {
	
	"sProcessing": "Procesando...",
	
	"sLengthMenu": "Mostrar _MENU_ registros",
	
	"sZeroRecords": "No se encontraron resultados",
	
	"sEmptyTable": "Ningún dato disponible en esta tabla",
	
	"sInfo": "Mostrando participantes del _START_ al _END_ de un total de _TOTAL_ registros",
	
	"sInfoEmpty": "Mostrando participantes del 0 al 0 de un total de 0 registros",
	
	"sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
	
	"sInfoPostFix": "",
	
	"sSearch": "Buscar: ",
	
	"sUrl": "",
	
	"sInfoThousands": ",",
	
	"sLoadingRecords": "Cargando...",
	
	"oPaginate": {
		
		"sFirst": "Primero",
		
		"sLast": "Último",
		
		"sNext": "Siguiente",
		
		"sPrevious": "Anterior"
		
	},
	
	"oAria": {
		
		"sSortAscending": ": Activar para ordenar la columna de manera ascendente",
		
		"sSortDescending": ": Activar para ordenar la columna de manera descendente"
		
	}
	
}

});





//--------------------------------------------------------------------------



/**

* Personas fuera Auditorio.

*/

$('#personas_fuera_auditorio').DataTable({
	
	"bStateSave": true,
	
	dom: 'lBfrtip',
	
	buttons: [{
		
		extend: 'excelHtml5',
		
		text: 'Exportar a Excel',
		
		title: nombreEmpresa + ' - Personas fuera del Auditorio',
		
		message: 'Generado el: ' + fechaGeneracion,
		
		exportOptions: {
			
			modifier: {
				
				search: 'applied',
				
				order: 'applied'
				
			}
			
		}
		
	},
	
	{
		
		extend: 'pdf',
		
		text: 'Exportar a PDF',
		
		title: 'Personas fuera del Auditorio',
		
		title: nombreEmpresa + ' - Personas fuera del Auditorio',
		
		message: 'Generado el: ' + fechaGeneracion + ' Generado Por: ' + nombreUsuario,
		
		header: true,
		
		footer: true,
		
		exportOptions: {
			
			modifier: {
				
				page: 'current'
				
			}
			
		}
		
	},
	
	{
		
		extend: 'copy',
		
		text: 'Copiar',
		
		exportOptions: {
			
			modifier: {
				
				search: 'applied',
				
				order: 'applied'
				
			}
			
		}
		
	}
	
],

lengthMenu: [
	
	[40, 50, 100, 100000],
	
	[40, 50, 100, "Todos"]
	
],

"scrollX": true,

"bProcessing": true,

"serverSide": true,

"ajax": {
	
	url: baseUrl + "informes/get_personas_fuera_auditorio", // json datasource
	
	type: "post", // type of method  ,GET/POST/DELETE
	
	error: function () {
		
		$("#processing").css("display", "none");
		
	}
	
},

"language": {
	
	"sProcessing": "Procesando...",
	
	"sLengthMenu": "Mostrar _MENU_ registros",
	
	"sZeroRecords": "No se encontraron resultados",
	
	"sEmptyTable": "Ningún dato disponible en esta tabla",
	
	"sInfo": "Mostrando participantes del _START_ al _END_ de un total de _TOTAL_ registros",
	
	"sInfoEmpty": "Mostrando participantes del 0 al 0 de un total de 0 registros",
	
	"sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
	
	"sInfoPostFix": "",
	
	"sSearch": "Buscar: ",
	
	"sUrl": "",
	
	"sInfoThousands": ",",
	
	"sLoadingRecords": "Cargando...",
	
	"oPaginate": {
		
		"sFirst": "Primero",
		
		"sLast": "Último",
		
		"sNext": "Siguiente",
		
		"sPrevious": "Anterior"
		
	},
	
	"oAria": {
		
		"sSortAscending": ": Activar para ordenar la columna de manera ascendente",
		
		"sSortDescending": ": Activar para ordenar la columna de manera descendente"
		
	}
	
}

});

$('#personas_en_auditorio').DataTable({
	
	"bStateSave": true,
	
	dom: 'lBfrtip',
	
	buttons: [{
		
		extend: 'excelHtml5',
		
		text: 'Exportar a Excel',
		
		title: nombreEmpresa + ' - Personas en Auditorio',
		
		message: 'Generado el: ' + fechaGeneracion,
		
		exportOptions: {
			
			modifier: {
				
				search: 'applied',
				
				order: 'applied'
				
			}
			
		}
		
	},
	
	{
		
		extend: 'pdf',
		
		text: 'Exportar a PDF',
		
		title: nombreEmpresa + ' - Personas en Auditorio',
		
		message: 'Generado el: ' + fechaGeneracion + ' Generado Por: ' + nombreUsuario,
		
		header: true,
		
		footer: true,
		
		exportOptions: {
			
			modifier: {
				
				page: 'current'
				
			}
			
		}
		
	},
	
	{
		
		extend: 'copy',
		
		text: 'Copiar',
		
		exportOptions: {
			
			modifier: {
				
				search: 'applied',
				
				order: 'applied'
				
			}
			
		}
		
	}
	
],

lengthMenu: [
	
	[40, 50, 100, 100000],
	
	[40, 50, 100, "Todos"]
	
],

"scrollX": true,

"bProcessing": true,

"serverSide": true,

"ajax": {
	
	url: baseUrl + "informes/get_personas_en_auditorio", // json datasource
	
	type: "post", // type of method  ,GET/POST/DELETE
	
	error: function () {
		
		$("#processing").css("display", "none");
		
	}
	
},

"language": {
	
	"sProcessing": "Procesando...",
	
	"sLengthMenu": "Mostrar _MENU_ registros",
	
	"sZeroRecords": "No se encontraron resultados",
	
	"sEmptyTable": "Ningún dato disponible en esta tabla",
	
	"sInfo": "Mostrando participantes del _START_ al _END_ de un total de _TOTAL_ registros",
	
	"sInfoEmpty": "Mostrando participantes del 0 al 0 de un total de 0 registros",
	
	"sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
	
	"sInfoPostFix": "",
	
	"sSearch": "Buscar: ",
	
	"sUrl": "",
	
	"sInfoThousands": ",",
	
	"sLoadingRecords": "Cargando...",
	
	"oPaginate": {
		
		"sFirst": "Primero",
		
		"sLast": "Último",
		
		"sNext": "Siguiente",
		
		"sPrevious": "Anterior"
		
	},
	
	"oAria": {
		
		"sSortAscending": ": Activar para ordenar la columna de manera ascendente",
		
		"sSortDescending": ": Activar para ordenar la columna de manera descendente"
		
	}
	
}

});



//------------------------------------------------------------------------------



$('#registrados_sin_participar').DataTable({
	
	"bStateSave": true,
	
	dom: 'lBfrtip',
	
	buttons: [{
		
		extend: 'excelHtml5',
		
		text: 'Exportar a Excel',
		
		title: nombreEmpresa + ' - Registrados sin Participar',
		
		exportOptions: {
			
			modifier: {
				
				search: 'applied',
				
				order: 'applied'
				
			}
			
		}
		
	},
	
	{
		
		extend: 'pdf',
		
		text: 'Exportar a PDF',
		
		title: nombreEmpresa + ' - Registrados sin Participar',
		
		message: 'Generado el: ' + fechaGeneracion + ' Generado Por: ' + nombreUsuario,
		
		header: true,
		
		footer: true,
		
		exportOptions: {
			
			modifier: {
				
				page: 'current'
				
			}
			
		}
		
	},
	
	{
		
		extend: 'copy',
		
		text: 'Copiar',
		
		exportOptions: {
			
			modifier: {
				
				search: 'applied',
				
				order: 'applied'
				
			}
			
		}
		
	}
	
],

lengthMenu: [
	
	[40, 50, 100, 100000],
	
	[40, 50, 100, "Todos"]
	
],

"scrollX": true,

"bProcessing": true,

"serverSide": true,

"ajax": {
	
	url: baseUrl + "informes/get_registrados_sin_participar", // json datasource
	
	type: "post", // type of method  ,GET/POST/DELETE
	
	error: function () {
		
		$("#processing").css("display", "none");
		
	}
	
},

"initComplete": function (settings, json) {
	
	$('#total_poblacion').html(json.poblacion);
	
	$('#porcentaje_total_poblacion').html(json.porcentaje_total_poblacion);
	
	$('#total_participacion').html(json.participacion);
	
	$('#porcentaje_total_participacion').html(json.porcentaje_total_participacion);
	
},

"footerCallback": function (tfoot, data, start, end, display) {
	
	var response = this.api().ajax.json();
	
	var api = this.api();
	
	console.log(response);
	
	$(tfoot).find('th').eq(0).html("Población: " + response.poblacion);
	
	$(tfoot).find('th').eq(1).html("% Población: " + response.porcentaje_total_poblacion);
	
	$(tfoot).find('th').eq(2).html("Partic.: " + response.participacion);
	
	$(tfoot).find('th').eq(3).html("% Partic.: " + response.porcentaje_total_participacion);
	
},

"language": {
	
	"sProcessing": "Procesando...",
	
	"sLengthMenu": "Mostrar _MENU_ registros",
	
	"sZeroRecords": "No se encontraron resultados",
	
	"sEmptyTable": "Ningún dato disponible en esta tabla",
	
	"sInfo": "Mostrando participantes del _START_ al _END_ de un total de _TOTAL_ registros",
	
	"sInfoEmpty": "Mostrando participantes del 0 al 0 de un total de 0 registros",
	
	"sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
	
	"sInfoPostFix": "",
	
	"sSearch": "Buscar: ",
	
	"sUrl": "",
	
	"sInfoThousands": ",",
	
	"sLoadingRecords": "Cargando...",
	
	"oPaginate": {
		
		"sFirst": "Primero",
		
		"sLast": "Último",
		
		"sNext": "Siguiente",
		
		"sPrevious": "Anterior"
		
	},
	
	"oAria": {
		
		"sSortAscending": ": Activar para ordenar la columna de manera ascendente",
		
		"sSortDescending": ": Activar para ordenar la columna de manera descendente"
		
	}
	
}

});



//------------------------------------------------------------------------------



/**

* Assitentes Hábiles. 

*/

$('#asistentes_habiles').DataTable({
	
	"bStateSave": true,
	
	dom: 'lBfrtip',
	
	buttons: [{
		
		extend: 'excelHtml5',
		
		text: 'Exportar a Excel',
		
		title: nombreEmpresa + ' - Asistentes Hábiles',
		
		exportOptions: {
			
			modifier: {
				
				search: 'applied',
				
				order: 'applied'
				
			}
			
		}
		
	},
	
	{
		
		extend: 'pdf',
		
		text: 'Exportar a PDF',
		
		title: nombreEmpresa + ' - Asistentes Hábiles',
		
		message: 'Generado el: ' + fechaGeneracion + ' Generado Por: ' + nombreUsuario,
		
		header: true,
		
		footer: true,
		
		exportOptions: {
			
			modifier: {
				
				page: 'current'
				
			}
			
		}
		
	},
	
	{
		
		extend: 'copy',
		
		text: 'Copiar',
		
		exportOptions: {
			
			modifier: {
				
				search: 'applied',
				
				order: 'applied'
				
			}
			
		}
		
	}
	
],

lengthMenu: [
	
	[40, 50, 100, 100000],
	
	[40, 50, 100, "Todos"]
	
],

"scrollX": true,

"bProcessing": true,

"serverSide": true,

"ajax": {
	
	url: baseUrl + "informes/get_asistentes_habiles", // json datasource
	
	type: "post", // type of method  ,GET/POST/DELETE
	
	error: function () {
		
		$("#processing").css("display", "none");
		
	}
	
},

"language": {
	
	"sProcessing": "Procesando...",
	
	"sLengthMenu": "Mostrar _MENU_ registros",
	
	"sZeroRecords": "No se encontraron resultados",
	
	"sEmptyTable": "Ningún dato disponible en esta tabla",
	
	"sInfo": "Mostrando participantes del _START_ al _END_ de un total de _TOTAL_ registros",
	
	"sInfoEmpty": "Mostrando participantes del 0 al 0 de un total de 0 registros",
	
	"sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
	
	"sInfoPostFix": "",
	
	"sSearch": "Buscar: ",
	
	"sUrl": "",
	
	"sInfoThousands": ",",
	
	"sLoadingRecords": "Cargando...",
	
	"oPaginate": {
		
		"sFirst": "Primero",
		
		"sLast": "Último",
		
		"sNext": "Siguiente",
		
		"sPrevious": "Anterior"
		
	},
	
	"oAria": {
		
		"sSortAscending": ": Activar para ordenar la columna de manera ascendente",
		
		"sSortDescending": ": Activar para ordenar la columna de manera descendente"
		
	}
	
}

});



//------------------------------------------------------------------------------



/**

* General Candidatos. 

*/

$('#general_candidatos').DataTable({
	
	"footerCallback": function (row, data, start, end, display) {
		
		var api = this.api(),
		
		data;
		
		
		
		// Remove the formatting to get integer data for summation
		
		var intVal = function (i) {
			
			return typeof i === 'string' ?
			
			i.replace(/[\$,]/g, '') * 1 :
			
			typeof i === 'number' ?
			
			i : 0;
			
		};
		
		
		
		// Total over all pages
		
		total = api
		
		.column(2)
		
		.data()
		
		.reduce(function (a, b) {
			
			return intVal(a) + intVal(b);
			
		}, 0);
		
		
		
		// Total over this page
		
		pageTotal = api
		
		.column(2, { page: 'current' })
		
		.data()
		
		.reduce(function (a, b) {
			
			return intVal(a) + intVal(b);
			
		}, 0);
		
		
		
		// Update footer
		
		$(api.column(2).footer()).html(
			
			// 'Total Votos:' + pageTotal + ' (' + total + ' total global)'
			
			'Total: ' + total + ''
			
			);
			
		},
		
		"bStateSave": true,
		
		dom: 'lBfrtip',
		"columns": [
			null,
			null,
			null,
			null,
			null,
			null,
			{ "width": "10%" },
		],
		buttons: [{
			
			extend: 'excelHtml5',
			
			text: 'Exportar a Excel',
			
			title: nombreEmpresa + ' - General Candidatos',
			
			exportOptions: {
				
				modifier: {
					
					search: 'applied',
					
					order: 'applied'
					
				}
				
			}
			
		},
		
		{
			
			extend: 'pdf',
			
			text: 'Exportar a PDF',
			
			title: nombreEmpresa + ' - General Candidatos',
			
			message: 'Generado el: ' + fechaGeneracion + ' Generado Por: ' + nombreUsuario,
			
			header: true,
			
			footer: true,
			orientation: 'landscape',
			customize: function ( doc ) {
				doc.defaultStyle.fontSize = 8;
				var cols = [];
				cols[6] = {text: 'Right part', alignment: 'right', margin:[0,0,20]};
			},
			
			exportOptions: {
				
				modifier: {
					
					page: 'current'
					
				}
				
			}
			
		},
		
		{
			
			extend: 'copy',
			
			text: 'Copiar',
			
			exportOptions: {
				
				modifier: {
					
					search: 'applied',
					
					order: 'applied'
					
				}
				
			}
			
		}
		
	],
	
	lengthMenu: [
		
		[40, 50, 100, 100000],
		
		[40, 50, 100, "Todos"]
		
	],
	
	"scrollX": true,
	
	"bProcessing": true,
	
	"serverSide": true,
	
	"ajax": {
		
		url: baseUrl + "informes/get_general_candidatos", // json datasource
		
		type: "post", // type of method  ,GET/POST/DELETE
		
		error: function () {
			
			$("#processing").css("display", "none");
			
		}
		
	},
	
	"language": {
		
		"sProcessing": "Procesando...",
		
		"sLengthMenu": "Mostrar _MENU_ registros",
		
		"sZeroRecords": "No se encontraron resultados",
		
		"sEmptyTable": "Ningún dato disponible en esta tabla",
		
		"sInfo": "Mostrando participantes del _START_ al _END_ de un total de _TOTAL_ registros",
		
		"sInfoEmpty": "Mostrando participantes del 0 al 0 de un total de 0 registros",
		
		"sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
		
		"sInfoPostFix": "",
		
		"sSearch": "Buscar: ",
		
		"sUrl": "",
		
		"sInfoThousands": ",",
		
		"sLoadingRecords": "Cargando...",
		
		"oPaginate": {
			
			"sFirst": "Primero",
			
			"sLast": "Último",
			
			"sNext": "Siguiente",
			
			"sPrevious": "Anterior"
			
		},
		
		"oAria": {
			
			"sSortAscending": ": Activar para ordenar la columna de manera ascendente",
			
			"sSortDescending": ": Activar para ordenar la columna de manera descendente"
			
		}
		
	}
	
});



//----------------------------------------------------------------------------------
/**
Personas sin participar. 
*/
$('#personas_sin_participar').DataTable({
	
	"bStateSave": true,
	
	dom: 'lBfrtip',
	
	buttons: [{
		
		extend: 'excelHtml5',
		
		text: 'Exportar a Excel',
		
		title: nombreEmpresa + ' - Personas sin Participar',
		
		exportOptions: {
			
			modifier: {
				
				search: 'applied',
				
				order: 'applied'
				
			}
			
		}
		
	},
	
	{
		
		extend: 'pdf',
		
		text: 'Exportar a PDF',
		
		title: nombreEmpresa + ' -  Personas sin Participar',
		
		customize: function (win) {
			
			win.defaultStyle.fontSize = '9';
			
		},
		
		message: 'Generado el: ' + fechaGeneracion + ' Generado Por: ' + nombreUsuario,
		
		header: true,
		
		footer: true,
		
		exportOptions: {
			
			modifier: {
				
				page: 'current'
				
			}
			
		}
		
	},
	
	{
		
		extend: 'copy',
		
		text: 'Copiar',
		
		exportOptions: {
			
			modifier: {
				
				search: 'applied',
				
				order: 'applied'
				
			}
			
		}
		
	}
	
],

lengthMenu: [
	
	[40, 50, 100, 100000],
	
	[40, 50, 100, "Todos"]
	
],

"scrollX": true,

"bProcessing": true,

"serverSide": true,

"ajax": {
	
	url: baseUrl + "informes/get_all_personas_sin_participar", // json datasource
	
	type: "post", // type of method  ,GET/POST/DELETE
	
	error: function () {
		
		$("#processing").css("display", "none");
		
	},
	
	
	
},

"footerCallback": function (tfoot, data, start, end, display) {
	
	var response = this.api().ajax.json();
	
	var api = this.api();
	
	$(tfoot).find('th').eq(0).html("Población: " + response.poblacion);
	
	$(tfoot).find('th').eq(1).html("% Población: " + response.porcentaje_total_poblacion);
	
	$(tfoot).find('th').eq(2).html("Sin Participar.: " + response.no_registradas);
	
	$(tfoot).find('th').eq(3).html("% Sin Partic.: " + response.porcentaje_total_no_registradas);
	
},

"initComplete": function (settings, json) {
	
	$('#total_poblacion').html(json.poblacion);
	
	$('#porcentaje_total_poblacion').html(json.porcentaje_total_poblacion);
	
	$('#sin_participar').html(json.recordsFiltered);
	
	$('#porcentaje_sin_participar').html(json.porcentaje_total_no_registradas);
	
},

"language": {
	
	"sProcessing": "Procesando...",
	
	"sLengthMenu": "Mostrar _MENU_ registros",
	
	"sZeroRecords": "No se encontraron resultados",
	
	"sEmptyTable": "Ningún dato disponible en esta tabla",
	
	"sInfo": "Mostrando participantes del _START_ al _END_ de un total de _TOTAL_ registros",
	
	"sInfoEmpty": "Mostrando participantes del 0 al 0 de un total de 0 registros",
	
	"sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
	
	"sInfoPostFix": "",
	
	"sSearch": "Buscar: ",
	
	"sUrl": "",
	
	"sInfoThousands": ",",
	
	"sLoadingRecords": "Cargando...",
	
	"oPaginate": {
		
		"sFirst": "Primero",
		
		"sLast": "Último",
		
		"sNext": "Siguiente",
		
		"sPrevious": "Anterior"
		
	},
	
	"oAria": {
		
		"sSortAscending": ": Activar para ordenar la columna de manera ascendente",
		
		"sSortDescending": ": Activar para ordenar la columna de manera descendente"
		
	}
	
}

});

//------------------------------------------------------------------------------



/**

* Por Instancia. 

*/

var instanciaId = $('#instancia_id').val();

$('#por_instancias').DataTable({
	
	"footerCallback": function (row, data, start, end, display) {
		
		var api = this.api(),
		
		data;
		
		
		
		// Remove the formatting to get integer data for summation
		
		var intVal = function (i) {
			
			return typeof i === 'string' ?
			
			i.replace(/[\$,]/g, '') * 1 :
			
			typeof i === 'number' ?
			
			i : 0;
			
		};
		
		
		
		// Total over all pages
		
		total = api
		
		.column(2)
		
		.data()
		
		.reduce(function (a, b) {
			
			return intVal(a) + intVal(b);
			
		}, 0);
		
		
		
		// Total over this page
		
		pageTotal = api
		
		.column(2, { page: 'current' })
		
		.data()
		
		.reduce(function (a, b) {
			
			return intVal(a) + intVal(b);
			
		}, 0);
		
		
		
		// Update footer
		
		$(api.column(2).footer()).html(
			
			// 'Total Votos:' + pageTotal + ' (' + total + ' total global)'
			
			'Total: ' + total + ''
			
			);
			
		},
		
		"bStateSave": true,
		
		dom: 'lBfrtip',
		
		buttons: [{
			
			extend: 'excelHtml5',
			
			text: nombreEmpresa + ' - Exportar a Excel',
			
			title: 'Informe por Instancias',
			
			exportOptions: {
				
				modifier: {
					
					search: 'applied',
					
					order: 'applied'
					
				}
				
			}
			
		},
		
		{
			
			extend: 'pdf',
			
			text: 'Exportar a PDF',
			
			title: nombreEmpresa + ' - Informe por Instancias',
			
			message: 'Generado el: ' + fechaGeneracion + ' Generado Por: ' + nombreUsuario,
			
			header: true,
			
			footer: true,
			
			exportOptions: {
				
				modifier: {
					
					page: 'current'
					
				}
				
			}
			
		},
		
		{
			
			extend: 'copy',
			
			text: 'Copiar',
			
			exportOptions: {
				
				modifier: {
					
					search: 'applied',
					
					order: 'applied'
					
				}
				
			}
			
		}
		
	],
	
	lengthMenu: [
		
		[40, 50, 100, 100000],
		
		[40, 50, 100, "Todos"]
		
	],
	
	"scrollX": true,
	
	"bProcessing": true,
	
	"serverSide": true,
	
	"ajax": {
		
		url: baseUrl + "informes/get_por_instancias/" + instanciaId, // json datasource
		
		type: "post", // type of method  ,GET/POST/DELETE
		
		error: function () {
			
			$("#processing").css("display", "none");
			
		}
		
	},
	
	"language": {
		
		"sProcessing": "Procesando...",
		
		"sLengthMenu": "Mostrar _MENU_ registros",
		
		"sZeroRecords": "No se encontraron resultados",
		
		"sEmptyTable": "Ningún dato disponible en esta tabla",
		
		"sInfo": "Mostrando participantes del _START_ al _END_ de un total de _TOTAL_ registros",
		
		"sInfoEmpty": "Mostrando participantes del 0 al 0 de un total de 0 registros",
		
		"sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
		
		"sInfoPostFix": "",
		
		"sSearch": "Buscar: ",
		
		"sUrl": "",
		
		"sInfoThousands": ",",
		
		"sLoadingRecords": "Cargando...",
		
		"oPaginate": {
			
			"sFirst": "Primero",
			
			"sLast": "Último",
			
			"sNext": "Siguiente",
			
			"sPrevious": "Anterior"
			
		},
		
		"oAria": {
			
			"sSortAscending": ": Activar para ordenar la columna de manera ascendente",
			
			"sSortDescending": ": Activar para ordenar la columna de manera descendente"
			
		}
		
	}
	
});

// Por instancias participantes. 
$('#por_instancias_participantes').DataTable({
	
	"footerCallback": function (row, data, start, end, display) {
		
		var api = this.api(),
		
		data;
		
		
		
		// Remove the formatting to get integer data for summation
		
		var intVal = function (i) {
			
			return typeof i === 'string' ?
			
			i.replace(/[\$,]/g, '') * 1 :
			
			typeof i === 'number' ?
			
			i : 0;
			
		};
		
		
		
		// Total over all pages
		
		total = api
		
		.column(2)
		
		.data()
		
		.reduce(function (a, b) {
			
			return intVal(a) + intVal(b);
			
		}, 0);
		
		
		
		// Total over this page
		
		pageTotal = api
		
		.column(2, { page: 'current' })
		
		.data()
		
		.reduce(function (a, b) {
			
			return intVal(a) + intVal(b);
			
		}, 0);
		
		
		
		// Update footer
		
		$(api.column(2).footer()).html(
			
			// 'Total Votos:' + pageTotal + ' (' + total + ' total global)'
			
			'Total: ' + total.toFixed(2) + ''
			
			);
			
		},
		
		"bStateSave": true,
		
		dom: 'lBfrtip',
		
		buttons: [{
			
			extend: 'excelHtml5',
			
			text: nombreEmpresa + ' - Exportar a Excel',
			
			title: 'Informe por Instancias',
			
			exportOptions: {
				
				modifier: {
					
					search: 'applied',
					
					order: 'applied'
					
				}
				
			}
			
		},
		
		{
			
			extend: 'pdf',
			
			text: 'Exportar a PDF',
			
			title: nombreEmpresa + ' - Informe por Instancias',
			
			message: 'Generado el: ' + fechaGeneracion + ' Generado Por: ' + nombreUsuario,
			
			header: true,
			
			footer: true,
			
			exportOptions: {
				
				modifier: {
					
					page: 'current'
					
				}
				
			}
			
		},
		
		{
			
			extend: 'copy',
			
			text: 'Copiar',
			
			exportOptions: {
				
				modifier: {
					
					search: 'applied',
					
					order: 'applied'
					
				}
				
			}
			
		}
		
	],
	
	lengthMenu: [
		
		[40, 50, 100, 100000],
		
		[40, 50, 100, "Todos"]
		
	],
	
	"scrollX": true,
	
	"bProcessing": true,
	
	"serverSide": true,
	
	"ajax": {
		
		url: baseUrl + "informes/get_por_instancias_participantes/" + instanciaId, // json datasource
		
		type: "post", // type of method  ,GET/POST/DELETE
		
		error: function () {
			
			$("#processing").css("display", "none");
			
		}
		
	},

	"initComplete": function (settings, json) {
	
		$('#total_poblacion').html(json.poblacion);
		
		$('#porcentaje_total_poblacion').html(json.porcentaje_total_poblacion);
		
		$('#participantes_por_instancia').html(json.participantes_por_instancia);
		
		$('#porcentaje_total_por_instancia').html(json.porcentaje_total_por_instancia);
		
	},
	
	"language": {
		
		"sProcessing": "Procesando...",
		
		"sLengthMenu": "Mostrar _MENU_ registros",
		
		"sZeroRecords": "No se encontraron resultados",
		
		"sEmptyTable": "Ningún dato disponible en esta tabla",
		
		"sInfo": "Mostrando participantes del _START_ al _END_ de un total de _TOTAL_ registros",
		
		"sInfoEmpty": "Mostrando participantes del 0 al 0 de un total de 0 registros",
		
		"sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
		
		"sInfoPostFix": "",
		
		"sSearch": "Buscar: ",
		
		"sUrl": "",
		
		"sInfoThousands": ",",
		
		"sLoadingRecords": "Cargando...",
		
		"oPaginate": {
			
			"sFirst": "Primero",
			
			"sLast": "Último",
			
			"sNext": "Siguiente",
			
			"sPrevious": "Anterior"
			
		},
		
		"oAria": {
			
			"sSortAscending": ": Activar para ordenar la columna de manera ascendente",
			
			"sSortDescending": ": Activar para ordenar la columna de manera descendente"
			
		}
		
	}
	
});


// Por instancias sin participar
$('#por_instancias_sin_participar').DataTable({
	
	"footerCallback": function (row, data, start, end, display) {
		
		var api = this.api();
	
		// Remove the formatting to get integer data for summation
		
		var intVal = function (i) {
			
			return typeof i === 'string' ?
			
			i.replace(/[\$,]/g, '') * 1 :
			
			typeof i === 'number' ?
			
			i : 0;
			
		};
		
		
		// Total over all pages
		
		total = api
		.column(4)
		.data()
		.reduce(function (a, b) {
			return intVal(a) + intVal(b);	
		}, 0);
		
	
		// Update footer
		
		$(api.column(4).footer()).html(
			
			// 'Total Votos:' + pageTotal + ' (' + total + ' total global)'
			
		//	'Total: ' + total + ''
			
			);
			
		},
		"bStateSave": true,
		
		dom: 'lBfrtip',
		
		buttons: [{
			
			extend: 'excelHtml5',
			
			text: nombreEmpresa + ' - Exportar a Excel',
			
			title: 'Informe por Instancias',
			
			exportOptions: {
				
				modifier: {
					
					search: 'applied',
					
					order: 'applied'
					
				}
				
			}
			
		},
		
		{
			
			extend: 'pdf',
			
			text: 'Exportar a PDF',
			
			title: nombreEmpresa + ' - Informe por Instancia - Sin participar',
			
			message: 'Generado el: ' + fechaGeneracion + ' Generado Por: ' + nombreUsuario,
			
			header: true,
			
			footer: true,
			
			exportOptions: {
				
				modifier: {
					
					page: 'current'
					
				}
				
			}
			
		},
		
		{
			
			extend: 'copy',
			
			text: 'Copiar',
			
			exportOptions: {
				
				modifier: {
					
					search: 'applied',
					
					order: 'applied'
					
				}
				
			}
			
		}
		
	],
	
	lengthMenu: [
		
		[40, 50, 100, 100000],
		
		[40, 50, 100, "Todos"]
		
	],
	
	"scrollX": true,
	
	"bProcessing": true,
	
	"serverSide": true,
	
	"ajax": {
		
		url: baseUrl + "informes/get_por_instancias_sin_participar/" + instanciaId, // json datasource
		
		type: "post", // type of method  ,GET/POST/DELETE
		
		error: function () {
			
			$("#processing").css("display", "none");
			
		}
		
	},

	"initComplete": function (settings, json) {
	
		$('#total_poblacion').html(json.poblacion);
		
		$('#porcentaje_total_poblacion').html(json.porcentaje_total_poblacion);
		
		$('#sin_participar').html(json.sin_participar);
		
		$('#porcentaje_sin_participar').html(json.porcentaje_sin_participar);
		
	},
	
	"language": {
		
		"sProcessing": "Procesando...",
		
		"sLengthMenu": "Mostrar _MENU_ registros",
		
		"sZeroRecords": "No se encontraron resultados",
		
		"sEmptyTable": "Ningún dato disponible en esta tabla",
		
		"sInfo": "Mostrando participantes del _START_ al _END_ de un total de _TOTAL_ registros",
		
		"sInfoEmpty": "Mostrando participantes del 0 al 0 de un total de 0 registros",
		
		"sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
		
		"sInfoPostFix": "",
		
		"sSearch": "Buscar: ",
		
		"sUrl": "",
		
		"sInfoThousands": ",",
		
		"sLoadingRecords": "Cargando...",
		
		"oPaginate": {
			
			"sFirst": "Primero",
			
			"sLast": "Último",
			
			"sNext": "Siguiente",
			
			"sPrevious": "Anterior"
			
		},
		
		"oAria": {
			
			"sSortAscending": ": Activar para ordenar la columna de manera ascendente",
			
			"sSortDescending": ": Activar para ordenar la columna de manera descendente"
			
		}
		
	}
	
});



//------------------------------------------------------------------------------   

//------------------------------------------------------------------------------   

/**

* Resumen por agencia. 

*/
var agenciaId = $('#agencia_id').val();
$('#por_agencia').DataTable({
	
	"footerCallback": function (row, data, start, end, display) {
		
		var api = this.api(),
		
		data;
		
		
		
		// Remove the formatting to get integer data for summation
		
		var intVal = function (i) {
			
			return typeof i === 'string' ?
			
			i.replace(/[\$,]/g, '') * 1 :
			
			typeof i === 'number' ?
			
			i : 0;
			
		};
		
		
		
		// Total over all pages
		
		total = api
		
		.column(2)
		
		.data()
		
		.reduce(function (a, b) {
			
			return intVal(a) + intVal(b);
			
		}, 0);
		
		console.log(total);
		
		
		
		// Total over this page
		
		pageTotal = api
		
		.column(2, { page: 'current' })
		
		.data()
		
		.reduce(function (a, b) {
			
			return intVal(a) + intVal(b);
			
		}, 0);
		
		
		
		// Update footer
		
		$(api.column(2).footer()).html(
			
			// 'Total Votos:' + pageTotal + ' (' + total + ' total global)'
			
			'Total: ' + total + ''
			
			);
			
		},
		
		"bStateSave": true,
		
		dom: 'lBfrtip',
		
		buttons: [{
			
			extend: 'excelHtml5',
			
			text: 'Exportar a Excel',
			
			message: 'Generado el: ' + fechaGeneracion + ' Generado Por: ' + nombreUsuario,
			
			exportOptions: {
				
				modifier: {
					
					search: 'applied',
					
					order: 'applied'
					
				}
				
			}
			
		},
		{
			
			extend: 'pdf',
			
			text: 'Exportar a PDF',
			
			title: nombreEmpresa + ' -  Informe por Agencia',
			
			customize: function (win) {
				
				win.defaultStyle.fontSize = '9';
				
			},
			
			message: 'Generado el: ' + fechaGeneracion + ' Generado Por: ' + nombreUsuario,
			
			header: true,
			
			footer: true,
			
			exportOptions: {
				
				modifier: {
					
					page: 'current'
					
				}
				
			}
			
		},
		
		{
			
			extend: 'copy',
			
			text: 'Copiar',
			
			exportOptions: {
				
				modifier: {
					
					search: 'applied',
					
					order: 'applied'
					
				}
				
			}
			
		}
		
	],
	
	lengthMenu: [
		
		[40, 50, 100, 100000],
		
		[40, 50, 100, "Todos"]
		
	],
	
	"scrollX": true,
	
	"bProcessing": true,
	
	"serverSide": true,
	
	"ajax": {
		
		url: baseUrl + "informes/get_por_agencia/"+agenciaId, // json datasource
		
		type: "post", // type of method  ,GET/POST/DELETE
		
		error: function () {
			
			$("#processing").css("display", "none");
			
		}
		
	},
	
	"language": {
		
		"sProcessing": "Procesando...",
		
		"sLengthMenu": "Mostrar _MENU_ registros",
		
		"sZeroRecords": "No se encontraron resultados",
		
		"sEmptyTable": "Ningún dato disponible en esta tabla",
		
		"sInfo": "Mostrando participantes del _START_ al _END_ de un total de _TOTAL_ registros",
		
		"sInfoEmpty": "Mostrando participantes del 0 al 0 de un total de 0 registros",
		
		"sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
		
		"sInfoPostFix": "",
		
		"sSearch": "Buscar: ",
		
		"sUrl": "",
		
		"sInfoThousands": ",",
		
		"sLoadingRecords": "Cargando...",
		
		"oPaginate": {
			
			"sFirst": "Primero",
			
			"sLast": "Último",
			
			"sNext": "Siguiente",
			
			"sPrevious": "Anterior"
			
		},
		
		"oAria": {
			
			"sSortAscending": ": Activar para ordenar la columna de manera ascendente",
			
			"sSortDescending": ": Activar para ordenar la columna de manera descendente"
			
		}
		
	}
	
});





/**

* Resumen por agencia. 

*/

$('#resumen_por_agencia').DataTable({
	
	"footerCallback": function (row, data, start, end, display) {
		
		var api = this.api(),
		
		data;
		
		
		
		// Remove the formatting to get integer data for summation
		
		var intVal = function (i) {
			
			return typeof i === 'string' ?
			
			i.replace(/[\$,]/g, '') * 1 :
			
			typeof i === 'number' ?
			
			i : 0;
			
		};
		
		
		
		// Total over all pages
		
		total = api
		
		.column(3)
		
		.data()
		
		.reduce(function (a, b) {
			
			return intVal(a) + intVal(b);
			
		}, 0);
		
		
		
		// Total over this page
		
		pageTotal = api
		
		.column(3, { page: 'current' })
		
		.data()
		
		.reduce(function (a, b) {
			
			return intVal(a) + intVal(b);
			
		}, 0);
		
		
		
		// Update footer
		
		$(api.column(3).footer()).html(
			
			// 'Total Votos:' + pageTotal + ' (' + total + ' total global)'
			
			'Total: ' + total + ''
			
			);
			
		},
		
		"bStateSave": true,
		
		dom: 'lBfrtip',
		
		buttons: [{
			
			extend: 'excelHtml5',
			
			text: 'Exportar a Excel',
			
			message: 'Generado el: ' + fechaGeneracion + ' Generado Por: ' + nombreUsuario,
			
			exportOptions: {
				
				modifier: {
					
					search: 'applied',
					
					order: 'applied'
					
				}
				
			}
			
		},
		
		{
			
			extend: 'pdf',
			
			text: 'Exportar a PDF',
			
			message: 'Generado el: ' + fechaGeneracion + ' Generado Por: ' + nombreUsuario,
			
			message: 'Generado el: ' + fechaGeneracion,
			
			header: true,
			
			footer: true,
			
			exportOptions: {
				
				modifier: {
					
					page: 'current'
					
				}
				
			}
			
		},
		
		{
			
			extend: 'copy',
			
			text: 'Copiar',
			
			exportOptions: {
				
				modifier: {
					
					search: 'applied',
					
					order: 'applied'
					
				}
				
			}
			
		}
		
	],
	
	lengthMenu: [
		
		[40, 50, 100, 100000],
		
		[40, 50, 100, "Todos"]
		
	],
	
	"scrollX": true,
	
	"bProcessing": true,
	
	"serverSide": true,
	
	"ajax": {
		
		url: baseUrl + "informes/get_resumen_por_agencia", // json datasource
		
		type: "post", // type of method  ,GET/POST/DELETE
		
		error: function () {
			
			$("#processing").css("display", "none");
			
		}
		
	},
	
	"language": {
		
		"sProcessing": "Procesando...",
		
		"sLengthMenu": "Mostrar _MENU_ registros",
		
		"sZeroRecords": "No se encontraron resultados",
		
		"sEmptyTable": "Ningún dato disponible en esta tabla",
		
		"sInfo": "Mostrando participantes del _START_ al _END_ de un total de _TOTAL_ registros",
		
		"sInfoEmpty": "Mostrando participantes del 0 al 0 de un total de 0 registros",
		
		"sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
		
		"sInfoPostFix": "",
		
		"sSearch": "Buscar: ",
		
		"sUrl": "",
		
		"sInfoThousands": ",",
		
		"sLoadingRecords": "Cargando...",
		
		"oPaginate": {
			
			"sFirst": "Primero",
			
			"sLast": "Último",
			
			"sNext": "Siguiente",
			
			"sPrevious": "Anterior"
			
		},
		
		"oAria": {
			
			"sSortAscending": ": Activar para ordenar la columna de manera ascendente",
			
			"sSortDescending": ": Activar para ordenar la columna de manera descendente"
			
		}
		
	}
	
});



});





//--------------------------------------------------------------------------

//-------------------------------------------------------------------------- 

/**

* Resumen IP Por agencia. 

*/

var agenciaId = $('#agencia_id').val();

$('#resumen_ip_por_agencia').DataTable({
	"columns": [
		null,
		null,
		null,
		{ "width": "10%" }
	],
	
	"footerCallback": function (row, data, start, end, display) {
		
		var api = this.api(),
		
		data;
		
		
		
		// Remove the formatting to get integer data for summation
		
		var intVal = function (i) {
			
			return typeof i === 'string' ?
			
			i.replace(/[\$,]/g, '') * 1 :
			
			typeof i === 'number' ?
			
			i : 0;
			
		};
		
		
		
		// Total over all pages
		
		total = api
		
		.column(1)
		
		.data()
		
		.reduce(function (a, b) {
			
			return intVal(a) + intVal(b);
			
		}, 0);
		
		
		
		// Total over this page
		
		pageTotal = api
		
		.column(1, { page: 'current' })
		
		.data()
		
		.reduce(function (a, b) {
			
			return intVal(a) + intVal(b);
			
		}, 0);
		
		
		
		// Update footer
		
		$(api.column(1).footer()).html(
			
			// 'Total Votos:' + pageTotal + ' (' + total + ' total global)'
			
			'T. Votos: ' + total + ''
			
			);
			
		},
		
		"bStateSave": true,
		
		dom: 'lBfrtip',
		
		buttons: [{
			
			extend: 'excelHtml5',
			
			text: 'Exportar a Excel',
			
			//   title: nombreEmpresa + ' - Informe por Agencia',
			
			exportOptions: {
				
				modifier: {
					
					search: 'applied',
					
					order: 'applied'
					
				}
				
			}
			
		},
		
		{
			
			extend: 'pdfHtml5',
			
			// text: nombreEmpresa + ' - Exportar a PDF',
			
			title: 'Informe por Agencia',
			
			//message: 'Generado el: ' + fechaGeneracion + ' Generado Por: ' + nombreUsuario,
			
			header: true,
			
			footer: true,
			
			exportOptions: {
				
				modifier: {
					
					//   page: 'current'
					orthogonal: 'export' 
					
				}
				
			}
			
		},
		
		{
			
			extend: 'copy',
			
			text: 'Copiar',
			
			exportOptions: {
				
				modifier: {
					
					search: 'applied',
					
					order: 'applied'
					
				}
				
			}
			
		}
		
	],
	
	lengthMenu: [
		
		[40, 50, 100, 100000],
		
		[40, 50, 100, "Todos"]
		
	],
	
	"scrollX": true,
	
	"bProcessing": true,
	
	"serverSide": true,
	
	"ajax": {
		
		url: baseUrl + "index.php/informes/get_ip_por_agencia/" + agenciaId, // json datasource
		
		type: "post", // type of method  ,GET/POST/DELETE
		
		error: function () {
			
			$("#processing").css("display", "none");
			
		}
		
	},
	
	"language": {
		
		"sProcessing": "Procesando...",
		
		"sLengthMenu": "Mostrar _MENU_ registros",
		
		"sZeroRecords": "No se encontraron resultados",
		
		"sEmptyTable": "Ningún dato disponible en esta tabla",
		
		"sInfo": "Mostrando participantes del _START_ al _END_ de un total de _TOTAL_ registros",
		
		"sInfoEmpty": "Mostrando participantes del 0 al 0 de un total de 0 registros",
		
		"sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
		
		"sInfoPostFix": "",
		
		"sSearch": "Buscar: ",
		
		"sUrl": "",
		
		"sInfoThousands": ",",
		
		"sLoadingRecords": "Cargando...",
		
		"oPaginate": {
			
			"sFirst": "Primero",
			
			"sLast": "Último",
			
			"sNext": "Siguiente",
			
			"sPrevious": "Anterior"
			
		},
		
		"oAria": {
			
			"sSortAscending": ": Activar para ordenar la columna de manera ascendente",
			
			"sSortDescending": ": Activar para ordenar la columna de manera descendente"
			
		}
		
	}
	
});







//--------------------------------------------------------------------------

//-------------------------------------------------------------------------- 

/**

* Resumen IP Por agencia. 

*/

var agenciaId = $('#agencia_id').val();

$('#resumen_votacion_usuario_registro').DataTable({
	
	"footerCallback": function (row, data, start, end, display) {
		
		var api = this.api(),
		
		data;
		
		
		
		// Remove the formatting to get integer data for summation
		
		var intVal = function (i) {
			
			return typeof i === 'string' ?
			
			i.replace(/[\$,]/g, '') * 1 :
			
			typeof i === 'number' ?
			
			i : 0;
			
		};
		
		
		
		// Total over all pages
		
		total = api
		
		.column(1)
		
		.data()
		
		.reduce(function (a, b) {
			
			return intVal(a) + intVal(b);
			
		}, 0);
		
		
		
		// Total over this page
		
		pageTotal = api
		
		.column(1, { page: 'current' })
		
		.data()
		
		.reduce(function (a, b) {
			
			return intVal(a) + intVal(b);
			
		}, 0);
		
		
		
		// Update footer
		
		$(api.column(1).footer()).html(
			
			// 'Total Votos:' + pageTotal + ' (' + total + ' total global)'
			
			'T. Votos: ' + total + ''
			
			);
			
		},
		
		"bStateSave": true,
		
		dom: 'lBfrtip',
		
		buttons: [{
			
			extend: 'excelHtml5',
			
			text: 'Exportar a Excel',
			
			//   title: nombreEmpresa + ' - Informe por Agencia',
			
			exportOptions: {
				
				modifier: {
					
					search: 'applied',
					
					order: 'applied'
					
				}
				
			}
			
		},
		
		
		
		{
			
			extend: 'copy',
			
			text: 'Copiar',
			
			exportOptions: {
				
				modifier: {
					
					search: 'applied',
					
					order: 'applied'
					
				}
				
			}
			
		}
		
	],
	
	lengthMenu: [
		
		[40, 50, 100, 100000],
		
		[40, 50, 100, "Todos"]
		
	],
	
	"scrollX": true,
	
	"bProcessing": true,
	
	"serverSide": true,
	
	"ajax": {
		
		url: baseUrl + "index.php/informes/get_resumen_votacion_usuario_registro/" + agenciaId, // json datasource
		
		type: "post", // type of method  ,GET/POST/DELETE
		
		error: function () {
			
			$("#processing").css("display", "none");
			
		}
		
	},
	
	"language": {
		
		"sProcessing": "Procesando...",
		
		"sLengthMenu": "Mostrar _MENU_ registros",
		
		"sZeroRecords": "No se encontraron resultados",
		
		"sEmptyTable": "Ningún dato disponible en esta tabla",
		
		"sInfo": "Mostrando participantes del _START_ al _END_ de un total de _TOTAL_ registros",
		
		"sInfoEmpty": "Mostrando participantes del 0 al 0 de un total de 0 registros",
		
		"sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
		
		"sInfoPostFix": "",
		
		"sSearch": "Buscar: ",
		
		"sUrl": "",
		
		"sInfoThousands": ",",
		
		"sLoadingRecords": "Cargando...",
		
		"oPaginate": {
			
			"sFirst": "Primero",
			
			"sLast": "Último",
			
			"sNext": "Siguiente",
			
			"sPrevious": "Anterior"
			
		},
		
		"oAria": {
			
			"sSortAscending": ": Activar para ordenar la columna de manera ascendente",
			
			"sSortDescending": ": Activar para ordenar la columna de manera descendente"
			
		}
		
	}
	
});