function validaMultiseleccion(id, val) {
    $('.grupo-seleccion').hide();
    $('.grupo-check-seleccion').hide();
    $('#NUM_MUSEIN').prop('disabled', true);
    $('#NUM_MUSEIN').prop('required', false);
    $('.bol-oblmul').prop('disabled', true);

    if (val === 'LVP') {
        $('.grupo-seleccion').show();
        $('.grupo-check-seleccion').show();
        $('#NUM_MUSEIN').prop('disabled', false);
        $('#NUM_MUSEIN').prop('required', true);
        $('.bol-oblmul').prop('disabled', false);
    }
}

//Noty Master function
function generateNoty(layout, text, type) {
    var n = noty({
        text: text,
        type: type,
        dismissQueue: true,
        layout: layout,
        theme: 'relax',
        timeout: 4000
    });
}

$(function () {
    $('#crear-form').parsley();

    $('.check-candidato').on('click', function () {
        var checked = $(this).is(':checked');
        if (checked) {
            $('.candidatos-contenedor').css('background-color', '');
            $(this).parent().parent().css('background-color', 'rgb(252, 135, 58)');
        } else {
            $('.candidatos-contenedor').css('background', '');
            $(this).parent().parent().css('background-color', '#ffffff');
        }
    });
    $('.check-asign').on('click', function () {
        var checked = $(this).is(':checked');
        if (checked) {
            $(this).prev().prop('disabled', true);
        } else {
            $(this).prev().prop('disabled', false);
        }
    });

    $('.disabled-select > option').prop('disabled', 'disabled');
    $('.disabled-select').on('click', function () {
        generateNoty('bottomLeft', 'No es posible editar el tipo de lista', 'error');
    });


    //Listado de Candidatos.
    $('#listing').DataTable({
        "bStateSave": true,
        dom: 'lBfrtip',
        scrollX: true,
        buttons: [
            {
                extend: 'excelHtml5',
                text: 'Exportar a Excel',
                title: 'Listas',
                exportOptions: {
                    modifier: {
                        search: 'applied',
                        order: 'applied'
                    }
                },
            },
            {
                extend: 'pdf',
                text: 'Exportar a PDF',
                title: ' Listas',
                header: true,
                footer: true,
                exportOptions: {
                    modifier: {
                        page: 'current'
                    }
                }
            },
            {
                extend: 'copy',
                text: 'Copiar',
                exportOptions: {
                    modifier: {
                        search: 'applied',
                        order: 'applied'
                    }
                }
            }
        ],
        lengthMenu: [[20, 50, 100, 100000], [20, 50, 100, "Todos"]],
        "scrollX": true,
        "bProcessing": true,
        "serverSide": true,
        "ajax": {
            url: baseUrl + "listas/get_all", // json datasource
            type: "post", // type of method  ,GET/POST/DELETE
            error: function () {
                $("#processing").css("display", "none");
            }
        },
        "language": {
            "sProcessing": "Procesando...",
            "sLengthMenu": "Mostrar _MENU_ registros",
            "sZeroRecords": "No se encontraron resultados",
            "sEmptyTable": "Ningún dato disponible en esta tabla",
            "sInfo": "Mostrando registros  del _START_ al _END_ de un total de _TOTAL_ registros",
            "sInfoEmpty": "Mostrando registros  del 0 al 0 de un total de 0 registros",
            "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
            "sInfoPostFix": "",
            "sSearch": "Buscar Usuario:",
            "sUrl": "",
            "sInfoThousands": ",",
            "sLoadingRecords": "Cargando...",
            "oPaginate": {
                "sFirst": "Primero",
                "sLast": "Último",
                "sNext": "Siguiente",
                "sPrevious": "Anterior"
            },
            "oAria": {
                "sSortAscending": ": Activar para ordenar la columna de manera ascendente",
                "sSortDescending": ": Activar para ordenar la columna de manera descendente"
            }
        }
    });



});
