$(document).ready(function () {
    $("#crear-pais-form").validate({
        rules: {
            COD_PAIS: {
                required: true,
                number: true,
                maxlength: 3
            },
            TEX_NOMPAIS: {
                required: true,
            }
        },
        messages: {
            COD_PAIS: "El código del país es requerido, debe contener solo números y max. 3 digitos",
            TEX_NOMPAIS: "El nombre del país es requerido",
        }
    });
//Listado de Países.
    $('#listing').DataTable({
        "bStateSave": true,
        dom: 'lBfrtip',
        buttons: [
            {
                extend: 'excelHtml5',
                text: 'Exportar a Excel',
                title: ' - Lista Asociados',
                exportOptions: {
                    modifier: {
                        search: 'applied',
                        order: 'applied'
                    }
                },
            },
            {
                extend: 'pdf',
                text: 'Exportar a PDF',
                title: ' - Lista Asociados',
                header: true,
                footer: true,
                exportOptions: {
                    modifier: {
                        page: 'current'
                    }
                }
            },
            {
                extend: 'copy',
                text: 'Copiar',
                exportOptions: {
                    modifier: {
                        search: 'applied',
                        order: 'applied'
                    }
                }
            }
        ],
        lengthMenu: [[20, 50, 100, 100000], [20, 50, 100, "Todos"]],
        "scrollX": true,
        "bProcessing": true,
        "serverSide": true,
        "ajax": {
            url: baseUrl + "paises/get_all", // json datasource
            type: "post", // type of method  ,GET/POST/DELETE
            error: function () {
                $("#processing").css("display", "none");
            }
        },
        "language": {
            "sProcessing": "Procesando...",
            "sLengthMenu": "Mostrar _MENU_ registros",
            "sZeroRecords": "No se encontraron resultados",
            "sEmptyTable": "Ningún dato disponible en esta tabla",
            "sInfo": "Mostrando paises del _START_ al _END_ de un total de _TOTAL_ registros",
            "sInfoEmpty": "Mostrando paises del 0 al 0 de un total de 0 registros",
            "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
            "sInfoPostFix": "",
            "sSearch": "Buscar país:",
            "sUrl": "",
            "sInfoThousands": ",",
            "sLoadingRecords": "Cargando...",
            "oPaginate": {
                "sFirst": "Primero",
                "sLast": "Último",
                "sNext": "Siguiente",
                "sPrevious": "Anterior"
            },
            "oAria": {
                "sSortAscending": ": Activar para ordenar la columna de manera ascendente",
                "sSortDescending": ": Activar para ordenar la columna de manera descendente"
            }
        }
    });
 

});