$(document).ready(function () {
	$("#crear-permiso-form").validate({
		rules: {
			TEX_NOMPERMI: {
				required: true,
			}
		},
		messages: {
			TEX_NOMPERMI: "El nombre del permiso es requerido",
		}
	});
//Listado de Países.
$('#listing').DataTable({
	"bStateSave": true,
	dom: 'lBfrtip',
	"columns": [
	null,
	null,
	null,
	null,
	null,
	null,
	{ "width": "20%" }],
	buttons: [
	{
		extend: 'excelHtml5',
		text: 'Exportar a Excel',
		title: 'Lista de Permisos',
		exportOptions: {
			modifier: {
				search: 'applied',
				order: 'applied'
			}
		},
	},
	{
		extend: 'pdf',
		text: 'Exportar a PDF',
		title: 'Lista de Permisos',
		header: true,
		footer: true,
		exportOptions: {
			modifier: {
				page: 'current'
			}
		}
	},
	{
		extend: 'copy',
		text: 'Copiar',
		exportOptions: {
			modifier: {
				search: 'applied',
				order: 'applied'
			}
		}
	}
	],
	lengthMenu: [[20, 50, 100, 100000], [20, 50, 100, "Todos"]],
	"scrollX": true,
	"bProcessing": true,
	"serverSide": true,
	"ajax": {
            url: baseUrl + "permisos/get_all", // json datasource
            type: "post", // type of method  ,GET/POST/DELETE
            error: function () {
            	$("#processing").css("display", "none");
            }
         },
         "language": {
         	"sProcessing": "Procesando...",
         	"sLengthMenu": "Mostrar _MENU_ registros",
         	"sZeroRecords": "No se encontraron resultados",
         	"sEmptyTable": "Ningún dato disponible en esta tabla",
         	"sInfo": "Mostrando permisos del _START_ al _END_ de un total de _TOTAL_ registros",
         	"sInfoEmpty": "Mostrando permisos del 0 al 0 de un total de 0 registros",
         	"sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
         	"sInfoPostFix": "",
         	"sSearch": "Buscar permiso:",
         	"sUrl": "",
         	"sInfoThousands": ",",
         	"sLoadingRecords": "Cargando...",
         	"oPaginate": {
         		"sFirst": "Primero",
         		"sLast": "Último",
         		"sNext": "Siguiente",
         		"sPrevious": "Anterior"
         	},
         	"oAria": {
         		"sSortAscending": ": Activar para ordenar la columna de manera ascendente",
         		"sSortDescending": ": Activar para ordenar la columna de manera descendente"
         	}
         }
      });

$('#COD_MODULO').on('change', function(){
	var text = $('#COD_MODULO option:selected').text();
	$('#TEX_MODULO').val($.trim(text));
	var nombre = $('#TEX_NOMPERMI').val($.trim(text));
	$('#TIPO_ACCION').on('keyup', function(){
		var accion = $(this).val();
		$('#TEX_NOMPERMI').val($.trim(text)+'_'+accion);
	});
});

});