$(function() {
    //Consulta posicion 
    function posicion() {
        var posicion;
        $.ajax({
            type: "POST",
            async: false,
            url: baseUrl + "sorteo/consulta_posicion",
            dataType: "json",
            success: function(response) {
                if (response.posicion) {
                    posicion = response.posicion;
                } else {
                    posicion = false;
                }
            }
        });

        return posicion;
    }
    //Parametros.
    var p = {
        speed: 500,
        duration: 0,
        stopImageNumber: posicion(),
        startCallback: function() {
            $('.start').attr('disabled', 'true');
            $('.stop').removeAttr('disabled');
            //Overrride de la posicion.
            this.stopImageNumber = posicion();
        },
        slowDownCallback: function() {
            console.log('slow');
        },
        stopCallback: function($stopElm) {
            //Posicion del ganador.
            var idGanador = $stopElm[0].id;
            //Consulta del ganador
            $.ajax({
                type: "POST",
                url: baseUrl + "sorteo/consulta_ganador",
                data: { id: idGanador, posicion: this.stopImageNumber },
                dataType: "html",
                success: function(response) {
                    $('.ganador').html(response);
                    //Audio ganador.
                    var soundID = "win";
                    createjs.Sound.registerSound("./audios/win.mp3", soundID);
                    createjs.Sound.play(soundID);
                }
            });
            $('.start').removeAttr('disabled');
        }

    }
    var rouletter = $('div.roulette');
    rouletter.roulette(p);
    $('.start').click(function() {
        if (!Number.isInteger(p.stopImageNumber)) {
            alert('No es posible realizar el sorteo');
            return false;
        }
        $('.ganador').html('');
        //Inicio del juego.
        //Audio.
        // var playing = "playing";
        //createjs.Sound.registerSound("./audios/playing.mp3", playing);
        //createjs.Sound.play(playing);
        rouletter.roulette('start');
    });
});