<?php

/**
 * The goal of this file is to allow developers a location
 * where they can overwrite core procedural functions and
 * replace them with their own. This file is loaded during
 * the bootstrap process and is called during the framework's
 * execution.
 *
 * This can be looked at as a `master helper` file that is
 * loaded early on, and may also contain additional functions
 * that you'd like to use throughout your entire application
 *
 * @see: https://codeigniter.com/userguide4/extending/common.html
 */

if (!function_exists('timeago')) {
    /**
     * Convierte una fecha en formato "hace X tiempo"
     */
    function timeago($datetime, $full = false) {
        $now = new DateTime;
        $ago = new DateTime($datetime);
        $diff = $now->diff($ago);

        // Calcular semanas manualmente
        $weeks = floor($diff->d / 7);
        $diff->d -= $weeks * 7;

        $string = array(
            'y' => 'año',
            'm' => 'mes',
            'w' => 'semana',
            'd' => 'día',
            'h' => 'hora',
            'i' => 'minuto',
            's' => 'segundo',
        );

        $result = [];
        foreach ($string as $k => $v) {
            if ($k == 'w' && $weeks) {
                $result[] = $weeks . ' ' . $v . ($weeks > 1 ? 's' : '');
            } elseif (isset($diff->$k) && $diff->$k) {
                $result[] = $diff->$k . ' ' . $v . ($diff->$k > 1 ? 's' : '');
            }
        }

        if (!$full) {
            $result = array_slice($result, 0, 1);
        }

        return $result ? 'Hace ' . implode(', ', $result) : 'Ahora mismo';
    }
}


if (!function_exists('format_phone')) {
    /**
     * Formatea un número de teléfono
     */
    function format_phone($phone) {
        $phone = preg_replace('/[^0-9]/', '', $phone);
        
        if (strlen($phone) == 10) {
            return '(' . substr($phone, 0, 3) . ') ' . substr($phone, 3, 3) . '-' . substr($phone, 6);
        }
        
        return $phone;
    }
}

if (!function_exists('generate_ticket_number')) {
    /**
     * Genera un número de ticket único
     */
    function generate_ticket_number() {
        return 'TK-' . date('Ymd') . '-' . str_pad(mt_rand(1, 9999), 4, '0', STR_PAD_LEFT);
    }
}

if (!function_exists('get_platform_icon')) {
    /**
     * Obtiene el ícono de la plataforma
     */
    function get_platform_icon($platform) {
        $icons = [
            'whatsapp' => 'fab fa-whatsapp',
            'telegram' => 'fab fa-telegram',
            'instagram' => 'fab fa-instagram'
        ];
        
        return $icons[$platform] ?? 'fas fa-comment';
    }
}

if (!function_exists('get_status_badge')) {
    /**
     * Obtiene el badge HTML para un estado
     */
    function get_status_badge($status) {
        $badges = [
            'active' => '<span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-green-100 text-green-800">Activo</span>',
            'inactive' => '<span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-gray-100 text-gray-800">Inactivo</span>',
            'open' => '<span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-yellow-100 text-yellow-800">Abierto</span>',
            'closed' => '<span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-red-100 text-red-800">Cerrado</span>',
            'assigned' => '<span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-blue-100 text-blue-800">Asignado</span>',
            'in_progress' => '<span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-purple-100 text-purple-800">En Proceso</span>',
        ];
        
        return $badges[$status] ?? '<span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-gray-100 text-gray-800">' . ucfirst($status) . '</span>';
    }
}