<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */

// Rutas de autenticación
$routes->get('login', 'AuthController::login');
$routes->get('auth/login', 'AuthController::login');
$routes->post('auth/login', 'AuthController::authenticate');
$routes->post('auth/verify2FA', 'AuthController::verify2FA');
$routes->post('logout', 'AuthController::logout');

// Ruta por defecto
$routes->get('/', 'AuthController::login');

// Dashboard general (requiere usuario logueado)
$routes->get('admin/dashboard', 'Admin\Dashboard::index', ['filter' => 'auth']);

// API para estadísticas y notificaciones en tiempo real
$routes->get('admin/dashboard/stats-api', 'Admin\Dashboard::getStatsApi', ['filter' => 'auth']);
$routes->get('admin/dashboard/notifications-api', 'Admin\Dashboard::getNotificationsApi', ['filter' => 'auth']);

// Rutas de conversaciones (accesibles para admin y advisor)
$routes->get('conversations', 'ConversationController::index', ['filter' => 'auth']);
$routes->get('conversations/get/(:any)', 'ConversationController::getConversation/$1', ['filter' => 'auth']);
$routes->get('conversations/refresh-list', 'ConversationController::refreshConversationList', ['filter' => 'auth']);
$routes->get('conversations/getConversationStatus/(:any)', 'ConversationController::getConversationStatus/$1', ['filter' => 'auth']);

$routes->post('conversations/webhook', 'ConversationController::webhook'); // Sin filtro para webhooks externos
$routes->get('conversations/webhook', 'ConversationController::webhook'); // Para verificación GET
$routes->post('conversations/send', 'ConversationController::send', ['filter' => 'auth']);
$routes->post('conversations/takeControl', 'ConversationController::takeControl', ['filter' => 'auth']);
$routes->post('conversations/transfer', 'ConversationController::transfer', ['filter' => 'auth']);
$routes->post('conversations/send-history', 'ConversationController::sendHistory', ['filter' => 'auth']);
$routes->get('admin/get-advisors', 'ConversationController::getAdvisors', ['filter' => 'auth']);
$routes->post('conversations/assign', 'ConversationController::assign', ['filter' => 'auth']);
$routes->get('conversations/(:segment)', 'ConversationController::index/$1', ['filter' => 'auth']);


// Rutas del ChatBot (integrado con flujos)
$routes->get('chatbot', 'ChatBotController::chatWindow');
$routes->post('chatbot/send', 'ChatBotController::sendMessageToChat');
$routes->options('chatbot/send', 'ChatBotController::sendMessageToChat');
$routes->post('chatbot/receive', 'ChatBotController::receiveMessage');

// Configuración de Webhook
$routes->get('admin/webhook-setup', 'WebhookSetupController::index', ['filter' => 'auth']);
$routes->post('admin/webhook-setup/setup', 'WebhookSetupController::setupWebhook', ['filter' => 'auth']);
$routes->get('admin/webhook-setup/test', 'WebhookSetupController::testWebhook', ['filter' => 'auth']);

// NUEVAS RUTAS PARA PERFIL DE ASESOR
$routes->group('advisor', ['filter' => 'auth'], function ($routes) {
    $routes->get('profile', 'AdvisorController::profile');
    $routes->post('profile/update', 'AdvisorController::updateProfile');
    $routes->post('profile/change-password', 'AdvisorController::changePassword');
    $routes->post('profile/toggle-2fa', 'AdvisorController::toggle2FA');
    $routes->get('profile/setup-2fa', 'AdvisorController::setup2FA');
    $routes->post('profile/verify-2fa-setup', 'AdvisorController::verify2FASetup');
    $routes->post('profile/disable-2fa', 'AdvisorController::disable2FA');
});

// Grupo de rutas restringidas solo a administradores
$routes->group('admin', ['namespace' => 'App\Controllers\Admin', 'filter' => 'admin'], function ($routes) { 
    // Gestión de usuarios
    $routes->get('users', 'UserController::index');
    $routes->get('users/create', 'UserController::create');
    $routes->post('users/store', 'UserController::store');
    $routes->get('users/edit/(:num)', 'UserController::edit/$1');
    $routes->post('users/update/(:num)', 'UserController::update/$1');
    $routes->get('users/delete/(:num)', 'UserController::delete/$1');

    // Gestión administrativa
    $routes->get('management', 'AdminController::management');
    $routes->post('management/whatsapp', 'AdminController::saveWhatsAppConfig');
    $routes->post('management/telegram', 'AdminController::saveTelegramConfig');
    $routes->post('management/instagram', 'AdminController::saveInstagramConfig');
    $routes->post('management/test-connection', 'AdminController::testConnection');
    $routes->post('management/toggle-platform', 'AdminController::togglePlatform');
    
    // NUEVA RUTA: Asignación de asesores a submenús
    $routes->post('management/assign-advisors', 'AdminController::assignAdvisors');
    $routes->get('management/advisor-assignments', 'AdminController::getAdvisorAssignments');

    // Flujos de atención
    $routes->group('flows', function ($routes) {
        $routes->get('/', 'FlowController::index');
        $routes->get('create', 'FlowController::create');
        $routes->post('store', 'FlowController::store');
        $routes->get('edit/(:num)', 'FlowController::edit/$1');
        $routes->post('update/(:num)', 'FlowController::update/$1');
        $routes->get('delete/(:num)', 'FlowController::delete/$1');
        $routes->get('duplicate/(:num)', 'FlowController::duplicate/$1');
        $routes->post('toggle-status', 'FlowController::toggleStatus');
        $routes->get('api/by-type/(:segment)', 'FlowController::getFlowsByType/$1');
        $routes->get('api/stats', 'FlowController::getStatsApi');
    });
});

// Tickets (accesibles para admin y advisor con restricciones)
$routes->group('admin/tickets', ['namespace' => 'App\Controllers\Admin', 'filter' => 'auth'], function ($routes) {
    $routes->get('/', 'TicketController::index');
    $routes->get('create', 'TicketController::create'); // Solo admin
    $routes->post('store', 'TicketController::store'); // Solo admin
    $routes->get('view/(:segment)', 'TicketController::view/$1');
    $routes->post('update/(:segment)', 'TicketController::update/$1');
    $routes->get('delete/(:segment)', 'TicketController::delete/$1'); // Solo admin
    $routes->post('create-from-conversation', 'TicketController::createFromConversation', ['filter' => 'auth']);
    $routes->get('stats-api', 'TicketController::getTicketStats', ['filter' => 'auth']);
});