<?php

namespace App\Controllers\Admin;

use CodeIgniter\Controller;
use App\Models\UserModel;
use App\Models\FlowModel;
use App\Models\AdvisorAssignmentModel;

class AdminController extends Controller
{
    protected $userModel;
    protected $flowModel;
    protected $advisorAssignmentModel;

    public function __construct()
    {
        $this->userModel = new UserModel();
        $this->flowModel = new FlowModel();
        $this->advisorAssignmentModel = new AdvisorAssignmentModel();
        
        // Verificar autenticación y rol de admin
        if (!session()->get('isLoggedIn') || session()->get('role') !== 'admin') {
            return redirect()->to(base_url('login'))->send();
        }
    }

public function testConnection()
{
    $apiUrl = "https://waba-v2.360dialog.io/v1/configs/webhook";
    $apiKey = "gIWJVuWLsASO4o9nfQGV392EAK"; // Tu clave segura

    // Obtener la URL desde el cuerpo JSON
    $request = $this->request->getJSON();
    $webhookUrl = isset($request->url) ? $request->url : null;

    if (!$webhookUrl) {
        return $this->response->setJSON([
            'success' => false,
            'message' => 'URL del webhook no proporcionada'
        ]);
    }

    $client = \Config\Services::curlrequest();

    try {
        $response = $client->post($apiUrl, [
            'headers' => [
                'Content-Type' => 'application/json',
                'D360-API-KEY' => $apiKey
            ],
            'body' => json_encode(['url' => $webhookUrl])
        ]);

        if ($response->getStatusCode() === 200) {
            return $this->response->setJSON(['success' => true]);
        } else {
            return $this->response->setJSON([
                'success' => false,
                'message' => 'Error en la API: ' . $response->getBody()
            ]);
        }
    } catch (\Exception $e) {
        return $this->response->setJSON([
            'success' => false,
            'message' => 'Excepción: ' . $e->getMessage()
        ]);
    }
}



 public function management()
    {
        // Obtener submenús activos
        $submenuFlows = $this->flowModel->where('type', 'submenu')
                                       ->where('is_active', true)
                                       ->orderBy('order_index', 'ASC')
                                       ->findAll();

                                       
        // Obtener asesores activos (excluyendo admins por defecto)
        $advisors = $this->userModel->where('role', 'advisor')
                                   ->orderBy('name', 'ASC')
                                   ->findAll();

        // Obtener asignaciones actuales
        $currentAssignments = $this->advisorAssignmentModel->getAllAssignmentsGrouped();
        

        return view('admin/management', [
            'title' => 'Administración - Chat Solibot',
            'submenuFlows' => $submenuFlows,
            'advisors' => $advisors,
            'currentAssignments' => $currentAssignments
        ]);
    }

    

    /**
     * Asignar asesores a submenús
     */
    public function assignAdvisors()
    {
        if ($this->request->getMethod() !== 'POST') {
            return redirect()->to(base_url('admin/management'))->with('error', 'Método no permitido');
        }

        try {
            $flowId = $this->request->getPost('flow_id');
            $flowKey = $this->request->getPost('flow_key');
            $assignedAdvisors = $this->request->getPost('assigned_advisors') ?? [];
         

            if (!$flowId || !$flowKey) {
                return redirect()->to(base_url('admin/management#general'))
                               ->with('error', 'Datos de flujo inválidoss');
            }

            // Asignar asesores al flujo
            $this->advisorAssignmentModel->assignAdvisorsToFlow($flowId, $flowKey, $assignedAdvisors);

            // Log de la acción
            $logData = [
                'action' => 'advisor_assignment',
                'admin_id' => session()->get('user_id'),
                'admin_name' => session()->get('username'),
                'flow_id' => $flowId,
                'flow_key' => $flowKey,
                'advisors_count' => count($assignedAdvisors),
                'timestamp' => date('Y-m-d H:i:s'),
                'advisors' => $assignedAdvisors
            ];
            
            log_message('info', 'Asignación de asesores: ' . json_encode($logData));

            return redirect()->to(base_url('admin/management#general'))
                           ->with('success', 'Asesores asignados exitosamente al submenú: ' . $flowKey);

        } catch (\Exception $e) {
            log_message('error', 'Error al asignar asesores: ' . $e->getMessage());
            return redirect()->to(base_url('admin/management#general'))
                           ->with('error', 'Error al guardar las asignaciones: ' . $e->getMessage());
        }
    }

    /**
     * Obtener asignaciones actuales de asesores (API)
     */
    public function getAdvisorAssignments()
    {
        try {
            $assignments = $this->advisorAssignmentModel->getAllAssignmentsGrouped();
            return $this->response->setJSON(['success' => true, 'assignments' => $assignments]);
        } catch (\Exception $e) {
            return $this->response->setJSON(['success' => false, 'message' => $e->getMessage()]);
        }
    }

    /**
     * Obtener asesor asignado para un submenú específico
     */
    public function getAssignedAdvisorForSubmenu($submenuKey)
    {
        try {
            $advisor = $this->advisorAssignmentModel->getRandomAdvisorForFlow($submenuKey);
            
            if ($advisor) {
                return [
                    'advisor_id' => $advisor['id'],
                    'advisor_name' => $advisor['first_name'] . ' ' . $advisor['last_name'],
                    'advisor_username' => $advisor['username']
                ];
            }
            
            return null;
        } catch (\Exception $e) {
            log_message('error', 'Error al obtener asesor asignado: ' . $e->getMessage());
            return null;
        }
    }

    /**
     * Guardar configuración de WhatsApp (simulado)
     */
    public function saveWhatsAppConfig()
    {
        $config = [
            'api_url' => $this->request->getPost('api_url'),
            'api_key' => $this->request->getPost('api_key'),
            'phone_number_id' => $this->request->getPost('phone_number_id'),
            'webhook_verify_token' => $this->request->getPost('webhook_verify_token'),
            'webhook_url' => base_url('conversations/webhook')
        ];

        // Guardar en archivo JSON
        $configFile = WRITEPATH . 'whatsapp_config.json';
        file_put_contents($configFile, json_encode($config, JSON_PRETTY_PRINT));

        return redirect()->to(base_url('admin/management'))
                       ->with('success', 'Configuración de WhatsApp guardada exitosamente');
    }

    /**
     * Guardar configuración de Telegram (simulado)
     */
    public function saveTelegramConfig()
    {
        $config = [
            'bot_token' => $this->request->getPost('bot_token'),
            'webhook_url' => base_url('webhook/telegram')
        ];

        // Guardar en archivo JSON
        $configFile = WRITEPATH . 'telegram_config.json';
        file_put_contents($configFile, json_encode($config, JSON_PRETTY_PRINT));

        return redirect()->to(base_url('admin/management'))
                       ->with('success', 'Configuración de Telegram guardada exitosamente');
    }

    /**
     * Guardar configuración de Instagram (simulado)
     */
    public function saveInstagramConfig()
    {
        $config = [
            'app_id' => $this->request->getPost('app_id'),
            'app_secret' => $this->request->getPost('app_secret'),
            'access_token' => $this->request->getPost('access_token'),
            'webhook_url' => base_url('webhook/instagram')
        ];

        // Guardar en archivo JSON
        $configFile = WRITEPATH . 'instagram_config.json';
        file_put_contents($configFile, json_encode($config, JSON_PRETTY_PRINT));

        return redirect()->to(base_url('admin/management'))
                       ->with('success', 'Configuración de Instagram guardada exitosamente');
    }

    /**
     * API para probar conexión (simulado)
     */
 

    /**
     * API para activar/desactivar plataforma (simulado)
     */
    public function togglePlatform()
    {
        if (!$this->request->isAJAX()) {
            return $this->response->setJSON(['success' => false, 'message' => 'Solicitud inválida']);
        }

        $platform = $this->request->getPost('platform');
        $isActive = $this->request->getPost('active') ? true : false;

        // Simular toggle de plataforma
        return $this->response->setJSON(['success' => true]);
    }
}