<?php
namespace App\Controllers\Admin;

use App\Models\UserModel;
use CodeIgniter\Controller;

class UserController extends Controller {
    protected $userModel;
    
    public function __construct()
    {
        $this->userModel = new UserModel();
        
        // Verifica si el usuario está logueado
        if (!session()->get('isLoggedIn')) {
            return redirect()->to(base_url('login'))->send(); // Redirige al login si no está logueado
        }
    
        // Depura el rol de usuario
        $userRole = session()->get('role');
        if (!$userRole) {
            die('El rol del usuario no está definido en la sesión.');
        }
    
        // Verifica si el usuario tiene rol de administrador
        if ($userRole !== 'admin') {
            return redirect()->to(base_url('admin/dashboard'))->with('error', 'No tienes permiso para acceder a esta sección.')->send();
        }
    }
    
    public function index()
    {
        // Configuración para la paginación
        $perPage = 10; // Número de registros por página

        // Obtiene la página actual desde el query string o usa 1 como predeterminada
        $currentPage = $this->request->getVar('page') ? (int)$this->request->getVar('page') : 1;

        // Total de registros en la base de datos
        $totalUsers = $this->userModel->countAll();

        // Total de páginas
        $totalPages = ceil($totalUsers / $perPage);

        // Calcular el offset para la consulta
        $offset = ($currentPage - 1) * $perPage;

        // Obtener los registros con límite y offset
        $users = $this->userModel->orderBy('id', 'ASC')->findAll($perPage, $offset);

        // Enviar datos a la vista
        $data = [
            'users' => $users,
            'current_page' => $currentPage,
            'total_pages' => $totalPages,
        ];

        return view('admin/users/index', $data);
    }

    public function create()
    {
        return view('admin/users/create');
    }

    public function store()
    {
       

        $cedula = $this->request->getPost('cedula');
    
        // Verificar si la cédula ya existe en la base de datos
        if ($this->userModel->where('cedula', $cedula)->first()) {
            // Redirigir con mensaje de error
            return redirect()->back()->with('error', 'La cédula ya está registrada.')->withInput();
        }
        $this->userModel->save([
            'username' => $this->request->getPost('username'),
            'password' => password_hash($this->request->getPost('password'), PASSWORD_DEFAULT),
            'role' => $this->request->getPost('role'),
            'cedula' => $this->request->getPost('cedula')
        ]);
        return redirect()->to('/admin/users');
    }

    public function edit($id)
    {
        $data['user'] = $this->userModel->find($id);
        return view('admin/users/edit', $data);
    }

    public function update($id)
{
    // Preparar los datos comunes
    $data = [
        'cedula' => $this->request->getPost('cedula'),
        'username' => $this->request->getPost('username'),
        'role' => $this->request->getPost('role'),
    ];

    // Verificar si se ingresó una nueva contraseña
    $password = $this->request->getPost('password');
    if (!empty($password)) {
        $data['password'] = password_hash($password, PASSWORD_DEFAULT);
    }

    // Actualizar el usuario
    $this->userModel->update($id, $data);

    return redirect()->to('/admin/users');
}

    public function delete($id)
    {
        $this->userModel->delete($id);
        return redirect()->to('/admin/users');
    }
}
