<?php
namespace App\Controllers;

use App\Models\UserModel;
use CodeIgniter\Controller;
use Sonata\GoogleAuthenticator\GoogleAuthenticator;
use Sonata\GoogleAuthenticator\GoogleQrUrl;
class AuthController extends Controller {

    public function enable2FA( $userId,$temp_token)
    {
        // Instanciar GoogleAuthenticator
       
    
        $ga = new GoogleAuthenticator();

        // Generar un secreto único para el usuario
        $secret = $ga->generateSecret();

        // Almacenar el secreto en la base de datos
        $userModel = new UserModel();
        $userModel->update($userId, ['google_auth_secret' => $secret]);

        // Generar la URL QR
     
        $qrCodeUrl = GoogleQrUrl::generate('Solibot', $secret);

        // Mostrar el código QR al usuario
        
      //  echo "Escanea este código QR con Google Authenticator: <img src='$qrCodeUrl' />";
      return view('enable_2fa', ['qrCodeUrl' => $qrCodeUrl, 'temp_token' => $temp_token]);

    }
    public function login() {
        if (session()->get('isLoggedIn')) {
            return redirect()->to('/admin/dashboard');
        }
        return view('login');
    }
    

    public function authenticate() {
        $session = session();
        $userModel = new UserModel();
    
        $recaptchaResponse = $this->request->getPost('g-recaptcha-response');
        $recaptchaSecret = '6LcjbnArAAAAAHBqJSsxVyXJciTa1uHSuE5NCxPa';
    
        $response = file_get_contents("https://www.google.com/recaptcha/api/siteverify?secret=$recaptchaSecret&response=$recaptchaResponse");
        $responseKeys = json_decode($response, true);
    
        if (intval($responseKeys["success"]) !== 1) {
            $session->setFlashdata('error', 'Verificación reCAPTCHA fallida.');
            return redirect()->back();
        }
        // Capturar datos del formulario
        
        $cedula_or_username = $this->request->getPost('username');
        $password = $this->request->getPost('password');
       // $pin = $this->request->getPost('pin'); // Capturar el PIN ingresado
        $googleAuthCode = $this->request->getPost('google_auth_code');  // Código 2FA
    
        // Buscar usuario por Cédula o Username
        $user = $userModel->where('cedula', $cedula_or_username)
                          ->orWhere('username', $cedula_or_username)
                          ->first();
    
        if ($user && password_verify($password, $user['password'])) {
            // Verificar el PIN
          /*  if ($user['pin'] !== $pin) {
                $session->setFlashdata('error', 'PIN incorrecto.');
                return redirect()->back();
            }*/
   
            // Generar un token único para la sesión
            $sessionToken = bin2hex(random_bytes(16)); // Genera un token único
    
            // Actualizar el token en la base de datos
            $userModel->update($user['id'], [
                'session_token' => $sessionToken
            ]);


             if ($user['two_factor_enabled']) {
                 // Verificar el código 2FA
                 if (empty($user['google_auth_secret'])) {
                    return $this->enable2FA($user['id'],$sessionToken);
                }
                if (!empty($user['google_auth_secret'])) {
                    return view('verify_2fa', ['temp_token' => $sessionToken]);
                }
            }
    
            // Establecer la sesión
            $session->set([
                'isLoggedIn' => true,
                'userId' => $user['id'],
                'cedula' => $user['cedula'],
                'username' => $user['username'],
                'role' => $user['role'],
                'session_token' => $sessionToken
            ]);
          
            return redirect()->to('/admin/dashboard'); // Redirigir al dashboard
        } else {
            $session->setFlashdata('error', 'Cédula/Usuario o Contraseña incorrectos.');
            return redirect()->back();
        }
        return redirect()->back();
    }


    public function verify2FA()
    {
       
        $session = session();
        $googleAuthCode = $this->request->getPost('google_auth_code');
        $tempToken = $this->request->getPost('temp_token');
        $userModel = new UserModel();
        $user = $userModel->where('session_token', $tempToken)->first();
    
        // Verificamos si el usuario existe y si tiene habilitado el 2FA
        if (!$user || empty($user['google_auth_secret'])) {
            $session->setFlashdata('error', 'El 2FA no está habilitado para este usuario.');
            return redirect()->to('/login');
        }
    
        // Instanciamos la clase GoogleAuthenticator
        $ga = new \Sonata\GoogleAuthenticator\GoogleAuthenticator();
    
        // Verificamos si el código es correcto
        $isValid = $ga->checkCode($user['google_auth_secret'], $googleAuthCode);
    
        // Imprimimos el código ingresado y el generado para ver qué está pasando
        print_r("Código ingresado: $googleAuthCode\n");
        print_r("Secreto: " . $user['google_auth_secret'] . "\n");
    
        // Si la verificación del código es correcta
        if ($isValid) {
          
            $session->set([
                'isLoggedIn' => true,
                'userId' => $user['id'],
                'cedula' => $user['cedula'],
                'username' => $user['username'],
                'role' => $user['role'],
                'session_token' => $tempToken
            ]);
    
            return redirect()->to('/admin/dashboard');
        } else {
            $session->setFlashdata('error', 'Código 2FA incorrecto');
            return redirect()->back();
        }
    }
    
    
    public function logout() {
        // Eliminar el token de la base de datos y destruir la sesión
        $session = session();
        $userModel = new UserModel();
        //print_r($session->get('userId'));die;
        $userModel->update($session->get('userId'), [
            'session_token' => null  // Limpiar el token de la base de datos
        ]);
        
        // Destruir la sesión
        $session->destroy();
        return redirect()->to('/login');
    }
}
