<?php

namespace App\Controllers;

use CodeIgniter\RESTful\ResourceController;
use App\Models\FlowModel;

class ChatBotController extends ResourceController
{
    protected $flowModel;

    public function __construct()
    {
        $this->flowModel = new FlowModel();
    }

    public function chatWindow()
    {
        return view('chatbot/index');
    }

    public function sendMessageToChat()
    {
        $input = $this->request->getJSON();
        $userMessage = $input->message ?? 'Hola, este es un mensaje predeterminado';
        $to = "573235268216";

        try {
            $botResponse = $this->sendToWhatsApp($to, $userMessage);
            return $this->response->setHeader('Access-Control-Allow-Origin', '*')
                                  ->setHeader('Content-Type', 'application/json')
                                  ->setJSON(['response' => $botResponse]);
        } catch (\Exception $e) {
            return $this->response->setHeader('Access-Control-Allow-Origin', '*')
                                  ->setHeader('Content-Type', 'application/json')
                                  ->setStatusCode(500)
                                  ->setJSON(['error' => 'Error al enviar el mensaje: ' . $e->getMessage()]);
        }
    }

    private function saveConversation($sender, $userMessage, $response)
{
    $file = WRITEPATH . 'conversations.json';

    // Crear el archivo si no existe
    if (!file_exists($file)) {
        file_put_contents($file, json_encode([]));
    }

    // Leer las conversaciones actuales
    $conversations = json_decode(file_get_contents($file), true);

    // Buscar la conversación del remitente o crear una nueva
    if (!isset($conversations[$sender])) {
        $conversations[$sender] = [];
    }

    // Agregar el mensaje y la respuesta
    $conversations[$sender][] = [
        'message' => $userMessage,
        'response' => $response,
        'timestamp' => time(),
    ];

    // Guardar las conversaciones actualizadas
    file_put_contents($file, json_encode($conversations, JSON_PRETTY_PRINT));
}

public function receiveMessage()
{
    $input = $this->request->getJSON();

    if (isset($input->messages)) {
        foreach ($input->messages as $message) {
            $from = $message->from;
            $userMessage = $message->text->body ?? '';
            $response = $this->processMessage($userMessage);

            // Guardar la conversación
            $this->saveConversation($from, $userMessage, $response);

            // Enviar respuesta
            $this->sendToWhatsApp($from, $response);
        }
    }

    return $this->response->setJSON(['status' => 'success']);
}

    private function processMessage($userMessage)
    {
        $flow = $this->flowModel
                     ->where('trigger_word', $userMessage)
                     ->where('status', 'active')
                     ->orderBy('priority', 'DESC')
                     ->first();

        if (!$flow) {
            return "Lo siento, no entendí tu mensaje.";
        }

        if ($flow['type'] === 'menu') {
            return $this->generateMenu($flow['response']);
        } elseif ($flow['type'] === 'redirect') {
            return "Por favor visita: " . $flow['response'];
        }

        return $flow['response'];
    }

    private function sendToWhatsApp($to, $message)
    {
        $api_url = "https://waba-sandbox.360dialog.io/v1/messages";
        $api_key = 'prOOuf_sandbox';

        $data = [
            "messaging_product" => "whatsapp",
            "recipient_type" => "individual",
            "to" => $to,
            "type" => "text",
            "text" => [
                "body" => $message
            ]
        ];

        $ch = curl_init($api_url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            "Content-Type: application/json",
            "D360-API-KEY: $api_key"
        ]);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));

        $response = curl_exec($ch);

        if (curl_errno($ch)) {
            $error = curl_error($ch);
            curl_close($ch);
            throw new \Exception("Error en cURL: " . $error);
        }

        curl_close($ch);

        $decodedResponse = json_decode($response, true);

        if (isset($decodedResponse['error'])) {
            throw new \Exception("Error en la API de 360dialog: " . $decodedResponse['error']['message']);
        }

        return $decodedResponse['messages'][0]['id'] ?? 'Mensaje enviado correctamente.';
    }

    private function generateMenu($menuResponse)
    {
        $options = explode("\n", $menuResponse);
        $menu = "Por favor selecciona una opción:\n";
        foreach ($options as $index => $option) {
            $menu .= ($index + 1) . ". " . $option . "\n";
        }
        return $menu;
    }
}
