<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateFlowsTable extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type'           => 'INT',
                'constraint'     => 11,
                'unsigned'       => true,
                'auto_increment' => true,
            ],
            'flow_key' => [
                'type'       => 'VARCHAR',
                'constraint' => '100',
                'unique'     => true,
            ],
            'name' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
            ],
            'type' => [
                'type'       => 'ENUM',
                'constraint' => ['menu', 'submenu', 'action', 'redirect'],
                'default'    => 'menu',
            ],
            'description' => [
                'type' => 'TEXT',
                'null' => true,
            ],
            'message' => [
                'type' => 'TEXT',
            ],
            'options' => [
                'type' => 'JSON',
                'null' => true,
            ],
            'redirect_url' => [
                'type'       => 'VARCHAR',
                'constraint' => '500',
                'null'       => true,
            ],
            'parent_id' => [
                'type'       => 'INT',
                'constraint' => 11,
                'unsigned'   => true,
                'null'       => true,
            ],
            'order_index' => [
                'type'       => 'INT',
                'constraint' => 11,
                'default'    => 1,
            ],
            'is_active' => [
                'type'       => 'BOOLEAN',
                'default'    => true,
            ],
            'requires_advisor' => [
                'type'       => 'BOOLEAN',
                'default'    => false,
            ],
            'created_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'updated_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
        ]);

        $this->forge->addKey('id', true);
        $this->forge->addKey('flow_key');
        $this->forge->addKey('type');
        $this->forge->addKey('parent_id');
        $this->forge->addKey('is_active');
        $this->forge->addKey('order_index');
        $this->forge->addForeignKey('parent_id', 'flows', 'id', 'SET NULL', 'CASCADE');
        $this->forge->createTable('flows');
    }

    public function down()
    {
        $this->forge->dropTable('flows');
    }
}