<?php
//yuri ramirez//
namespace App\Filters;

use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use CodeIgniter\Filters\FilterInterface;
use App\Models\UserModel;

class AuthFilter implements FilterInterface
{
    public function before(RequestInterface $request, $arguments = null)
    {
        $session = session();
        $userModel = new UserModel();

        // Verificar si el usuario está autenticado
        if (!$session->get('isLoggedIn')) {
            return redirect()->to('/login');
        }

        // Obtener userId y session_token de la sesión
        $userId = $session->get('userId');
        $sessionToken = $session->get('session_token');

        // Si no hay userId o session_token en la sesión, redirigir al login
        if (!$userId || !$sessionToken) {
            $session->destroy(); // Destruir la sesión
            return redirect()->to('/login');
        }

        // Buscar al usuario en la base de datos
        $user = $userModel->find($userId);

        // Si el token de la base de datos no coincide, destruir la sesión y redirigir al login
        if ($user && $user['session_token'] !== $sessionToken) {
            $session->destroy(); // Destruir la sesión
            return redirect()->to('/login');
        }
    }

    public function after(RequestInterface $request, ResponseInterface $response, $arguments = null)
    {
        // No necesitamos hacer nada después de la solicitud
    }
}
