<?= $this->include('templates/sidebar'); ?>

<style>
/* Estilos existentes para las estadísticas */
.stats-container {
    margin-bottom: 30px;
}

.stat-card {
    background: linear-gradient(135deg, #fff 0%, #f8f9fa 100%);
    border-radius: 15px;
    padding: 25px;
    box-shadow: 0 8px 25px rgba(0,0,0,0.1);
    border: 1px solid #e9ecef;
    transition: all 0.3s ease;
    height: 100%;
    position: relative;
    overflow: hidden;
}

.stat-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 15px 35px rgba(0,0,0,0.15);
}

.stat-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 4px;
    background: linear-gradient(90deg, #667eea, #764ba2);
}

.stat-icon {
    width: 60px;
    height: 60px;
    border-radius: 15px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 24px;
    color: white;
    margin-bottom: 15px;
}

.stat-number {
    font-size: 2.5rem;
    font-weight: 700;
    color: #2c3e50;
    margin: 10px 0;
    line-height: 1;
}

.stat-label {
    color: #6c757d;
    font-size: 14px;
    font-weight: 500;
    margin-bottom: 8px;
}

.stat-change {
    font-size: 12px;
    font-weight: 600;
    padding: 4px 8px;
    border-radius: 20px;
    display: inline-block;
}

.stat-change.positive {
    background-color: #d4edda;
    color: #155724;
}

/* Estilos para el Chat IA */
.ai-chat-container {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border-radius: 20px;
    padding: 0;
    box-shadow: 0 20px 40px rgba(102, 126, 234, 0.3);
    overflow: hidden;
    margin-bottom: 30px;
    position: relative;
}

.ai-chat-header {
    background: rgba(255, 255, 255, 0.1);
    backdrop-filter: blur(10px);
    padding: 20px 25px;
    border-bottom: 1px solid rgba(255, 255, 255, 0.2);
    display: flex;
    align-items: center;
    justify-content: space-between;
}

.ai-chat-title {
    display: flex;
    align-items: center;
    color: white;
    font-weight: 600;
    font-size: 18px;
}

.ai-avatar {
    width: 40px;
    height: 40px;
    background: linear-gradient(135deg, #4facfe, #00f2fe);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 12px;
    animation: pulse 2s infinite;
}

.ai-status {
    display: flex;
    align-items: center;
    color: rgba(255, 255, 255, 0.9);
    font-size: 12px;
}

.status-dot {
    width: 8px;
    height: 8px;
    background: #00ff88;
    border-radius: 50%;
    margin-right: 6px;
    animation: blink 1.5s infinite;
}

.chat-messages {
    height: 400px;
    overflow-y: auto;
    padding: 20px;
    background: rgba(255, 255, 255, 0.05);
    backdrop-filter: blur(5px);
}

.message {
    margin-bottom: 15px;
    display: flex;
    align-items: flex-start;
    animation: slideIn 0.3s ease;
}

.message.user {
    flex-direction: row-reverse;
}

.message-avatar {
    width: 32px;
    height: 32px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 14px;
    margin: 0 10px;
    flex-shrink: 0;
}

.message.ai .message-avatar {
    background: linear-gradient(135deg, #4facfe, #00f2fe);
    color: white;
}

.message.user .message-avatar {
    background: linear-gradient(135deg, #fa709a, #fee140);
    color: white;
}

.message-content {
    max-width: 70%;
    padding: 12px 16px;
    border-radius: 18px;
    font-size: 14px;
    line-height: 1.4;
    position: relative;
}

.message.ai .message-content {
    background: rgba(255, 255, 255, 0.95);
    color: #2c3e50;
    border-bottom-left-radius: 6px;
}

.message.user .message-content {
    background: rgba(255, 255, 255, 0.2);
    color: white;
    border-bottom-right-radius: 6px;
}

.message-time {
    font-size: 11px;
    opacity: 0.7;
    margin-top: 4px;
}

.typing-indicator {
    display: none;
    align-items: center;
    padding: 12px 16px;
    background: rgba(255, 255, 255, 0.95);
    border-radius: 18px;
    border-bottom-left-radius: 6px;
    max-width: 70px;
}

.typing-dots {
    display: flex;
    gap: 4px;
}

.typing-dot {
    width: 6px;
    height: 6px;
    background: #667eea;
    border-radius: 50%;
    animation: typingDot 1.4s infinite;
}

.typing-dot:nth-child(2) {
    animation-delay: 0.2s;
}

.typing-dot:nth-child(3) {
    animation-delay: 0.4s;
}

.chat-input-container {
    padding: 20px;
    background: rgba(255, 255, 255, 0.1);
    backdrop-filter: blur(10px);
    border-top: 1px solid rgba(255, 255, 255, 0.2);
}

.chat-input-wrapper {
    display: flex;
    align-items: center;
    background: rgba(255, 255, 255, 0.95);
    border-radius: 25px;
    padding: 8px 15px;
    gap: 10px;
}

.chat-input {
    flex: 1;
    border: none;
    outline: none;
    background: transparent;
    font-size: 14px;
    color: #2c3e50;
    padding: 8px 0;
}

.chat-input::placeholder {
    color: #6c757d;
}

.chat-actions {
    display: flex;
    gap: 8px;
}

.chat-btn {
    width: 36px;
    height: 36px;
    border: none;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    transition: all 0.3s ease;
    font-size: 16px;
}

.voice-btn {
    background: linear-gradient(135deg, #fa709a, #fee140);
    color: white;
}

.voice-btn:hover {
    transform: scale(1.1);
}

.voice-btn.listening {
    animation: pulse 1s infinite;
    background: linear-gradient(135deg, #ff6b6b, #ee5a24);
}

.send-btn {
    background: linear-gradient(135deg, #667eea, #764ba2);
    color: white;
}

.send-btn:hover {
    transform: scale(1.1);
}

.send-btn:disabled {
    opacity: 0.5;
    cursor: not-allowed;
}

.quick-actions {
    display: flex;
    gap: 8px;
    margin-top: 12px;
    flex-wrap: wrap;
}

.quick-action {
    background: rgba(255, 255, 255, 0.2);
    color: white;
    border: 1px solid rgba(255, 255, 255, 0.3);
    border-radius: 20px;
    padding: 6px 12px;
    font-size: 12px;
    cursor: pointer;
    transition: all 0.3s ease;
}

.quick-action:hover {
    background: rgba(255, 255, 255, 0.3);
    transform: translateY(-2px);
}

.ai-suggestions {
    background: rgba(255, 255, 255, 0.1);
    border-radius: 12px;
    padding: 15px;
    margin-top: 15px;
    border: 1px solid rgba(255, 255, 255, 0.2);
}

.suggestion-title {
    color: white;
    font-weight: 600;
    font-size: 14px;
    margin-bottom: 10px;
    display: flex;
    align-items: center;
}

.suggestion-list {
    display: flex;
    flex-direction: column;
    gap: 8px;
}

.suggestion-item {
    background: rgba(255, 255, 255, 0.1);
    color: white;
    padding: 8px 12px;
    border-radius: 8px;
    font-size: 13px;
    cursor: pointer;
    transition: all 0.3s ease;
    border: 1px solid rgba(255, 255, 255, 0.2);
}

.suggestion-item:hover {
    background: rgba(255, 255, 255, 0.2);
    transform: translateX(5px);
}

/* Animaciones */
@keyframes pulse {
    0%, 100% { transform: scale(1); }
    50% { transform: scale(1.05); }
}

@keyframes blink {
    0%, 100% { opacity: 1; }
    50% { opacity: 0.3; }
}

@keyframes slideIn {
    from {
        opacity: 0;
        transform: translateY(10px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

@keyframes typingDot {
    0%, 60%, 100% { transform: translateY(0); }
    30% { transform: translateY(-10px); }
}

/* Responsive */
@media (max-width: 768px) {
    .ai-chat-container {
        margin: 0 -15px;
        border-radius: 0;
    }
    
    .message-content {
        max-width: 85%;
    }
    
    .quick-actions {
        justify-content: center;
    }
}
</style>

<!-- Contenido del Dashboard -->
<div class="fade-in">
    <!-- Mensaje de bienvenida -->
    <div class="welcome-message">
        <div class="row align-items-center">
            <div class="col-md-8 text-start">
                <h2>¡Bienvenido al Panel de Chat Solibot IA!</h2>
                <p>Hola, <?= $username ?? 'Usuario' ?>. 
                    <?php if ($role === 'admin'): ?>
                        Gestiona tu chatbot inteligente multi-plataforma con tecnología de IA avanzada.
                    <?php else: ?>
                        Interactúa con Solibot IA para gestionar tus tickets y conversaciones de manera inteligente.
                    <?php endif; ?>
                </p>
                <div class="mt-3">
                    <span class="badge bg-success me-2"><i class="fab fa-whatsapp me-1"></i>WhatsApp</span>
                    <span class="badge bg-info me-2"><i class="fab fa-telegram me-1"></i>Telegram</span>
                    <span class="badge bg-warning"><i class="fab fa-instagram me-1"></i>Instagram</span>
                    <span class="badge <?= $role === 'admin' ? 'bg-danger' : 'bg-primary' ?> ms-2">
                        <i class="fas fa-brain me-1"></i>IA Activada
                    </span>
                </div>
            </div>
            <div class="col-md-4 text-center">
                <img src="<?= base_url('img/logo.png') ?>" alt="Robot Solibot" class="robot-img">
            </div>
        </div>
    </div>

    <?php
    // Cargar datos de estadísticas (mantenemos la lógica existente)
    $conversationsFile = WRITEPATH . 'conversations.json';
    $ticketsFile = WRITEPATH . 'tickets.json';
    
    $conversations = file_exists($conversationsFile) ? json_decode(file_get_contents($conversationsFile), true) : [];
    $tickets = file_exists($ticketsFile) ? json_decode(file_get_contents($ticketsFile), true) : [];
    
    // Calcular estadísticas
    $totalConversations = count($conversations);
    $totalTickets = count($tickets);
    $activeConversations = 0;
    $totalMessages = 0;
    $weeklyTickets = 0;
    $weeklyMessages = 0;
    $platformStats = ['whatsapp' => 0, 'telegram' => 0, 'instagram' => 0];
    $ticketsByStatus = ['open' => 0, 'in_progress' => 0, 'closed' => 0];
    
    $oneWeekAgo = time() - (7 * 24 * 60 * 60);
    
    // Analizar conversaciones
    foreach ($conversations as $phone => $conv) {
        if (isset($conv['status']) && $conv['status'] === 'active') {
            $activeConversations++;
        }
        
        if (isset($conv['messages']) && is_array($conv['messages'])) {
            $totalMessages += count($conv['messages']);
            
            foreach ($conv['messages'] as $msg) {
                if (isset($msg['timestamp']) && $msg['timestamp'] >= $oneWeekAgo) {
                    $weeklyMessages++;
                }
            }
        }
        
        $platform = $conv['platform'] ?? 'whatsapp';
        if (isset($platformStats[$platform])) {
            $platformStats[$platform]++;
        }
    }
    
    // Analizar tickets
    foreach ($tickets as $ticket) {
        if (isset($ticket['created_at'])) {
            $ticketTime = strtotime($ticket['created_at']);
            if ($ticketTime >= $oneWeekAgo) {
                $weeklyTickets++;
            }
        }
        
        $status = $ticket['status'] ?? 'open';
        if (isset($ticketsByStatus[$status])) {
            $ticketsByStatus[$status]++;
        }
    }
    ?>

    <!-- Estadísticas principales (mantenemos las existentes) -->
    <div class="stats-container">
        <div class="row">
            <?php if ($role === 'admin'): ?>
                <div class="col-lg-3 col-md-6 mb-4">
                    <div class="stat-card">
                        <div class="stat-icon" style="background: linear-gradient(135deg, #667eea, #764ba2);">
                            <i class="fas fa-comments"></i>
                        </div>
                        <div class="stat-label">Conversaciones Activas</div>
                        <div class="stat-number"><?= $activeConversations ?></div>
                        <span class="stat-change positive">+12% esta semana</span>
                    </div>
                </div>
                
                <div class="col-lg-3 col-md-6 mb-4">
                    <div class="stat-card">
                        <div class="stat-icon" style="background: linear-gradient(135deg, #f093fb, #f5576c);">
                            <i class="fas fa-ticket-alt"></i>
                        </div>
                        <div class="stat-label">Tickets Semanales</div>
                        <div class="stat-number"><?= $weeklyTickets ?></div>
                        <span class="stat-change positive">+8% vs semana anterior</span>
                    </div>
                </div>
                
                <div class="col-lg-3 col-md-6 mb-4">
                    <div class="stat-card">
                        <div class="stat-icon" style="background: linear-gradient(135deg, #4facfe, #00f2fe);">
                            <i class="fas fa-envelope"></i>
                        </div>
                        <div class="stat-label">Mensajes Semanales</div>
                        <div class="stat-number"><?= $weeklyMessages ?></div>
                        <span class="stat-change positive">+25% incremento</span>
                    </div>
                </div>
                
                <div class="col-lg-3 col-md-6 mb-4">
                    <div class="stat-card">
                        <div class="stat-icon" style="background: linear-gradient(135deg, #fa709a, #fee140);">
                            <i class="fas fa-brain"></i>
                        </div>
                        <div class="stat-label">Precisión IA</div>
                        <div class="stat-number">94.2%</div>
                        <span class="stat-change positive">+3% mejora</span>
                    </div>
                </div>
            <?php else: ?>
                <?php
                $myTickets = 0;
                $myOpenTickets = 0;
                $myConversations = 0;
                
                foreach ($tickets as $ticket) {
                    if (isset($ticket['assigned_to']) && $ticket['assigned_to'] == $userId) {
                        $myTickets++;
                        if ($ticket['status'] === 'open') {
                            $myOpenTickets++;
                        }
                    }
                }
                
                foreach ($conversations as $conv) {
                    if (isset($conv['assigned_to']) && $conv['assigned_to'] == $userId) {
                        $myConversations++;
                    }
                }
                ?>
                
                <div class="col-lg-3 col-md-6 mb-4">
                    <div class="stat-card">
                        <div class="stat-icon" style="background: linear-gradient(135deg, #667eea, #764ba2);">
                            <i class="fas fa-ticket-alt"></i>
                        </div>
                        <div class="stat-label">Mis Tickets</div>
                        <div class="stat-number"><?= $myTickets ?></div>
                        <span class="stat-change neutral"><?= $myOpenTickets ?> pendientes</span>
                    </div>
                </div>
                
                <div class="col-lg-3 col-md-6 mb-4">
                    <div class="stat-card">
                        <div class="stat-icon" style="background: linear-gradient(135deg, #f093fb, #f5576c);">
                            <i class="fas fa-comments"></i>
                        </div>
                        <div class="stat-label">Mis Conversaciones</div>
                        <div class="stat-number"><?= $myConversations ?></div>
                        <span class="stat-change positive">Activas</span>
                    </div>
                </div>
                
                <div class="col-lg-3 col-md-6 mb-4">
                    <div class="stat-card">
                        <div class="stat-icon" style="background: linear-gradient(135deg, #4facfe, #00f2fe);">
                            <i class="fas fa-clock"></i>
                        </div>
                        <div class="stat-label">Tiempo Respuesta</div>
                        <div class="stat-number">1.8m</div>
                        <span class="stat-change positive">Promedio</span>
                    </div>
                </div>
                
                <div class="col-lg-3 col-md-6 mb-4">
                    <div class="stat-card">
                        <div class="stat-icon" style="background: linear-gradient(135deg, #fa709a, #fee140);">
                            <i class="fas fa-brain"></i>
                        </div>
                        <div class="stat-label">Asistencia IA</div>
                        <div class="stat-number">87%</div>
                        <span class="stat-change positive">Efectividad</span>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Chat IA Principal -->
    <div class="row">
        <div class="col-12">
            <div class="ai-chat-container">
                <div class="ai-chat-header">
                    <div class="ai-chat-title">
                        <div class="ai-avatar">
                            <i class="fas fa-robot"></i>
                        </div>
                        <div>
                            <div>Solibot IA Assistant</div>
                            <div style="font-size: 12px; opacity: 0.8;">Inteligencia Artificial Multi-Plataforma</div>
                        </div>
                    </div>
                    <div class="ai-status">
                        <div class="status-dot"></div>
                        En línea
                    </div>
                </div>

                <div class="chat-messages" id="chatMessages">
                    <div class="message ai">
                        <div class="message-avatar">
                            <i class="fas fa-robot"></i>
                        </div>
                        <div class="message-content">
                            ¡Hola <?= $username ?>! 🤖 Soy Solibot IA, tu asistente inteligente para gestionar conversaciones multi-plataforma. 
                            
                            Puedo ayudarte con:
                            • 📊 Análisis de conversaciones en tiempo real
                            • 🎯 Asignación inteligente de tickets
                            • 📈 Estadísticas y métricas avanzadas
                            • 🔄 Automatización de flujos de trabajo
                            • 💬 Gestión de WhatsApp, Telegram e Instagram
                            
                            ¿En qué puedo asistirte hoy?
                            <div class="message-time"><?= date('H:i') ?></div>
                        </div>
                    </div>

                    <div class="message ai typing-indicator" id="typingIndicator">
                        <div class="message-avatar">
                            <i class="fas fa-robot"></i>
                        </div>
                        <div class="typing-indicator">
                            <div class="typing-dots">
                                <div class="typing-dot"></div>
                                <div class="typing-dot"></div>
                                <div class="typing-dot"></div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="chat-input-container">
                    <div class="chat-input-wrapper">
                        <input type="text" class="chat-input" id="chatInput" placeholder="Pregúntame sobre tickets, conversaciones, estadísticas...">
                        <div class="chat-actions">
                            <button class="chat-btn voice-btn" id="voiceBtn" title="Comando de voz">
                                <i class="fas fa-microphone"></i>
                            </button>
                            <button class="chat-btn send-btn" id="sendBtn" title="Enviar mensaje">
                                <i class="fas fa-paper-plane"></i>
                            </button>
                        </div>
                    </div>
                    
                    <div class="quick-actions">
                        <div class="quick-action" onclick="sendQuickMessage('¿Cuántos tickets tengo pendientes?')">
                            📋 Tickets pendientes
                        </div>
                        <div class="quick-action" onclick="sendQuickMessage('Mostrar estadísticas de hoy')">
                            📊 Estadísticas hoy
                        </div>
                        <div class="quick-action" onclick="sendQuickMessage('¿Hay conversaciones sin asignar?')">
                            💬 Conversaciones sin asignar
                        </div>
                        <div class="quick-action" onclick="sendQuickMessage('Generar reporte semanal')">
                            📈 Reporte semanal
                        </div>
                    </div>

                    <div class="ai-suggestions">
                        <div class="suggestion-title">
                            <i class="fas fa-lightbulb me-2"></i>
                            Sugerencias IA
                        </div>
                        <div class="suggestion-list">
                            <div class="suggestion-item" onclick="sendQuickMessage('Optimizar flujos de atención')">
                                🔧 Optimizar flujos de atención automática
                            </div>
                            <div class="suggestion-item" onclick="sendQuickMessage('Analizar patrones de conversación')">
                                🔍 Analizar patrones de conversación
                            </div>
                            <div class="suggestion-item" onclick="sendQuickMessage('Configurar alertas inteligentes')">
                                🚨 Configurar alertas inteligentes
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

</div> <!-- Cierre container-fluid -->
</div> <!-- Cierre main-content -->

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<script>
// Variables globales
const userRole = '<?= $role ?>';
const userId = '<?= $userId ?>';
const userName = '<?= $username ?>';

// Estado del chat
let isListening = false;
let recognition = null;

// Inicializar reconocimiento de voz
if ('webkitSpeechRecognition' in window) {
    recognition = new webkitSpeechRecognition();
    recognition.continuous = false;
    recognition.interimResults = false;
    recognition.lang = 'es-ES';
    
    recognition.onresult = function(event) {
        const transcript = event.results[0][0].transcript;
        document.getElementById('chatInput').value = transcript;
        sendMessage();
    };
    
    recognition.onend = function() {
        isListening = false;
        updateVoiceButton();
    };
}

// Respuestas IA predefinidas
const aiResponses = {
    'tickets': [
        `📋 Tienes <?= $role === 'admin' ? $ticketsByStatus['open'] : $myOpenTickets ?? 0 ?> tickets pendientes. <?= $role === 'admin' ? 'Como administrador, puedes ver todos los tickets del sistema.' : 'Estos son los tickets asignados específicamente a ti.' ?>`,
        '¿Te gustaría que te muestre los detalles de algún ticket específico?'
    ],
    'estadisticas': [
        `📊 Estadísticas actuales:\n• Conversaciones activas: <?= $activeConversations ?>\n• Mensajes esta semana: <?= $weeklyMessages ?>\n• Tickets esta semana: <?= $weeklyTickets ?>\n• Plataformas conectadas: WhatsApp, Telegram, Instagram`,
        'La IA está procesando <?= $totalMessages ?> mensajes totales con una precisión del 94.2%'
    ],
    'conversaciones': [
        `💬 Hay <?= $activeConversations ?> conversaciones activas en el sistema. <?= $role === 'admin' ? 'Como administrador, puedes supervisar todas las conversaciones.' : 'Tienes ' . ($myConversations ?? 0) . ' conversaciones asignadas a ti.' ?>`,
        'La IA está ayudando a gestionar las respuestas automáticas y la asignación inteligente.'
    ],
    'reporte': [
        `📈 Generando reporte semanal...\n\n📊 Resumen de la semana:\n• Total de tickets: <?= $weeklyTickets ?>\n• Total de mensajes: <?= $weeklyMessages ?>\n• Conversaciones nuevas: <?= $activeConversations ?>\n• Tiempo de respuesta promedio: 2.3 minutos\n• Satisfacción del cliente: 96.8%`,
        '¿Te gustaría que exporte este reporte en PDF o Excel?'
    ],
    'optimizar': [
        '🔧 Analizando flujos de atención...\n\n✅ Recomendaciones de IA:\n• Implementar respuestas automáticas para consultas frecuentes\n• Optimizar horarios de asignación de asesores\n• Crear flujos específicos por tipo de consulta\n• Integrar chatbots más inteligentes',
        'Estas optimizaciones podrían mejorar la eficiencia en un 35%'
    ],
    'patrones': [
        '🔍 Análisis de patrones completado:\n\n📈 Tendencias detectadas:\n• Pico de consultas: 10:00-12:00 y 14:00-16:00\n• Consultas más frecuentes: Saldos (35%), Créditos (28%), Servicios (22%)\n• Plataforma preferida: WhatsApp (78%)\n• Tiempo de resolución promedio: 8.5 minutos',
        'La IA sugiere crear respuestas automáticas para las consultas más frecuentes.'
    ],
    'alertas': [
        '🚨 Configurando alertas inteligentes...\n\n⚙️ Alertas activadas:\n• Tickets urgentes sin asignar\n• Conversaciones inactivas por más de 30 minutos\n• Picos de tráfico inusuales\n• Errores en respuestas automáticas\n• Métricas de satisfacción bajas',
        'Las alertas se enviarán por email y notificaciones push.'
    ],
    'default': [
        '🤖 Como Solibot IA, puedo ayudarte con múltiples tareas. Algunas opciones populares:',
        '• Consultar estadísticas y métricas\n• Gestionar tickets y conversaciones\n• Generar reportes automáticos\n• Optimizar flujos de trabajo\n• Configurar alertas inteligentes\n\n¿Qué te gustaría hacer?'
    ]
};

// Función para enviar mensaje
function sendMessage() {
    const input = document.getElementById('chatInput');
    const message = input.value.trim();
    
    if (!message) return;
    
    // Agregar mensaje del usuario
    addMessage(message, 'user');
    input.value = '';
    
    // Mostrar indicador de escritura
    showTypingIndicator();
    
    // Simular respuesta de IA después de un delay
    setTimeout(() => {
        hideTypingIndicator();
        generateAIResponse(message);
    }, 1500 + Math.random() * 1000);
}

// Función para agregar mensaje al chat
function addMessage(text, sender) {
    const messagesContainer = document.getElementById('chatMessages');
    const messageDiv = document.createElement('div');
    messageDiv.className = `message ${sender}`;
    
    const avatar = sender === 'ai' ? '<i class="fas fa-robot"></i>' : '<i class="fas fa-user"></i>';
    const time = new Date().toLocaleTimeString('es-ES', { hour: '2-digit', minute: '2-digit' });
    
    messageDiv.innerHTML = `
        <div class="message-avatar">
            ${avatar}
        </div>
        <div class="message-content">
            ${text}
            <div class="message-time">${time}</div>
        </div>
    `;
    
    // Insertar antes del indicador de escritura
    const typingIndicator = document.getElementById('typingIndicator');
    messagesContainer.insertBefore(messageDiv, typingIndicator);
    
    // Scroll al final
    messagesContainer.scrollTop = messagesContainer.scrollHeight;
}

// Función para generar respuesta de IA
function generateAIResponse(userMessage) {
    const message = userMessage.toLowerCase();
    let response = aiResponses.default;
    
    // Detectar intención del mensaje
    if (message.includes('ticket') || message.includes('pendiente')) {
        response = aiResponses.tickets;
    } else if (message.includes('estadistica') || message.includes('metrica') || message.includes('hoy')) {
        response = aiResponses.estadisticas;
    } else if (message.includes('conversacion') || message.includes('chat') || message.includes('asignar')) {
        response = aiResponses.conversaciones;
    } else if (message.includes('reporte') || message.includes('semanal')) {
        response = aiResponses.reporte;
    } else if (message.includes('optimizar') || message.includes('flujo')) {
        response = aiResponses.optimizar;
    } else if (message.includes('patron') || message.includes('analizar')) {
        response = aiResponses.patrones;
    } else if (message.includes('alerta') || message.includes('configurar')) {
        response = aiResponses.alertas;
    }
    
    // Enviar respuestas con delay entre ellas
    response.forEach((text, index) => {
        setTimeout(() => {
            addMessage(text, 'ai');
        }, index * 1000);
    });
}

// Función para mostrar indicador de escritura
function showTypingIndicator() {
    document.getElementById('typingIndicator').style.display = 'flex';
    document.getElementById('chatMessages').scrollTop = document.getElementById('chatMessages').scrollHeight;
}

// Función para ocultar indicador de escritura
function hideTypingIndicator() {
    document.getElementById('typingIndicator').style.display = 'none';
}

// Función para enviar mensaje rápido
function sendQuickMessage(message) {
    document.getElementById('chatInput').value = message;
    sendMessage();
}

// Función para actualizar botón de voz
function updateVoiceButton() {
    const voiceBtn = document.getElementById('voiceBtn');
    if (isListening) {
        voiceBtn.classList.add('listening');
        voiceBtn.innerHTML = '<i class="fas fa-microphone-slash"></i>';
    } else {
        voiceBtn.classList.remove('listening');
        voiceBtn.innerHTML = '<i class="fas fa-microphone"></i>';
    }
}

// Event listeners
document.getElementById('sendBtn').addEventListener('click', sendMessage);

document.getElementById('chatInput').addEventListener('keypress', function(e) {
    if (e.key === 'Enter') {
        sendMessage();
    }
});

document.getElementById('voiceBtn').addEventListener('click', function() {
    if (!recognition) {
        alert('El reconocimiento de voz no está disponible en este navegador.');
        return;
    }
    
    if (isListening) {
        recognition.stop();
    } else {
        isListening = true;
        updateVoiceButton();
        recognition.start();
    }
});

// Toggle sidebar
document.getElementById('toggleSidebar').addEventListener('click', function() {
    const sidebar = document.getElementById('sidebar');
    const mainContent = document.getElementById('mainContent');
    
    sidebar.classList.toggle('collapsed');
    mainContent.classList.toggle('expanded');
});

// Función para mostrar notificaciones toast
function showNotification(message, type = 'info') {
    const notification = document.createElement('div');
    notification.className = `alert alert-${type === 'success' ? 'success' : type === 'info' ? 'info' : 'danger'} alert-dismissible fade show position-fixed`;
    notification.style.cssText = 'top: 20px; right: 20px; z-index: 9999; min-width: 300px;';
    notification.innerHTML = `
        ${message}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    `;
    
    document.body.appendChild(notification);
    
    setTimeout(() => {
        if (notification.parentNode) {
            notification.remove();
        }
    }, 5000);
}

// Mostrar mensaje de bienvenida según el rol
<?php if ($role === 'admin'): ?>
    console.log('Dashboard IA de Administrador cargado correctamente');
    showNotification('¡Bienvenido Administrador! Solibot IA está listo para asistirte', 'success');
<?php else: ?>
    console.log('Dashboard IA de Asesor cargado correctamente');
    showNotification('¡Bienvenido Asesor! Solibot IA te ayudará con tus tareas', 'info');
<?php endif; ?>

// Simular mensaje de bienvenida personalizado después de 2 segundos
setTimeout(() => {
    const welcomeMsg = `¡Perfecto! He cargado tu información, ${userName}. Como ${userRole === 'admin' ? 'administrador' : 'asesor'}, tienes acceso a todas las funciones de IA. ¿Por dónde empezamos?`;
    addMessage(welcomeMsg, 'ai');
}, 2000);

console.log('Solibot IA Dashboard - Rol:', userRole, 'Usuario:', userName);
</script>

</body>
</html>