<?= $this->include('templates/sidebar'); ?>

<div class="fade-in">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h2><i class="fas fa-plus-circle text-primary me-2"></i>Crear Nuevo Flujo de Menú</h2>
            <p class="text-muted">Configura un nuevo menú interactivo para el chatbot</p>
        </div>
        <a href="<?= base_url('admin/flows') ?>" class="btn btn-outline-secondary">
            <i class="fas fa-arrow-left me-2"></i>Volver a Flujos
        </a>
    </div>

    <div class="row">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0"><i class="fas fa-cog me-2"></i>Configuración del Flujo</h5>
                </div>
                <div class="card-body">
                    <form action="<?= base_url('admin/flows/store') ?>" method="POST" id="flowForm">
                        <?= csrf_field() ?>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="flow_key" class="form-label">
                                        <i class="fas fa-key me-1"></i>Clave del Flujo *
                                    </label>
                                    <input type="text" class="form-control" id="flow_key" name="flow_key" required
                                           placeholder="Ej: credito_menu">
                                    <div class="form-text">Identificador único del flujo (sin espacios)</div>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="name" class="form-label">
                                        <i class="fas fa-tag me-1"></i>Nombre del Flujo *
                                    </label>
                                    <input type="text" class="form-control" id="name" name="name" required
                                           placeholder="Ej: Menú Principal de Crédito">
                                    <div class="form-text">Nombre descriptivo para identificar este flujo</div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="type" class="form-label">
                                        <i class="fas fa-list me-1"></i>Tipo de Flujo *
                                    </label>
                                    <select class="form-select" id="type" name="type" required onchange="updateFormByType()">
                                        <option value="">Seleccionar tipo...</option>
                                        <option value="menu">Menú Principal</option>
                                        <option value="submenu">Submenú</option>
                                        <option value="action">Acción Específica</option>
                                        <option value="redirect">Redirección a URL</option>
                                    </select>
                                </div>
                            </div>
                            
                          <!--  <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="parent_id" class="form-label">Flujo Padre</label>
                                    <select class="form-select" id="parent_id" name="parent_id">
                                        <option value="">Sin padre (menú principal)</option>
                                        <?php if (!empty($parentFlows)): ?>
                                            <?php foreach ($parentFlows as $parentFlow): ?>
                                                <option value="<?= $parentFlow['id'] ?>">
                                                    <?= htmlspecialchars($parentFlow['name']) ?>
                                                </option>
                                            <?php endforeach; ?>
                                        <?php endif; ?>
                                    </select>
                                </div>
                            </div>-->
                        </div>

                        <div class="mb-3">
                            <label for="description" class="form-label">
                                <i class="fas fa-align-left me-1"></i>Descripción
                            </label>
                            <textarea class="form-control" id="description" name="description" rows="2"
                                      placeholder="Descripción breve del propósito de este flujo"></textarea>
                        </div>

                        <div class="mb-3">
                            <label for="message" class="form-label">
                                <i class="fas fa-comment me-1"></i>Mensaje del Chatbot *
                            </label>
                            <textarea class="form-control" id="message" name="message" rows="4" required
                                      placeholder="Mensaje que mostrará el chatbot al usuario"></textarea>
                            <div class="form-text">Este es el texto que verá el usuario cuando acceda a este menú</div>
                        </div>

                        <!-- Sección de opciones (solo para menús) -->
                        <div id="optionsSection" style="display: none;">
                            <div class="d-flex justify-content-between align-items-center mb-3">
                                <label class="form-label mb-0">
                                    <i class="fas fa-list-ol me-1"></i>Opciones del Menú
                                </label>
                                <button type="button" class="btn btn-sm btn-outline-primary" onclick="addOption()">
                                    <i class="fas fa-plus me-1"></i>Agregar Opción
                                </button>
                            </div>
                            <div id="optionsContainer">
                                <!-- Las opciones se agregan dinámicamente aquí -->
                            </div>
                        </div>

                        <!-- Sección de URL (solo para redirecciones) -->
                        <div id="urlSection" style="display: none;">
                            <div class="mb-3">
                                <label for="redirect_url" class="form-label">
                                    <i class="fas fa-link me-1"></i>URL de Destino *
                                </label>
                                <input type="url" class="form-control" id="redirect_url" name="redirect_url"
                                       placeholder="https://ejemplo.com/documento.pdf">
                                <div class="form-text">URL completa a la que se redirigirá al usuario</div>
                            </div>
                        </div>

                        <!-- Configuración avanzada -->
                        <div class="card mt-4">
                            <div class="card-header">
                                <h6 class="mb-0">
                                    <i class="fas fa-cogs me-2"></i>Configuración Avanzada
                                    <button type="button" class="btn btn-sm btn-outline-info float-end" 
                                            data-bs-toggle="collapse" data-bs-target="#advancedConfig">
                                        <i class="fas fa-chevron-down"></i>
                                    </button>
                                </h6>
                            </div>
                            <div class="collapse" id="advancedConfig">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <label for="order_index" class="form-label">Orden</label>
                                                <input type="number" class="form-control" id="order_index" name="order_index" 
                                                       value="1" min="1">
                                                <div class="form-text">Orden de aparición en el menú</div>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="mt-4">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" id="is_active" name="is_active" checked>
                                                    <label class="form-check-label" for="is_active">
                                                        Activar inmediatamente
                                                    </label>
                                                </div>
                                                <div class="form-check mt-2">
                                                    <input class="form-check-input" type="checkbox" id="requires_advisor" name="requires_advisor">
                                                    <label class="form-check-label" for="requires_advisor">
                                                        Requiere asesor humano
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="d-flex justify-content-between mt-4">
                            <div>
                                <button type="button" class="btn btn-outline-info me-2" onclick="previewFlow()">
                                    <i class="fas fa-eye me-2"></i>Vista Previa
                                </button>
                            
                                <button type="button" class="btn btn-outline-secondary me-2" onclick="history.back()">
                                    <i class="fas fa-times me-2"></i>Cancelar
                                </button>
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save me-2"></i>Crear Flujo
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <!-- Plantillas predefinidas -->
            <div class="card">
                <div class="card-header">
                    <h6 class="mb-0"><i class="fas fa-templates me-2"></i>Plantillas Rápidas</h6>
                </div>
                <div class="card-body">
                    <div class="d-grid gap-2">
                        <button class="btn btn-outline-primary btn-sm" onclick="loadCreditTemplate()">
                            <i class="fas fa-credit-card me-2"></i>Menú de Crédito
                        </button>
                        <button class="btn btn-outline-success btn-sm" onclick="loadCarteraTemplate()">
                            <i class="fas fa-wallet me-2"></i>Menú de Cartera
                        </button>
                        <button class="btn btn-outline-info btn-sm" onclick="loadAhorrosTemplate()">
                            <i class="fas fa-piggy-bank me-2"></i>Ahorros y CDAT
                        </button>
                        <button class="btn btn-outline-warning btn-sm" onclick="loadAuxiliosTemplate()">
                            <i class="fas fa-hands-helping me-2"></i>Auxilios
                        </button>
                        <button class="btn btn-outline-secondary btn-sm" onclick="loadOtrosTemplate()">
                            <i class="fas fa-ellipsis-h me-2"></i>Otros Servicios
                        </button>
                    </div>
                </div>
            </div>

            <!-- Ayuda -->
            <div class="card mt-3">
                <div class="card-header">
                    <h6 class="mb-0"><i class="fas fa-question-circle me-2"></i>Ayuda</h6>
                </div>
                <div class="card-body">
                    <div class="small">
                        <p><strong>Tipos de Flujo:</strong></p>
                        <ul class="list-unstyled">
                            <li><i class="fas fa-list text-primary me-2"></i><strong>Menú Principal:</strong> Opciones principales del chatbot</li>
                            <li><i class="fas fa-indent text-info me-2"></i><strong>Submenú:</strong> Opciones secundarias</li>
                            <li><i class="fas fa-cog text-success me-2"></i><strong>Acción:</strong> Respuesta específica</li>
                            <li><i class="fas fa-external-link-alt text-warning me-2"></i><strong>Redirección:</strong> Enlace externo</li>
                        </ul>
                        
                        <p class="mt-3"><strong>Consejos:</strong></p>
                        <ul class="list-unstyled">
                            <li><i class="fas fa-lightbulb text-warning me-2"></i>Usa mensajes claros y concisos</li>
                            <li><i class="fas fa-lightbulb text-warning me-2"></i>Numera las opciones del 1 al 9</li>
                            <li><i class="fas fa-lightbulb text-warning me-2"></i>Incluye siempre opción para asesor</li>
                            <li><i class="fas fa-lightbulb text-warning me-2"></i>Configura respuestas directas para respuestas rápidas</li>
                            <li><i class="fas fa-lightbulb text-warning me-2"></i>La clave del submenu main_menu  siempre te llevara alos opciones de Menu Principal</li>
                        </ul>
                    </div>
                </div>
            </div>

            <!-- Vista previa -->
            <div class="card mt-3" id="previewCard" style="display: none;">
                <div class="card-header">
                    <h6 class="mb-0"><i class="fas fa-eye me-2"></i>Vista Previa</h6>
                </div>
                <div class="card-body">
                    <div class="border rounded p-3 bg-light">
                        <div class="d-flex align-items-start">
                            <div class="bg-primary rounded-circle p-2 me-3">
                                <i class="fas fa-robot text-white"></i>
                            </div>
                            <div class="flex-grow-1">
                                <strong>Chatbot Solibot</strong>
                                <div class="mt-2 p-3 bg-white rounded shadow-sm" id="previewContent">
                                    <!-- Contenido se carga dinámicamente -->
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

</div> <!-- Cierre container-fluid -->
</div> <!-- Cierre main-content -->

<script>
let optionCounter = 0;

// Actualizar formulario según el tipo seleccionado
function updateFormByType() {
    const type = document.getElementById('type').value;
    const optionsSection = document.getElementById('optionsSection');
    const urlSection = document.getElementById('urlSection');
    
    // Ocultar todas las secciones
    optionsSection.style.display = 'none';
    urlSection.style.display = 'none';
    
    // Mostrar sección según el tipo
    if (type === 'menu' || type === 'submenu') {
        optionsSection.style.display = 'block';
        if (document.getElementById('optionsContainer').children.length === 0) {
            addOption(); // Agregar primera opción automáticamente
        }
    } else if (type === 'redirect') {
        urlSection.style.display = 'block';
    }
}

// Auto-generar clave del flujo basada en el nombre
document.getElementById('name').addEventListener('input', function() {
    const flowKey = document.getElementById('flow_key');
    if (!flowKey.value) {
        const key = this.value.toLowerCase()
                              .replace(/[^a-z0-9\s]/g, '')
                              .replace(/\s+/g, '_')
                              .substring(0, 50);
        flowKey.value = key;
    }
});

// Función para manejar el cambio de acción
function handleActionChange(selectElement) {
    const optionCard = selectElement.closest('.card-body');
    const responseSection = optionCard.querySelector('.response-section');
    const valueInput = optionCard.querySelector('.value-input');
    
    if (selectElement.value === 'response') {
        // Mostrar sección de respuesta y ocultar campo de valor
        if (responseSection) responseSection.style.display = 'block';
        if (valueInput) valueInput.style.display = 'none';
    } else {
        // Ocultar sección de respuesta y mostrar campo de valor
        if (responseSection) responseSection.style.display = 'none';
        if (valueInput) valueInput.style.display = 'block';
    }
}

// Agregar nueva opción al menú
function addOption() {
    optionCounter++;
    const container = document.getElementById('optionsContainer');
    
    const optionDiv = document.createElement('div');
    optionDiv.className = 'card mb-3 border-start border-4 border-primary';
    optionDiv.innerHTML = `
        <div class="card-body p-3">
            <div class="row align-items-center">
                <div class="col-md-2">
                    <label class="form-label small text-muted mb-1">Tecla</label>
                    <input type="text" class="form-control form-control-sm" 
                           name="options[${optionCounter}][key]" 
                           placeholder="1" 
                           value="${optionCounter}">
                </div>
                <div class="col-md-5">
                    <label class="form-label small text-muted mb-1">Texto de la opción *</label>
                    <input type="text" class="form-control form-control-sm" 
                           name="options[${optionCounter}][text]" 
                           placeholder="Texto de la opción" required>
                </div>
                <div class="col-md-4">
                    <label class="form-label small text-muted mb-1">Acción</label>
                    <select class="form-select form-select-sm" name="options[${optionCounter}][action]" onchange="handleActionChange(this)">
                        <option value="submenu">Ir a submenú</option>
                        <option value="action">Ejecutar acción</option>
                        <option value="response">Respuesta directa</option>
                        <option value="advisor">Conectar asesor</option>
                        <option value="url">Abrir URL</option>
                    </select>
                </div>
                <div class="col-md-1">
                    <label class="form-label small text-muted mb-1">&nbsp;</label>
                    <button type="button" class="btn btn-sm btn-outline-danger d-block" onclick="removeOption(this)">
                        <i class="fas fa-trash"></i>
                    </button>
                </div>
            </div>
            
            <!-- Campo de valor (para URLs, IDs de submenú, etc.) -->
            <div class="row mt-2 value-input">
                <div class="col-md-12">
                    <label class="form-label small text-muted mb-1">Valor/URL/ID del submenú</label>
                    <input type="text" class="form-control form-control-sm" 
                           name="options[${optionCounter}][value]" 
                           placeholder="Valor/URL/ID del submenú (opcional)">
                </div>
            </div>
            
            <!-- Sección de respuesta directa -->
            <div class="row mt-2 response-section" style="display: none;">
                <div class="col-md-12">
                    <label class="form-label small text-muted mb-1">
                        <i class="fas fa-comment-dots text-success me-1"></i>Respuesta del chatbot *
                    </label>
                    <textarea class="form-control form-control-sm" 
                              name="options[${optionCounter}][response]" 
                              rows="3"
                              placeholder="Escribe aquí la respuesta que dará el chatbot cuando el usuario seleccione esta opción..."></textarea>
                    <div class="form-text small">
                        <i class="fas fa-info-circle text-info me-1"></i>
                        Esta respuesta se enviará inmediatamente cuando el usuario seleccione la opción ${optionCounter}
                    </div>
                </div>
            </div>
            
            <!-- Indicador visual del tipo de acción -->
            <div class="row mt-2">
                <div class="col-md-12">
                    <div class="action-indicator">
                        <span class="badge bg-secondary action-badge">Ir a submenú</span>
                    </div>
                </div>
            </div>
        </div>
    `;
    
    container.appendChild(optionDiv);
    
    // Actualizar el indicador visual
    updateActionIndicator(optionDiv.querySelector('select[name*="[action]"]'));
}

// Actualizar indicador visual de la acción
function updateActionIndicator(selectElement) {
    const optionCard = selectElement.closest('.card-body');
    const actionBadge = optionCard.querySelector('.action-badge');
    const action = selectElement.value;
    
    // Actualizar texto y color del badge
    switch(action) {
        case 'submenu':
            actionBadge.textContent = 'Ir a submenú';
            actionBadge.className = 'badge bg-primary action-badge';
            break;
        case 'action':
            actionBadge.textContent = 'Ejecutar acción';
            actionBadge.className = 'badge bg-warning action-badge';
            break;
        case 'response':
            actionBadge.textContent = 'Respuesta directa';
            actionBadge.className = 'badge bg-success action-badge';
            break;
        case 'advisor':
            actionBadge.textContent = 'Conectar asesor';
            actionBadge.className = 'badge bg-info action-badge';
            break;
        case 'url':
            actionBadge.textContent = 'Abrir URL';
            actionBadge.className = 'badge bg-secondary action-badge';
            break;
    }
}

// Modificar la función handleActionChange para incluir el indicador
function handleActionChange(selectElement) {
    const optionCard = selectElement.closest('.card-body');
    const responseSection = optionCard.querySelector('.response-section');
    const valueInput = optionCard.querySelector('.value-input');
    
    if (selectElement.value === 'response') {
        // Mostrar sección de respuesta y ocultar campo de valor
        if (responseSection) responseSection.style.display = 'block';
        if (valueInput) valueInput.style.display = 'none';
    } else {
        // Ocultar sección de respuesta y mostrar campo de valor
        if (responseSection) responseSection.style.display = 'none';
        if (valueInput) valueInput.style.display = 'block';
    }
    
    // Actualizar indicador visual
    updateActionIndicator(selectElement);
}

// Remover opción
function removeOption(button) {
    button.closest('.card').remove();
}

// Vista previa del flujo
function previewFlow() {
    const name = document.getElementById('name').value || 'Flujo Sin Nombre';
    const message = document.getElementById('message').value || 'Mensaje no configurado';
    const type = document.getElementById('type').value;
    
    let content = `<strong>${name}</strong><br><br>${message.replace(/\n/g, '<br>')}<br><br>`;
    
    if (type === 'menu' || type === 'submenu') {
        const options = document.querySelectorAll('#optionsContainer .card');
        if (options.length > 0) {
            options.forEach(option => {
                const key = option.querySelector('input[name*="[key]"]').value;
                const text = option.querySelector('input[name*="[text]"]').value;
                const action = option.querySelector('select[name*="[action]"]').value;
                const response = option.querySelector('textarea[name*="[response]"]');
                
                if (key && text) {
                    content += `${key}. ${text}`;
                    
                    // Mostrar información adicional según el tipo de acción
                    if (action === 'response' && response && response.value.trim()) {
                        content += ` <span class="text-success small">→ Respuesta configurada</span>`;
                    } else if (action === 'advisor') {
                        content += ` <span class="text-info small">→ Conecta con asesor</span>`;
                    } else if (action === 'url') {
                        content += ` <span class="text-secondary small">→ Abre enlace</span>`;
                    } else if (action === 'submenu') {
                        content += ` <span class="text-primary small">→ Va a submenú</span>`;
                    }
                    
                    content += '<br>';
                }
            });
        }
    } else if (type === 'redirect') {
        const url = document.getElementById('redirect_url').value;
        if (url) {
            content += `<a href="${url}" target="_blank">🔗 ${url}</a>`;
        }
    }
    
    document.getElementById('previewContent').innerHTML = content;
    document.getElementById('previewCard').style.display = 'block';
    
    // Scroll suave hacia la vista previa
    document.getElementById('previewCard').scrollIntoView({ 
        behavior: 'smooth', 
        block: 'nearest' 
    });
}

// Plantillas predefinidas
function loadCreditTemplate() {
    document.getElementById('flow_key').value = 'credito_menu';
    document.getElementById('name').value = 'Menú de Crédito';
    document.getElementById('type').value = 'submenu';
    document.getElementById('description').value = 'Opciones relacionadas con servicios de crédito';
    document.getElementById('message').value = '💳 *SERVICIOS DE CRÉDITO*\n\nSelecciona la opción que necesitas:';
    
    updateFormByType();
    
    // Limpiar opciones existentes
    document.getElementById('optionsContainer').innerHTML = '';
    optionCounter = 0;
    
    // Agregar opciones predefinidas
    const options = [
        { key: '1', text: 'Información sobre créditos disponibles', action: 'response', response: '📋 *INFORMACIÓN DE CRÉDITOS*\n\nContamos con los siguientes tipos de crédito:\n\n• Crédito de libre inversión\n• Crédito de vehículo\n• Crédito educativo\n• Crédito de vivienda\n\n¿Te interesa alguno en particular? Puedes contactar a un asesor digitando *asesor* o visitar nuestra página web.' },
        { key: '2', text: 'Descargar reglamento de crédito', action: 'url' },
        { key: '3', text: 'Radicar solicitud de crédito', action: 'action' },
        { key: '4', text: 'Comunicar con un asesor', action: 'advisor' },
        { key: '0', text: 'Volver al menú principal', action: 'submenu' }
    ];
    
    options.forEach(opt => {
        addOption();
        const lastOption = document.querySelector('#optionsContainer .card:last-child');
        lastOption.querySelector('input[name*="[key]"]').value = opt.key;
        lastOption.querySelector('input[name*="[text]"]').value = opt.text;
        const actionSelect = lastOption.querySelector('select[name*="[action]"]');
        actionSelect.value = opt.action;
        handleActionChange(actionSelect);
        
        if (opt.response) {
            const responseTextarea = lastOption.querySelector('textarea[name*="[response]"]');
            if (responseTextarea) {
                responseTextarea.value = opt.response;
            }
        }
    });
}

function loadCarteraTemplate() {
    document.getElementById('flow_key').value = 'cartera_menu';
    document.getElementById('name').value = 'Menú de Cartera';
    document.getElementById('type').value = 'submenu';
    document.getElementById('description').value = 'Opciones para consultas de cartera y estados de cuenta';
    document.getElementById('message').value = '💰 *SERVICIOS DE CARTERA*\n\nSelecciona la opción que necesitas:';
    
    updateFormByType();
    
    document.getElementById('optionsContainer').innerHTML = '';
    optionCounter = 0;
    
    const options = [
        { key: '1', text: 'Consultar saldo actual', action: 'response', response: '💰 *CONSULTA DE SALDO*\n\nPara consultar tu saldo actual, puedes:\n\n• Usar nuestra app móvil\n• Ingresar a la página web\n• Llamar a nuestra línea de atención\n• Visitar cualquiera de nuestras oficinas\n\n¿Necesitas ayuda con alguna de estas opciones? Contacta un asesor digitando *asesor*' },
        { key: '2', text: 'Descargar estado de cuenta', action: 'url' },
        { key: '3', text: 'Comunicar con un asesor', action: 'advisor' },
        { key: '0', text: 'Volver al menú principal', action: 'submenu' }
    ];
    
    options.forEach(opt => {
        addOption();
        const lastOption = document.querySelector('#optionsContainer .card:last-child');
        lastOption.querySelector('input[name*="[key]"]').value = opt.key;
        lastOption.querySelector('input[name*="[text]"]').value = opt.text;
        const actionSelect = lastOption.querySelector('select[name*="[action]"]');
        actionSelect.value = opt.action;
        handleActionChange(actionSelect);
        
        if (opt.response) {
            const responseTextarea = lastOption.querySelector('textarea[name*="[response]"]');
            if (responseTextarea) {
                responseTextarea.value = opt.response;
            }
        }
    });
}

function loadAhorrosTemplate() {
    document.getElementById('flow_key').value = 'ahorros_menu';
    document.getElementById('name').value = 'Menú de Ahorros y CDAT';
    document.getElementById('type').value = 'submenu';
    document.getElementById('description').value = 'Servicios de ahorros y certificados de depósito';
    document.getElementById('message').value = '🏦 *AHORROS Y CDAT*\n\nSelecciona la opción que necesitas:';
    
    updateFormByType();
    
    document.getElementById('optionsContainer').innerHTML = '';
    optionCounter = 0;
    
    const options = [
        { key: '1', text: 'Información sobre productos de ahorro', action: 'response', response: '🏦 *PRODUCTOS DE AHORRO*\n\nTenemos estas opciones para ti:\n\n• **Cuenta de Ahorros:** Sin cuota de manejo\n• **CDAT:** Certificados desde $100.000\n• **Ahorro Programado:** Cumple tus metas\n• **Ahorro Navideño:** Para diciembre\n\n¿Quieres más información? Contacta un asesor digitando *asesor*' },
        { key: '2', text: 'Consultar reglamento de ahorro', action: 'url' },
        { key: '3', text: 'Descargar estado de cuenta de ahorros', action: 'url' },
        { key: '4', text: 'Comunicar con un asesor', action: 'advisor' },
        { key: '0', text: 'Volver al menú principal', action: 'submenu' }
    ];
    
    options.forEach(opt => {
        addOption();
        const lastOption = document.querySelector('#optionsContainer .card:last-child');
        lastOption.querySelector('input[name*="[key]"]').value = opt.key;
        lastOption.querySelector('input[name*="[text]"]').value = opt.text;
        const actionSelect = lastOption.querySelector('select[name*="[action]"]');
        actionSelect.value = opt.action;
        handleActionChange(actionSelect);
        
        if (opt.response) {
            const responseTextarea = lastOption.querySelector('textarea[name*="[response]"]');
            if (responseTextarea) {
                responseTextarea.value = opt.response;
            }
        }
    });
}

function loadAuxiliosTemplate() {
    document.getElementById('flow_key').value = 'auxilios_menu';
    document.getElementById('name').value = 'Menú de Auxilios';
    document.getElementById('type').value = 'submenu';
    document.getElementById('description').value = 'Servicios de auxilios y beneficios';
    document.getElementById('message').value = '🤝 *SERVICIOS DE AUXILIOS*\n\nSelecciona la opción que necesitas:';
    
    updateFormByType();
    
    document.getElementById('optionsContainer').innerHTML = '';
    optionCounter = 0;
    
    const options = [
        { key: '1', text: 'Información sobre auxilios disponibles', action: 'response', response: '🤝 *AUXILIOS DISPONIBLES*\n\nOfrecemos estos auxilios:\n\n• **Auxilio de Anteojos:** Hasta $200.000\n• **Auxilio Odontológico:** Hasta $300.000\n• **Auxilio de Calamidad:** Casos especiales\n• **Auxilio Educativo:** Para hijos asociados\n\nPara aplicar, contacta un asesor digitando *asesor*' },
        { key: '2', text: 'Descargar reglamento de auxilios', action: 'url' },
        { key: '3', text: 'Consultar estado de solicitudes', action: 'action' },
        { key: '4', text: 'Comunicar con un asesor', action: 'advisor' },
        { key: '0', text: 'Volver al menú principal', action: 'submenu' }
    ];
    
    options.forEach(opt => {
        addOption();
        const lastOption = document.querySelector('#optionsContainer .card:last-child');
        lastOption.querySelector('input[name*="[key]"]').value = opt.key;
        lastOption.querySelector('input[name*="[text]"]').value = opt.text;
        const actionSelect = lastOption.querySelector('select[name*="[action]"]');
        actionSelect.value = opt.action;
        handleActionChange(actionSelect);
        
        if (opt.response) {
            const responseTextarea = lastOption.querySelector('textarea[name*="[response]"]');
            if (responseTextarea) {
                responseTextarea.value = opt.response;
            }
        }
    });
}

function loadOtrosTemplate() {
    document.getElementById('flow_key').value = 'otros_menu';
    document.getElementById('name').value = 'Otros Servicios';
    document.getElementById('type').value = 'submenu';
    document.getElementById('description').value = 'Otros servicios y consultas generales';
    document.getElementById('message').value = '📋 *OTROS SERVICIOS*\n\nPor favor, describe brevemente tu solicitud o selecciona una opción:';
    
    updateFormByType();
    
    document.getElementById('optionsContainer').innerHTML = '';
    optionCounter = 0;
    
    const options = [
        { key: '1', text: 'Horarios de atención', action: 'response', response: '🕒 *HORARIOS DE ATENCIÓN*\n\n**Oficinas:**\nLunes a Viernes: 8:00 AM - 5:00 PM\nSábados: 8:00 AM - 12:00 PM\n\n**Línea telefónica:**\nLunes a Viernes: 7:00 AM - 7:00 PM\nSábados: 8:00 AM - 2:00 PM\n\n**Página web y app:** 24/7\n\n¿Necesitas más información? Contacta un asesor digitando *asesor*' },
        { key: '2', text: 'Información general', action: 'action' },
        { key: '3', text: 'Comunicar con un asesor', action: 'advisor' },
        { key: '0', text: 'Volver al menú principal', action: 'submenu' }
    ];
    
    options.forEach(opt => {
        addOption();
        const lastOption = document.querySelector('#optionsContainer .card:last-child');
        lastOption.querySelector('input[name*="[key]"]').value = opt.key;
        lastOption.querySelector('input[name*="[text]"]').value = opt.text;
        const actionSelect = lastOption.querySelector('select[name*="[action]"]');
        actionSelect.value = opt.action;
        handleActionChange(actionSelect);
        
        if (opt.response) {
            const responseTextarea = lastOption.querySelector('textarea[name*="[response]"]');
            if (responseTextarea) {
                responseTextarea.value = opt.response;
            }
        }
    });
}

// Validación del formulario
document.getElementById('flowForm').addEventListener('submit', function(e) {
    const type = document.getElementById('type').value;
    const message = document.getElementById('message').value.trim();
    const flowKey = document.getElementById('flow_key').value.trim();
    
    if (!flowKey) {
        e.preventDefault();
        alert('La clave del flujo es obligatoria');
        return;
    }
    
    if (!message) {
        e.preventDefault();
        alert('El mensaje del chatbot es obligatorio');
        return;
    }
    
    if (type === 'redirect') {
        const url = document.getElementById('redirect_url').value.trim();
        if (!url) {
            e.preventDefault();
            alert('La URL de destino es obligatoria para redirecciones');
            return;
        }
    }
    
    if ((type === 'menu' || type === 'submenu')) {
        const options = document.querySelectorAll('#optionsContainer .card');
        if (options.length === 0) {
            e.preventDefault();
            alert('Debes agregar al menos una opción para los menús');
            return;
        }
        
        // Validar que todas las opciones tengan texto
        let hasEmptyOption = false;
        let hasEmptyResponse = false;
        
        options.forEach(option => {
            const text = option.querySelector('input[name*="[text]"]').value.trim();
            const action = option.querySelector('select[name*="[action]"]').value;
            const response = option.querySelector('textarea[name*="[response]"]');
            
            if (!text) {
                hasEmptyOption = true;
            }
            
            // Validar que las respuestas directas tengan contenido
            if (action === 'response' && response && !response.value.trim()) {
                hasEmptyResponse = true;
            }
        });
        
        if (hasEmptyOption) {
            e.preventDefault();
            alert('Todas las opciones deben tener texto');
            return;
        }
        
        if (hasEmptyResponse) {
            e.preventDefault();
            alert('Las opciones con "Respuesta directa" deben tener un mensaje configurado');
            return;
        }
    }
});

// Auto-preview mientras escribe
document.getElementById('message').addEventListener('input', function() {
    if (this.value.trim() && document.getElementById('previewCard').style.display !== 'none') {
        previewFlow();
    }
});
</script>

</body>
</html>