<?= $this->include('templates/sidebar'); ?>

<div class="fade-in">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h2><i class="fas fa-project-diagram text-primary me-2"></i>Gestión de Flujos de Menú</h2>
            <p class="text-muted">Configura los menús interactivos del chatbot para cada servicio</p>
        </div>
        <a href="<?= base_url('admin/flows/create') ?>" class="btn btn-primary">
            <i class="fas fa-plus me-2"></i>Crear Nuevo Flujo
        </a>
    </div>

    <!-- Estadísticas de flujos -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card bg-primary text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h4><?= $stats['total'] ?? 0 ?></h4>
                            <p class="mb-0">Total Flujos</p>
                        </div>
                        <i class="fas fa-project-diagram fa-2x opacity-50"></i>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-success text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h4><?= $stats['active'] ?? 0 ?></h4>
                            <p class="mb-0">Flujos Activos</p>
                        </div>
                        <i class="fas fa-check-circle fa-2x opacity-50"></i>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-info text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h4><?= $stats['menus'] ?? 0 ?></h4>
                            <p class="mb-0">Menús Principales</p>
                        </div>
                        <i class="fas fa-list fa-2x opacity-50"></i>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-warning text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h4><?= $stats['submenus'] ?? 0 ?></h4>
                            <p class="mb-0">Submenús</p>
                        </div>
                        <i class="fas fa-indent fa-2x opacity-50"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filtros -->
    <div class="card mb-4">
        <div class="card-body">
            <div class="row">
                <div class="col-md-4">
                    <input type="text" id="searchFlows" class="form-control" placeholder="🔍 Buscar flujos...">
                </div>
                <div class="col-md-3">
                    <select id="filterType" class="form-select">
                        <option value="">Todos los tipos</option>
                        <option value="menu">Menú Principal</option>
                        <option value="submenu">Submenú</option>
                        <option value="action">Acción</option>
                        <option value="redirect">Redirección</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <select id="filterStatus" class="form-select">
                        <option value="">Todos los estados</option>
                        <option value="1">Activos</option>
                        <option value="0">Inactivos</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <button class="btn btn-outline-secondary w-100" onclick="clearFilters()">
                        <i class="fas fa-times me-1"></i>Limpiar
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Lista de flujos -->
    <div class="card">
        <div class="card-header">
            <h5 class="mb-0"><i class="fas fa-list me-2"></i>Flujos Configurados</h5>
        </div>
        <div class="card-body">
            <?php if (!empty($flows)): ?>
                <div class="row" id="flowsContainer">
                    <?php foreach ($flows as $flow): ?>
                        <div class="col-md-6 col-lg-4 mb-4 flow-item" 
                             data-type="<?= $flow['type'] ?>" 
                             data-status="<?= $flow['is_active'] ? '1' : '0' ?>"
                             data-name="<?= strtolower($flow['name']) ?>"
                             data-flow-id="<?= $flow['id'] ?>">
                            <div class="card h-100 flow-card">
                                <div class="card-header d-flex justify-content-between align-items-center">
                                    <div class="d-flex align-items-center">
                                        <?php
                                        $typeIcons = [
                                            'menu' => 'fas fa-list text-primary',
                                            'submenu' => 'fas fa-indent text-info',
                                            'action' => 'fas fa-cog text-success',
                                            'redirect' => 'fas fa-external-link-alt text-warning'
                                        ];
                                        $icon = $typeIcons[$flow['type']] ?? 'fas fa-question text-secondary';
                                        ?>
                                        <i class="<?= $icon ?> me-2"></i>
                                        <strong><?= htmlspecialchars($flow['name']) ?></strong>
                                    </div>
                                    <div class="form-check form-switch">
                                        <input class="form-check-input" type="checkbox" 
                                               <?= $flow['is_active'] ? 'checked' : '' ?>
                                               onchange="toggleFlowStatus('<?= $flow['id'] ?>', this.checked)">
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="mb-2">
                                        <span class="badge bg-<?= $flow['is_active'] ? 'success' : 'secondary' ?>">
                                            <?= $flow['is_active'] ? 'Activo' : 'Inactivo' ?>
                                        </span>
                                        <span class="badge bg-light text-dark ms-1">
                                            <?= ucfirst($flow['type']) ?>
                                        </span>
                                        <?php if ($flow['requires_advisor']): ?>
                                            <span class="badge bg-warning ms-1">Requiere Asesor</span>
                                        <?php endif; ?>
                                    </div>
                                    
                                    <?php if (!empty($flow['description'])): ?>
                                        <p class="text-muted small mb-2">
                                            <?= htmlspecialchars(substr($flow['description'], 0, 100)) ?>
                                            <?= strlen($flow['description']) > 100 ? '...' : '' ?>
                                        </p>
                                    <?php endif; ?>

                                    <?php if (!empty($flow['options'])): ?>
                                        <div class="mb-2">
                                            <small class="text-muted">Opciones:</small>
                                            <div class="mt-1">
                                                <?php 
                                                // Asegurar que options sea un array
                                                $options = $flow['options'];
                                                if (is_string($options)) {
                                                    $options = json_decode($options, true);
                                                }
                                                if (!is_array($options)) {
                                                    $options = [];
                                                }
                                                $displayOptions = array_slice($options, 0, 3);
                                                ?>
                                                <?php foreach ($displayOptions as $option): ?>
                                                    <?php if (is_array($option) && isset($option['key']) && isset($option['text'])): ?>
                                                        <span class="badge bg-light text-dark me-1 mb-1">
                                                            <?= htmlspecialchars($option['key']) ?>. <?= htmlspecialchars($option['text']) ?>
                                                        </span>
                                                    <?php endif; ?>
                                                <?php endforeach; ?>
                                                <?php if (count($options) > 3): ?>
                                                    <span class="text-muted small">+<?= count($options) - 3 ?> más</span>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    <?php endif; ?>

                                    <small class="text-muted">
                                        <i class="fas fa-clock me-1"></i>
                                        Actualizado: <?= date('d/m/Y H:i', strtotime($flow['updated_at'])) ?>
                                    </small>
                                </div>
                                <div class="card-footer">
                                    <div class="btn-group w-100" role="group">
                                        <button type="button" class="btn btn-outline-primary btn-sm" 
                                                onclick="editFlow('<?= $flow['id'] ?>')" title="Editar">
                                            <i class="fas fa-edit"></i>
                                        </button>
                                        <button type="button" class="btn btn-outline-info btn-sm" 
                                                onclick="previewFlow(<?= htmlspecialchars(json_encode($flow)) ?>)" title="Vista previa">
                                            <i class="fas fa-eye"></i>
                                        </button>
                                        <button type="button" class="btn btn-outline-success btn-sm" 
                                                onclick="duplicateFlow('<?= $flow['id'] ?>')" title="Duplicar">
                                            <i class="fas fa-copy"></i>
                                        </button>
                                        <button type="button" class="btn btn-outline-danger btn-sm" 
                                                onclick="deleteFlow('<?= $flow['id'] ?>', '<?= htmlspecialchars($flow['name']) ?>')" title="Eliminar">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php else: ?>
                <div class="text-center py-5">
                    <i class="fas fa-project-diagram fa-3x text-muted mb-3"></i>
                    <h5 class="text-muted">No hay flujos configurados</h5>
                    <p class="text-muted">Crea tu primer flujo para comenzar a configurar los menús del chatbot</p>
                    <a href="<?= base_url('admin/flows/create') ?>" class="btn btn-primary">
                        <i class="fas fa-plus me-2"></i>Crear Primer Flujo
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Información adicional -->
    <div class="row mt-4">
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h6 class="mb-0"><i class="fas fa-info-circle me-2"></i>¿Qué son los flujos?</h6>
                </div>
                <div class="card-body">
                    <p class="mb-2">Los flujos definen la estructura de menús interactivos del chatbot:</p>
                    <ul class="list-unstyled">
                        <li><i class="fas fa-check text-success me-2"></i><strong>Menú Principal:</strong> Opciones principales del chatbot</li>
                        <li><i class="fas fa-check text-success me-2"></i><strong>Submenús:</strong> Opciones secundarias organizadas</li>
                        <li><i class="fas fa-check text-success me-2"></i><strong>Acciones:</strong> Respuestas automáticas específicas</li>
                        <li><i class="fas fa-check text-success me-2"></i><strong>Redirecciones:</strong> Enlaces a recursos externos</li>
                    </ul>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h6 class="mb-0"><i class="fas fa-lightbulb me-2"></i>Estructura Recomendada</h6>
                </div>
                <div class="card-body">
                    <div class="small">
                        <div class="mb-2">
                            <strong>1. Crédito</strong>
                            <div class="ms-3 text-muted">
                                • Descargar reglamento<br>
                                • Radicar solicitud<br>
                                • Comunicar asesor
                            </div>
                        </div>
                        <div class="mb-2">
                            <strong>2. Cartera</strong>
                            <div class="ms-3 text-muted">
                                • Estado de cuenta<br>
                                • Comunicar asesor
                            </div>
                        </div>
                        <div class="mb-2">
                            <strong>3. Ahorros y CDAT</strong>
                            <div class="ms-3 text-muted">
                                • Consultar reglamento<br>
                                • Estado de cuenta
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal para vista previa -->
<div class="modal fade" id="previewModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Vista Previa del Flujo</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="border rounded p-3 bg-light">
                    <div class="d-flex align-items-start">
                        <div class="bg-primary rounded-circle p-2 me-3">
                            <i class="fas fa-robot text-white"></i>
                        </div>
                        <div class="flex-grow-1">
                            <strong>Chatbot Solibot</strong>
                            <div class="mt-2 p-3 bg-white rounded shadow-sm" id="previewContent">
                                <!-- Contenido se carga dinámicamente -->
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
            </div>
        </div>
    </div>
</div>

</div> <!-- Cierre container-fluid -->
</div> <!-- Cierre main-content -->

<script>
// Filtros y búsqueda
document.getElementById('searchFlows').addEventListener('input', filterFlows);
document.getElementById('filterType').addEventListener('change', filterFlows);
document.getElementById('filterStatus').addEventListener('change', filterFlows);

function filterFlows() {
    const searchTerm = document.getElementById('searchFlows').value.toLowerCase();
    const typeFilter = document.getElementById('filterType').value;
    const statusFilter = document.getElementById('filterStatus').value;
    
    const flowItems = document.querySelectorAll('.flow-item');
    
    flowItems.forEach(item => {
        const name = item.dataset.name;
        const type = item.dataset.type;
        const status = item.dataset.status;
        
        const matchesSearch = name.includes(searchTerm);
        const matchesType = !typeFilter || type === typeFilter;
        const matchesStatus = !statusFilter || status === statusFilter;
        
        if (matchesSearch && matchesType && matchesStatus) {
            item.style.display = 'block';
        } else {
            item.style.display = 'none';
        }
    });
}

function clearFilters() {
    document.getElementById('searchFlows').value = '';
    document.getElementById('filterType').value = '';
    document.getElementById('filterStatus').value = '';
    filterFlows();
}

// Funciones de gestión de flujos
function editFlow(flowId) {
    window.location.href = `<?= base_url('admin/flows/edit/') ?>${flowId}`;
}

function deleteFlow(flowId, flowName) {
    if (confirm(`¿Estás seguro de eliminar el flujo "${flowName}"?\n\nEsta acción no se puede deshacer.`)) {
        window.location.href = `<?= base_url('admin/flows/delete/') ?>${flowId}`;
    }
}

function duplicateFlow(flowId) {
    if (confirm('¿Deseas crear una copia de este flujo?')) {
        window.location.href = `<?= base_url('admin/flows/duplicate/') ?>${flowId}`;
    }
}

function toggleFlowStatus(flowId, isActive) {
    fetch(`<?= base_url('admin/flows/toggle-status') ?>`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-Requested-With': 'XMLHttpRequest'
        },
        body: JSON.stringify({
            flow_id: flowId,
            active: isActive
        })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            showNotification('Estado del flujo actualizado', 'success');
            // Actualizar badge
            const flowCard = document.querySelector(`[data-flow-id="${flowId}"]`);
            if (flowCard) {
                const badge = flowCard.querySelector('.badge');
                if (isActive) {
                    badge.className = 'badge bg-success';
                    badge.textContent = 'Activo';
                    flowCard.dataset.status = '1';
                } else {
                    badge.className = 'badge bg-secondary';
                    badge.textContent = 'Inactivo';
                    flowCard.dataset.status = '0';
                }
            }
        } else {
            showNotification('Error al actualizar el estado', 'error');
        }
    })
    .catch(error => {
        showNotification('Error de conexión', 'error');
    });
}

function previewFlow(flowData) {
    const flow = typeof flowData === 'string' ? JSON.parse(flowData) : flowData;
    
    let content = `<strong>${flow.name}</strong><br><br>`;
    content += flow.message.replace(/\n/g, '<br>');
    
    if (flow.options && Array.isArray(flow.options) && flow.options.length > 0) {
        content += '<br><br>';
        flow.options.forEach(option => {
            if (option && option.key && option.text) {
                content += `${option.key}. ${option.text}<br>`;
            }
        });
    }
    
    document.getElementById('previewContent').innerHTML = content;
    new bootstrap.Modal(document.getElementById('previewModal')).show();
}

// Mostrar notificaciones
function showNotification(message, type) {
    const notification = document.createElement('div');
    notification.className = `alert alert-${type === 'success' ? 'success' : type === 'error' ? 'danger' : 'info'} alert-dismissible fade show position-fixed`;
    notification.style.cssText = 'top: 20px; right: 20px; z-index: 9999; min-width: 300px;';
    notification.innerHTML = `
        ${message}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    `;
    
    document.body.appendChild(notification);
    
    setTimeout(() => {
        if (notification.parentNode) {
            notification.remove();
        }
    }, 5000);
}

// Mostrar notificaciones de sesión
<?php if (session()->getFlashdata('success')): ?>
    showNotification('<?= session()->getFlashdata('success') ?>', 'success');
<?php endif; ?>

<?php if (session()->getFlashdata('error')): ?>
    showNotification('<?= session()->getFlashdata('error') ?>', 'error');
<?php endif; ?>

// Animaciones de las tarjetas
document.querySelectorAll('.flow-card').forEach(card => {
    card.addEventListener('mouseenter', function() {
        this.style.transform = 'translateY(-5px)';
        this.style.boxShadow = '0 8px 25px rgba(0,0,0,0.15)';
    });
    
    card.addEventListener('mouseleave', function() {
        this.style.transform = 'translateY(0)';
        this.style.boxShadow = '';
    });
});
</script>

<style>
.flow-card {
    transition: all 0.3s ease;
    border: 1px solid #e0e0e0;
}

.flow-card:hover {
    border-color: #00d4ff;
}

.form-check-input:checked {
    background-color: #00d4ff;
    border-color: #00d4ff;
}

.badge {
    font-size: 0.75rem;
}

.btn-group .btn {
    flex: 1;
}

.card-header {
    background-color: #f8f9fa;
    border-bottom: 1px solid #e0e0e0;
}

.flow-item {
    transition: all 0.3s ease;
}

.flow-item[style*="display: none"] {
    opacity: 0;
    transform: scale(0.8);
}
</style>

</body>
</html>