<?= $this->include('templates/sidebar'); ?>

<div class="fade-in">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h2><i class="fas fa-cogs text-primary me-2"></i>Administración del Sistema</h2>
            <p class="text-muted">Configura las integraciones y parámetros del chatbot multi-plataforma</p>
        </div>
    </div>

    <!-- Pestañas de configuración con colores -->
    <ul class="nav nav-tabs nav-tabs-colorful" id="configTabs" role="tablist">
        <li class="nav-item" role="presentation">
            <button class="nav-link active nav-whatsapp" id="whatsapp-tab" data-bs-toggle="tab" data-bs-target="#whatsapp" type="button" role="tab" aria-controls="whatsapp" aria-selected="true">
                <i class="fab fa-whatsapp me-2"></i>WhatsApp
            </button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link nav-telegram" id="telegram-tab" data-bs-toggle="tab" data-bs-target="#telegram" type="button" role="tab" aria-controls="telegram" aria-selected="false">
                <i class="fab fa-telegram me-2"></i>Telegram
            </button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link nav-instagram" id="instagram-tab" data-bs-toggle="tab" data-bs-target="#instagram" type="button" role="tab" aria-controls="instagram" aria-selected="false">
                <i class="fab fa-instagram me-2"></i>Instagram
            </button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link nav-general" id="general-tab" data-bs-toggle="tab" data-bs-target="#general" type="button" role="tab" aria-controls="general" aria-selected="false">
                <i class="fas fa-project-diagram me-2"></i>Asignar Asesores
            </button>
        </li>
    </ul>

    <div class="tab-content" id="configTabsContent">
        <!-- Configuración WhatsApp -->
        <div class="tab-pane fade show active" id="whatsapp" role="tabpanel" aria-labelledby="whatsapp-tab">
            <div class="card mt-3 border-success">
                <div class="card-header bg-success text-white">
                    <h5 class="mb-0">
                        <i class="fab fa-whatsapp me-2"></i>
                        🟢 Configuración de WhatsApp Business API
                    </h5>
                </div>
                <div class="card-body">
                    <?php
                    $whatsappConfig = [];
                    $configFile = WRITEPATH . 'whatsapp_config.json';
                    if (file_exists($configFile)) {
                        $whatsappConfig = json_decode(file_get_contents($configFile), true);
                    }
                    ?>
                    
                    <form action="<?= base_url('admin/management/whatsapp') ?>" method="POST">
                        <?= csrf_field() ?>

                        <div class="mb-3">
                            <label class="form-label text-success fw-bold">
                                <i class="fas fa-globe me-1"></i>🌐 URL del Webhook
                            </label>
                            <div class="input-group">
                                <input type="text" id="webhook_url" class="form-control border-success" readonly 
                                  value="<?= base_url('conversations/webhook') ?>">

                                <button class="btn btn-success" type="button" onclick="copyToClipboard('<?= base_url('conversations/webhook') ?>')">
                                    <i class="fas fa-copy"></i> 📋
                                </button>
                            </div>
                            <div class="form-text text-success">Configura esta URL en tu panel de WhatsApp Business</div>
                        </div>

                        <div class="d-flex justify-content-between">
                            <button type="button" class="btn btn-outline-success" onclick="testWhatsAppConnection()">
                                <i class="fas fa-vial me-2"></i>🧪 Probar Conexión
                            </button>
                            <button type="submit" class="btn btn-success">
                                <i class="fas fa-save me-2"></i>💾 Guardar Configuración
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- Configuración Telegram -->
        <div class="tab-pane fade" id="telegram" role="tabpanel" aria-labelledby="telegram-tab">
            <div class="card mt-3 border-primary">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0">
                        <i class="fab fa-telegram me-2"></i>
                        🔵 Configuración de Telegram Bot
                    </h5>
                </div>
                <div class="card-body">
                    <?php
                    $telegramConfig = [];
                    $configFile = WRITEPATH . 'telegram_config.json';
                    if (file_exists($configFile)) {
                        $telegramConfig = json_decode(file_get_contents($configFile), true);
                    }
                    ?>
                    
                    <form action="<?= base_url('admin/management/telegram') ?>" method="POST">
                        <?= csrf_field() ?>
                        
                        <div class="mb-3">
                            <label for="bot_token" class="form-label text-primary fw-bold">
                                <i class="fas fa-robot me-1"></i>🤖 Token del Bot
                            </label>
                            <input type="text" class="form-control border-primary" id="bot_token" name="bot_token" 
                                   value="<?= $telegramConfig['bot_token'] ?? '' ?>"
                                   placeholder="123456789:ABCdefGHIjklMNOpqrsTUVwxyz">
                            <div class="form-text text-primary">Token proporcionado por @BotFather</div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label text-primary fw-bold">
                                <i class="fas fa-globe me-1"></i>🌐 URL del Webhook
                            </label>
                            <div class="input-group">
                                <input type="text" class="form-control border-primary" readonly 
                                       value="<?= base_url('webhook/telegram') ?>">
                                <button class="btn btn-primary" type="button" onclick="copyToClipboard('<?= base_url('webhook/telegram') ?>')">
                                    <i class="fas fa-copy"></i> 📋
                                </button>
                            </div>
                            <div class="form-text text-primary">Configura esta URL como webhook en Telegram</div>
                        </div>

                        <div class="alert alert-info border-primary">
                            <h6><i class="fas fa-info-circle me-2 text-primary"></i>📋 Instrucciones:</h6>
                            <ol class="mb-0">
                                <li>🤖 Crea un bot con @BotFather en Telegram</li>
                                <li>📝 Copia el token del bot aquí</li>
                                <li>💾 Guarda la configuración</li>
                                <li>⚙️ El webhook se configurará automáticamente</li>
                            </ol>
                        </div>

                        <div class="d-flex justify-content-between">
                            <button type="button" class="btn btn-outline-primary" onclick="testTelegramConnection()">
                                <i class="fas fa-vial me-2"></i>🧪 Probar Conexión
                            </button>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save me-2"></i>💾 Guardar Configuración
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- Configuración Instagram -->
        <div class="tab-pane fade" id="instagram" role="tabpanel" aria-labelledby="instagram-tab">
            <div class="card mt-3 border-danger">
                <div class="card-header bg-danger text-white">
                    <h5 class="mb-0">
                        <i class="fab fa-instagram me-2"></i>
                        🔴 Configuración de Instagram Graph API
                    </h5>
                </div>
                <div class="card-body">
                    <?php
                    $instagramConfig = [];
                    $configFile = WRITEPATH . 'instagram_config.json';
                    if (file_exists($configFile)) {
                        $instagramConfig = json_decode(file_get_contents($configFile), true);
                    }
                    ?>
                    
                    <form action="<?= base_url('admin/management/instagram') ?>" method="POST">
                        <?= csrf_field() ?>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="app_id" class="form-label text-danger fw-bold">
                                        <i class="fas fa-id-card me-1"></i>🆔 App ID
                                    </label>
                                    <input type="text" class="form-control border-danger" id="app_id" name="app_id" 
                                           value="<?= $instagramConfig['app_id'] ?? '' ?>"
                                           placeholder="123456789012345">
                                    <div class="form-text text-danger">ID de la aplicación de Facebook</div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="app_secret" class="form-label text-danger fw-bold">
                                        <i class="fas fa-lock me-1"></i>🔒 App Secret
                                    </label>
                                    <input type="password" class="form-control border-danger" id="app_secret" name="app_secret" 
                                           value="<?= $instagramConfig['app_secret'] ?? '' ?>"
                                           placeholder="tu_app_secret">
                                    <div class="form-text text-danger">Secreto de la aplicación</div>
                                </div>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label for="access_token" class="form-label text-danger fw-bold">
                                <i class="fas fa-key me-1"></i>🔑 Access Token
                            </label>
                            <textarea class="form-control border-danger" id="access_token" name="access_token" rows="3"
                                      placeholder="Tu access token de Instagram"><?= $instagramConfig['access_token'] ?? '' ?></textarea>
                            <div class="form-text text-danger">Token de acceso para Instagram Graph API</div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label text-danger fw-bold">
                                <i class="fas fa-globe me-1"></i>🌐 URL del Webhook
                            </label>
                            <div class="input-group">
                                <input type="text" class="form-control border-danger" readonly 
                                       value="<?= base_url('webhook/instagram') ?>">
                                <button class="btn btn-danger" type="button" onclick="copyToClipboard('<?= base_url('webhook/instagram') ?>')">
                                    <i class="fas fa-copy"></i> 📋
                                </button>
                            </div>
                            <div class="form-text text-danger">Configura esta URL en Facebook Developers</div>
                        </div>

                        <div class="alert alert-warning border-warning">
                            <h6><i class="fas fa-exclamation-triangle me-2 text-warning"></i>⚠️ Nota:</h6>
                            <p class="mb-0">Instagram requiere una cuenta de negocio y aprobación de Facebook para usar la API de mensajería.</p>
                        </div>

                        <div class="d-flex justify-content-between">
                            <button type="button" class="btn btn-outline-danger" onclick="testInstagramConnection()">
                                <i class="fas fa-vial me-2"></i>🧪 Probar Conexión
                            </button>
                            <button type="submit" class="btn btn-danger">
                                <i class="fas fa-save me-2"></i>💾 Guardar Configuración
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- Gestión de Flujos y Asignaciones -->
        <div class="tab-pane fade" id="general" role="tabpanel" aria-labelledby="general-tab">
            <div class="card mt-3 border-info">
                <div class="card-header bg-info text-white">
                    <h5 class="mb-0">
                        <i class="fas fa-project-diagram me-2"></i>
                        🔄 Gestión de Flujos y Asignación de Usuarios
                    </h5>
                </div>
                <div class="card-body">
                    <!-- Sección de Flujos Activos desde BD -->
                    <div class="row">
                        <div class="col-md-12">
                            <div class="card border-primary mb-4 d-none" id="flow-card">
                                <div class="card-header bg-primary text-white">
                                    <h6 class="mb-0">
                                        <i class="fas fa-sitemap me-2"></i>📊 Flujos Configurados en Base de Datos
                                    </h6>
                                </div>
                                <div class="card-body">
                                    <?php
                                    // Obtener flujos desde la base de datos de forma segura
                                    try {
                                        $flowModel = new \App\Models\FlowModel();
                                        $allFlows = $flowModel->orderBy('order_index', 'ASC')->findAll();
                                        
                                        $menuFlows = [];
                                        $submenuFlows = [];
                                        
                                        foreach ($allFlows as $flow) {
                                            if ($flow['type'] === 'menu') {
                                                $menuFlows[] = $flow;
                                            } elseif ($flow['type'] === 'submenu') {
                                                $submenuFlows[] = $flow;
                                            }
                                        }
                                    } catch (\Exception $e) {
                                        $menuFlows = [];
                                        $submenuFlows = [];
                                        log_message('error', 'Error al obtener flujos: ' . $e->getMessage());
                                    }
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Asignación de Usuarios a Submenús -->
                    <div class="row">
                        <div class="col-md-12">
                            <div class="card border-info">
                                <div class="card-header bg-info text-white">
                                    <h6 class="mb-0">
                                        <i class="fas fa-users-cog me-2"></i>👥 Asignación de Asesores por Menú
                                    </h6>
                                </div>
                                <div class="card-body">
                                    <div class="alert alert-info">
                                        <i class="fas fa-info-circle me-2"></i>
                                        <strong>Configura qué asesores recibirán los mensajes de cada Menú cuando los usuarios soliciten atención humana.</strong>
                                    </div>

                                    <?php
                                    // Obtener asesores reales de la base de datos de forma segura
                                    try {
                                        $userModel = new \App\Models\UserModel();
                                        $advisors = $userModel->where('role', 'advisor')->findAll();
                                    } catch (\Exception $e) {
                                        $advisors = [];
                                        log_message('error', 'Error al obtener asesores: ' . $e->getMessage());
                                    }
                                    ?>

                                    <!-- FORMULARIO CORREGIDO CON SCROLL -->
                                    <?php if (!empty($submenuFlows)): ?>
                                        <?php 
                                        $colors = ['primary', 'success', 'warning', 'danger', 'info', 'secondary'];
                                        $colorIndex = 0;
                                        ?>
                                        
                                        <div class="row">
                                            <?php foreach ($submenuFlows as $flow): ?>
                                                <?php if ($flow['is_active']): ?>
                                                    <div class="col-md-6 mb-4">
                                                        <div class="card border-<?= $colors[$colorIndex % count($colors)] ?>">
                                                            <div class="card-header bg-<?= $colors[$colorIndex % count($colors)] ?> text-white">
                                                                <h6 class="mb-0">
                                                                    <?php
                                                                    // Asignar emojis según el tipo de submenú
                                                                    $emoji = '📋';
                                                                    if (strpos(strtolower($flow['name']), 'crédito') !== false) $emoji = '💳';
                                                                    elseif (strpos(strtolower($flow['name']), 'cartera') !== false) $emoji = '💰';
                                                                    elseif (strpos(strtolower($flow['name']), 'ahorro') !== false) $emoji = '🏦';
                                                                    elseif (strpos(strtolower($flow['name']), 'auxilio') !== false) $emoji = '🤝';
                                                                    ?>
                                                                    <?= $emoji ?> <?= htmlspecialchars($flow['name']) ?>
                                                                </h6>
                                                            </div>
                                                            <div class="card-body">
                                                                <!-- Formulario individual para cada flujo -->
                                                                <form action="<?= base_url('admin/management/assign-advisors') ?>" method="POST" class="assignment-form">
                                                                    <?= csrf_field() ?>
                                                                    
                                                                    <!-- Campos ocultos para identificar el flujo -->
                                                                    <input type="hidden" name="flow_id" value="<?= $flow['id'] ?>">
                                                                    <input type="hidden" name="flow_key" value="<?= $flow['flow_key'] ?>">
                                                                    
                                                                    <label class="form-label fw-bold mb-3">
                                                                        <i class="fas fa-users me-2"></i>Asesores Asignados:
                                                                    </label>
                                                                    
                                                                    <?php if (!empty($advisors)): ?>
                                                                        <?php 
                                                                        // Obtener asesores ya asignados a este flujo específico
                                                                        $assignedAdvisors = [];
                                                                        if (isset($currentAssignments[$flow['flow_key']])) {
                                                                            $assignedAdvisors = array_column($currentAssignments[$flow['flow_key']]['advisors'], 'user_id');
                                                                        }
                                                                        ?>
                                                                        
                                                                        <!-- ÁREA CON SCROLL PARA MUCHOS ASESORES -->
                                                                        <div class="advisors-scroll-container mb-3">
                                                                            <div class="advisors-list">
                                                                                <?php foreach ($advisors as $advisor): ?>
                                                                                    <div class="advisor-checkbox-wrapper mb-2">
                                                                                        <div class="form-check">
                                                                                            <input class="form-check-input advisor-checkbox" 
                                                                                                   type="checkbox" 
                                                                                                   id="advisor_<?= $flow['id'] ?>_<?= $advisor['id'] ?>" 
                                                                                                   name="assigned_advisors[]" 
                                                                                                   value="<?= $advisor['id'] ?>"
                                                                                                   <?= in_array($advisor['id'], $assignedAdvisors) ? 'checked' : '' ?>>
                                                                                            
                                                                                            <label class="form-check-label advisor-label d-flex align-items-center" 
                                                                                                   for="advisor_<?= $flow['id'] ?>_<?= $advisor['id'] ?>">
                                                                                                <div class="advisor-info d-flex align-items-center w-100">
                                                                                                    <div class="advisor-avatar me-2">
                                                                                                        <?= $advisor['role'] === 'admin' ? '👑' : '👨‍💼' ?>
                                                                                                    </div>
                                                                                                    <div class="advisor-details flex-grow-1">
                                                                                                        <span class="advisor-name fw-medium">
                                                                                                            <?= htmlspecialchars($advisor['name']) ?>
                                                                                                        </span>
                                                                                                        <small class="advisor-username text-muted d-block">
                                                                                                            (<?= htmlspecialchars($advisor['username']) ?>)
                                                                                                        </small>
                                                                                                    </div>
                                                                                                    <?php if ($advisor['role'] === 'admin'): ?>
                                                                                                        <span class="badge bg-danger ms-2">Admin</span>
                                                                                                    <?php endif; ?>
                                                                                                    <div class="check-indicator ms-2">
                                                                                                        <i class="fas fa-check text-success" style="display: none;"></i>
                                                                                                    </div>
                                                                                                </div>
                                                                                            </label>
                                                                                        </div>
                                                                                    </div>
                                                                                <?php endforeach; ?>
                                                                            </div>
                                                                        </div>
                                                                        
                                                                        <!-- Contador de asesores seleccionados -->
                                                                        <div class="selected-count mb-3">
                                                                            <small class="text-muted">
                                                                                <i class="fas fa-info-circle me-1"></i>
                                                                                <span class="count-text">0 asesores seleccionados</span>
                                                                            </small>
                                                                        </div>
                                                                        
                                                                        <!-- Botón de envío para este flujo específico -->
                                                                        <div class="text-center">
                                                                            <button type="submit" class="btn btn-<?= $colors[$colorIndex % count($colors)] ?> btn-sm">
                                                                                <i class="fas fa-save me-2"></i>Asignar Asesores
                                                                            </button>
                                                                        </div>
                                                                        
                                                                    <?php else: ?>
                                                                        <div class="alert alert-warning">
                                                                            <i class="fas fa-exclamation-triangle me-2"></i>
                                                                            No hay asesores activos en el sistema.
                                                                            <a href="<?= base_url('admin/users/create') ?>" class="btn btn-sm btn-warning ms-2">
                                                                                <i class="fas fa-plus"></i> Crear Asesor
                                                                            </a>
                                                                        </div>
                                                                    <?php endif; ?>
                                                                </form>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <?php $colorIndex++; ?>
                                                <?php endif; ?>
                                            <?php endforeach; ?>
                                        </div>
                                        
                                    <?php else: ?>
                                        <div class="col-md-12">
                                            <div class="alert alert-info text-center">
                                                <i class="fas fa-info-circle fa-3x mb-3"></i>
                                                <h5>No hay submenús configurados</h5>
                                                <p>Primero debes crear submenús en la gestión de flujos para poder asignar asesores.</p>
                                                <a href="<?= base_url('admin/flows/create') ?>" class="btn btn-primary">
                                                    <i class="fas fa-plus me-2"></i>Crear Primer Submenú
                                                </a>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Configuración de Notificaciones -->
                    <div class="row mt-4">
                        <div class="col-md-12">
                            <div class="card border-secondary">
                                <div class="card-header bg-secondary text-white">
                                    <h6 class="mb-0">
                                        <i class="fas fa-bell me-2"></i>🔔 Configuración de Notificaciones
                                    </h6>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-6">
                                           
                                            <div class="form-check mb-3">
                                                <input class="form-check-input" type="checkbox" id="notifyAdvisorRequest" checked>
                                                <label class="form-check-label fw-bold" for="notifyAdvisorRequest">
                                                    👨‍💼 Notificar cuando un usuario solicite asesor
                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-check mb-3">
                                                <input class="form-check-input" type="checkbox" id="notifyTicketCreated" checked>
                                                <label class="form-check-label fw-bold" for="notifyTicketCreated">
                                                    🎫 Notificar cuando se cree un nuevo ticket
                                                </label>
                                            </div>
                                           
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

   
  
</div>

</div> <!-- Cierre container-fluid -->
</div> <!-- Cierre main-content -->

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<script>
function copyToClipboard(text) {
    navigator.clipboard.writeText(text).then(function() {
        showNotification('📋 URL copiada al portapapeles', 'success');
    });
}

function showNotification(msg, tipo) {
    const noti = document.getElementById("notificacion");
    noti.innerText = msg;
    noti.style.color = tipo === 'success' ? 'green' : tipo === 'error' ? 'red' : 'black';
}

function testWhatsAppConnection() {
    const webhookUrl = document.getElementById("webhook_url").value;

    showNotification("🔍 Probando conexión con WhatsApp...", "info");
    fetch(`<?= base_url('admin/management/test-connection') ?>`, {
   
        method: "POST",
        headers: {
            "Content-Type": "application/json"
        },
        body: JSON.stringify({ url: webhookUrl })
    })
    .then(res => res.json())
    .then(data => {
        if (data.success) {
            showNotification("✅ Conexión con WhatsApp exitosa", "success");
        } else {
            showNotification("❌ Error: " + data.message, "error");
        }
    })
    .catch(err => {
        showNotification("❌ Error de red: " + err.message, "error");
    });
}




function testTelegramConnection() {
    showNotification('🔍 Probando conexión con Telegram...', 'info');
    setTimeout(() => {
        showNotification('✅ Conexión con Telegram exitosa', 'success');
    }, 2000);
}

function testInstagramConnection() {
    showNotification('🔍 Probando conexión con Instagram...', 'info');
    setTimeout(() => {
        showNotification('✅ Conexión con Instagram exitosa', 'success');
    }, 2000);
}

function showNotification(message, type) {
    const notification = document.createElement('div');
    notification.className = `alert alert-${type === 'success' ? 'success' : type === 'info' ? 'info' : 'danger'} alert-dismissible fade show position-fixed`;
    notification.style.cssText = 'top: 20px; right: 20px; z-index: 9999; min-width: 300px; box-shadow: 0 4px 12px rgba(0,0,0,0.15);';
    notification.innerHTML = `
        <strong>${message}</strong>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    `;
    
    document.body.appendChild(notification);
    
    setTimeout(() => {
        if (notification.parentNode) {
            notification.remove();
        }
    }, 5000);
}

// Mostrar notificaciones de sesión
<?php if (session()->getFlashdata('success')): ?>
    showNotification('✅ <?= session()->getFlashdata('success') ?>', 'success');
<?php endif; ?>

<?php if (session()->getFlashdata('error')): ?>
    showNotification('❌ <?= session()->getFlashdata('error') ?>', 'error');
<?php endif; ?>

// Inicializar tooltips de Bootstrap
document.addEventListener('DOMContentLoaded', function() {
    var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
    var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
        return new bootstrap.Tooltip(tooltipTriggerEl);
    });

    // ===== FUNCIONALIDAD MEJORADA PARA FORMULARIOS CON SCROLL =====
    
    // Manejar el cambio visual de los checkboxes
    const checkboxes = document.querySelectorAll('.advisor-checkbox');
    
    checkboxes.forEach(checkbox => {
        checkbox.addEventListener('change', function() {
            const wrapper = this.closest('.advisor-checkbox-wrapper');
            const checkIcon = wrapper.querySelector('.check-indicator i');
            const form = this.closest('.assignment-form');
            
            if (this.checked) {
                wrapper.style.backgroundColor = '#e8f5e8';
                wrapper.style.borderLeft = '4px solid #28a745';
                checkIcon.style.display = 'inline-block';
            } else {
                wrapper.style.backgroundColor = '';
                wrapper.style.borderLeft = '';
                checkIcon.style.display = 'none';
            }
            
            // Actualizar contador
            updateSelectedCount(form);
        });
        
        // Aplicar estilo inicial si ya está marcado
        if (checkbox.checked) {
            const wrapper = checkbox.closest('.advisor-checkbox-wrapper');
            const checkIcon = wrapper.querySelector('.check-indicator i');
            wrapper.style.backgroundColor = '#e8f5e8';
            wrapper.style.borderLeft = '4px solid #28a745';
            checkIcon.style.display = 'inline-block';
        }
    });
    
    // Función para actualizar contador de seleccionados
    function updateSelectedCount(form) {
        const checkedBoxes = form.querySelectorAll('input[name="assigned_advisors[]"]:checked');
        const countText = form.querySelector('.count-text');
        const count = checkedBoxes.length;
        
        if (countText) {
            countText.textContent = `${count} asesor${count !== 1 ? 'es' : ''} seleccionado${count !== 1 ? 's' : ''}`;
            
            // Cambiar color según cantidad
            const countContainer = countText.closest('.selected-count');
            if (count > 0) {
                countContainer.className = 'selected-count mb-3 text-success';
            } else {
                countContainer.className = 'selected-count mb-3 text-muted';
            }
        }
    }
    
    // Inicializar contadores
    document.querySelectorAll('.assignment-form').forEach(form => {
        updateSelectedCount(form);
    });
    
    // Manejar envío de formularios
    const forms = document.querySelectorAll('.assignment-form');
    
    forms.forEach(form => {
        form.addEventListener('submit', function(e) {
            const checkedBoxes = this.querySelectorAll('input[name="assigned_advisors[]"]:checked');
            
            if (checkedBoxes.length === 0) {
                e.preventDefault();
                showNotification('⚠️ Por favor selecciona al menos un asesor para asignar.', 'warning');
                return false;
            }
            
            // Mostrar loading en el botón
            const submitBtn = this.querySelector('button[type="submit"]');
            const originalText = submitBtn.innerHTML;
            submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>Guardando...';
            submitBtn.disabled = true;
            
            // Restaurar botón después de 3 segundos (en caso de error)
            setTimeout(() => {
                submitBtn.innerHTML = originalText;
                submitBtn.disabled = false;
            }, 3000);
        });
    });
});
</script>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        // Restaurar la pestaña activa desde localStorage
        const lastTabId = localStorage.getItem('activeTabId');
        if (lastTabId) {
            const lastTab = document.querySelector(`button[data-bs-target="${lastTabId}"]`);
            if (lastTab) new bootstrap.Tab(lastTab).show();
        }

        // Guardar la pestaña activa cada vez que se cambia
        const tabButtons = document.querySelectorAll('button[data-bs-toggle="tab"]');
        tabButtons.forEach(btn => {
            btn.addEventListener('shown.bs.tab', function (e) {
                const target = e.target.getAttribute('data-bs-target');
                localStorage.setItem('activeTabId', target);
            });
        });
    });
</script>


<style>
.status-indicator {
    width: 12px;
    height: 12px;
    border-radius: 50%;
    animation: pulse 2s infinite;
}

@keyframes pulse {
    0% { opacity: 1; }
    50% { opacity: 0.5; }
    100% { opacity: 1; }
}

.form-check-input:checked {
    background-color: #00d4ff;
    border-color: #00d4ff;
}

/* Pestañas con colores */
.nav-tabs-colorful .nav-whatsapp.active {
    background-color: #25d366 !important;
    color: white !important;
    border-color: #25d366 !important;
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(37, 211, 102, 0.3);
}

.nav-tabs-colorful .nav-telegram.active {
    background-color: #0088cc !important;
    color: white !important;
    border-color: #0088cc !important;
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(0, 136, 204, 0.3);
}

.nav-tabs-colorful .nav-instagram.active {
    background: linear-gradient(45deg, #f09433 0%,#e6683c 25%,#dc2743 50%,#cc2366 75%,#bc1888 100%) !important;
    color: white !important;
    border-color: #dc2743 !important;
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(220, 39, 67, 0.3);
}

.nav-tabs-colorful .nav-general.active {
    background-color: #17a2b8 !important;
    color: white !important;
    border-color: #17a2b8 !important;
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(23, 162, 184, 0.3);
}

/* ===== PESTAÑAS MEJORADAS ===== */
.nav-tabs-colorful .nav-link {
    background-color: #f8f9fa;
    color: #6c757d;
    border: 1px solid #dee2e6;
    border-bottom: none;
    margin-right: 2px;
    transition: all 0.3s ease;
    position: relative;
    overflow: hidden;
}

.nav-tabs-colorful .nav-link:not(.active) {
    background: linear-gradient(135deg, #e9ecef 0%, #f8f9fa 100%);
    color: #6c757d;
    opacity: 0.7;
    transform: scale(0.95);
}

.nav-tabs-colorful .nav-link:not(.active):hover {
    background: linear-gradient(135deg, #dee2e6 0%, #e9ecef 100%);
    color: #495057;
    opacity: 0.9;
    transform: scale(0.98);
    box-shadow: 0 2px 8px rgba(0,0,0,0.1);
}

.nav-tabs-colorful .nav-link:hover {
    transform: translateY(-2px);
    transition: all 0.3s ease;
    box-shadow: 0 4px 8px rgba(0,0,0,0.1);
}

.card {
    transition: all 0.3s ease;
    border-radius: 10px;
}

.card:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(0,0,0,0.15);
}

.btn {
    transition: all 0.3s ease;
    border-radius: 8px;
}

.btn:hover {
    transform: translateY(-1px);
    box-shadow: 0 4px 8px rgba(0,0,0,0.1);
}

.form-control {
    border-radius: 8px;
    transition: all 0.3s ease;
}

.form-control:focus {
    transform: translateY(-1px);
    box-shadow: 0 4px 8px rgba(0,0,0,0.1);
}

.alert {
    border-radius: 10px;
    border: none;
}

/* Efectos de hover para las cards de estado */
.bg-success.bg-opacity-10:hover,
.bg-warning.bg-opacity-10:hover,
.bg-danger.bg-opacity-10:hover,
.bg-primary.bg-opacity-10:hover {
    transform: scale(1.02);
    transition: all 0.3s ease;
    box-shadow: 0 4px 12px rgba(0,0,0,0.1);
}

/* Estilos para las cards de asignación */
.form-check {
    padding: 8px 12px;
    margin: 4px 0;
    border-radius: 6px;
    transition: all 0.3s ease;
}

.form-check:hover {
    background-color: rgba(0,0,0,0.05);
}

.form-check-input:checked + .form-check-label {
    font-weight: bold;
    color: #0d6efd;
}

/* Animaciones para las pestañas */
.tab-pane {
    animation: fadeIn 0.5s ease-in;
}

@keyframes fadeIn {
    from { opacity: 0; transform: translateY(10px); }
    to { opacity: 1; transform: translateY(0); }
}

/* Resaltar pestañas activas */
.nav-tabs .nav-link.active {
    font-weight: bold;
    border-bottom: 3px solid;
}

/* Efectos especiales para las cards de flujos */
.border-success:hover { border-color: #198754 !important; }
.border-warning:hover { border-color: #ffc107 !important; }
.border-primary:hover { border-color: #0d6efd !important; }
.border-danger:hover { border-color: #dc3545 !important; }
.border-info:hover { border-color: #0dcaf0 !important; }
.border-secondary:hover { border-color: #6c757d !important; }

/* Agrandar todos los checkboxes */
.form-check-input {
    width: 1.3em;
    height: 1.3em;
    margin-top: 0.3em;
    cursor: pointer;
    border: 2px solid #333;
}

/* Resaltar el texto (etiqueta) cuando el checkbox está marcado */
.form-check-input:checked + .form-check-label {
    background-color: #e6f0ff;
    border-radius: 0.4rem;
    font-weight: bold;
    padding: 0.3rem 0.6rem;
    display: inline-block;
}

/* ===== ESTILOS PARA EL SCROLL DE ASESORES ===== */
.advisors-scroll-container {
    max-height: 300px; /* Altura máxima antes de mostrar scroll */
    overflow-y: auto;
    border: 1px solid #e9ecef;
    border-radius: 8px;
    padding: 10px;
    background-color: #f8f9fa;
}

/* Personalizar scrollbar */
.advisors-scroll-container::-webkit-scrollbar {
    width: 8px;
}

.advisors-scroll-container::-webkit-scrollbar-track {
    background: #f1f1f1;
    border-radius: 4px;
}

.advisors-scroll-container::-webkit-scrollbar-thumb {
    background: #c1c1c1;
    border-radius: 4px;
}

.advisors-scroll-container::-webkit-scrollbar-thumb:hover {
    background: #a8a8a8;
}

/* Estilos mejorados para los elementos de asesor */
.advisor-checkbox-wrapper {
    transition: all 0.3s ease;
    border-radius: 8px;
    padding: 8px;
    margin: 2px 0;
    background-color: white;
    border: 1px solid transparent;
}

.advisor-checkbox-wrapper:hover {
    background-color: #f0f8ff;
    border-color: #dee2e6;
    transform: translateX(2px);
}

.advisor-label {
    cursor: pointer;
    margin-bottom: 0;
    width: 100%;
}

.advisor-info {
    padding: 5px 0;
}

.advisor-avatar {
    font-size: 1.2em;
    width: 30px;
    text-align: center;
}

.advisor-name {
    color: #333;
    font-size: 0.95em;
}

.advisor-username {
    font-size: 0.8em;
    color: #6c757d;
}

.form-check-input:checked ~ .form-check-label .check-indicator i {
    display: inline-block !important;
}

.assignment-form {
    margin: 0;
}



/* Ocultar indicador si hay pocos elementos */
.advisors-scroll-container[data-count="small"]::before {
    display: none;
}

/* Contador de seleccionados */
.selected-count {
    padding: 8px 12px;
    background-color: #f8f9fa;
    border-radius: 6px;
    border-left: 4px solid #6c757d;
    transition: all 0.3s ease;
}

.selected-count.text-success {
    background-color: #d4edda;
    border-left-color: #28a745;
}

/* Animación suave para cambios */
.advisor-checkbox-wrapper {
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
}

/* Efecto de focus para accesibilidad */
.form-check-input:focus {
    box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.25);
}

/* Responsive para móviles */
@media (max-width: 768px) {
    .advisors-scroll-container {
        max-height: 250px;
    }
    
    .advisor-info {
        padding: 6px 0;
    }
    
    .advisor-name {
        font-size: 0.9em;
    }
    
    .advisor-username {
        font-size: 0.75em;
    }
}
</style>

</body>
</html>