<?php echo $this->include('templates/sidebar'); ?>

<div class="fade-in">
    <div class="container mt-4">
        <div class="main-container">

            <!-- Header -->
            <div class="header-section">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h1 class="mb-2">
                            <i class="fas fa-plus-circle me-3"></i>
                            Crear Nuevo Ticket
                        </h1>
                        <p class="mb-0 opacity-75">
                            Registra una nueva incidencia o solicitud de soporte
                        </p>
                    </div>
                    <a href="<?= base_url('admin/tickets') ?>" class="btn btn-light btn-custom">
                        <i class="fas fa-arrow-left me-2"></i>Volver
                    </a>
                </div>
            </div>

            <!-- Form Section -->
            <div class="form-section">
                <form action="<?= base_url('admin/tickets/store') ?>" method="POST" id="ticketForm">
                    <?= csrf_field() ?>

                    <!-- Conversaciones -->
                    <?php
                        $file = WRITEPATH . 'conversations.json';
                        $conversations = file_exists($file) ? json_decode(file_get_contents($file), true) : [];
                    ?>
                    <div class="form-group">
                        <label class="form-label">
                            <i class="fas fa-comments me-2"></i>
                            Conversación <span class="required">*</span>
                        </label>

                        <?php if (!empty($conversations)): ?>
                            <input type="text" id="search-conversations" class="form-control mb-3" placeholder="Buscar conversación por nombre o mensaje...">

                            <div class="conversation-list" style="max-height: 300px; overflow-y: auto;">
                                <?php foreach ($conversations as $phone => $conversation): ?>
                                    <?php
                                        $messages = $conversation['messages'] ?? [];
                                        $lastMsg = 'Sin mensaje';
                                        $lastTime = 'Sin fecha';

                                        if (!empty($messages)) {
                                            $last = end($messages);
                                            $lastMsg = $last['message'] ?? 'Sin mensaje';
                                            $lastTime = isset($last['timestamp']) ? date('d/m/Y H:i', $last['timestamp']) : 'Sin fecha';
                                        }

                                        $userName = $conversation['user_name'] ?? 'Usuario';
                                        $platform = $conversation['platform'] ?? null;
                                    ?>
                                    <div class="conversation-card" onclick="selectConversation('<?= $phone ?>', this)" data-search="<?= strtolower($userName) ?> <?= strtolower($lastMsg) ?> <?= strtolower($conversation['id'] ?? $phone) ?>">
                                        <input type="radio" name="user_phone" value="<?= $phone ?>" id="conv_<?= $phone ?>" style="display: none;">

                                        <div class="d-flex justify-content-between align-items-start">
                                            <div>
                                                <div class="fw-medium mb-1"><?= htmlspecialchars($userName) ?></div>
                                                <div class="text-muted small mb-2"><?= substr(htmlspecialchars($lastMsg), 0, 100) ?>...</div>
                                                <div class="d-flex align-items-center gap-2">
                                                    <?php if ($platform): ?>
                                                        <span class="platform-badge platform-<?= htmlspecialchars($platform) ?>">
                                                            <i class="fab fa-<?= htmlspecialchars($platform) ?> me-1"></i>
                                                            <?= ucfirst($platform) ?>
                                                        </span>
                                                    <?php else: ?>
                                                        <span class="platform-badge bg-secondary text-white">
                                                            <i class="fas fa-question-circle me-1"></i>
                                                            Desconocido
                                                        </span>
                                                    <?php endif; ?>
                                                    <small class="text-muted">ID: #<?= htmlspecialchars($conversation['id'] ?? $phone) ?></small>
                                                </div>
                                            </div>
                                            <div class="text-end">
                                                <small class="text-muted"><?= $lastTime ?></small>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        <?php else: ?>
                            <div class="alert alert-warning">
                                <i class="fas fa-exclamation-triangle me-2"></i>
                                No hay conversaciones activas disponibles.
                            </div>
                        <?php endif; ?>
                    </div>

                    <!-- Asunto -->
                    <div class="form-group">
                        <label for="subject" class="form-label">
                            <i class="fas fa-tag me-2"></i>
                            Asunto <span class="required">*</span>
                        </label>
                        <input type="text" class="form-control" id="subject" name="subject" placeholder="Describe brevemente el problema o solicitud" value="<?= old('subject') ?>" required>
                    </div>

                    <!-- Descripción -->
                    <div class="form-group">
                        <label for="description" class="form-label">
                            <i class="fas fa-align-left me-2"></i>
                            Descripción <span class="required">*</span>
                        </label>
                        <textarea class="form-control" id="description" name="description" rows="5" placeholder="Proporciona una descripción detallada del problema o solicitud" required><?= old('description') ?></textarea>
                    </div>

                    <!-- Prioridad -->
                    <div class="form-group">
                        <label for="priority" class="form-label">
                            <i class="fas fa-exclamation me-2"></i>
                            Prioridad <span class="required">*</span>
                        </label>
                        <select class="form-select" id="priority" name="priority" required>
                            <option value="">Seleccionar prioridad</option>
                            <option value="urgent" <?= old('priority') === 'urgent' ? 'selected' : '' ?>>Urgente</option>
                            <option value="Alta" <?= old('priority') === 'Alta' ? 'selected' : '' ?>>Alta</option>
                            <option value="Media" <?= old('priority') === 'Media' ? 'selected' : '' ?>>Media</option>
                            <option value="Baja" <?= old('priority') === 'Baja' ? 'selected' : '' ?>>Baja</option>
                        </select>
                    </div>

                    <!-- Asignar asesor -->
                    <div class="form-group">
                        <label for="advisor_id" class="form-label">
                            <i class="fas fa-user-tie me-2"></i>
                            Asignar a Asesor
                        </label>
                        <select class="form-select" id="advisor_id" name="assigned_to">
                            <option value="">Sin asignar</option>
                            <?php foreach ($advisors as $advisor): ?>
                                <option value="<?= $advisor['id'] ?>" data-name="<?= htmlspecialchars($advisor['name']) ?>" <?= old('advisor_id') == $advisor['id'] ? 'selected' : '' ?>>
                                    <?= htmlspecialchars($advisor['name']) ?> <?= $advisor['role'] === 'admin' ? '(Administrador)' : '' ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                        <!-- Campo oculto para enviar el nombre del asesor -->
                        <input type="hidden" name="user_name" id="user_name" value="">
                    </div>

                    <!-- Botones -->
                    <div class="d-flex gap-3 justify-content-end">
                        <a href="<?= base_url('admin/tickets') ?>" class="btn btn-secondary-custom btn-custom">
                            <i class="fas fa-times me-2"></i>Cancelar
                        </a>
                        <button type="submit" class="btn btn-primary-custom btn-custom">
                            <i class="fas fa-save me-2"></i>Crear Ticket
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Scripts -->
<script>
// Función para seleccionar conversación (estaba faltando)
function selectConversation(phone, element) {
    console.log('🎯 Seleccionando conversación:', phone);
    
    // Remover selección previa
    document.querySelectorAll('.conversation-card').forEach(card => {
        card.classList.remove('selected');
    });
    
    // Agregar selección actual
    element.classList.add('selected');
    
    // Marcar el radio button
    const radio = document.getElementById('conv_' + phone);
    if (radio) {
        radio.checked = true;
        console.log('✅ Radio button marcado para:', phone);
    }
}

document.addEventListener('DOMContentLoaded', function () {
    const form = document.getElementById('ticketForm');
    if (!form) {
        console.warn('⚠️ No se encontró el formulario');
        return;
    }

    console.log('✅ DOM cargado, formulario detectado');

    form.addEventListener('submit', function (e) {
        console.log("📨 Evento submit capturado");

        const selected = document.querySelector('input[name="user_phone"]:checked');

        if (!selected) {
            e.preventDefault();
            console.log("⚠️ No hay conversación seleccionada");

            const confirmar = confirm('⚠️ Estás creando un ticket sin asociar ninguna conversación.\n¿Deseas continuar de todos modos?');
            
            if (confirmar) {
                console.log("✅ Usuario aceptó continuar");
                // Enviar el formulario sin validación de conversación
                form.submit();
            } else {
                console.log("❌ Usuario canceló el envío");
                return false;
            }
        } else {
            console.log("✅ Conversación seleccionada:", selected.value);
        }
    });

    // Manejo del selector de asesor
    const advisorSelect = document.getElementById('advisor_id');
    const userNameInput = document.getElementById('user_name');
    
    if (advisorSelect && userNameInput) {
        advisorSelect.addEventListener('change', function () {
            const selectedOption = this.options[this.selectedIndex];
            const advisorName = selectedOption.getAttribute('data-name') || '';
            userNameInput.value = advisorName;
            console.log('👤 Asesor seleccionado:', advisorName);
        });

        // Establecer valor inicial si hay uno seleccionado
        const selectedOption = advisorSelect.options[advisorSelect.selectedIndex];
        if (selectedOption) {
            const advisorName = selectedOption.getAttribute('data-name') || '';
            userNameInput.value = advisorName;
        }
    }

    // Búsqueda de conversaciones
    const searchInput = document.getElementById('search-conversations');
    if (searchInput) {
        searchInput.addEventListener('input', function () {
            const searchValue = this.value.toLowerCase();
            document.querySelectorAll('.conversation-card').forEach(card => {
                const text = card.getAttribute('data-search') || '';
                if (text.includes(searchValue)) {
                    card.style.display = 'block';
                } else {
                    card.style.display = 'none';
                }
            });
            console.log('🔍 Búsqueda aplicada:', searchValue);
        });
    }
});
</script>

<!-- ESTILOS -->
<style>
    :root {
        --primary-color: #6c69cd;
        --secondary-color: #6b7280;
        --border-color: #e5e7eb;
        --dark-color: #374151;
        --danger-color: #ef4444;
    }

    .main-container {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        border-radius: 20px;
        overflow: hidden;
        box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
    }

    .header-section {
        background: rgba(255, 255, 255, 0.95);
        backdrop-filter: blur(10px);
        padding: 2rem;
        position: relative;
        overflow: hidden;
    }

    .header-section::before {
        content: '';
        position: absolute;
        top: 0;
        right: 0;
        width: 150px;
        height: 150px;
        background: rgba(108, 105, 205, 0.1);
        border-radius: 50%;
        transform: translate(50%, -50%);
    }

    .form-section {
        background: rgba(255, 255, 255, 0.98);
        backdrop-filter: blur(10px);
        padding: 2rem;
    }

    .form-label {
        font-weight: 600;
        color: var(--dark-color);
        margin-bottom: 0.5rem;
        display: flex;
        align-items: center;
    }

    .form-control, .form-select {
        border-radius: 12px;
        border: 1px solid var(--border-color);
        padding: 0.75rem 1rem;
        transition: all 0.3s ease;
        background: rgba(255, 255, 255, 0.9);
    }

    .form-control:focus, .form-select:focus {
        box-shadow: 0 0 0 0.2rem rgba(108, 105, 205, 0.25);
        border-color: var(--primary-color);
        background: white;
    }

    .btn-custom {
        border-radius: 12px;
        font-weight: 500;
        padding: 0.75rem 1.5rem;
        transition: all 0.3s ease;
        border: none;
        text-decoration: none;
        display: inline-flex;
        align-items: center;
    }

    .btn-primary-custom {
        background: linear-gradient(135deg, #6c69cd 0%, #5b59c5 100%);
        color: white;
    }

    .btn-primary-custom:hover {
        transform: translateY(-2px);
        box-shadow: 0 10px 15px -3px rgba(108, 105, 205, 0.4);
        color: white;
    }

    .btn-secondary-custom {
        background: linear-gradient(135deg, #6b7280 0%, #4b5563 100%);
        color: white;
    }

    .btn-secondary-custom:hover {
        background: linear-gradient(135deg, #4b5563 0%, #374151 100%);
        color: white;
        transform: translateY(-1px);
    }

    .btn-light {
        background: rgba(255, 255, 255, 0.9);
        color: var(--dark-color);
        border: 1px solid rgba(255, 255, 255, 0.5);
    }

    .btn-light:hover {
        background: white;
        color: var(--dark-color);
        transform: translateY(-1px);
    }

    .form-group {
        margin-bottom: 1.5rem;
    }

    .required {
        color: var(--danger-color);
    }

    .conversation-card {
        border: 2px solid transparent;
        border-radius: 12px;
        padding: 1rem;
        margin-bottom: 0.5rem;
        cursor: pointer;
        transition: all 0.3s ease;
        background: rgba(255, 255, 255, 0.7);
        backdrop-filter: blur(5px);
    }

    .conversation-card:hover {
        border-color: var(--primary-color);
        background: rgba(108, 105, 205, 0.1);
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(108, 105, 205, 0.15);
    }

    .conversation-card.selected {
        border-color: var(--primary-color);
        background: rgba(108, 105, 205, 0.15);
        box-shadow: 0 4px 12px rgba(108, 105, 205, 0.2);
    }

    .conversation-list {
        border-radius: 12px;
        padding: 0.5rem;
        background: rgba(248, 250, 252, 0.5);
    }

    .platform-badge {
        padding: 0.25rem 0.5rem;
        border-radius: 8px;
        font-size: 0.75rem;
        font-weight: 500;
        display: inline-flex;
        align-items: center;
    }

    .platform-whatsapp {
        background: #25d366;
        color: white;
    }

    .platform-telegram {
        background: #0088cc;
        color: white;
    }

    .platform-instagram {
        background: #e4405f;
        color: white;
    }

    .alert-warning {
        background: rgba(251, 191, 36, 0.1);
        border: 1px solid rgba(251, 191, 36, 0.3);
        color: #92400e;
        border-radius: 12px;
        padding: 1rem;
    }

    .fade-in {
        animation: fadeIn 0.5s ease-in;
    }

    @keyframes fadeIn {
        from { opacity: 0; transform: translateY(20px); }
        to { opacity: 1; transform: translateY(0); }
    }

    /* Responsive design */
    @media (max-width: 768px) {
        .header-section, .form-section {
            padding: 1rem;
        }
        
        .d-flex.gap-3 {
            flex-direction: column;
        }
        
        .btn-custom {
            width: 100%;
            justify-content: center;
        }
    }
</style>