<?= $this->include('templates/sidebar'); ?>

<div class="fade-in">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h2><i class="fas fa-ticket-alt text-primary me-2"></i>Gestión de Tickets</h2>
            <p class="text-muted">
                <?php if ($role === 'admin'): ?>
                    Administra todos los tickets del sistema
                <?php else: ?>
                    Gestiona tus tickets asignados
                <?php endif; ?>
            </p>
        </div>
        <?php if ($role === 'admin'): ?>
            <a href="<?= base_url('admin/tickets/create') ?>" class="btn btn-primary">
                <i class="fas fa-plus me-2"></i>Crear Nuevo Ticket
            </a>
        <?php endif; ?>
    </div>

    <!-- Estadísticas de tickets -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card bg-warning text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h4><?= count(array_filter($tickets, fn($t) => $t['status'] === 'open')) ?></h4>
                            <p class="mb-0">Tickets Abiertos</p>
                        </div>
                        <i class="fas fa-clock fa-2x opacity-50"></i>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-info text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h4><?= count(array_filter($tickets, fn($t) => $t['status'] === 'in_progress')) ?></h4>
                            <p class="mb-0">En Proceso</p>
                        </div>
                        <i class="fas fa-cog fa-2x opacity-50"></i>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-success text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h4><?= count(array_filter($tickets, fn($t) => $t['status'] === 'closed')) ?></h4>
                            <p class="mb-0">Resueltos</p>
                        </div>
                        <i class="fas fa-check-circle fa-2x opacity-50"></i>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-danger text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h4><?= count(array_filter($tickets, fn($t) => $t['priority'] === 'urgent' && $t['status'] !== 'closed')) ?></h4>
                            <p class="mb-0">Urgentes</p>
                        </div>
                        <i class="fas fa-exclamation-triangle fa-2x opacity-50"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filtros -->
    <div class="card mb-4">
        <div class="card-body">
            <form method="GET" action="<?= base_url('admin/tickets') ?>">
                <div class="row">
                    <div class="col-md-3">
                        <select name="status" class="form-select">
                            <option value="">Todos los estados</option>
                            <option value="open" <?= request()->getGet('status') === 'open' ? 'selected' : '' ?>>Abiertos</option>
                            <option value="assigned" <?= request()->getGet('status') === 'assigned' ? 'selected' : '' ?>>Asignados</option>
                            <option value="in_progress" <?= request()->getGet('status') === 'in_progress' ? 'selected' : '' ?>>En Proceso</option>
                            <option value="closed" <?= request()->getGet('status') === 'closed' ? 'selected' : '' ?>>Cerrados</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <select name="priority" class="form-select">
                            <option value="">Todas las prioridades</option>
                            <option value="low" <?= request()->getGet('priority') === 'low' ? 'selected' : '' ?>>Baja</option>
                            <option value="medium" <?= request()->getGet('priority') === 'medium' ? 'selected' : '' ?>>Media</option>
                            <option value="high" <?= request()->getGet('priority') === 'high' ? 'selected' : '' ?>>Alta</option>
                            <option value="urgent" <?= request()->getGet('priority') === 'urgent' ? 'selected' : '' ?>>Urgente</option>
                        </select>
                    </div>
                    <?php if ($role === 'admin'): ?>
                        <div class="col-md-3">
                            <select name="assigned_to" class="form-select">
                                <option value="">Todos los asesores</option>
                                <option value="unassigned" <?= request()->getGet('assigned_to') === 'unassigned' ? 'selected' : '' ?>>Sin asignar</option>
                                <?php foreach ($advisors as $advisor): ?>
                                    <option value="<?= $advisor['id'] ?>" <?= request()->getGet('assigned_to') == $advisor['id'] ? 'selected' : '' ?>>
                                        <?= htmlspecialchars($advisor['username']) ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    <?php endif; ?>
                    <div class="col-md-3">
                        <div class="d-flex gap-2">
                            <button type="submit" class="btn btn-outline-primary">
                                <i class="fas fa-filter me-1"></i>Filtrar
                            </button>
                            <a href="<?= base_url('admin/tickets') ?>" class="btn btn-outline-secondary">
                                <i class="fas fa-times me-1"></i>Limpiar
                            </a>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Lista de tickets -->
    <div class="card">
        <div class="card-header">
            <h5 class="mb-0"><i class="fas fa-list me-2"></i>Lista de Tickets</h5>
        </div>
        <div class="card-body">
            <?php if (!empty($tickets)): ?>
                <div class="table-responsive" style="max-height: 450px; overflow-y: auto;">
                  <table class="table table-hover align-middle">

                        <thead>
                            <tr>
                                <th>Ticket</th>
                                <th>Numero</th>
                                <th>Asunto</th>
                                <th>Estado</th>
                                <th>Prioridad</th>
                                <th>Asignado a</th>
                                <th>Fecha</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($tickets as $ticket): ?>
                                <tr>
                                    <td>
                                        <strong><?= htmlspecialchars($ticket['ticket_number']) ?></strong><br>
                                        <small class="text-muted">
                                            <i class="<?= get_platform_icon($ticket['platform']) ?> me-1"></i>
                                            <?= ucfirst($ticket['platform']) ?>
                                        </small>
                                    </td>
                                    <td>
                                        
                                       
                                        <?php if (!empty($ticket['user_phone'])): ?>
                                            <small class="text-muted">
                                                <i class="fas fa-phone me-1"></i><?= format_phone($ticket['user_phone']) ?>
                                            </small>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <strong><?= htmlspecialchars($ticket['subject']) ?></strong>
                                        <small class="text-muted">
                                            
                                            <?= strlen($ticket['description']) > 100 ? '...' : '' ?>
                                        </small>
                                    </td>
                                    <td><?= get_status_badge($ticket['status']) ?></td>
                                    <td>
                                        <?php
                                        $colors = ['low'=>'secondary', 'medium'=>'info', 'high'=>'warning', 'urgent'=>'danger'];
                                        $labels = ['low'=>'Baja', 'medium'=>'Media', 'high'=>'Alta', 'urgent'=>'Urgente'];
                                        ?>
                                        <span class="badge bg-<?= $colors[$ticket['priority']] ?? 'secondary' ?>">
                                            <?= $labels[$ticket['priority']] ?? ucfirst($ticket['priority']) ?>
                                        </span>
                                    </td>
                                    <td>
                                        <?php if (!empty($ticket['assigned_to'])): ?>
                                            <?php
                                            $assigned = array_filter($advisors, fn($a) => $a['id'] == $ticket['assigned_to']);
                                            $assignedAdvisor = reset($assigned);
                                            ?>
                                            <span class="badge bg-primary">
                                                <i class="fas fa-user me-1"></i>
                                                <?= $assignedAdvisor['username'] ?? 'Asesor' ?>
                                            </span>
                                        <?php else: ?>
                                            <span class="badge bg-light text-dark">Sin asignar</span>
                                        <?php endif; ?>
                                    </td>
                                    <td><small class="text-muted"><?= timeago($ticket['created_at']) ?></small></td>
                                    <td>
                                        <div class="btn-group">
                                            <a href="<?= base_url('admin/tickets/view/' . $ticket['id']) ?>" class="btn btn-sm btn-outline-primary" title="Ver detalles">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <?php if ($role === 'admin'): ?>
                                                <button type="button" class="btn btn-sm btn-outline-danger"
                                                    onclick="deleteTicket('<?= $ticket['id'] ?>', '<?= htmlspecialchars($ticket['ticket_number']) ?>')"
                                                    title="Eliminar">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            <?php else: ?>
                <div class="text-center py-5">
                    <i class="fas fa-ticket-alt fa-3x text-muted mb-3"></i>
                    <h5 class="text-muted">No hay tickets disponibles</h5>
                    <p class="text-muted">
                        <?= $role === 'admin'
                            ? 'Los tickets aparecerán aquí cuando se creen desde conversaciones o manualmente'
                            : 'Los tickets asignados a ti aparecerán aquí'; ?>
                    </p>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

</div> <!-- Cierre container-fluid -->
</div> <!-- Cierre main-content -->

<script>
function deleteTicket(ticketId, ticketNumber) {
    if (confirm(`¿Estás seguro de eliminar el ticket "${ticketNumber}"?\n\nEsta acción no se puede deshacer.`)) {
        window.location.href = `<?= base_url('admin/tickets/delete/') ?>${ticketId}`;
    }
}

<?php if (session()->getFlashdata('success')): ?>
    showNotification('<?= session()->getFlashdata('success') ?>', 'success');
<?php endif; ?>

<?php if (session()->getFlashdata('error')): ?>
    showNotification('<?= session()->getFlashdata('error') ?>', 'error');
<?php endif; ?>

function showNotification(message, type) {
    const notification = document.createElement('div');
    notification.className = `alert alert-${type === 'success' ? 'success' : 'danger'} alert-dismissible fade show position-fixed`;
    notification.style.cssText = 'top: 20px; right: 20px; z-index: 9999; min-width: 300px;';
    notification.innerHTML = `${message}<button type="button" class="btn-close" data-bs-dismiss="alert"></button>`;
    document.body.appendChild(notification);
    setTimeout(() => notification.remove(), 5000);
}

setInterval(() => {
    if (!document.querySelector('.modal.show')) {
        window.location.reload();
    }
}, 30000);
</script>

</body>
</html>
