<?php echo $this->include('templates/sidebar'); ?>

<div class="fade-in">
    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="mb-2">
                <i class="fas fa-ticket-alt me-3"></i>
                Ticket #<?= $ticket['ticket_number'] ?? $ticket['id'] ?>
            </h1>
            <p class="mb-0 text-muted">
                <?= htmlspecialchars($ticket['subject'] ?? 'Sin asunto') ?>
            </p>
        </div>
        <div class="d-flex gap-2">
            <?php if (!empty($ticket['user_phone'])): ?>
                <a href="<?= base_url('conversations/' . $ticket['user_phone']) ?>" class="btn btn-success">
                    <i class="fas fa-comments me-2"></i>Ver Conversación
                </a>
            <?php endif; ?>
            <a href="<?= base_url('admin/tickets') ?>" class="btn btn-outline-primary">
                <i class="fas fa-arrow-left me-2"></i>Volver
            </a>
        </div>
    </div>

    <!-- Flash Messages -->
    <?php if (session()->getFlashdata('success')): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="fas fa-check-circle me-2"></i><?= session()->getFlashdata('success') ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <?php if (session()->getFlashdata('error')): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="fas fa-exclamation-circle me-2"></i><?= session()->getFlashdata('error') ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <?php if (session()->getFlashdata('errors')): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="fas fa-exclamation-circle me-2"></i>
            <ul class="mb-0">
                <?php foreach (session()->getFlashdata('errors') as $error): ?>
                    <li><?= $error ?></li>
                <?php endforeach; ?>
            </ul>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <!-- Main Content -->
    <div class="row">
        <!-- Left Column -->
        <div class="col-lg-8">
            <!-- Description -->
            <div class="card shadow-sm mb-4">
                <div class="card-body">
                    <h5 class="card-title mb-3"><i class="fas fa-align-left me-2"></i>Descripción del Problema</h5>
                    <p class="card-text">
                        <?= !empty($ticket['description']) ? nl2br(htmlspecialchars($ticket['description'])) : '<em>No hay descripción disponible.</em>' ?>
                    </p>
                </div>
            </div>

            <!-- Timeline -->
            <div class="form-section mb-4">
                <h5 class="mb-3"><i class="fas fa-history me-2"></i>Historial del Ticket</h5>
                <div class="timeline">
                    <div class="timeline-item">
                        <div class="timeline-icon bg-success text-white">
                            <i class="fas fa-plus"></i>
                        </div>
                        <div class="timeline-content">
                            <div class="fw-bold">Ticket creado</div>
                            <small class="text-muted"><?= date('d/m/Y H:i', strtotime($ticket['created_at'])) ?></small>
                        </div>
                    </div>

                    <?php if (!empty($ticket['assigned_to']) && !empty($ticket['advisor_name'])): ?>
                        <div class="timeline-item">
                            <div class="timeline-icon bg-info text-white">
                                <i class="fas fa-user-check"></i>
                            </div>
                            <div class="timeline-content">
                                <div class="fw-bold">Asignado a <?= htmlspecialchars($ticket['advisor_name']) ?></div>
                                <small class="text-muted">
                                    <?= !empty($ticket['assigned_at']) ? date('d/m/Y H:i', strtotime($ticket['assigned_at'])) : 'Fecha de asignación no registrada' ?>
                                </small>
                            </div>
                        </div>
                    <?php endif; ?>

                    <?php if (!empty($ticket['updated_at']) && $ticket['updated_at'] !== $ticket['created_at']): ?>
                        <div class="timeline-item">
                            <div class="timeline-icon bg-warning text-white">
                                <i class="fas fa-pen"></i>
                            </div>
                            <div class="timeline-content">
                                <div class="fw-bold">Última actualización</div>
                                <small class="text-muted"><?= date('d/m/Y H:i', strtotime($ticket['updated_at'])) ?></small>
                            </div>
                        </div>
                    <?php endif; ?>

                    <?php if (!empty($ticket['closed_at'])): ?>
                        <div class="timeline-item">
                            <div class="timeline-icon bg-secondary text-white">
                                <i class="fas fa-check-circle"></i>
                            </div>
                            <div class="timeline-content">
                                <div class="fw-bold">Ticket cerrado</div>
                                <small class="text-muted"><?= date('d/m/Y H:i', strtotime($ticket['closed_at'])) ?></small>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Right Column -->
        <div class="col-lg-4">
            <div class="card shadow-sm mb-4">
                <div class="card-body">
                    <h5 class="card-title"><i class="fas fa-info-circle me-2"></i>Información del Ticket</h5>
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item"><strong>ID:</strong> #<?= $ticket['id'] ?></li>
                        <li class="list-group-item"><strong>Estado:</strong> <span class="badge bg-info text-dark"><?= $ticket['status'] ?></span></li>
                        <li class="list-group-item"><strong>Prioridad:</strong> <span class="badge bg-<?= $ticket['priority'] === 'urgent' ? 'danger' : ($ticket['priority'] === 'Alta' ? 'warning text-dark' : ($ticket['priority'] === 'Media' ? 'primary' : 'secondary')) ?>"><?= $ticket['priority'] ?></span></li>
                        <li class="list-group-item"><strong>Asesor:</strong> <?= htmlspecialchars($ticket['user_name'] ?? 'Sin asignar') ?></li>
                        <li class="list-group-item"><strong>Plataforma:</strong> <span class="badge bg-dark"><i class="fab fa-<?= $ticket['platform'] ?> me-1"></i><?= ucfirst($ticket['platform']) ?></span></li>
                        <?php if (!empty($ticket['user_phone'])): ?>
                            <li class="list-group-item">
                                <strong>Teléfono:</strong> 
                                <span class="text-muted"><?= htmlspecialchars($ticket['user_phone']) ?></span>
                                <a href="<?= base_url('conversations/get/' . $ticket['user_phone']) ?>" class="btn btn-sm btn-outline-success ms-2" title="Ver conversación">
                                    <i class="fas fa-external-link-alt"></i>
                                </a>
                            </li>
                        <?php endif; ?>
                        <li class="list-group-item"><strong>Creado:</strong> <?= date('d/m/Y H:i', strtotime($ticket['created_at'])) ?></li>
                    </ul>
                </div>
            </div>

            <!-- Update Form -->
            <div class="card shadow-sm">
                <div class="card-body">
                    <h5 class="card-title"><i class="fas fa-edit me-2"></i>Actualizar Ticket</h5>
                    <form action="<?= base_url('admin/tickets/update/' . $ticket['id']) ?>" method="POST">
                        <?= csrf_field() ?>

                        <div class="mb-3">
                            <label for="status" class="form-label">Estado</label>
                            <select class="form-select" id="status" name="status" required>
                                <option value="Pendiente" <?= $ticket['status'] === 'Pendiente' ? 'selected' : '' ?>>Pendiente</option>
                                <option value="in_progress" <?= $ticket['status'] === 'in_progress' ? 'selected' : '' ?>>En Proceso</option>
                                <option value="closed" <?= $ticket['status'] === 'closed' ? 'selected' : '' ?>>Resuelto</option>
                                
                            </select>
                        </div>

                        <div class="mb-3">
                            <label for="priority" class="form-label">Prioridad</label>
                            <select class="form-select" id="priority" name="priority" required>
                                <option value="urgent" <?= $ticket['priority'] === 'urgent' ? 'selected' : '' ?>>Urgente</option>
                                <option value="Alta" <?= $ticket['priority'] === 'Alta' ? 'selected' : '' ?>>Alta</option>
                                <option value="Media" <?= $ticket['priority'] === 'Media' ? 'selected' : '' ?>>Media</option>
                                <option value="Baja" <?= $ticket['priority'] === 'Baja' ? 'selected' : '' ?>>Baja</option>
                            </select>
                        </div>

                        <div class="mb-3">
                            <label for="advisor_id" class="form-label">Asignar Asesor</label>
                            <select class="form-select" id="advisor_id" name="advisor_id">
                                <option value="">Sin asignar</option>
                                <?php foreach ($advisors as $advisor): ?>
                                    <option value="<?= $advisor['id'] ?>" data-name="<?= htmlspecialchars($advisor['name']) ?>" <?= ($ticket['assigned_to'] ?? '') == $advisor['id'] ? 'selected' : '' ?>>
                                        <?= htmlspecialchars($advisor['name']) ?> <?= $advisor['role'] === 'admin' ? '(Admin)' : '' ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>

                        <input type="hidden" name="user_name" id="user_name_input" value="<?= $ticket['user_name'] ?? '' ?>">

                        <button type="submit" class="btn btn-primary w-100">
                            <i class="fas fa-save me-2"></i>Guardar Cambios
                        </button>
                    </form>

                    <script>
                        const advisorSelect = document.getElementById('advisor_id');
                        const originalAdvisorId = '<?= $ticket['assigned_to'] ?? '' ?>';

                        advisorSelect?.addEventListener('change', function () {
                            const selectedOption = this.options[this.selectedIndex];
                            const selectedId = this.value;
                            const name = selectedOption.getAttribute('data-name') || '';

                            if (selectedId !== originalAdvisorId) {
                                document.getElementById('user_name_input').value = name;
                            }
                        });
                    </script>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.timeline {
    display: flex;
    flex-direction: column;
    gap: 1rem;
    position: relative;
}
.timeline-item {
    display: flex;
    align-items: flex-start;
    gap: 1rem;
    position: relative;
}
.timeline-icon {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    flex-shrink: 0;
    font-size: 1rem;
    box-shadow: 0 0 0 3px rgba(0,0,0,0.05);
}
.timeline-content {
    background: var(--light-bg, #f9f9f9);
    padding: 0.75rem 1rem;
    border-radius: 10px;
    flex-grow: 1;
    border: 1px solid var(--border-color, #ddd);
}

/* Estilos para los botones de conversación */
.btn-success {
    background-color: #25d366;
    border-color: #25d366;
}

.btn-success:hover {
    background-color: #1ea952;
    border-color: #1ea952;
}

.btn-outline-success {
    color: #25d366;
    border-color: #25d366;
}

.btn-outline-success:hover {
    background-color: #25d366;
    border-color: #25d366;
    color: white;
}

/* Responsive para los botones del header */
@media (max-width: 768px) {
    .d-flex.gap-2 {
        flex-direction: column;
        gap: 0.5rem !important;
    }
    
    .d-flex.gap-2 .btn {
        width: 100%;
        justify-content: center;
    }
}
</style>