<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Crear Usuario</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">

    <style>
        body {
            background-color: #f4f6f9;
            color: #212529;
            font-family: Arial, sans-serif;
        }

        .content-container {
            margin-top: 60px;
            padding: 15px;
        }

        h2 {
            font-size: 1.5rem;
            font-weight: bold;
            color: #333;
            text-align: center;
            margin-bottom: 15px;
        }

        .form-container {
            background-color: #ffffff;
            padding: 15px;
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            margin: 0 auto;
        }

        .form-container label {
            font-size: 0.9rem;
            font-weight: bold;
            color: #333;
            margin-bottom: 5px;
        }

        .form-container input, .form-container select {
            font-size: 0.85rem;
            padding: 8px;
            border-radius: 5px;
            border: 1px solid #ddd;
            width: 100%;
        }

        .form-container .btn-container {
            display: flex;
            justify-content: space-between;
            margin-top: 15px;
        }

        .btn-save {
            background-color: #00d4ff;
            color: #ffffff;
            text-decoration: none;
            padding: 8px 15px;
            border-radius: 5px;
            font-size: 0.85rem;
            font-weight: bold;
            border: none;
            transition: background-color 0.3s ease, transform 0.2s;
        }

        .btn-save:hover {
            background-color: #0288d1;
            transform: scale(1.05);
        }

        .btn-back {
            background-color: #ddd;
            color: #333;
            text-decoration: none;
            padding: 8px 15px;
            border-radius: 5px;
            font-size: 0.85rem;
            font-weight: bold;
            border: none;
            transition: background-color 0.3s ease;
        }

        .btn-back:hover {
            background-color: #bbb;
        }
        .page-title {
        font-size: 1.3rem; /* Tamaño reducido */
        font-weight: bold;
        color: #00d4ff;
        text-align: center;
        margin-bottom: 15px;
        display: flex;
        justify-content: center;
        align-items: center;
        gap: 8px; /* Espacio entre el ícono y el texto */
    }

    .page-title i {
        font-size: 1.5rem; /* Tamaño reducido del ícono */
        color: #0288d1; /* Azul para el ícono */
    }
        
    </style>
</head>
<body>

<?= $this->include('templates/sidebar'); ?>

<div class="container content-container">
<h2 class="page-title">
    <i class="fas fa-user-plus"></i> Crear Usuario
</h2>
  <!-- Mensaje de error -->
  <?php if (session()->getFlashdata('error')): ?>
    <div class="alert alert-danger">
        <?= session()->getFlashdata('error'); ?>
    </div>
    <?php endif; ?>
    <div class="form-container">
        <form action="<?= base_url('admin/users/store'); ?>" method="post">
        <div class="mb-3">
    <label for="cedula">Cédula:</label>
    <input type="text" name="cedula" id="cedula" value="<?= old('cedula') ?>" required>
</div>
<div class="mb-3">
    <label for="username">Nombre de Usuario:</label>
    <input type="text" name="username" id="username" value="<?= old('username') ?>" required>
</div>
<div class="mb-3">
    <label for="password" class="form-label">Contraseña:</label>
    <input type="password" name="password" id="password" class="form-control" autocomplete="new-password" required>
</div>
<div class="mb-3">
    <label for="role">Rol:</label>
    <select name="role" id="role" class="form-control">
        <option value="admin" <?= old('role') === 'admin' ? 'selected' : '' ?>>Administrador</option>
        <option value="advisor" <?= old('role') === 'advisor' ? 'selected' : '' ?>>Asesor</option>
    </select>
</div>


            <div class="btn-container d-flex justify-content-between">
    <a href="<?= base_url('admin/users'); ?>" class="btn-back">
        <i class="fas fa-arrow-left"></i> Regresar
    </a>
    <button type="submit" class="btn-save">
        <i class="fas fa-save"></i> Guardar
    </button>
</div>

        </form>
    </div>
</div>

</body>
</html>
<?= $this->include('templates/footer'); ?>
