<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Editar Usuario</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">

    <style>
        body {
            background-color: #f4f6f9;
            color: #212529;
            font-family: Arial, sans-serif;
        }

        .content-container {
            margin-top: 60px;
            padding: 15px;
        }

        .page-title {
            font-size: 1.3rem;
            font-weight: bold;
            color: #00d4ff;
            text-align: center;
            margin-bottom: 15px;
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 8px;
        }

        .page-title i {
            font-size: 1.5rem;
            color: #0288d1;
        }

        .form-container {
            background-color: #ffffff;
            padding: 15px;
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            margin: 0 auto;
        }

        .form-container label {
            font-size: 0.9rem;
            font-weight: bold;
            color: #333;
            margin-bottom: 5px;
        }

        .form-container input, .form-container select {
            font-size: 0.85rem;
            padding: 8px;
            border-radius: 5px;
            border: 1px solid #ddd;
            width: 100%;
        }

        .form-container .btn-container {
            display: flex;
            justify-content: space-between;
            margin-top: 15px;
        }

        .btn-save {
            background-color: #00d4ff;
            color: #ffffff;
            text-decoration: none;
            padding: 8px 15px;
            border-radius: 5px;
            font-size: 0.85rem;
            font-weight: bold;
            border: none;
            transition: background-color 0.3s ease, transform 0.2s;
        }

        .btn-save:hover {
            background-color: #0288d1;
            transform: scale(1.05);
        }

        .btn-back {
            background-color: #ddd;
            color: #333;
            text-decoration: none;
            padding: 8px 15px;
            border-radius: 5px;
            font-size: 0.85rem;
            font-weight: bold;
            border: none;
            transition: background-color 0.3s ease;
        }

        .btn-back:hover {
            background-color: #bbb;
        }

        .error-message {
            color: red;
            font-size: 0.85rem;
            margin-top: 5px;
            display: none; /* Oculto por defecto */
        }
    </style>

    <script>
        function togglePasswordField() {
            const checkbox = document.getElementById('update-password');
            const passwordField = document.getElementById('password-field');
            passwordField.style.display = checkbox.checked ? 'block' : 'none';

            const passwordInput = document.getElementById('password');
            if (!checkbox.checked) {
                passwordInput.value = ''; // Limpia el campo de contraseña si se desmarca
            }
        }

        function validateForm(event) {
            const checkbox = document.getElementById('update-password');
            const passwordInput = document.getElementById('password');
            const errorMessage = document.getElementById('password-error');

            if (checkbox.checked && passwordInput.value.trim() === '') {
                errorMessage.style.display = 'block'; // Muestra el mensaje de error
                event.preventDefault(); // Evita el envío del formulario
            } else {
                errorMessage.style.display = 'none'; // Oculta el mensaje de error si no aplica
            }
        }
    </script>
</head>
<body>

<?= $this->include('templates/sidebar'); ?>

<div class="container content-container">
    <h2 class="page-title">
        <i class="fas fa-user-edit"></i> Editar Usuario
    </h2>

    <div class="form-container">
        <form action="<?= base_url('admin/users/update/' . $user['id']); ?>" method="post" onsubmit="validateForm(event)">
            <div class="mb-3">
                <label for="cedula">Cédula:</label>
                <input type="text" name="cedula" id="cedula" value="<?= $user['cedula']; ?>" required>
            </div>
            <div class="mb-3">
                <label for="username">Nombre de Usuario:</label>
                <input type="text" name="username" id="username" value="<?= $user['username']; ?>" required>
            </div>
            <div class="mb-3">
                <input type="checkbox" id="update-password" onclick="togglePasswordField()">
                <label for="update-password">¿Desea actualizar la contraseña?</label>
            </div>
            <div class="mb-3" id="password-field" style="display: none;">
                <label for="password" class="form-label">Nueva Contraseña:</label>
                <input type="password" name="password" id="password" class="form-control" autocomplete="new-password">
                <span id="password-error" class="error-message">Debes ingresar una nueva contraseña o desmarcar la opción.</span>
            </div>
            <div class="mb-3">
                <label for="role">Rol:</label>
                <select name="role" id="role">
                    <option value="admin" <?= $user['role'] === 'admin' ? 'selected' : ''; ?>>Administrador</option>
                    <option value="advisor" <?= $user['role'] === 'user' ? 'selected' : ''; ?>>Asesor</option>
                </select>
            </div>

            <div class="btn-container d-flex justify-content-between">
                <a href="<?= base_url('admin/users'); ?>" class="btn-back">
                    <i class="fas fa-arrow-left"></i> Regresar
                </a>
                <button type="submit" class="btn-save">
                    <i class="fas fa-save"></i> Actualizar
                </button>
            </div>
        </form>
    </div>
</div>

<?= $this->include('templates/footer'); ?>

</body>
</html>
