<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gestión de Usuarios</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <style>
        body {
            background-color: #f4f6f9;
            color: #212529;
            font-family: Arial, sans-serif;
        }

        .content-container {
            margin-top: 80px;
            padding: 20px;
        }

        h2 {
            font-size: 2rem;
            font-weight: bold;
            color: #333;
            text-align: center;
            margin-bottom: 20px;
        }

        .table-container {
            background-color: #ffffff;
            padding: 20px;
            border-radius: 15px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
        }

        .table th {
            background-color: #00d4ff;
            color: #ffffff;
            font-weight: bold;
            text-align: center;
            padding: 15px;
            border: none;
        }

        .table td {
            text-align: center;
            padding: 12px;
            border-bottom: 1px solid #ddd;
        }

        .table-striped tr:nth-child(even) {
            background-color: #f2f2f2;
        }

        .table-striped tr:hover {
            background-color: #e6f7ff;
            transition: background-color 0.3s ease-in-out;
        }

        .btn-create {
            background-color: #00d4ff;
            color: #ffffff;
            text-decoration: none;
            padding: 10px 20px;
            border-radius: 5px;
            font-size: 1rem;
            font-weight: bold;
            display: inline-flex;
            align-items: center;
            transition: background-color 0.3s ease, transform 0.2s;
        }

        .btn-create i {
            margin-right: 8px;
        }

        .btn-create:hover {
            background-color: #0288d1;
            transform: scale(1.05);
        }

        .icon-action {
            font-size: 1.2rem;
            cursor: pointer;
            transition: color 0.3s ease;
        }

        .icon-edit:hover {
            color: #0288d1;
        }

        .icon-delete:hover {
            color: #d32f2f;
        }

        .pagination {
            justify-content: center;
            margin-top: 20px;
        }

        .search-box {
            margin-bottom: 20px;
        }

        .search-box input {
            border-radius: 5px;
            border: 1px solid #ddd;
            padding: 10px;
            width: 100%;
        }
        .page-title {
        font-size: 1.3rem; /* Tamaño reducido */
        font-weight: bold;
        color: #00d4ff;
        text-align: center;
        margin-bottom: 15px;
        display: flex;
        justify-content: center;
        align-items: center;
        gap: 8px; /* Espacio entre el ícono y el texto */
    }

    .page-title i {
        font-size: 1.5rem; /* Tamaño reducido del ícono */
        color: #0288d1; /* Azul para el ícono */
    }
    </style>

    <script>
        // Buscador
        function filterTable() {
            const searchInput = document.getElementById('search-input');
            const filter = searchInput.value.toLowerCase();
            const tableRows = document.querySelectorAll('.table tbody tr');

            tableRows.forEach(row => {
                const cells = Array.from(row.getElementsByTagName('td'));
                const matches = cells.some(cell => cell.textContent.toLowerCase().includes(filter));
                row.style.display = matches ? '' : 'none';
            });
        }

        // Paginador
        document.addEventListener('DOMContentLoaded', function () {
            const rowsPerPage = 10;
            const tableRows = Array.from(document.querySelectorAll('.table tbody tr'));
            const totalPages = Math.ceil(tableRows.length / rowsPerPage);
            const paginationContainer = document.querySelector('.pagination');

            function showPage(page) {
                tableRows.forEach((row, index) => {
                    row.style.display = (index >= (page - 1) * rowsPerPage && index < page * rowsPerPage) ? '' : 'none';
                });

                document.querySelectorAll('.page-item').forEach(item => item.classList.remove('active'));
                document.querySelector(`.page-item[data-page="${page}"]`).classList.add('active');
            }

            function createPagination() {
                for (let i = 1; i <= totalPages; i++) {
                    const li = document.createElement('li');
                    li.className = `page-item ${i === 1 ? 'active' : ''}`;
                    li.dataset.page = i;

                    const a = document.createElement('a');
                    a.className = 'page-link';
                    a.textContent = i;
                    a.href = '#';
                    a.addEventListener('click', (e) => {
                        e.preventDefault();
                        showPage(i);
                    });

                    li.appendChild(a);
                    paginationContainer.appendChild(li);
                }
            }

            createPagination();
            showPage(1);
        });

        function confirmDelete(url) {
    Swal.fire({
        title: '¿Estás seguro?',
        text: "Esta acción no se puede deshacer",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Sí, eliminar',
        cancelButtonText: 'No, cancelar'
    }).then((result) => {
        if (result.isConfirmed) {
            window.location.href = url;
        }
    });
}

    </script>
</head>
<body>

<?= $this->include('templates/sidebar'); ?>

<div class="container content-container">
<h2 class="page-title">
    <i class="fas fa-users"></i> Gestión de Usuarios
</h2>

    <div class="row align-items-center mb-3">
        <div class="col-md-8">
            <input type="text" id="search-input" onkeyup="filterTable()" placeholder="Buscar en la tabla..." class="form-control">
        </div>
        <div class="col-md-4 text-end">
            <a href="<?= base_url('admin/users/create'); ?>" class="btn-create">
                <i class="fas fa-plus"></i> Crear Usuario
            </a>
        </div>
    </div>

    <div class="table-container">
        <div class="table-responsive">
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Cédula</th>
                        <th>Nombre de Usuario</th>
                        <th>Rol</th>
                        <th>Acciones</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($users as $user): ?>
                    <tr>
                        <td><?= $user['id']; ?></td>
                        <td><?= $user['cedula']; ?></td>
                        <td><?= $user['username']; ?></td>
                        <td><?= $user['role']; ?></td>
                        <td>
                            <i class="fas fa-edit icon-action icon-edit" title="Editar" onclick="location.href='<?= base_url('admin/users/edit/' . $user['id']); ?>'"></i>
                            &nbsp;&nbsp;
                            <i class="fas fa-trash-alt icon-action icon-delete" title="Eliminar" onclick="confirmDelete('<?= base_url('admin/users/delete/' . $user['id']); ?>')"></i>

                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>

            <!-- Paginación -->
            <nav aria-label="Page navigation">
                <ul class="pagination"></ul>
            </nav>
        </div>
    </div>
</div>

</body>
</html>
<?= $this->include('templates/footer'); ?>
