class Pagination {
    constructor(options) {
      this.container = options.container;
      this.records = options.records;
      this.recordsPerPage = options.recordsPerPage;
      this.currentPage = options.currentPage;
      this.pages = Math.ceil(this.records / this.recordsPerPage);
    }
  
    render() {
      var html = '';
      for (var i = 1; i <= this.pages; i++) {
        if (i === this.currentPage) {
          html += '<li class="active"><a href="#">' + i + '</a></li>';
        } else {
          html += '<li><a href="#" data-page="' + i + '">' + i + '</a></li>';
        }
      }
      $(this.container).html(html);
    }
  
    on(event, callback) {
      $(this.container).on(event, function(event) {
        var page = $(event.target).data('page');
        callback(page);
      });
    }
  }