<?= $this->include('templates/sidebar'); ?>

<div class="fade-in">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h2><i class="fas fa-user-cog text-primary me-2"></i>Mi Perfil</h2>
            <p class="text-muted">Gestiona tu información personal y configuraciones de seguridad</p>
        </div>
        <div>
            <span class="badge bg-<?= $user['role'] === 'admin' ? 'danger' : 'primary' ?> fs-6">
                <i class="fas fa-<?= $user['role'] === 'admin' ? 'crown' : 'headset' ?> me-1"></i>
                <?= ucfirst($user['role']) ?>
            </span>
        </div>
    </div>

    <div class="row">
        <!-- Información Personal -->
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0"><i class="fas fa-user me-2"></i>Información Personal</h5>
                </div>
                <div class="card-body">
                    <form action="<?= base_url('advisor/profile/update') ?>" method="POST">
                        <?= csrf_field() ?>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="name" class="form-label">
                                        <i class="fas fa-user me-1"></i>Nombre Completo *
                                    </label>
                                    <input type="text" class="form-control" id="name" name="name" 
                                           value="<?= htmlspecialchars($user['name'] ?? '') ?>" required>
                                </div>
                            </div>
                            
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">
                                        <i class="fas fa-id-card me-1"></i>Cédula
                                    </label>
                                    <input type="text" class="form-control" value="<?= htmlspecialchars($user['cedula'] ?? '') ?>" readonly>
                                    <div class="form-text">La cédula no se puede modificar</div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">
                                        <i class="fas fa-user-tag me-1"></i>Usuario
                                    </label>
                                    <input type="text" class="form-control" value="<?= htmlspecialchars($user['username'] ?? '') ?>" readonly>
                                    <div class="form-text">El nombre de usuario no se puede modificar</div>
                                </div>
                            </div>
                        </div>

                        <div class="d-flex justify-content-end">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save me-2"></i>Actualizar Información
                            </button>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Cambiar Contraseña -->
            <div class="card mt-4">
                <div class="card-header">
                    <h5 class="mb-0"><i class="fas fa-lock me-2"></i>Cambiar Contraseña</h5>
                </div>
                <div class="card-body">
                    <form action="<?= base_url('advisor/profile/change-password') ?>" method="POST" id="passwordForm">
                        <?= csrf_field() ?>
                        
                        <div class="row">
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="current_password" class="form-label">Contraseña Actual *</label>
                                    <input type="password" class="form-control" id="current_password" name="current_password" required>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="new_password" class="form-label">Nueva Contraseña *</label>
                                    <input type="password" class="form-control" id="new_password" name="new_password" required minlength="6">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="confirm_password" class="form-label">Confirmar Contraseña *</label>
                                    <input type="password" class="form-control" id="confirm_password" name="confirm_password" required>
                                </div>
                            </div>
                        </div>

                        <div class="d-flex justify-content-end">
                            <button type="submit" class="btn btn-warning">
                                <i class="fas fa-key me-2"></i>Cambiar Contraseña
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- Panel de Seguridad -->
        <div class="col-md-4">
            <!-- Estado de la cuenta -->
            <div class="card">
                <div class="card-header">
                    <h6 class="mb-0"><i class="fas fa-shield-alt me-2"></i>Estado de la Cuenta</h6>
                </div>
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <span>Estado:</span>
                        <span class="badge bg-success">Activa</span>
                    </div>
                    
                    <div class="d-flex justify-content-between align-items-center">
                        <span>Miembro desde:</span>
                        <small class="text-muted">
                            <?= !empty($user['created_at']) ? date('d/m/Y', strtotime($user['created_at'])) : 'N/A' ?>
                        </small>
                    </div>
                </div>
            </div>

            <!-- Autenticación de Dos Factores -->
            <div class="card mt-3">
                <div class="card-header">
                    <h6 class="mb-0"><i class="fas fa-mobile-alt me-2"></i>Autenticación de Dos Factores</h6>
                </div>
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <span>Estado 2FA:</span>
                        <span class="badge bg-<?= ($user['two_factor_enabled'] ?? false) ? 'success' : 'secondary' ?>">
                            <?= ($user['two_factor_enabled'] ?? false) ? 'Activado' : 'Desactivado' ?>
                        </span>
                    </div>

                    <!-- Switch para activar/desactivar 2FA -->
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <span>Control 2FA:</span>
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="toggle2FA" 
                                   <?= ($user['two_factor_enabled'] ?? false) ? 'checked' : '' ?>
                                   onchange="toggle2FA(this.checked)">
                            <label class="form-check-label" for="toggle2FA">
                                <?= ($user['two_factor_enabled'] ?? false) ? 'Activado' : 'Desactivado' ?>
                            </label>
                        </div>
                    </div>

                    <?php if (!($user['two_factor_enabled'] ?? false)): ?>
                        <!-- 2FA Desactivado -->
                        <div class="alert alert-warning">
                            <small>
                                <i class="fas fa-exclamation-triangle me-1"></i>
                                Tu cuenta no tiene activada la autenticación de dos factores. Te recomendamos activarla para mayor seguridad.
                            </small>
                        </div>
                        
                        <?php if (empty($user['google_auth_secret'])): ?>
                            <div class="d-grid">
                                <a href="<?= base_url('advisor/profile/setup-2fa') ?>" class="btn btn-success">
                                    <i class="fas fa-shield-alt me-2"></i>Configurar 2FA
                                </a>
                            </div>
                        <?php else: ?>
                            <div class="alert alert-info">
                                <small>
                                    <i class="fas fa-info-circle me-1"></i>
                                    Ya tienes 2FA configurado. Usa el switch de arriba para activarlo.
                                </small>
                            </div>
                        <?php endif; ?>
                    <?php else: ?>
                        <!-- 2FA Activado -->
                        <div class="alert alert-success">
                            <small>
                                <i class="fas fa-check-circle me-1"></i>
                                Tu cuenta está protegida con autenticación de dos factores.
                            </small>
                        </div>

                    <?php endif; ?>
                </div>
            </div>

            <!-- Información de Seguridad -->
            <div class="card mt-3">
                <div class="card-header">
                    <h6 class="mb-0"><i class="fas fa-info-circle me-2"></i>Consejos de Seguridad</h6>
                </div>
                <div class="card-body">
                    <ul class="list-unstyled small">
                        <li class="mb-2">
                            <i class="fas fa-check text-success me-2"></i>
                            Usa contraseñas seguras con al menos 8 caracteres
                        </li>
                        <li class="mb-2">
                            <i class="fas fa-check text-success me-2"></i>
                            Activa la autenticación de dos factores
                        </li>
                        <li class="mb-2">
                            <i class="fas fa-check text-success me-2"></i>
                            No compartas tus credenciales con nadie
                        </li>
                        <li>
                            <i class="fas fa-check text-success me-2"></i>
                            Cierra sesión al terminar tu trabajo
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>


</div> <!-- Cierre container-fluid -->
</div> <!-- Cierre main-content -->

<script>
// Función para toggle 2FA
function toggle2FA(isEnabled) {
    const form = document.createElement('form');
    form.method = 'POST';
    form.action = '<?= base_url('advisor/profile/toggle-2fa') ?>';
    
    const csrfInput = document.createElement('input');
    csrfInput.type = 'hidden';
    csrfInput.name = '<?= csrf_token() ?>';
    csrfInput.value = '<?= csrf_hash() ?>';
    
    const actionInput = document.createElement('input');
    actionInput.type = 'hidden';
    actionInput.name = 'action';
    actionInput.value = isEnabled ? 'enable' : 'disable';
    
    form.appendChild(csrfInput);
    form.appendChild(actionInput);
    document.body.appendChild(form);
    form.submit();
}

// Validación de contraseñas
document.getElementById('passwordForm').addEventListener('submit', function(e) {
    const newPassword = document.getElementById('new_password').value;
    const confirmPassword = document.getElementById('confirm_password').value;
    
    if (newPassword !== confirmPassword) {
        e.preventDefault();
        alert('Las contraseñas no coinciden');
        return false;
    }
    
    if (newPassword.length < 6) {
        e.preventDefault();
        alert('La nueva contraseña debe tener al menos 6 caracteres');
        return false;
    }
});

// Validación en tiempo real de confirmación de contraseña
document.getElementById('confirm_password').addEventListener('input', function() {
    const newPassword = document.getElementById('new_password').value;
    const confirmPassword = this.value;
    
    if (newPassword !== confirmPassword) {
        this.setCustomValidity('Las contraseñas no coinciden');
        this.classList.add('is-invalid');
    } else {
        this.setCustomValidity('');
        this.classList.remove('is-invalid');
        this.classList.add('is-valid');
    }
});

// Mostrar notificaciones
<?php if (session()->getFlashdata('success')): ?>
    showNotification('<?= session()->getFlashdata('success') ?>', 'success');
<?php endif; ?>

<?php if (session()->getFlashdata('error')): ?>
    showNotification('<?= session()->getFlashdata('error') ?>', 'error');
<?php endif; ?>

<?php if (session()->getFlashdata('info')): ?>
    showNotification('<?= session()->getFlashdata('info') ?>', 'info');
<?php endif; ?>

function showNotification(message, type) {
    const notification = document.createElement('div');
    notification.className = `alert alert-${type === 'success' ? 'success' : type === 'error' ? 'danger' : 'info'} alert-dismissible fade show position-fixed`;
    notification.style.cssText = 'top: 20px; right: 20px; z-index: 9999; min-width: 300px;';
    notification.innerHTML = `
        ${message}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    `;
    
    document.body.appendChild(notification);
    
    setTimeout(() => {
        if (notification.parentNode) {
            notification.remove();
        }
    }, 5000);
}


</script>

</body>
</html>