<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ChatBot</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        body {
            background-color: #f4f6f9;
            font-family: Arial, sans-serif;
        }
        .chat-container {
            max-width: 600px;
            margin: 50px auto;
            background-color: white;
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
            overflow: hidden;
        }
        .chat-header {
            background-color: #00d4ff;
            color: white;
            padding: 15px;
            text-align: center;
            font-size: 1.5rem;
        }
        .chat-messages {
            padding: 15px;
            height: 400px;
            overflow-y: auto;
            background-color: #f9f9f9;
        }
        .chat-bubble {
            padding: 10px;
            border-radius: 10px;
            margin-bottom: 10px;
            max-width: 75%;
        }
        .user {
            background-color: #00d4ff;
            color: white;
            align-self: flex-end;
            text-align: right;
        }
        .bot {
            background-color: #e6e6e6;
            color: black;
            align-self: flex-start;
            text-align: left;
        }
        .chat-input {
            display: flex;
            padding: 10px;
            background-color: #fff;
        }
        .chat-input input {
            flex: 1;
            border: 1px solid #ddd;
            border-radius: 5px;
            padding: 10px;
            margin-right: 10px;
        }
        .chat-input button {
            background-color: #00d4ff;
            color: white;
            border: none;
            padding: 10px 20px;
            border-radius: 5px;
        }
        .chat-input button:hover {
            background-color: #0288d1;
        }
    </style>
</head>
<body>
<div class="chat-container">
    <div class="chat-header">
        ChatBot
    </div>
    <div id="chat-messages" class="chat-messages d-flex flex-column"></div>
    <div class="chat-input">
        <input type="text" id="user-input" placeholder="Escribe tu mensaje...">
        <button id="send-button">Enviar</button>
    </div>
</div>
<script>
    document.getElementById('send-button').addEventListener('click', function () {
        const userMessage = document.getElementById('user-input').value;
        if (userMessage.trim() === '') {
            alert('Por favor, escribe un mensaje.');
            return;
        }

        const chatMessages = document.getElementById('chat-messages');
        chatMessages.innerHTML += `<div class="chat-bubble user">${userMessage}</div>`;
        document.getElementById('user-input').value = '';

        fetch('https://f441-190-84-88-191.ngrok-free.app/probando/public/chatbot/send', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
            body: JSON.stringify({ message: userMessage }),
        })
        .then(response => response.json())
        .then(data => {
            chatMessages.innerHTML += `<div class="chat-bubble bot">${data.response}</div>`;
        })
        .catch(error => console.error('Error:', error));
    });
</script>
</body>
</html>
