<?= $this->include('templates/sidebar'); ?>
    <style>
        /* Chat específico - Estilo Solibot */
        .chat-container {
            height: calc(100vh - 80px);
            display: flex;
            flex-direction: column;
        }

        .chat-content {
            display: flex;
            flex-grow: 1;
            overflow: hidden;
        }

        /* Lista de conversaciones - Estilo Solibot */
        .chat-sidebar {
            width: 400px;
            background-color: white;
            border-right: 1px solid #e4e6ea;
            display: flex;
            flex-direction: column;
        }

        .search-bar {
            margin: 12px;
            border-radius: 8px;
            border: 1px solid #e4e6ea;
            background-color: #f0f2f5;
            padding: 10px 15px;
            font-size: 14px;
        }

        .search-bar:focus {
            outline: none;
            border-color: #667eea;
            background-color: white;
        }

        .conversation-list {
            flex-grow: 1;
            overflow-y: auto;
        }

        .conversation-item {
            cursor: pointer;
            padding: 12px 16px;
            border-bottom: 1px solid #f0f2f5;
            transition: background-color 0.2s ease;
            position: relative;
        }

        .conversation-item:hover {
            background-color: #f5f6f6;
        }

        .conversation-item.active {
            background-color: #e7f3ff;
            border-right: 3px solid #667eea;
        }

        .conversation-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 4px;
        }

        .conversation-name {
            font-weight: 500;
            color: #111b21;
            font-size: 16px;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .conversation-time {
            font-size: 12px;
            color: #667781;
            margin-left: auto;
        }

        .conversation-preview {
            color: #667781;
            font-size: 14px;
            margin: 2px 0;
            display: -webkit-box;
            -webkit-line-clamp: 1;
            -webkit-box-orient: vertical;
            overflow: hidden;
        }

        .conversation-status {
            display: flex;
            align-items: center;
            gap: 8px;
            margin-top: 4px;
            flex-wrap: wrap;
        }

        .status-badge {
            font-size: 11px;
            padding: 2px 6px;
            border-radius: 10px;
            font-weight: 500;
        }

        .status-active { background-color: #d1f4cc; color: #0b6623; }
        .status-bot { background-color: #e3f2fd; color: #1976d2; }
        .status-assigned { background-color: #fff3e0; color: #f57c00; }

        /* 🎯 NUEVOS ESTILOS PARA PLATAFORMAS */
        .platform-badge {
            font-size: 10px;
            padding: 2px 6px;
            border-radius: 8px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.3px;
        }

        .platform-whatsapp { 
            background-color: #25d366; 
            color: white; 
        }

        .platform-instagram { 
            background: linear-gradient(45deg, #f09433 0%,#e6683c 25%,#dc2743 50%,#cc2366 75%,#bc1888 100%);
            color: white; 
        }

        .platform-telegram { 
            background-color: #0088cc; 
            color: white; 
        }

        .platform-unknown { 
            background-color: #6c757d; 
            color: white; 
        }

        .platform-icon {
            width: 14px;
            height: 14px;
            border-radius: 50%;
            display: inline-block;
            margin-right: 4px;
        }

        .platform-icon.whatsapp {
            background-color: #25d366;
        }

        .platform-icon.instagram {
            background: linear-gradient(45deg, #f09433 0%,#e6683c 25%,#dc2743 50%,#cc2366 75%,#bc1888 100%);
        }

        .platform-icon.telegram {
            background-color: #0088cc;
        }

        .platform-icon.unknown {
            background-color: #6c757d;
        }

        /* 🎯 Nuevos estilos para mostrar asesores */
        .advisor-info {
            margin-top: 6px;
            padding: 4px 8px;
            background-color: rgba(102, 126, 234, 0.1);
            border-radius: 8px;
            border-left: 3px solid #667eea;
        }

        .advisor-list {
            display: flex;
            flex-wrap: wrap;
            gap: 4px;
            margin-top: 2px;
        }

        .advisor-badge {
            background-color: #667eea;
            color: white;
            font-size: 10px;
            padding: 2px 6px;
            border-radius: 12px;
            font-weight: 500;
        }

        .advisor-count {
            color: #667eea;
            font-size: 11px;
            font-weight: 600;
        }

        .access-reason-badge {
            font-size: 10px;
            padding: 1px 4px;
            border-radius: 6px;
            font-weight: 500;
        }

        .access-flow { background-color: #e3f2fd; color: #1976d2; }
        .access-ticket { background-color: #fff3e0; color: #f57c00; }
        .access-both { background-color: #e8f5e8; color: #2e7d32; }

        /* Área principal del chat - Estilo Solibot */
        .chat-main {
            flex-grow: 1;
            display: flex;
            flex-direction: column;
            background-color: #efeae2;
            background-image: url("data:image/svg+xml,%3Csvg width='60' height='60' viewBox='0 0 60 60' xmlns='http://www.w3.org/2000/svg'%3E%3Cg fill='none' fill-rule='evenodd'%3E%3Cg fill='%23d4d4d4' fill-opacity='0.05'%3E%3Cpath d='m36 34v-4h-2v4h-4v2h4v4h2v-4h4v-2h-4zm0-30V0h-2v4h-4v2h4v4h2V6h4V4h-4zM6 34v-4H4v4H0v2h4v4h2v-4h4v-2H6zM6 4V0H4v4H0v2h4v4h2V6h4V4H6z'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E");
        }

        .chat-header {
            background-color: #f0f2f5;
            padding: 10px 20px;
            border-bottom: 1px solid #e4e6ea;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .chat-header-info {
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .chat-avatar {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: linear-gradient(135deg, #667eea, #764ba2);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: bold;
            position: relative;
        }

        .chat-avatar .platform-indicator {
            position: absolute;
            bottom: -2px;
            right: -2px;
            width: 16px;
            height: 16px;
            border-radius: 50%;
            border: 2px solid white;
        }

        .chat-user-info h6 {
            margin: 0;
            color: #111b21;
            font-size: 16px;
            font-weight: 500;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .chat-user-info small {
            color: #667781;
            font-size: 13px;
        }

        .chat-actions {
            display: flex;
            gap: 8px;
        }

        .chat-actions .btn {
            padding: 6px 12px;
            font-size: 13px;
            border-radius: 20px;
        }

        /* 🎯 Información de asesores en el header del chat */
        .chat-advisor-info {
            background-color: rgba(102, 126, 234, 0.1);
            border: 1px solid rgba(102, 126, 234, 0.2);
            border-radius: 8px;
            padding: 8px 12px;
            margin-top: 8px;
        }

        .chat-advisor-info h6 {
            margin: 0 0 4px 0;
            color: #667eea;
            font-size: 12px;
            font-weight: 600;
            text-transform: uppercase;
        }

        .chat-advisor-list {
            display: flex;
            flex-wrap: wrap;
            gap: 6px;
        }

        .chat-advisor-badge {
            background-color: #667eea;
            color: white;
            font-size: 11px;
            padding: 3px 8px;
            border-radius: 12px;
            font-weight: 500;
        }

        /* Área de mensajes - Estilo Solibot */
        .chat-box {
            flex-grow: 1;
            overflow-y: auto;
            padding: 20px;
            max-height: calc(100vh - 200px);
        }

        .message {
            margin-bottom: 12px;
            display: flex;
            align-items: flex-end;
            gap: 8px;
        }

        .message.received {
            justify-content: flex-start;
        }

        .message.sent {
            justify-content: flex-end;
        }

        .message.system {
            justify-content: center;
            margin: 20px 0;
        }

        .message-bubble {
            max-width: 65%;
            padding: 8px 12px;
            border-radius: 7.5px;
            position: relative;
            word-wrap: break-word;
            box-shadow: 0 1px 0.5px rgba(0,0,0,0.13);
        }

        /* Mensajes recibidos (usuario) */
        .message.received .message-bubble {
            background-color: white;
            color: #111b21;
            border-bottom-left-radius: 2px;
        }

        /* Mensajes enviados (bot/asesor) */
        .message.sent .message-bubble {
            background-color: #d9fdd3;
            color: #111b21;
            border-bottom-right-radius: 2px;
        }

        /* Mensajes del sistema */
        .message.system .message-bubble {
            background-color: rgba(255,255,255,0.8);
            color: #667781;
            font-style: italic;
            text-align: center;
            border-radius: 15px;
            font-size: 13px;
            padding: 6px 12px;
        }

        .message-time {
            font-size: 11px;
            color: #667781;
            margin-top: 2px;
            text-align: right;
        }

        .message.received .message-time {
            text-align: left;
        }

        .message-sender {
            font-size: 12px;
            color: #667eea;
            margin-bottom: 2px;
            font-weight: 500;
            display: flex;
            align-items: center;
            gap: 4px;
        }


        

        /* Caja de respuesta - Estilo Solibot */
        .response-box {
            background-color: #f0f2f5;
            padding: 10px 20px;
            display: flex;
            align-items: flex-end;
            gap: 8px;
        }

        .response-input {
            flex-grow: 1;
            background-color: white;
            border: none;
            border-radius: 21px;
            padding: 9px 12px 11px;
            resize: none;
            font-size: 15px;
            line-height: 20px;
            max-height: 100px;
            min-height: 20px;
        }

        .response-input:focus {
            outline: none;
        }

        .send-button {
            background-color: #667eea;
            color: white;
            border: none;
            border-radius: 50%;
            width: 42px;
            height: 42px;
            cursor: pointer;
            transition: background-color 0.2s ease;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .send-button:hover {
            background-color: #5a6fd8;
        }

        .send-button:disabled {
            background-color: #8696a0;
            cursor: not-allowed;
        }

        /* Sección de acciones */
        .action-section {
            background-color: #f0f2f5;
            padding: 8px 20px;
            border-top: 1px solid #e4e6ea;
            display: flex;
            align-items: center;
            gap: 8px;
            flex-wrap: wrap;
        }

        .action-btn {
            background-color: white;
            color: #54656f;
            border: 1px solid #e4e6ea;
            border-radius: 15px;
            padding: 6px 12px;
            font-size: 13px;
            cursor: pointer;
            transition: all 0.2s ease;
        }

        .action-btn:hover {
            background-color: #f5f6f6;
            border-color: #667eea;
            color: #667eea;
        }

        /* Estado vacío */
        .empty-state {
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            height: 100%;
            color: #667781;
            text-align: center;
            background-color: #f0f2f5;
        }

        .empty-state i {
            font-size: 4rem;
            margin-bottom: 20px;
            opacity: 0.3;
            color: #667eea;
        }

        .empty-state h4 {
            color: #111b21;
            margin-bottom: 8px;
        }

        .empty-state p {
            color: #667781;
            margin-bottom: 20px;
        }

        /* Indicadores de flujo */
        .flow-indicator {
            background-color: rgba(102,126,234,0.1);
            border-left: 3px solid #667eea;
            padding: 6px 10px;
            margin: 4px 0;
            border-radius: 4px;
            font-size: 12px;
            color: #667eea;
        }

        .auto-response-badge {
            background-color: #667eea;
            color: white;
            font-size: 10px;
            padding: 2px 6px;
            border-radius: 8px;
            margin-left: 6px;
        }

        /* ===== ESTILOS MEJORADOS PARA EL MODAL assignAdvisorModal ===== */
        #assignAdvisorModal {
            backdrop-filter: blur(10px) !important;
            -webkit-backdrop-filter: blur(10px) !important;
            background-color: rgba(0, 0, 0, 0.7) !important;
            animation: fadeInBackdrop 0.4s ease-out;
        }

        @keyframes fadeInBackdrop {
            from { opacity: 0; }
            to { opacity: 1; }
        }

        #assignAdvisorModal .modal-dialog {
            animation: slideInUp 0.5s cubic-bezier(0.34, 1.56, 0.64, 1);
            transform: none !important;
        }

        @keyframes slideInUp {
            from {
                opacity: 0;
                transform: translateY(60px) scale(0.8);
            }
            to {
                opacity: 1;
                transform: translateY(0) scale(1);
            }
        }

        #assignAdvisorModal .modal-content {
            border: none !important;
            border-radius: 24px !important;
            box-shadow: 0 30px 60px rgba(0, 0, 0, 0.3), 
                        0 0 0 1px rgba(255, 255, 255, 0.1),
                        0 0 40px rgba(102, 126, 234, 0.15) !important;
            background: linear-gradient(145deg, #ffffff 0%, #f8f9fa 100%);
            overflow: hidden;
            position: relative;
        }

        /* Efecto de brillo sutil en el modal */
        #assignAdvisorModal .modal-content::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 2px;
            background: linear-gradient(90deg, transparent, rgba(102, 126, 234, 0.8), transparent);
            animation: shimmer 3s ease-in-out infinite;
        }

        @keyframes shimmer {
            0%, 100% { opacity: 0.3; }
            50% { opacity: 1; }
        }

        #assignAdvisorModal .modal-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%) !important;
            color: white !important;
            border-bottom: none !important;
            padding: 24px 28px 20px 28px !important;
            position: relative;
            overflow: hidden;
        }

        /* Efecto de ondas en el header */
        #assignAdvisorModal .modal-header::before {
            content: '';
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: radial-gradient(circle, rgba(255, 255, 255, 0.15) 0%, transparent 70%);
            animation: wave 8s ease-in-out infinite;
        }

        @keyframes wave {
            0%, 100% { transform: rotate(0deg) scale(1); }
            50% { transform: rotate(180deg) scale(1.1); }
        }

        #assignAdvisorModal .modal-title {
            font-weight: 700 !important;
            font-size: 1.35rem !important;
            margin: 0 !important;
            position: relative;
            z-index: 1;
            display: flex;
            align-items: center;
            text-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }

        #assignAdvisorModal .modal-title i {
            background: rgba(255, 255, 255, 0.25);
            padding: 10px;
            border-radius: 12px;
            margin-right: 14px !important;
            font-size: 1.1rem;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }

        #assignAdvisorModal .btn-close {
            background: rgba(255, 255, 255, 0.2) !important;
            border-radius: 12px !important;
            padding: 10px !important;
            opacity: 1 !important;
            position: relative;
            z-index: 1;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }

        #assignAdvisorModal .btn-close:hover {
            background: rgba(255, 255, 255, 0.35) !important;
            transform: rotate(90deg) scale(1.1);
            box-shadow: 0 6px 12px rgba(0, 0, 0, 0.15);
        }

        #assignAdvisorModal .modal-body {
            padding: 28px !important;
            background: white;
            position: relative;
        }

        /* Mejoras para el select */
        #assignAdvisorModal #advisorSelect {
            border: 2px solid #e9ecef !important;
            border-radius: 16px !important;
            padding: 16px 20px !important;
            font-size: 1rem !important;
          
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1) !important;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08) !important;
            position: relative;
            font-weight: 500;
        }

        #assignAdvisorModal #advisorSelect:focus {
            border-color: #667eea !important;
            box-shadow: 0 0 0 4px rgba(102, 126, 234, 0.15), 
                        0 8px 25px rgba(102, 126, 234, 0.2) !important;
            outline: none !important;
            transform: translateY(-2px);
        }

        #assignAdvisorModal #advisorSelect:hover {
            border-color: #667eea !important;
            transform: translateY(-1px);
            box-shadow: 0 6px 20px rgba(0, 0, 0, 0.12) !important;
        }

        /* Estilo para las opciones del select */
        #assignAdvisorModal #advisorSelect option {
            padding: 12px;
            background: white;
            color: #333;
            font-weight: 500;
        }

        #assignAdvisorModal .modal-footer {
            background: linear-gradient(145deg, #f8f9fa 0%, #e9ecef 100%) !important;
            border-top: 1px solid #dee2e6 !important;
            padding: 20px 28px !important;
            display: flex;
            gap: 16px;
            justify-content: flex-end;
        }

        /* Mejoras para los botones */
        #assignAdvisorModal .btn {
            border-radius: 14px !important;
            padding: 12px 24px !important;
            font-weight: 600 !important;
            font-size: 0.95rem !important;
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1) !important;
            border: none !important;
            position: relative;
            overflow: hidden;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        #assignAdvisorModal .btn::before {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            width: 0;
            height: 0;
            background: rgba(255, 255, 255, 0.4);
            border-radius: 50%;
            transform: translate(-50%, -50%);
            transition: width 0.8s, height 0.8s;
        }

        #assignAdvisorModal .btn:hover::before {
            width: 400px;
            height: 400px;
        }

        #assignAdvisorModal .btn-secondary {
            background: linear-gradient(135deg, #6c757d 0%, #5a6268 100%) !important;
            color: white !important;
            box-shadow: 0 6px 20px rgba(108, 117, 125, 0.4) !important;
        }

        #assignAdvisorModal .btn-secondary:hover {
            background: linear-gradient(135deg, #5a6268 0%, #495057 100%) !important;
            transform: translateY(-3px);
            box-shadow: 0 10px 30px rgba(108, 117, 125, 0.5) !important;
        }

        #assignAdvisorModal .btn-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%) !important;
            color: white !important;
            box-shadow: 0 6px 20px rgba(102, 126, 234, 0.4) !important;
        }

        #assignAdvisorModal .btn-primary:hover {
            background: linear-gradient(135deg, #5a6fd8 0%, #6a4190 100%) !important;
            transform: translateY(-3px);
            box-shadow: 0 10px 30px rgba(102, 126, 234, 0.5) !important;
        }

        #assignAdvisorModal .btn:active {
            transform: translateY(-1px) !important;
        }

        /* Efectos adicionales */
        #assignAdvisorModal .modal-content {
            animation: modalGlow 3s ease-in-out infinite alternate;
        }

        @keyframes modalGlow {
            from {
                box-shadow: 0 30px 60px rgba(0, 0, 0, 0.3), 
                           0 0 0 1px rgba(255, 255, 255, 0.1),
                           0 0 40px rgba(102, 126, 234, 0.15);
            }
            to {
                box-shadow: 0 30px 60px rgba(0, 0, 0, 0.3), 
                           0 0 0 1px rgba(255, 255, 255, 0.1),
                           0 0 60px rgba(102, 126, 234, 0.25);
            }
        }

        /* Indicador de carga para el select */
        #assignAdvisorModal #advisorSelect.loading {
            background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='24' height='24' viewBox='0 0 24 24' fill='none' stroke='%23667eea' stroke-width='2' stroke-linecap='round' stroke-linejoin='round'%3E%3Cpath d='M21 12a9 9 0 11-6.219-8.56'/%3E%3C/svg%3E");
            background-repeat: no-repeat;
            background-position: right 16px center;
            background-size: 20px;
            animation: spin 1s linear infinite;
        }

        @keyframes spin {
            from { transform: rotate(0deg); }
            to { transform: rotate(360deg); }
        }

        /* Responsive */
        @media (max-width: 576px) {
            #assignAdvisorModal .modal-dialog {
                margin: 1rem !important;
                max-width: calc(100% - 2rem) !important;
            }
            
            #assignAdvisorModal .modal-content {
                border-radius: 20px !important;
            }
            
            #assignAdvisorModal .modal-header,
            #assignAdvisorModal .modal-body,
            #assignAdvisorModal .modal-footer {
                padding: 20px !important;
            }

            #assignAdvisorModal .btn {
                padding: 10px 20px !important;
                font-size: 0.9rem !important;
            }
        }

        @media (max-width: 768px) {
            .sidebar {
                width: 80px;
            }
            
            .main-content {
                margin-left: 80px;
            }
            
            .sidebar-header h3,
            .sidebar-header small,
            .nav-link span,
            .user-details {
                display: none;
            }

            .chat-sidebar {
                width: 100%;
                position: absolute;
                z-index: 1000;
                height: 100%;
                transform: translateX(-100%);
                transition: transform 0.3s ease;
            }
            
            .chat-sidebar.show {
                transform: translateX(0);
            }

            .message-bubble {
                max-width: 85%;
            }
        }

        /* Scrollbar personalizado */
        .conversation-list::-webkit-scrollbar,
        .chat-box::-webkit-scrollbar {
            width: 6px;
        }

        .conversation-list::-webkit-scrollbar-track,
        .chat-box::-webkit-scrollbar-track {
            background: transparent;
        }

        .conversation-list::-webkit-scrollbar-thumb,
        .chat-box::-webkit-scrollbar-thumb {
            background-color: rgba(0,0,0,0.2);
            border-radius: 3px;
        }

        /* Animaciones */
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }

        .fade-in {
            animation: fadeIn 0.3s ease-out;
        }

        /* Online indicator */
        .online-indicator {
            width: 8px;
            height: 8px;
            border-radius: 50%;
            background-color: #667eea;
            display: inline-block;
            margin-right: 6px;
            animation: pulse 2s infinite;
        }

        @keyframes pulse {
            0% { opacity: 1; }
            50% { opacity: 0.5; }
            100% { opacity: 1; }
        }

        /* 🎯 ERROR HANDLING - Estilos para casos sin datos */
        .error-safe {
            display: inline-block;
            color: #6c757d;
            font-style: italic;
        }

        .platform-safe {
            display: inline-flex;
            align-items: center;
            gap: 4px;
        }
    </style>
<!-- Contenido Principal -->
<div class="fade-in">
    <!-- Header del contenido -->
    <div class="content-header">
        <div class="d-flex align-items-center">
            <button class="toggle-btn" id="toggleSidebar">
                <i class="fas fa-bars"></i>
            </button>
            <div>
                <h5 class="mb-0">
                    <i class="fas fa-robot text-primary me-2"></i>
                    Chat Solibot Multi-Plataforma
                </h5>
                <small class="text-muted">Conversaciones inteligentes en tiempo real</small>
            </div>
        </div>
        <div class="d-flex align-items-center">
            <span class="online-indicator"></span>
            <small class="text-muted">Bot Activo</small>
            <div class="ms-3">
                <span class="badge bg-success">
                    <?= isset($conversations) ? count($conversations) : 0 ?> Conversaciones
                </span>
            </div>
        </div>
    </div>

    <!-- Contenido de la página -->
    <div class="chat-container">
        <div class="chat-content">
            <!-- Lista de conversaciones -->
            <div class="chat-sidebar">
                <input type="text" id="search-conversations" class="search-bar" placeholder="Buscar conversaciones...">
                
                <div class="conversation-list">
                    <?php if (!empty($conversations) && is_array($conversations)): ?>
                        <?php foreach ($conversations as $sender => $conversation): ?>
                            <?php
                            // 🎯 PROTECCIÓN CONTRA ERRORES - Validar datos
                            $conversation = is_array($conversation) ? $conversation : [];
                            $platform = isset($conversation['platform']) ? strtolower($conversation['platform']) : 'unknown';
                            $isActive = (isset($selectedSender) && $sender === $selectedSender) ? 'active' : '';
                            $messages = isset($conversation['messages']) && is_array($conversation['messages']) ? $conversation['messages'] : [];
                            $lastActivity = isset($conversation['last_activity']) ? $conversation['last_activity'] : time();
                            $assignedAdvisors = isset($conversation['asignados']) && is_array($conversation['asignados']) ? $conversation['asignados'] : [];
                            $currentRole = session() ? session()->get('role') : '';
                            
                            // Obtener último mensaje de forma segura
                            $lastMessage = '';
                            if (!empty($messages)) {
                                $lastMsg = end($messages);
                                $lastMessage = isset($lastMsg['message']) ? $lastMsg['message'] : 'Sin mensajes';
                            } else {
                                $lastMessage = 'Sin mensajes';
                            }
                            
                            // Determinar clase de plataforma
                            $platformClass = in_array($platform, ['whatsapp', 'instagram', 'telegram']) ? $platform : 'unknown';
                            ?>
                            <div class="conversation-item <?= $isActive; ?>" data-sender="<?= htmlspecialchars($sender); ?>" data-platform="<?= htmlspecialchars($platform); ?>">
                                
                                <div class="conversation-header">
                                    <div class="conversation-name platform-safe">
                                        <span class="platform-icon <?= $platformClass; ?>"></span>
                                        <?= htmlspecialchars($sender); ?>
                                        <span class="platform-badge platform-<?= $platformClass; ?>">
                                            <?= ucfirst($platform); ?>
                                        </span>
                                    </div>
                                    <div class="conversation-time">
                                        <?= $lastActivity ? date('H:i', $lastActivity) : date('H:i'); ?>
                                    </div>
                                </div>
                                
                                <div class="conversation-preview">
                                    <?= htmlspecialchars(substr($lastMessage, 0, 50) . (strlen($lastMessage) > 50 ? '...' : '')); ?>
                                </div>
                                
                                <div class="conversation-status">
                                    <?php if (isset($conversation['assigned_to']) && $conversation['assigned_to']): ?>
                                        <span class="status-badge status-assigned">Asignado</span>
                                    <?php else: ?>
                                        <span class="status-badge status-bot">Bot Automático</span>
                                    <?php endif; ?>
                                    
                                    <small class="text-muted">
                                        <?= count($messages); ?> mensaje<?= count($messages) !== 1 ? 's' : ''; ?>
                                    </small>

                                    <!-- 🎯 Mostrar razón de acceso si existe -->
                                    <?php if (isset($conversation['access_reason'])): ?>
                                        <?php
                                        $accessReason = $conversation['access_reason'];
                                        $reasonClass = $accessReason === 'flow' ? 'flow' : ($accessReason === 'ticket' ? 'ticket' : 'both');
                                        $reasonText = $accessReason === 'flow' ? 'Flow' : ($accessReason === 'ticket' ? 'Ticket' : 'Ambos');
                                        ?>
                                        <span class="access-reason-badge access-<?= $reasonClass; ?>">
                                            <?= $reasonText; ?>
                                        </span>
                                    <?php endif; ?>

                                    <!-- 🎯 Mostrar contador de mensajes no leídos si existe -->
                                    <?php if (isset($conversation['unread_count']) && $conversation['unread_count'] > 0): ?>
                                        <span class="status-badge" style="background-color: #ff3333; color: white;">
                                            <?= $conversation['unread_count']; ?>
                                        </span>
                                    <?php endif; ?>
                                </div>

                                <!-- 🎯 NUEVA SECCIÓN: Mostrar asesores asignados -->
                                <?php if ($currentRole === 'admin' && !empty($assignedAdvisors)): ?>
                                    <div class="advisor-info">
                                        <div class="advisor-count">
                                            <i class="fas fa-users me-1"></i>
                                            <?= count($assignedAdvisors); ?> asesor<?= count($assignedAdvisors) > 1 ? 'es' : ''; ?> asignado<?= count($assignedAdvisors) > 1 ? 's' : ''; ?>
                                        </div>
                                        <div class="advisor-list">
                                            <?php foreach ($assignedAdvisors as $advisorId): ?>
                                                <?php
                                                // Aquí deberías obtener el nombre real del asesor de la base de datos
                                                $advisorName = "Asesor #" . htmlspecialchars($advisorId);
                                                ?>
                                                <span class="advisor-badge"><?= $advisorName; ?></span>
                                            <?php endforeach; ?>
                                        </div>
                                    </div>
                                <?php endif; ?>

                                <!-- 🎯 Información adicional para tickets -->
                                <?php if (isset($conversation['ticket_info']) && is_array($conversation['ticket_info'])): ?>
                                    <div class="advisor-info">
                                        <div class="advisor-count">
                                            <i class="fas fa-ticket-alt me-1"></i>
                                            Ticket: #<?= isset($conversation['ticket_info']['ticket_number']) ? htmlspecialchars($conversation['ticket_info']['ticket_number']) : 'N/A'; ?>
                                        </div>
                                        <small class="text-muted">
                                            <?= isset($conversation['ticket_info']['subject']) ? htmlspecialchars($conversation['ticket_info']['subject']) : 'Sin asunto'; ?>
                                        </small>
                                    </div>
                                <?php endif; ?>
                            </div>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <div class="empty-state p-4">
                            <i class="fas fa-robot"></i>
                            <h6>No hay conversaciones</h6>
                            <p class="small">Las conversaciones aparecerán cuando los usuarios escriban al bot desde cualquier plataforma</p>
                            <div class="platform-safe mt-2">
                                <span class="platform-badge platform-whatsapp">WhatsApp</span>
                                <span class="platform-badge platform-instagram">Instagram</span>
                                <span class="platform-badge platform-telegram">Telegram</span>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Área principal del chat -->
            <div class="chat-main">
                <?php if (isset($selectedSender) && $selectedSender): ?>
                    <?php
                    // 🎯 PROTECCIÓN: Obtener datos de conversación seleccionada de forma segura
                    $selectedConvData = isset($conversations[$selectedSender]) && is_array($conversations[$selectedSender]) ? $conversations[$selectedSender] : [];
                    $selectedPlatform = isset($selectedConvData['platform']) ? strtolower($selectedConvData['platform']) : 'unknown';
                    $platformClass = in_array($selectedPlatform, ['whatsapp', 'instagram', 'telegram']) ? $selectedPlatform : 'unknown';
                    $selectedConversation = isset($selectedConversation) && is_array($selectedConversation) ? $selectedConversation : [];
                    $assignedAdvisors = isset($selectedConvData['asignados']) && is_array($selectedConvData['asignados']) ? $selectedConvData['asignados'] : [];
                    $currentRole = session() ? session()->get('role') : '';
                    ?>
                    
                    <!-- Header del chat -->
                    <div class="chat-header">
                        <div class="chat-header-info">
                            <div class="chat-avatar">
                                <?= strtoupper(substr($selectedSender, -2)); ?>
                                <div class="platform-indicator platform-icon <?= $platformClass; ?>"></div>
                            </div>
                            <div class="chat-user-info">
                                <h6>
                                    <?= htmlspecialchars($selectedSender); ?>
                                    <span class="platform-badge platform-<?= $platformClass; ?>">
                                        <?= ucfirst($selectedPlatform); ?>
                                    </span>
                                </h6>
                                <small>
                                    <?php 
                                    $status = isset($selectedConvData['status']) ? $selectedConvData['status'] : 'active';
                                    if (isset($selectedConvData['current_flow'])) {
                                        echo 'Flujo: ' . htmlspecialchars($selectedConvData['current_flow']);
                                    } else {
                                        echo 'En línea • ' . ucfirst($selectedPlatform);
                                    }
                                    ?>
                                </small>
                            </div>
                        </div>
                        <div class="chat-actions">
                            <button class="btn btn-outline-secondary btn-sm" onclick="updateConversation()">
                                <i class="fas fa-sync-alt"></i>
                            </button>
                        </div>
                    </div>

                    <!-- 🎯 NUEVA SECCIÓN: Información de asesores en el header del chat -->
                    <?php if ($currentRole === 'admin' && !empty($assignedAdvisors)): ?>
                        <div class="chat-advisor-info">
                            <h6><i class="fas fa-user-tie me-1"></i>Asesores Asignados</h6>
                            <div class="chat-advisor-list">
                                <?php foreach ($assignedAdvisors as $advisorId): ?>
                                    <?php
                                    // Aquí deberías obtener el nombre real del asesor
                                    $advisorName = "Asesor #" . htmlspecialchars($advisorId);
                                    ?>
                                    <span class="chat-advisor-badge"><?= $advisorName; ?></span>
                                <?php endforeach; ?>
                            </div>
                            
                            <!-- Información adicional del flow -->
                            <?php if (isset($resultado) && isset($resultado[$selectedSender])): ?>
                                <div class="mt-2">
                                    <small class="text-muted">
                                        <i class="fas fa-sitemap me-1"></i>
                                        Flow: <?= isset($resultado[$selectedSender]['flow_key']) ? htmlspecialchars($resultado[$selectedSender]['flow_key']) : 'N/A'; ?> 
                                        (ID: <?= isset($resultado[$selectedSender]['flow_id']) ? htmlspecialchars($resultado[$selectedSender]['flow_id']) : 'N/A'; ?>)
                                    </small>
                                </div>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>

                    <!-- Área de mensajes -->
                    <div class="chat-box" id="chat-box">
                        <?php if (!empty($selectedConversation)): ?>
                            <?php foreach ($selectedConversation as $message): ?>
                                <?php
                                // 🎯 PROTECCIÓN: Validar estructura del mensaje
                                $message = is_array($message) ? $message : [];
                                $messageText = isset($message['message']) ? $message['message'] : '';
                                $messageType = isset($message['type']) ? $message['type'] : 'received';
                                $senderType = isset($message['sender_type']) ? $message['sender_type'] : '';
                                $timestamp = isset($message['timestamp']) ? $message['timestamp'] : time();
                                $flowId = isset($message['flow_id']) ? $message['flow_id'] : '';
                                $messagePlatform = isset($message['platform']) ? strtolower($message['platform']) : $selectedPlatform;
                                $msgPlatformClass = in_array($messagePlatform, ['whatsapp', 'instagram', 'telegram']) ? $messagePlatform : 'unknown';
                                ?>
                                <div class="message <?= htmlspecialchars($messageType); ?> fade-in" data-platform="<?= htmlspecialchars($messagePlatform); ?>">
                                    <?php if ($senderType === 'bot'): ?>
                                        <div class="message-sender">
                                            <span class="platform-icon <?= $msgPlatformClass; ?>"></span>
                                            <i class="fas fa-robot me-1"></i>Solibot
                                            <span class="auto-response-badge">Auto</span>
                                        </div>
                                    <?php elseif ($senderType === 'advisor'): ?>
                                        <div class="message-sender">
                                            <span class="platform-icon <?= $msgPlatformClass; ?>"></span>
                                            <i class="fas fa-user-tie me-1"></i>Asesor
                                        </div>
                                    <?php elseif ($senderType === 'user'): ?>
                                        <div class="message-sender">
                                            <span class="platform-icon <?= $msgPlatformClass; ?>"></span>
                                            <i class="fas fa-user me-1"></i>Usuario
                                        </div>
                                    <?php endif; ?>
                                    
                                    <div class="message-bubble">
                                        <?= nl2br(htmlspecialchars($messageText)); ?>
                                        <div class="message-time">
                                            <?= date('H:i', $timestamp); ?>
                                            <?php if ($flowId): ?>
                                                <i class="fas fa-robot ms-1" title="Respuesta automática"></i>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <div class="empty-state">
                                <i class="fas fa-comment-slash"></i>
                                <p>No hay mensajes en esta conversación</p>
                                <small class="text-muted">
                                    Conversación desde <?= ucfirst($selectedPlatform); ?>
                                </small>
                            </div>
                        <?php endif; ?>
                    </div>

                    <!-- Caja de respuesta -->
                    <div class="response-box">
                        <textarea id="response-message" class="response-input" rows="1" 
                                  placeholder="Escribe un mensaje para <?= ucfirst($selectedPlatform); ?>..." 
                                  onkeypress="handleKeyPress(event)"
                                  oninput="autoResize(this)"></textarea>
                        <button id="send-message" class="send-button" title="Enviar mensaje a <?= ucfirst($selectedPlatform); ?>">
                            <i class="fas fa-paper-plane"></i>
                        </button>
                    </div>

<!-- Modal mejorado - EXACTAMENTE EL MISMO HTML -->
<div id="assignAdvisorModal" style="display: none; position: fixed; top: 0; left: 0; width: 100vw; height: 100vh; z-index: 1055; background-color: rgba(0, 0, 0, 0.6);">
  <div class="modal-dialog modal-lg modal-dialog-centered" style="margin: auto; top: 25%;">
    <div class="modal-content shadow rounded-3" style="background-color: #fff; border: 1px solid #ccc;">
      
      <div class="modal-header py-2">
        <h5 class="modal-title">
          <i class="fas fa-user-tie text-primary me-2"></i>Asignar Asesor
        </h5>
        <button type="button" class="btn-close" onclick="closeAssignModal()" aria-label="Cerrar"></button>
      </div>
      
      <div class="modal-body">
        <div class="mb-2">
          <label class="form-label">Seleccionar asesor:</label>
          <select id="advisorSelect" class="form-select form-select-sm">
            <!-- Se llena dinámicamente -->
          </select>
        </div>

        <div class="form-check mb-2">
          <input class="form-check-input" type="checkbox" id="priorityTicket">
          <label class="form-check-label" for="priorityTicket">Asignar como ticket prioritario</label>
        </div>

        <div class="form-check mb-2">
          <input class="form-check-input" type="checkbox" id="sendObservation">
          <label class="form-check-label" for="sendObservation">¿Desea enviar observación?</label>
        </div>

        <div class="mb-2" id="observationField" style="display: none;">
          <textarea id="observationText" class="form-control form-control-sm" rows="2" placeholder="Escribe la observación..."></textarea>
        </div>
      </div>

      <div class="modal-footer py-2">
        <button class="btn btn-secondary btn-sm" onclick="closeAssignModal()">Cancelar</button>
        <button class="btn btn-primary btn-sm" onclick="confirmAdvisorAssignment()">Asignar</button>
      </div>
    </div>
  </div>
</div>

                    <!-- Acciones rápidas -->
                    <div class="action-section">
                        <button class="action-btn" onclick="transferConversation()">
                            <i class="fas fa-user-tie me-1"></i>Asignar Asesor
                        </button>
                        <button class="action-btn" onclick="viewFlowHistory()">
                            <i class="fas fa-history me-1"></i>Historial
                        </button>
                        <button class="action-btn" onclick="exportConversation()">
                            <i class="fas fa-download me-1"></i>Exportar Chat
                        </button>
                    </div>

                <?php else: ?>
                    <div class="empty-state">
                        <i class="fas fa-robot" style="background: linear-gradient(45deg, #25d366, #0088cc); -webkit-background-clip: text; -webkit-text-fill-color: transparent;"></i>
                        <h4>Chat Solibot Multi-Plataforma</h4>
                        <p>Selecciona una conversación para comenzar a chatear</p>
                        <div class="mt-4">
                            <div class="alert alert-light border">
                                <h6><i class="fas fa-robot me-2"></i>Sistema Inteligente Activo</h6>
                                <ul class="mb-0 small">
                                    <li>✅ Respuestas automáticas configuradas</li>
                                    <li>✅ Flujos de atención activos</li>
                                    <li>✅ Intervención manual disponible</li>
                                    <li>🎯 Soporte multi-plataforma habilitado</li>
                                </ul>
                                <div class="platform-safe mt-3">
                                    <span class="platform-badge platform-whatsapp me-2"><i class="fas fa-check me-1"></i>WhatsApp</span>
                                    <span class="platform-badge platform-instagram me-2"><i class="fas fa-check me-1"></i>Instagram</span>
                                    <span class="platform-badge platform-telegram"><i class="fas fa-check me-1"></i>Telegram</span>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>

        </div>
        
    </div>
</div>

<script>
// Variables globales - Protegidas contra errores
const currentSender = "<?= isset($selectedSender) ? htmlspecialchars($selectedSender) : ''; ?>";
const currentPlatform = "<?= isset($selectedConvData['platform']) ? htmlspecialchars(strtolower($selectedConvData['platform'])) : 'unknown'; ?>";
let lastMessageTimestamp = <?= !empty($selectedConversation) ? end($selectedConversation)['timestamp'] : 0 ?>;
let renderedMessages = new Set();
let isUpdating = false; // Flag para evitar actualizaciones múltiples

// 🎯 FUNCIONES DE UTILIDAD PARA MANEJO SEGURO DE DATOS
function safeGet(obj, key, defaultValue = '') {
    try {
        return obj && typeof obj === 'object' && obj.hasOwnProperty(key) ? obj[key] : defaultValue;
    } catch (e) {
        console.warn('Error accessing object property:', e);
        return defaultValue;
    }
}

function safePlatformClass(platform) {
    const validPlatforms = ['whatsapp', 'instagram', 'telegram'];
    return validPlatforms.includes(platform) ? platform : 'unknown';
}

function getPlatformIcon(platform) {
    const icons = {
        'whatsapp': '💬',
        'instagram': '📷',
        'telegram': '✈️',
        'unknown': '💻'
    };
    return icons[platform] || icons['unknown'];
}

// Toggle sidebar
if (document.getElementById('toggleSidebar')) {
    document.getElementById('toggleSidebar').addEventListener('click', function() {
        const sidebar = document.getElementById('sidebar');
        const mainContent = document.getElementById('mainContent');
        
        if (sidebar) sidebar.classList.toggle('collapsed');
        if (mainContent) mainContent.classList.toggle('expanded');
    });
}

// Inicializar cuando carga la página
document.addEventListener('DOMContentLoaded', function() {
    setupEventListeners();
    
    // Auto-scroll al cargar
    if (currentSender) {
        setTimeout(() => {
            scrollToBottom();
        }, 100);
    }
    
    console.log(`🎯 Solibot Multi-Plataforma iniciado - Conversación actual: ${currentSender} (${currentPlatform})`);
});

function setupEventListeners() {
    try {
        // Filtro de conversaciones con soporte multi-plataforma
        const searchInput = document.getElementById('search-conversations');
        if (searchInput) {
            searchInput.addEventListener('input', function () {
                const query = this.value.toLowerCase();
                document.querySelectorAll('.conversation-item').forEach(item => {
                    const text = item.textContent.toLowerCase();
                    const platform = item.dataset.platform || '';
                    const matches = text.includes(query) || platform.includes(query);
                    item.style.display = matches ? '' : 'none';
                });
            });
        }

        // Seleccionar conversación
        document.querySelectorAll('.conversation-item').forEach(item => {
            item.addEventListener('click', function () {
                try {
                    const sender = this.dataset.sender;
                    const platform = this.dataset.platform || 'unknown';
                    
                    if (!sender) {
                        console.warn('Sender no encontrado en el elemento');
                        return;
                    }
                    
                    // Actualizar estado visual
                    document.querySelectorAll('.conversation-item').forEach(i => i.classList.remove('active'));
                    this.classList.add('active');
                    
                    // Redirigir con información de plataforma
                    const baseUrl = "<?= base_url('conversations'); ?>";
                    window.location.href = `${baseUrl}/${encodeURIComponent(sender)}?platform=${encodeURIComponent(platform)}`;
                } catch (e) {
                    console.error('Error al seleccionar conversación:', e);
                    showNotification("Error al seleccionar conversación", "error");
                }
            });
        });

        // Enviar mensaje
        const sendButton = document.getElementById('send-message');
        if (sendButton) {
            sendButton.addEventListener('click', sendMessage);
        }
    } catch (e) {
        console.error('Error en setupEventListeners:', e);
    }
}

function sendMessage() {
    try {
        const messageInput = document.getElementById('response-message');
        if (!messageInput) {
            console.error('Input de mensaje no encontrado');
            return;
        }
        
        const message = messageInput.value.trim();
        
        if (message === "" || isUpdating || !currentSender) {
            return;
        }

        // Deshabilitar botón mientras se envía
        const sendBtn = document.getElementById('send-message');
        if (sendBtn) {
            sendBtn.disabled = true;
            sendBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i>';
        }
        isUpdating = true;

        const requestData = {
            sender: currentSender,
            message: message,
            platform: currentPlatform || 'unknown'
        };

        fetch("<?= base_url('conversations/send'); ?>", {
            method: "POST",
            headers: {
                "Content-Type": "application/json"
            },
            body: JSON.stringify(requestData)
        })
        .then(response => {
            if (!response.ok) {
                throw new Error(`HTTP error! status: ${response.status}`);
            }
            return response.json();
        })
        .then(data => {
            if (data && data.status === "success") {
                messageInput.value = "";
                messageInput.style.height = 'auto';
                
                // Esperar un momento antes de actualizar para evitar duplicados
                setTimeout(() => {
                    updateConversation();
                }, 500);
                
                showNotification(`Mensaje enviado via ${currentPlatform.toUpperCase()}`, "success");
            } else {
                showNotification("Error: " + (data ? data.message : 'Respuesta inválida'), "error");
            }
        })
        .catch(error => {
            console.error('Error enviando mensaje:', error);
            showNotification("Error de conexión", "error");
        })
        .finally(() => {
            // Rehabilitar botón
            if (sendBtn) {
                sendBtn.disabled = false;
                sendBtn.innerHTML = '<i class="fas fa-paper-plane"></i>';
                messageInput.focus();
            }
            isUpdating = false;
        });
    } catch (e) {
        console.error('Error en sendMessage:', e);
        showNotification("Error inesperado al enviar mensaje", "error");
        isUpdating = false;
    }
}

function sendQuickMessage(message) {
    if (isUpdating || !currentSender) return;
    
    try {
        const messageInput = document.getElementById('response-message');
        if (messageInput) {
            messageInput.value = message;
            sendMessage();
        }
    } catch (e) {
        console.error('Error en sendQuickMessage:', e);
    }
}

function transferConversation() {
    try {
        fetch("<?= base_url('admin/get-advisors'); ?>")
            .then(res => {
                if (!res.ok) throw new Error(`HTTP error! status: ${res.status}`);
                return res.json();
            })
            .then(data => {
                if (data && data.status === "success" && data.advisors) {
                    const select = document.getElementById('advisorSelect');
                    if (select) {
                        select.innerHTML = '<option value="">Seleccionar...</option>';
                        data.advisors.forEach(adv => {
                            if (adv && adv.id && adv.name) {
                                const opt = document.createElement('option');
                                opt.value = adv.id;
                                opt.textContent = adv.name;
                                select.appendChild(opt);
                            }
                        });
                        document.getElementById('assignAdvisorModal').style.display = 'block';
                    }
                } else {
                    showNotification("No se pudieron cargar los asesores", "error");
                }
            })
            .catch(error => {
                console.error('Error cargando asesores:', error);
                showNotification("Error al cargar asesores", "error");
            });
    } catch (e) {
        console.error('Error en transferConversation:', e);
        showNotification("Error inesperado", "error");
    }
}

function resetToMainMenu() {
    sendQuickMessage('menu');
}

function viewFlowHistory() {
    try {
        const chatMessages = [];
        const messageElements = document.querySelectorAll('#chat-box .message');

        messageElements.forEach(msgEl => {
            try {
                const senderEl = msgEl.querySelector('.message-sender');
                const bubbleEl = msgEl.querySelector('.message-bubble');
                const timeEl = msgEl.querySelector('.message-time');
                const platform = msgEl.dataset.platform || currentPlatform;

                const sender = senderEl ? senderEl.textContent.trim() : 'Desconocido';
                const text = bubbleEl ? bubbleEl.textContent.trim() : '';
                const time = timeEl ? timeEl.textContent.trim() : '';

                if (text) {
                    chatMessages.push({
                        sender,
                        message: text,
                        time,
                        platform
                    });
                }
            } catch (e) {
                console.warn('Error procesando mensaje individual:', e);
            }
        });

        if (chatMessages.length === 0) {
            showNotification("No hay mensajes para enviar.", "info");
            return;
        }

        // Confirmar antes de enviar
        if (!confirm(`¿Deseas enviar por correo el historial de esta conversación de ${currentPlatform.toUpperCase()}?`)) return;

        fetch("<?= base_url('conversations/send-history'); ?>", {
            method: "POST",
            headers: {
                "Content-Type": "application/json"
            },
            body: JSON.stringify({
                sender: currentSender,
                messages: chatMessages,
                platform: currentPlatform
            })
        })
        .then(res => {
            if (!res.ok) throw new Error(`HTTP error! status: ${res.status}`);
            return res.json();
        })
        .then(data => {
            if (data && data.status === "success") {
                showNotification("Historial enviado por correo correctamente.", "success");
            } else {
                showNotification("Error al enviar: " + (data ? data.message : 'Error desconocido'), "error");
            }
        })
        .catch(err => {
            console.error('Error enviando historial:', err);
            showNotification("Error al conectar con el servidor", "error");
        });
    } catch (e) {
        console.error('Error en viewFlowHistory:', e);
        showNotification("Error inesperado al procesar historial", "error");
    }
}

function exportConversation() {
    try {
        const messages = [];
        const messageElements = document.querySelectorAll('#chat-box .message');
        
        messageElements.forEach(msgEl => {
            try {
                const senderEl = msgEl.querySelector('.message-sender');
                const bubbleEl = msgEl.querySelector('.message-bubble');
                const timeEl = msgEl.querySelector('.message-time');
                const platform = msgEl.dataset.platform || currentPlatform;

                const sender = senderEl ? senderEl.textContent.trim() : 'Usuario';
                const text = bubbleEl ? bubbleEl.textContent.trim() : '';
                const time = timeEl ? timeEl.textContent.trim() : new Date().toLocaleTimeString();

                if (text) {
                    messages.push(`[${time}] ${sender} (${platform.toUpperCase()}): ${text}`);
                }
            } catch (e) {
                console.warn('Error procesando mensaje para exportar:', e);
            }
        });

        if (messages.length === 0) {
            showNotification("No hay mensajes para exportar", "info");
            return;
        }

        const content = `Conversación Solibot Multi-Plataforma\n` +
                       `Usuario: ${currentSender}\n` +
                       `Plataforma: ${currentPlatform.toUpperCase()}\n` +
                       `Fecha: ${new Date().toLocaleString()}\n` +
                       `${'='.repeat(50)}\n\n` +
                       messages.join('\n');

        const blob = new Blob([content], { type: 'text/plain' });
        const url = window.URL.createObjectURL(blob);
        const a = document.createElement('a');
        a.href = url;
        a.download = `chat_${currentSender}_${currentPlatform}_${new Date().toISOString().split('T')[0]}.txt`;
        document.body.appendChild(a);
        a.click();
        document.body.removeChild(a);
        window.URL.revokeObjectURL(url);

        showNotification("Conversación exportada correctamente", "success");
    } catch (e) {
        console.error('Error exportando conversación:', e);
        showNotification("Error al exportar conversación", "error");
    }
}

function updateConversation() {
    if (!currentSender || isUpdating) return;
    
    try {
        isUpdating = true;
        
        const url = `<?= base_url('conversations/get/'); ?>${encodeURIComponent(currentSender)}?platform=${encodeURIComponent(currentPlatform)}`;

        fetch(url)
            .then(response => {
                if (!response.ok) throw new Error(`HTTP error! status: ${response.status}`);
                return response.json();
            })
            .then(data => {
                if (data && data.status === "success" && data.conversation) {
                    const chatBox = document.getElementById('chat-box');
                    if (!chatBox) return;
                    
                    const wasAtBottom = isScrolledToBottom();

                    // Agregar solo nuevos mensajes
                    data.conversation.forEach(message => {
                        try {
                            if (!message || !message.message || (message.timestamp && message.timestamp <= lastMessageTimestamp)) return;

                            renderNewMessage(message);
                            if (message.timestamp) {
                                lastMessageTimestamp = message.timestamp;
                            }
                        } catch (e) {
                            console.warn('Error procesando mensaje individual en actualización:', e);
                        }
                    });

                    if (wasAtBottom) scrollToBottom();
                } else {
                    console.warn('Respuesta de actualización inválida:', data);
                }
            })
            .catch(error => {
                console.error("Error al actualizar conversación:", error);
            })
            .finally(() => {
                isUpdating = false;
            });
    } catch (e) {
        console.error('Error en updateConversation:', e);
        isUpdating = false;
    }
}

function handleKeyPress(event) {
    try {
        if (event.key === 'Enter' && !event.shiftKey) {
            event.preventDefault();
            sendMessage();
        }
    } catch (e) {
        console.error('Error en handleKeyPress:', e);
    }
}

function autoResize(textarea) {
    try {
        if (textarea) {
            textarea.style.height = 'auto';
            textarea.style.height = Math.min(textarea.scrollHeight, 100) + 'px';
        }
    } catch (e) {
        console.error('Error en autoResize:', e);
    }
}

function scrollToBottom() {
    try {
        const chatBox = document.getElementById('chat-box');
        if (chatBox) {
            chatBox.scrollTop = chatBox.scrollHeight;
        }
    } catch (e) {
        console.error('Error en scrollToBottom:', e);
    }
}

function isScrolledToBottom() {
    try {
        const chatBox = document.getElementById('chat-box');
        if (!chatBox) return false;
        return chatBox.scrollTop + chatBox.clientHeight >= chatBox.scrollHeight - 5;
    } catch (e) {
        console.error('Error en isScrolledToBottom:', e);
        return false;
    }
}

function showNotification(message, type) {
    try {
        // Crear notificación estilo Solibot
        const notification = document.createElement('div');
        notification.className = 'position-fixed top-0 start-50 translate-middle-x mt-3';
        notification.style.zIndex = '9999';
        
        const alertClass = type === 'success' ? 'success' : type === 'error' ? 'danger' : 'info';
        notification.innerHTML = `
            <div class="alert alert-${alertClass} alert-dismissible fade show">
                ${message}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        `;
        
        document.body.appendChild(notification);
        
        setTimeout(() => {
            if (notification.parentNode) {
                notification.remove();
            }
        }, 3000);
    } catch (e) {
        console.error('Error mostrando notificación:', e);
        // Fallback a alert nativo
        alert(message);
    }
}

function renderNewMessage(message) {
    try {
        const chatBox = document.getElementById('chat-box');
        if (!chatBox || !message) return;
        
        const messageDiv = document.createElement('div');
        const messageType = safeGet(message, 'type', 'received');
        const senderType = safeGet(message, 'sender_type', '');
        const messagePlatform = safeGet(message, 'platform', currentPlatform);
        const platformClass = safePlatformClass(messagePlatform);
        
        messageDiv.classList.add('message', messageType, 'fade-in');
        messageDiv.dataset.platform = messagePlatform;

        let senderInfo = '';
        if (senderType === 'bot') {
            senderInfo = `<div class="message-sender">
                <span class="platform-icon ${platformClass}"></span>
                <i class="fas fa-robot me-1"></i>Solibot 
                <span class="auto-response-badge">Auto</span>
            </div>`;
        } else if (senderType === 'advisor') {
            senderInfo = `<div class="message-sender">
                <span class="platform-icon ${platformClass}"></span>
                <i class="fas fa-user-tie me-1"></i>Asesor
            </div>`;
        } else if (senderType === 'user') {
            senderInfo = `<div class="message-sender">
                <span class="platform-icon ${platformClass}"></span>
                <i class="fas fa-user me-1"></i>Usuario
            </div>`;
        }

        let flowIndicator = '';
        if (safeGet(message, 'flow_id', '')) {
            flowIndicator = '<i class="fas fa-robot ms-1" title="Respuesta automática"></i>';
        }

        const timestamp = safeGet(message, 'timestamp', Date.now() / 1000);
        const timeString = new Date(timestamp * 1000).toLocaleTimeString('es-ES', {hour: '2-digit', minute: '2-digit'});
        const messageText = safeGet(message, 'message', '').replace(/\n/g, '<br>');

        messageDiv.innerHTML = `
            ${senderInfo}
            <div class="message-bubble">
                ${messageText}
                <div class="message-time">${timeString}${flowIndicator}</div>
            </div>
        `;
        
        chatBox.appendChild(messageDiv);
    } catch (e) {
        console.error('Error renderizando nuevo mensaje:', e);
    }
}

let lastConversationListTimestamp = 0;

function updateConversationList() {
    try {
        const url = `<?= base_url('conversations/refresh-list'); ?>?last_timestamp=${lastConversationListTimestamp}&selected=${encodeURIComponent(currentSender)}&platform=${encodeURIComponent(currentPlatform)}`;
        
        fetch(url)
            .then(response => {
                if (!response.ok) throw new Error(`HTTP error! status: ${response.status}`);
                return response.json();
            })
            .then(data => {
                if (data && data.status === "success" && data.html) {
                    // Actualizar el timestamp solo si hay nuevos mensajes
                    if (data.last_timestamp && data.last_timestamp > lastConversationListTimestamp) {
                        lastConversationListTimestamp = data.last_timestamp;

                        // Reemplazar HTML de la lista de conversaciones
                        const container = document.querySelector('.conversation-list');
                        if (container) {
                            container.innerHTML = data.html;
                        }

                        // Volver a asignar eventos
                        setupEventListeners();
                    }
                }
            })
            .catch(error => {
                console.error("Error actualizando lista de conversaciones:", error);
            });
    } catch (e) {
        console.error('Error en updateConversationList:', e);
    }
}

function confirmAdvisorAssignment() {
    try {
        const advisorSelect = document.getElementById('advisorSelect');
        const priorityCheckbox = document.getElementById('priorityTicket');
        const observationCheckbox = document.getElementById('sendObservation');
        const observationText = document.getElementById('observationText');
        
        if (!advisorSelect || !currentSender) {
            showNotification("Error: Datos faltantes", "error");
            return;
        }
        
        const advisorId = advisorSelect.value;
        if (!advisorId) {
            showNotification("Por favor selecciona un asesor", "error");
            return;
        }
        
        const requestData = {
            sender: currentSender,
            user_id: advisorId,
            priority: priorityCheckbox ? priorityCheckbox.checked : false,
            observation: (observationCheckbox && observationCheckbox.checked && observationText) ? observationText.value.trim() : '',
            platform: currentPlatform
        };

        fetch("<?= base_url('conversations/assign'); ?>", {
            method: "POST",
            headers: { "Content-Type": "application/json" },
            body: JSON.stringify(requestData)
        })
        .then(res => {
            if (!res.ok) throw new Error(`HTTP error! status: ${res.status}`);
            return res.json();
        })
        .then(data => {
            if (data && data.status === 'success') {
                showNotification(`✅ Asignación exitosa en ${currentPlatform.toUpperCase()}`, "success");
                closeAssignModal();
                // Actualizar la conversación para mostrar el cambio
                setTimeout(() => updateConversation(), 1000);
            } else {
                showNotification("❌ " + (data ? data.message : 'Error desconocido'), "error");
            }
        })
        .catch(err => {
            console.error('Error en asignación:', err);
            showNotification("❌ Error de conexión", "error");
        });
    } catch (e) {
        console.error('Error en confirmAdvisorAssignment:', e);
        showNotification("❌ Error inesperado", "error");
    }
}

function closeAssignModal() {
    try {
        const modal = document.getElementById('assignAdvisorModal');
        if (modal) {
            modal.style.display = 'none';
        }
    } catch (e) {
        console.error('Error cerrando modal:', e);
    }
}

// Event listener para mostrar/ocultar campo de observación
const sendObservationCheckbox = document.getElementById('sendObservation');
if (sendObservationCheckbox) {
    sendObservationCheckbox.addEventListener('change', function () {
        try {
            const observationField = document.getElementById('observationField');
            if (observationField) {
                observationField.style.display = this.checked ? 'block' : 'none';
            }
        } catch (e) {
            console.error('Error manejando checkbox de observación:', e);
        }
    });
}

// Actualización automática controlada cada 3 segundos
if (currentSender) {
    setInterval(() => {
        try {
            if (!isUpdating) {
                updateConversation();
            }
            updateConversationList();
        } catch (e) {
            console.error('Error en actualización automática:', e);
        }
    }, 3000);
}

console.log('🎯 Chat Solibot Multi-Plataforma cargado correctamente');
console.log(`📱 Plataformas soportadas: WhatsApp, Instagram, Telegram`);
console.log(`🔄 Conversación actual: ${currentSender || 'Ninguna'} (${currentPlatform || 'unknown'})`);

</script>

</body>
</html>