<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Inicio de Sesión - Solibot</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="<?= base_url('css/style.css') ?>">
    <script src="https://www.google.com/recaptcha/api.js?hl=es" async defer></script>
    <style>
        /* Espaciado extra para el contenedor principal */
.container {
    margin-top: 60px; /* Ajusta este valor si es necesario */
}

        </style>
</head>
<body>

<header class="header header-fixed">
    <div class="container d-flex align-items-center">
        <img src="<?= base_url('img/logo.png') ?>" alt="Logo Solibot" class="logo">
        <span class="app-name">Solibot</span>
    </div>
</header>

<div class="container d-flex justify-content-center align-items-center vh-100 mt-5"> <!-- mt-5 para el margen superior -->
    <div class="col-md-4">
        <h2>Bienvenido a Solibot</h2>
        <p class="mb-4">Inicia sesión para gestionar el chatbot</p>

        <?php if (session()->getFlashdata('error')): ?>
            <div class="alert alert-danger">
                <?= session()->getFlashdata('error') ?>
            </div>
        <?php endif; ?>

        <form action="<?= base_url('auth/login') ?>" method="post">
            <div class="mb-3">
                <label for="username" class="form-label">Usuario</label>
                <input type="text" name="username" id="username" class="form-control" required>
            </div>
            <div class="mb-3">
                <label for="password" class="form-label">Contraseña</label>
                <input type="password" name="password" id="password" class="form-control" required>
            </div>
            <div class="g-recaptcha" data-sitekey="6LcjbnArAAAAAJWVRYwnOsOiZ5lGZ5aemuVFXGrj"></div>

         

            <button type="submit" class="btn btn-primary w-100">Iniciar Sesión</button>
        </form>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
