<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $title ?? 'Panel de Administración - Solibot'; ?></title>

    <!-- Cargar Bootstrap desde CDN -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script> <!-- Bootstrap Bundle con Popper -->

    <!-- Agregar Iconos de Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">

    <!-- Estilos personalizados -->
    <link rel="stylesheet" href="<?= base_url('css/style.css') ?>">

    <style>
        /* Incluye aquí tus estilos personalizados del header */
        .header {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            background-color: #ffffff;
            z-index: 1000;
            padding: 15px 0;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }
        .header .logo {
            height: 40px;
            margin-right: 10px;
        }
        .header .app-name {
            color: #00d4ff;
            font-size: 1.8rem;
            font-weight: bold;
            letter-spacing: 1px;
        }
        .navbar-nav .nav-link {
            color: #333333 !important;
            font-weight: 500;
            padding: 10px 20px;
            font-size: 1.1rem;
            border-radius: 8px;
            transition: background-color 0.3s ease, transform 0.3s ease;
        }
        .navbar-nav .nav-link:hover {
            background-color: #00d4ff;
            color: #ffffff;
            transform: scale(1.05);
        }
         
        /* Menú hamburguesa para móviles */
        .navbar-toggler-icon {
            background-color: #00d4ff;
        }

         /* Responsividad para pantallas móviles */
         @media (max-width: 768px) {
            .navbar-nav .nav-link {
                font-size: 0.9rem;
            }

            .navbar-nav .nav-item {
                padding-left: 15px;
            }

            .form-container {
                max-width: 90%;
                padding: 20px;
            }
        }
    </style>
</head>
<body>

<!-- Header -->
<header class="header">
    <div class="container d-flex align-items-center justify-content-between">
        <div class="d-flex align-items-center">
            <img src="<?= base_url('img/logo.png') ?>" alt="Logo Solibot" class="logo">
            <span class="app-name">Solibot</span>
        </div>
        <nav class="navbar navbar-expand-lg">
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <!-- Dashboard -->
                    <li class="nav-item">
                        <a class="nav-link" href="<?= base_url('admin/dashboard'); ?>">
                            <i class="fas fa-tachometer-alt nav-icon"></i> Dashboard
                        </a>
                    </li>
                    
                    <!-- Menú exclusivo para el administrador -->
                    <?php if (session()->get('role') === 'admin') : ?>
                        <!-- Gestión de Usuarios -->
                        <li class="nav-item">
                            <a class="nav-link" href="<?= base_url('admin/users'); ?>">
                                <i class="fas fa-users nav-icon"></i> Usuarios
                            </a>
                        </li>
                        <!-- Administración -->
                        <li class="nav-item">
                            <a class="nav-link" href="<?= base_url('admin/management'); ?>">
                                <i class="fas fa-cogs nav-icon"></i> Administración
                            </a>
                        </li>
                    <?php endif; ?>
                    
                    <!-- Flujos de Atención -->
                    <li class="nav-item">
                        <a class="nav-link" href="<?= base_url('admin/flows'); ?>">
                            <i class="fas fa-project-diagram nav-icon"></i> Flujos de Atención
                        </a>
                    </li>
                    
                    <!-- Tickets -->
                    <li class="nav-item">
                        <a class="nav-link" href="<?= base_url('admin/tickets'); ?>">
                            <i class="fas fa-ticket-alt nav-icon"></i> Tickets
                        </a>
                    </li>
                    
                    <!-- Logout -->
                    <li class="nav-item">
                        <form action="<?= base_url('logout'); ?>" method="POST" class="d-inline">
                            <button type="submit" class="btn btn-link nav-link">
                                <i class="fas fa-sign-out-alt nav-icon"></i> Salir
                            </button>
                        </form>
                    </li>
                </ul>
            </div>
        </nav>
    </div>
</header>

