<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $title ?? 'Panel de Administración - Chat Solibot'; ?></title>

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    
    <!-- Chart.js para gráficos -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

    <style>
        body {
            margin: 0;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f8f9fa;
        }

        /* Sidebar */
        .sidebar {
            position: fixed;
            top: 0;
            left: 0;
            height: 100vh;
            width: 280px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            z-index: 1000;
            transition: all 0.3s ease;
            overflow-y: auto;
            display: flex;
            flex-direction: column;
        }

        .sidebar.collapsed {
            width: 80px;
        }

        /* Logo del sidebar */
        .sidebar-header {
            padding: 20px;
            text-align: center;
            border-bottom: 1px solid rgba(255,255,255,0.1);
            flex-shrink: 0;
        }

        .sidebar-header .logo {
            width: 50px;
            height: 50px;
            border-radius: 50%;
            margin-bottom: 10px;
        }

        .sidebar-header h3 {
            margin: 0;
            font-size: 1.5rem;
            font-weight: bold;
            transition: opacity 0.3s ease;
        }

        .sidebar.collapsed .sidebar-header h3,
        .sidebar.collapsed .sidebar-header small {
            opacity: 0;
        }

        /* Navegación del sidebar */
        .sidebar-nav {
            padding: 10px 0;
            flex-grow: 1;
          /*  padding-bottom: 120px; /* Espacio extra para evitar solapamiento */
        }

        .nav-item {
            margin: 5px 15px;
        }

        .nav-link {
            display: flex;
            align-items: center;
            padding: 12px 20px;
            color: rgba(255,255,255,0.8);
            text-decoration: none;
            border-radius: 10px;
            transition: all 0.3s ease;
            position: relative;
        }

        .nav-link:hover {
            background-color: rgba(255,255,255,0.1);
            color: white;
            transform: translateX(5px);
        }

        .nav-link.active {
            background-color: rgba(255,255,255,0.2);
            color: white;
        }

        .nav-link i {
            width: 20px;
            margin-right: 15px;
            text-align: center;
        }

        .sidebar.collapsed .nav-link span {
            opacity: 0;
        }

        .sidebar.collapsed .badge {
            opacity: 0;
        }

        /* Usuario info en sidebar - POSICIÓN FIJA EN LA PARTE INFERIOR */
        .sidebar-user {
           /* position: absolute;*/
            bottom: 0;
            left: 0;
            right: 0;
            padding: 10px;
            border-top: 1px solid rgba(255,255,255,0.1);
            background: rgba(0,0,0,0.1);
            backdrop-filter: blur(10px);
        }

        .user-info {
            display: flex;
            align-items: center;
            margin-bottom: 15px;
        }

        .user-avatar {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background-color: rgba(255,255,255,0.2);
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 10px;
        }

        .user-details h6 {
            margin: 0;
            font-size: 0.9rem;
        }

        .user-details small {
            color: rgba(255,255,255,0.7);
        }

        .sidebar.collapsed .user-details {
            display: none;
        }

        .sidebar.collapsed .user-info {
            justify-content: center;
            margin-bottom: 10px;
        }

        /* Botón de logout mejorado */
        .logout-btn {
            background: rgba(255,255,255,0.1);
            border: 1px solid rgba(255,255,255,0.2);
            color: white;
            border-radius: 8px;
            padding: 8px 15px;
            font-size: 0.9rem;
            transition: all 0.3s ease;
            width: 100%;
        }

        .logout-btn:hover {
            background: rgba(255,255,255,0.2);
            border-color: rgba(255,255,255,0.3);
            color: white;
            transform: translateY(-1px);
        }

        .sidebar.collapsed .logout-btn span {
            display: none;
        }

        .sidebar.collapsed .logout-btn {
            padding: 8px;
            width: 40px;
            height: 40px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        /* Contenido principal */
        .main-content {
            margin-left: 280px;
            transition: margin-left 0.3s ease;
            min-height: 100vh;
        }

        .main-content.expanded {
            margin-left: 80px;
        }

        /* Header del contenido */
        .content-header {
            background: white;
            padding: 20px 30px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .toggle-btn {
            background: none;
            border: none;
            font-size: 1.2rem;
            color: #666;
            cursor: pointer;
            margin-right: 20px;
            padding: 8px;
            border-radius: 5px;
            transition: background-color 0.3s ease;
        }

        .toggle-btn:hover {
            background-color: #f8f9fa;
        }

        /* Tarjetas de estadísticas mejoradas */
        .stats-card {
            background: linear-gradient(135deg, #00d4ff 0%, #0288d1 100%);
            color: white;
            border-radius: 15px;
            padding: 25px;
            margin-bottom: 20px;
            box-shadow: 0 8px 25px rgba(0, 212, 255, 0.3);
            transition: transform 0.3s ease, box-shadow 0.3s ease;
            position: relative;
        }

        .stats-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 12px 35px rgba(0, 212, 255, 0.4);
        }

        .stats-number {
            font-size: 2.5rem;
            font-weight: bold;
            margin-bottom: 10px;
        }

        .stats-label {
            font-size: 1.1rem;
            opacity: 0.9;
        }

        .stats-icon {
            position: absolute;
            top: 20px;
            right: 20px;
            font-size: 2rem;
            opacity: 0.3;
        }

        /* Tarjetas del dashboard mejoradas */
        .dashboard-card {
            background: white;
            border-radius: 15px;
            padding: 25px;
            margin-bottom: 20px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.08);
            transition: transform 0.3s ease, box-shadow 0.3s ease;
            height: 220px;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
        }

        .dashboard-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 25px rgba(0,0,0,0.15);
        }

        .dashboard-card h4 {
            color: #333;
            margin-bottom: 15px;
            font-weight: 600;
        }

        .dashboard-card p {
            color: #666;
            flex-grow: 1;
        }

        .btn-dashboard {
            background: linear-gradient(135deg, #00d4ff 0%, #0288d1 100%);
            color: white;
            border: none;
            border-radius: 25px;
            padding: 12px 25px;
            font-weight: 600;
            text-decoration: none;
            display: inline-block;
            transition: all 0.3s ease;
        }

        .btn-dashboard:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0, 212, 255, 0.4);
            color: white;
        }

        /* Mensaje de bienvenida mejorado */
        .welcome-message {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border-radius: 20px;
            padding: 40px;
            margin-bottom: 30px;
        }

        .welcome-message h2 {
            font-size: 2.5rem;
            margin-bottom: 15px;
            font-weight: 700;
        }

        .welcome-message p {
            font-size: 1.2rem;
            opacity: 0.9;
        }

        .robot-img {
            width: 120px;
            height: 120px;
            border-radius: 50%;
            border: 4px solid rgba(255,255,255,0.3);
            margin-top: 20px;
        }

        /* Responsive */
        @media (max-width: 768px) {
            .sidebar {
                width: 80px;
            }
            
            .main-content {
                margin-left: 80px;
            }
            
            .sidebar-header h3,
            .sidebar-header small,
            .nav-link span,
            .user-details {
                display: none;
            }
        }

        /* Animaciones */
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }

        .fade-in {
            animation: fadeIn 0.6s ease-out;
        }

        /* Indicador de estado */
        .status-indicator {
            width: 10px;
            height: 10px;
            border-radius: 50%;
            background-color: #28a745;
            display: inline-block;
            margin-right: 8px;
            animation: pulse 2s infinite;
        }

        @keyframes pulse {
            0% { opacity: 1; }
            50% { opacity: 0.5; }
            100% { opacity: 1; }
        }

        .notification-icon {
            width: 35px;
            height: 35px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .notification-item {
            padding: 10px;
            border-radius: 8px;
            transition: background-color 0.3s ease;
        }

        .notification-item:hover {
            background-color: #f8f9fa;
        }

        .text-purple {
            color: #6f42c1 !important;
        }

        /* Separador visual entre navegación y usuario */
        .nav-separator {
            height: 1px;
            background: rgba(255,255,255,0.1);
            margin: 20px 15px;
        }
    </style>
</head>
<body>

<!-- Sidebar -->
<div class="sidebar" id="sidebar">
    <!-- Header del Sidebar -->
    <div class="sidebar-header">
        <img src="<?= base_url('img/logo.png') ?>" alt="Logo Solibot" class="logo">
        <h3>Chat Solibot</h3>
        <small>Sistema Multi-plataforma</small>
    </div>

    <!-- Navegación -->
    <nav class="sidebar-nav">
        <ul class="nav flex-column">
            <!-- Dashboard -->
            <li class="nav-item">
                <a class="nav-link active" href="<?= base_url('admin/dashboard'); ?>">
                    <i class="fas fa-tachometer-alt"></i>
                    <span>Dashboard</span>
                </a>
            </li>

            <!-- Conversaciones -->
            <li class="nav-item">
                <a class="nav-link" href="<?= base_url('conversations'); ?>">
                    <i class="fas fa-comments"></i>
                    <span>Conversaciones</span>
                    
                </a>
            </li>

            <!-- Tickets -->
            <li class="nav-item">
                <a class="nav-link" href="<?= base_url('admin/tickets'); ?>">
                    <i class="fas fa-ticket-alt"></i>
                    <span>Tickets</span>
                    
                </a>
            </li>

            <!-- Menú exclusivo para administrador -->
            <?php if (session()->get('role') === 'admin') : ?>
                <li class="nav-item">
                    <a class="nav-link" href="<?= base_url('admin/users'); ?>">
                        <i class="fas fa-users"></i>
                        <span>Usuarios</span>
                    </a>
                </li>

                <li class="nav-item">
                    <a class="nav-link" href="<?= base_url('admin/flows'); ?>">
                        <i class="fas fa-project-diagram"></i>
                        <span>Flujos de Atención</span>
                    </a>
                </li>

                <li class="nav-item">
                    <a class="nav-link" href="<?= base_url('admin/management'); ?>">
                        <i class="fas fa-cogs"></i>
                        <span>Administración</span>
                    </a>
                </li>
            <?php endif; ?>

            <!-- Configuración -->
            <li class="nav-item">
                <a class="nav-link" href="<?= base_url('advisor/profile'); ?>">
                    <i class="fas fa-cog"></i>
                    <span>Mi Perfil</span>
                </a>
            </li>
        </ul>

        <!-- Separador visual -->
        <div class="nav-separator"></div>
    </nav>

    <!-- Usuario info - FIJO EN LA PARTE INFERIOR -->
    <div class="sidebar-user">
        <div class="user-info">
            <div class="user-avatar">
                <i class="fas fa-user"></i>
            </div>
            <div class="user-details">
                <h6><?= session()->get('username') ?? 'Usuario' ?></h6>
                <small><?= ucfirst(session()->get('role') ?? 'admin') ?></small>
            </div>
        </div>
        <form action="<?= base_url('logout'); ?>" method="POST">
            <button type="submit" class="logout-btn">
                <i class="fas fa-sign-out-alt me-2"></i><span>Cerrar Sesión</span>
            </button>
        </form>
    </div>
</div>

<!-- Contenido Principal -->
<div class="main-content" id="mainContent">
    <!-- Header del contenido -->
    <div class="content-header">
        <div class="d-flex align-items-center">
            <button class="toggle-btn" id="toggleSidebar">
                <i class="fas fa-bars"></i>
            </button>
            <h4 class="mb-0">Panel de Administración - Chat Solibot</h4>
        </div>
        <div class="d-flex align-items-center">
            <span class="status-indicator"></span>
            <small class="text-muted">Sistema Activo</small>
            <div class="ms-3">
                <i class="fas fa-bell text-muted"></i>
                
            </div>
        </div>
    </div>

    <!-- Contenido de la página -->
    <div class="container-fluid p-4">