<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Verificación 2FA - Solibot</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="<?= base_url('css/style.css') ?>"> <!-- Usando el estilo general -->
    <script src="https://www.google.com/recaptcha/api.js?hl=es" async defer></script>

    <style>
        /* Ajuste en el tamaño del campo de código */
        input#google_auth_code {
            font-size: 0.9rem; /* Reducir el tamaño de la fuente */
            letter-spacing: 1px; /* Mantener el espaciado entre caracteres */
            padding: 8px 15px; /* Reducir el relleno y hacerlo más compacto */
            text-align: center; /* Centrar el texto en el input */
            width: 100%; /* Asegurar que ocupe el 100% del ancho disponible */
            margin-bottom: 15px; /* Espacio debajo del campo */
        }

        /* Estilo del botón de verificación */
        .form-container .btn {
            font-size: 0.9rem; /* Reducir el tamaño de la fuente del botón */
            padding: 10px 20px; /* Relleno más pequeño */
            width: auto; /* No ocupar todo el ancho */
            margin: 0 auto; /* Centrar el botón */
            display: block; /* Asegura que el botón se centre correctamente */
        }

        /* Ajustar la altura de los campos de texto (input) */
        .form-container .form-control {
            font-size: 0.9rem; /* Reducir el tamaño de la fuente */
            padding: 8px 15px; /* Reducir el relleno */
            height: auto; /* Asegurar que el input no se expanda */
        }

        /* Asegurar que el QR se vea centrado y tenga un tamaño adecuado */
        .form-container img {
            max-width: 100%; /* Limitar al 100% de su contenedor */
            height: auto; /* Mantener la proporción del QR */
            display: block; /* Hacerlo un bloque para centrarlo */
            margin: 0 auto 20px; /* Centrar y dejar espacio abajo */
        }

        /* Título y texto del formulario */
        .form-container h2, .form-container p {
            font-size: 1rem; /* Reducir el tamaño del texto */
            text-align: center; /* Asegurar que el texto esté centrado */
            margin-bottom: 20px;
        }

        /* Estilo para la alerta */
        .alert {
            margin-top: 20px; /* Espacio superior para la alerta */
        }
    </style>
</head>
<body>

<!-- Header fijo -->
<header class="header header-fixed">
    <div class="container d-flex align-items-center">
        <img src="<?= base_url('img/logo.png') ?>" alt="Logo Solibot" class="logo">
        <span class="app-name">Solibot</span>
    </div>
</header>

<!-- Contenedor Principal centrado, similar al login -->
<div class="container d-flex justify-content-center align-items-center vh-100 mt-5">
    <div class="form-container"> 
    <h2>Verificación en dos pasos</h2>
    <p class="mb-4">Ingresa el código de Google Authenticator</p>

        <!-- Formulario de verificación -->
        <form action="<?= base_url('auth/verify2FA') ?>" method="POST">
    <input type="hidden" name="temp_token" value="<?= $temp_token ?>">
            <div class="mb-3">
                <label for="google_auth_code" class="form-label">Código de Google Authenticator</label>
                <input type="text" name="google_auth_code" id="google_auth_code" class="form-control" required>
            </div>
            <button type="submit" class="btn btn-primary">Verificar Código</button> <!-- Botón reducido en tamaño -->
        </form>

        <!-- Mensajes de error -->
        <?php if (session()->getFlashdata('error')): ?>
            <div class="alert alert-danger">
                <?= session()->getFlashdata('error') ?>
            </div>
        <?php endif; ?>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
